
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

void CDisassemblerDlg::ExecuteArmDisasm()
{	/*ARMtAZu*/
	u32	opcode;
	u8	opcode_24_4;

	opcode = ARM_OPCODE_D;

	/*IyR[hw肳͈͂̃rbgo*/
	opcode_24_4	= (u8)((opcode >> 24) & 0x0F);	/*24-27 4bit*/

	switch(opcode_24_4){
	case 0x0:	/*0000*/
		if((u8)((opcode >> 4) & 0x0F) == 0x09){
			if(opcode & BIT23){	/*Multiply Long*/
				if(opcode & BIT21){	/*Accumelate*/
					disasm_arm_mlal();
					break;
				}else{
					disasm_arm_mull();
					break;
				}
			}else{					/*Multiply*/
				if(opcode & BIT21){	/*Accumelate*/
					disasm_arm_mla();
					break;
				}else{
					disasm_arm_mul();
					break;
				}
			}
		}
	case 0x1:	/*0001*/
		if(((opcode >> 4) & 0xFF) == 0x09){	/*00001001*/
			disasm_arm_swp();	/*Single Data Swap*/
			break;
		}
		if((opcode & 0x0FFFFFF0) == 0x012FFF10){
			disasm_arm_bx();	/*Branch and Exchange*/
			break;
		}
		if(opcode & BIT4){	/*Halfword data Transfer:*/
			if(opcode & BIT22){	/*immdiate offset*/
				if(opcode & BIT20){	/*Load from memory*/
					disasm_arm_ldrs_imm();
				}else{					/*Store to memory*/
					disasm_arm_strs_imm();
				}
				break;
			}else{					/*register offset*/
				if(opcode & BIT20){	/*Load from memory*/
					disasm_arm_ldrs();
				}else{					/*Store to memory*/
					disasm_arm_strs();
				}
				break;
			}
		}
	case 0x2:	/*0010*/
	case 0x3:	/*0011*/
	/*Data Processing*/
		switch((u8)((opcode>>21) & 0x0F)){
		case 0x0: disasm_arm_and();break;
		case 0x1: disasm_arm_eor();break;
		case 0x2: disasm_arm_sub();break;
		case 0x3: disasm_arm_rsb();break;
		case 0x4: disasm_arm_add();break;
		case 0x5: disasm_arm_adc();break;
		case 0x6: disasm_arm_sbc();break;
		case 0x7: disasm_arm_rsc();break;
		case 0x8: disasm_arm_tst();break;
		case 0x9: disasm_arm_teq();break;
		case 0xA: disasm_arm_cmp();break;
		case 0xB: disasm_arm_cmn();break;
		case 0xC: disasm_arm_orr();break;
		case 0xD: disasm_arm_mov();break;
		case 0xE: disasm_arm_bic();break;
		case 0xF: disasm_arm_mvn();break;
		}
		break;
	/*Single Data Transfer*/
	case 0x4:	/*0100*/
	case 0x5:	/*0101*/
	case 0x6:	/*0110*/
	case 0x7:	/*0111*/
		if(opcode & BIT20){	/*Load from memory*/
			disasm_arm_ldr();
			break;
		}else{					/*Store to memory*/
			disasm_arm_str();
			break;
		}
		if(opcode & BIT4){
			disasm_arm_undef();
			break;
		}
	/*Block Data Transfer*/
	case 0x8:	/*1000*/
	case 0x9:	/*1001*/
		if(opcode & BIT20){	/*Load from */
			disasm_arm_ldm();
		}else{
			disasm_arm_stm();
		}
		break;
	/*Branch*/
	case 0xA:	/*1010*/
		disasm_arm_b();
		break;
	case 0xB:	/*1011*/
		disasm_arm_bl();	/*branch with Link*/
		break;
	/*Coprocesser Data Transfer*/
	case 0xC:	/*1100*/
	case 0xD:	/*1101*/
		if(opcode & BIT20){	/*Load from */
			disasm_arm_ldc();
		}else{
			disasm_arm_stc();
		}
		break;
	case 0xE:	/*1110*/
		if(opcode & BIT4){
	/*Coprocesser Resgister Transfer*/
			if(opcode & BIT20){	/*Load from Co-Processer*/
				disasm_arm_mrc();
			}else{					/*Store to Co-Processer*/
				disasm_arm_mcr();
			}
		}else{
	/*Coprocesser Data Operation*/
			disasm_arm_cdp();
		}
		break;
	/*Software interrupt*/
	case 0xF:	/*1111*/
		disasm_arm_swi();
		break;
	default:
		disasm_arm_unknow();	/*Unknow opcode*/
	}
	
	debug_pc += 4;
}

void CDisassemblerDlg::ExecuteThumbDisasm()
{	/*ThumbtAZu*/
	u16	opcode;
	u8	opcode_11_5, opcode_6_5, opcode_9_3;

	opcode = THUMB_OPCODE_D;

	/*IyR[hw肳͈͂̃rbgo*/
	opcode_11_5	= (u8)((opcode >> 11) & 0x11);	/*11-15 5bit*/
	switch(opcode_11_5){
	case 0x00:	/*00000*/
		disasm_thumb_lsl_imm();/*LSL Rd,Rs,#Offset5 - 1*/
		break;
	case 0x01:	/*00001*/
		disasm_thumb_lsr_imm();/*LSR Rd,Rs,#Offset5 - 1*/
		break;
	case 0x02:	/*00010*/
		disasm_thumb_asr_imm();/*ASR Rd,Rs,#Offset5 - 1*/
		break;
	case 0x03:	/*00011*/
		if(opcode & BIT9){
			disasm_thumb_sub();/*Z - 2*/
		}else{
			disasm_thumb_add();/*Z - 2*/
		}
		break;
	case 0x04:	/*00100*/
		disasm_thumb_mov();/*MOV Rd,#Offset8 ړ - 3*/
		break;
	case 0x05:	/*00101*/
		disasm_thumb_cmp();/*CMP Rd,#Offset8 r - 3*/
		break;
	case 0x06:	/*00110*/
		disasm_thumb_add_imm();/*ADD Rd,#Offset8 Z - 3*/
		break;
	case 0x07:	/*00111*/
		disasm_thumb_sub_imm();/*SUB Rd,#Offset8 Z - 3*/
		break;
	case 0x08:	/*01000*/
		opcode_6_5	= (u8)((opcode>>6) & 0x1F);
		switch(opcode_6_5){
		case 0x00:	/*HiWX^/Xe[g*/
		case 0x01:
		case 0x02:
			disasm_thumb_add_hi();	/*HiWX^ - 5*/
			break;
		case 0x03:
		case 0x04:
		case 0x05:
			disasm_thumb_cmp_hi();	/*HiWX^ - 5*/
			break;
		case 0x06:
		case 0x07:
		case 0x08:
			disasm_thumb_mov_hi();	/*HiWX^ - 5*/
			break;
		case 0x09:
		case 0x0a:
		case 0x0b:
			disasm_thumb_bx_hi();	/*ƃXe[gύX - 5*/
			break;
		case 0x10:	/*ALUZ - 4*/
			disasm_thumb_and();
			break;
		case 0x11:
			disasm_thumb_eor();
			break;
		case 0x12:
			disasm_thumb_lsl();
			break;
		case 0x13:
			disasm_thumb_lsr();
			break;
		case 0x14:
			disasm_thumb_asr();
			break;
		case 0x15:
			disasm_thumb_adc();
			break;
		case 0x16:
			disasm_thumb_sbc();
			break;
		case 0x17:
			disasm_thumb_ror();
			break;
		case 0x18:
			disasm_thumb_tst();
			break;
		case 0x19:
			disasm_thumb_neg();
			break;
		case 0x1A:
			disasm_thumb_cmp();
			break;
		case 0x1B:
			disasm_thumb_cmn();
			break;
		case 0x1C:
			disasm_thumb_orr();
			break;
		case 0x1D:
			disasm_thumb_mul();
			break;
		case 0x1E:
			disasm_thumb_bic();
			break;
		case 0x1F:
			disasm_thumb_mvn();
			break;
		}
		break;
	case 0x09:	/*01001*/
		disasm_thumb_ldr_pc();	/*PC΃[h - 6*/
		break;
	case 0x0A:	/*01010*/
	case 0x0B:	/*01011*/
		opcode_9_3	= (u8)((opcode>>6) & 0x07);
		switch(opcode_9_3){
		/*WX^ItZbgɂ郍[h/XgA - 7*/
		case 0x0:	/*000 LB0*/
			disasm_thumb_str();
			break;
		case 0x2:	/*010 LB0*/
			disasm_thumb_strb();
			break;
		case 0x4:	/*100 LB0*/
			disasm_thumb_ldr();
			break;
		case 0x6:	/*110 LB0*/
			disasm_thumb_ldrb();
			break;
		/*oCg^n[t[h̃[h^XgAƕg - 8*/
		case 0x1:	/*000 HS0*/
			disasm_thumb_strh();
			break;
		case 0x3:	/*010 HS0*/
			disasm_thumb_ldsb();
			break;
		case 0x5:	/*100 HS0*/
			disasm_thumb_ldrh();
			break;
		case 0x7:	/*110 HS0*/
			disasm_thumb_ldsh();
			break;
		}
		break;	
	/*C~fBGCgItZbgɂ郍[h^XgA - 9*/
	case 0x0C:	/*01100 - BL=00*/
		disasm_thumb_str_imm();	/*str rd,[rb,#imm]*/
		break;
	case 0x0D:	/*01101 - BL=01*/
		disasm_thumb_ldr_imm();	/*ldr rd,[rb,#imm]*/
		break;
	case 0x0E:	/*01110 - BL=10*/
		disasm_thumb_strb_imm();/*strb rd,[rb,#imm]*/
		break;
	case 0x0F:	/*01111 - BL=11*/
		disasm_thumb_ldrb_imm();/*ldrb rd,[rb,#imm]*/
		break;
	/*n[t[h̃[h^XgA - 10*/
	case 0x10:	/*10000 - L=0*/
		disasm_thumb_strh_imm();/*strh rd,[rb,#imm]*/
		break;
	case 0x11:	/*10001 - L=1*/
		disasm_thumb_ldrh_imm();/*ldrh rd,[rb,#imm]*/
		break;
	/*SP΃[h^XgA - 11*/
	case 0x12:	/*10010 - S=0*/
		disasm_thumb_str_sp();/*str rd,[SP,#imm]*/
		break;
	case 0x13:	/*10011 - S=1*/
		disasm_thumb_ldr_sp();/*ldr rd,[SP,#imm]*/
		break;
	/*AhX̃[h - 12*/
	case 0x14:	/*10100 - S=0*//*add rd,PC,#imm*/
	case 0x15:	/*10101 - S=1*//*add rd,SP,#imm*/
		disasm_thumb_add_adr();
		break;
	case 0x16:	/*10110*/
	case 0x17:	/*10111*/
		if(opcode & BIT10){
	/*WX^PUSH/POP - 14*/
			if(opcode & BIT11){	/*L*/
				disasm_thumb_pop();/*POP {Rlist}*/
			}else{
				disasm_thumb_push();/*PUSH {Rlist}*/
			}
		}else{
	/*X^bN|C^ɃItZbgZ - 13*/
			if(!((opcode>>8) & 0x7)){	/*000S*/
				disasm_thumb_add_sp();/*add SP,#+-imm*/
			}
			break;
		}
		break;
	/*WX^̃[h^XgA - 15*/
	case 0x18:	/*11000*/
		disasm_thumb_stmia();/*stmia rb!,{Rlist}*/
		break;
	case 0x19:	/*11001*/
		disasm_thumb_ldmia();/*ldmia rb!,{Rlist}*/
		break;
	case 0x1A:	/*11010*/
	case 0x1B:	/*11011*/
		if(((opcode >> 8) & 0xF) == 0xF){
	/*\tgEFA荞 - 17*/
			disasm_thumb_swi();
		}else{
	/* - 16*/
			disasm_thumb_bxx();
		}
		break;
	/* - 18*/
	case 0x1C:	/*11100*/
		disasm_thumb_b();
		break;
	/*ƃN - 19*/
	case 0x1E:	/*11110*/
	case 0x1F:	/*11111*/
		disasm_thumb_bl();
		break;
	default:
		m_lstDisasm.AddString("<undefined>");
		break;
	}

	debug_pc += 2;
}
