
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#include <stdio.h>
#include <string.h>
#include "../include/defines.h"

typedef struct{
	u32	rom_entry_point;
	u8	nintendo_logo[156];
	u8	game_title[12];
	u8	game_code[4];
	u8	maker_code[2];
	u8	fixed_value;
	u8	main_unit_code;
	u8	device_type;
	u8	reversed_area0[7];
	u8	software_version;
	u8	complement_check;
	u8	reversed_area1[2];
	u32	ram_entry_point;
	u8	boot_mode;
	u8	slace_id_number;
	u8	notused[26];
	u32	joybus_entry_point;
}AGB_HEADER;


int ShowHeaderInfo(unsigned char* pRom, char* str)
{
	int	i, flag;
	unsigned char *ptr_char;
	char temp[64];
	unsigned char sum;
	AGB_HEADER *agbh;

	if(!pRom){
		strcpy(str, "ROMt@CJĂB.");
		return 1;
	}

	agbh = (AGB_HEADER*)pRom;

	if((pRom[0x9C] & 0x84) == 0x84){
		strcat(str, "fobMO:\t\tenable\n");
	}

	ptr_char = agbh->game_title;
	for(i = 0; i < 12; i++){
		temp[i] = ptr_char[i];
		if(!ptr_char[i])break;
	}
	temp[i] = '\0';	/*őPQ*/

	strcpy(str, "^Cg: \t\t");
	strcat(str, temp);

	sprintf(temp, "\nQ[R[h: \tAGB-%c%c%c%c",
		agbh->game_code[0],	/*AGB ID*/
		agbh->game_code[1],	/*Zk(2byte)*/
		agbh->game_code[2],
		agbh->game_code[3]	/*R[h*/
		);
	strcat(str, temp);

	sprintf(temp, "\nAGB ID:\t\t%s",
		(agbh->game_code[0] == 'A')?"ok":"bat");
	strcat(str, temp);

	strcat(str, "\nR[h:\t");
	switch(agbh->game_code[3]){
	case 'E':
		strcat(str, "[bp");
		break;
	case 'J':
		strcat(str, "{");
		break;
	case 'U':
		strcat(str, "O");
		break;
	default:
		strcat(str, "s");
		break;
	}

	sprintf(temp, "\n[J[R[h:\t%02Xh", pRom[0xB0]);
	strcat(str, temp);

	strcat(str, "\n[J[:\t");

	switch(agbh->maker_code[0]){
	case '0':
		switch(agbh->maker_code[1]){
		case '1':
			strcat(str, "CV");
			break;
		}
		break;
	default:
		strcat(str, "s");
	}

	strcat(str, "\nŒ96h:\t\t");
	strcat(str, (agbh->fixed_value == 0x96)?"ok":"bat");

	sprintf(temp, "\njbgR[h:\t%02Xh", 
		agbh->main_unit_code);
	strcat(str, temp);

	sprintf(temp, "\nfoCX^Cv:\t%02Xh", 
		agbh->device_type);
	strcat(str, temp);

	flag = 1;
	for(i = 0; i < 7; i++){
		if(agbh->reversed_area0[i])flag = 0;
	}

	sprintf(temp, "\n\ς݃GA1:\t%s",
		flag?"ok":"bat");
	strcat(str, temp);

	sprintf(temp, "\no[W:\t\t%d", 
		agbh->software_version);
	strcat(str, temp);

	strcat(str, "\n`FbNT: \t");
	sum = 0;
	for(i = 0xA0; i < 0xBC; i++){
		sum -= pRom[i];
	}
	sum -= 0x19;
	if(sum == agbh->complement_check){
		sprintf(temp, "ok");
	}else{
		sprintf(temp, "bat (%02Xh => %02Xh)", 
			sum == agbh->complement_check, sum);
	}
	strcat(str, temp);

	flag = 1;
	for(i = 0; i < 2; i++){
		if(agbh->reversed_area1[i])flag = 0;
	}

	sprintf(temp, "\n\ς݃GA2:\t%s",
		flag?"ok":"bat");
	strcat(str, temp);

	strcat(str, "\nN[h:\t");
	switch(agbh->boot_mode){
	case 1:
		strcat(str, "WCoX[h");
		break;
	case 2:
	case 0:
		strcat(str, "W[h");
		break;
	case 3:
		strcat(str, "}`vC[[h");
		break;
	default:
		sprintf(temp, "s(%xh)", agbh->boot_mode);
		strcat(str, temp);
	}

	sprintf(temp, "\nSlace id:\t\t#%d", 
		agbh->slace_id_number);
	strcat(str, temp);

	strcat(str, "\t\t");

	return 0;
}
