
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/


/*WX^ʂ̃ItZbg*/
unsigned int iotype_offset_table[8] = {
0x000,
0x060,
0x0B0,
0x100,
0x120,
0x130,
0x134,
0x200,
};


/*WXʃR{{bNXp*/
char *ioname_table[8] = {
"LCD I/OWX^",
"TEhWX^",
"DMA]`l",
"^C}[WX^",
"VAʐM (1)",
"L[",
"VAʐM (2)",
"荞,ҋ@,dRg[",
};


/*WX^ʃXg{bNXp*/
char *lcd_ioname_table[43] = {
"LCDRg[",
"hLgĂȂ - Green Swap",
"LCDXe[^X",
"JE^",
"BG0Rg[",
"BG1Rg[",
"BG2Rg[",
"BG3Rg[",
"BG0 X-ItZbg",
"BG0 Y-ItZbg",
"BG1 X-ItZbg",
"BG1 Y-ItZbg",
"BG2 X-ItZbg",
"BG2 Y-ItZbg",
"BG3 X-ItZbg",
"BG3 Y-ItZbg",
"BG2 ]/gp[^ A (dx)",
"BG2 ]/gp[^ B (dmx)",
"BG2 ]/gp[^ C (dy)",
"BG2 ]/gp[^ D (dmy)",
"BG2 Reference Point X-Coordinate",
"-",
"BG2 Reference Point Y-Coordinate",
"-",
"BG3 ]/gp[^ A (dx)",
"BG3 ]/gp[^ B (dmx)",
"BG3 ]/gp[^ C (dy)",
"BG3 ]/gp[^ D (dmy)",
"BG3 Reference Point X-Coordinate",
"-",
"BG3 Reference Point Y-Coordinate",
"-",
"Window 0  Dimensions",
"Window 1  Dimensions",
"Window 0  Dimensions",
"Window 1  Dimensions",
"Control Inside of Window(s)",
"Control Outside of Windows & Inside of OBJ Window",
"Mosaic Size",
"<gp>",
"Color Special Effects Selection",
"Alpha Blending Coefficients",
"Brightness (Fade-In/Out) Coefficient",
};

char *_lcd_ioname_table[43] = {
"DISPCNT",
"<gp>",
"DISPSTAT",
"VCOUNT",
"BG0CNT",
"BG1CNT",
"BG2CNT",
"BG3CNT",
"BG0HOFS",
"BG0VOFS",
"BG1HOFS",
"BG1VOFS",
"BG2HOFS",
"BG2VOFS",
"BG3HOFS",
"BG3VOFS",
"BG2PA",
"BG2PB",
"BG2PC",
"BG2PD",
"BG2PX",
"-",
"BG2PY",
"-",
"BG3PA",
"BG3PB",
"BG3PC",
"BG3PD",
"BG3PX",
"-",
"BG3PY",
"-",
"WIN0H",
"WIN1H",
"WIN0V",
"WIN1V",
"WININ",
"WINOUT",
"MOSAIC",
"<gp>",
"BLDCNT",
"BLDALPHA",
"BLDY",
};

char *sound_ioname_table[36] = {
"`l1 XEB[vWX^",
"`l1 Duty//Gx[v",
"`l1 g/Rg[",
"<gp>",
"`l2 Duty//Gx[v",
"<gp>",
"`l2 g/Rg[",
"<gp>",
"`l3 ~/f[^RAMI",
"`l3 /{[",
"`l3 g/Rg[",
"<gp>",
"`l4 /Gx[v",
"<gp>",
"`l4 g/Rg[",
"<gp>",
"Rg[ XeI/{[/",
"Rg[ ~LVO/DMARg[",
"Rg[ TEh I/It",
"<gp>",
"TEhPWMRg[",
"<gp>",
"<gp>",
"<gp>",
"`l3 g`p^[RAM",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"`lA FIFO, Data 0-3",
"-",
"`lB FIFO, Data 0-3",
"-",
};

char *_sound_ioname_table[36] = {
"SOUND1CNT_L",
"SOUND1CNT_H",
"SOUND1CNT_X",
"<gp>",
"SOUND2CNT_L",
"<gp>",
"SOUND2CNT_H",
"<gp>",
"SOUND3CNT_L",
"SOUND3CNT_H",
"SOUND3CNT_X",
"<gp>",
"SOUND4CNT_L",
"<gp>",
"SOUND4CNT_H",
"<gp>",
"SOUNDCNT_L",
"SOUNDCNT_H",
"SOUNDCNT_X",
"<gp>",
"SOUNDBIAS",
"<gp>",
"<gp>",
"<gp>",
"WAVE_RAM",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"FIFO_A",
"-",
"FIFO_B",
"-",
};

char *dma_ioname_table[24] = {
"DMA 0 ]AhX",
"-",
"DMA 0 ]AhX",
"-",
"DMA 0 ]JEg",
"DMA 0 Rg[",
"DMA 1 ]AhX",
"-",
"DMA 1 ]AhX",
"-",
"DMA 1 ]JEg",
"DMA 1 Rg[",
"DMA 2 ]AhX",
"-",
"DMA 2 ]AhX",
"-",
"DMA 2 JEg",
"DMA 2 Rg[",
"DMA 3 ]AhX",
"-",
"DMA 3 ]AhX",
"-",
"DMA 3 JEg",
"DMA 3 Rg[",
};

char *_dma_ioname_table[24] = {
"DMA0SAD",
"-",
"DMA0DAD",
"-",
"DMA0CNT_L",
"DMA0CNT_H",
"DMA1SAD",
"-",
"DMA1DAD",
"-",
"DMA1CNT_L",
"DMA1CNT_H ",
"DMA2SAD",
"-",
"DMA2DAD",
"-",
"DMA2CNT_L",
"DMA2CNT_H",
"DMA3SAD",
"-",
"DMA3DAD",
"-",
"DMA3CNT_L",
"DMA3CNT_H",
};

char *timer_ioname_table[8] = {
"^C}[ 0 JE^/[h",
"^C}[ 0 Rg[",
"^C}[ 1 JE^/[h",
"^C}[ 1 Rg[",
"^C}[ 2 JE^/[h",
"^C}[ 2 Rg[",
"^C}[ 3 JE^/[h",
"^C}[ 3 Rg[",
};

char *_timer_ioname_table[8] = {
"TM0CNT_L",
"TM0CNT_H",
"TM1CNT_L",
"TM1CNT_H",
"TM2CNT_L",
"TM2CNT_H",
"TM3CNT_L",
"TM3CNT_H",
};

char *sio1_ioname_table[6] = {
"SIOf[^ 0 (e)",
"SIOf[^ 1 (1Ԗڂ̎q)",
"SIOf[^ 2 (2Ԗڂ̎q)",
"SIOf[^ 3 (3Ŗڂ̎q)",
"SIORg[WX^",
"SIOf[^",
};

char *_sio1_ioname_table[6] = {
"SIODATA32",
"SIOMULTI1",
"SIOMULTI2",
"SIOMULTI3",
"SIOCNT",
"SIOMLT_SEND",
};


char *key_ioname_table[2] = {
"L[Xe[^X",
"L[荞݃Rg[",
};

char *_key_ioname_table[2] = {
"KEYINPUT",
"KEYCNT",
};

char *sio2_ioname_table[19] = {
"SIO[hI/General Purpose Data",
"Ancient - ԊOWX^",
"<gp>",
"<gp>",
"<gp>",
"<gp>",
"SIO JOYoXRg[",
"<gp>",
"<gp>",
"<gp>",
"<gp>",
"<gp>",
"<gp>",
"<gp>",
"SIO JOYoXMf[^",
"-",
"SIO JOYoX]f[^",
"-",
"SIO JOYoXMXe[^X",
};

char *_sio2_ioname_table[19] = {
"RCNT",
"IR",
"<gp>",
"<gp>",
"<gp>",
"<gp>",
"JOYCNT",
"<gp>",
"<gp>",
"<gp>",
"<gp>",
"<gp>",
"<gp>",
"<gp>",
"JOY_RECV",
"-",
"JOY_TRANS",
"-",
"JOYSTAT",
};

char *irq_ioname_table[5] = {
"荞ݗLWX^",
"荞ݗvtO / IRQ Acknowledge",
"Game PakEFCgXe[gRg[",
"<gp>",
"荞݃}X^[WX^",
};

char *_irq_ioname_table[5] = {
"IE",
"IF",
"WAITCNT",
"<gp>",
"IME",
};


/*WX^rbg̏ڍ׃`FbN{bNX*/
char *notused_flag_table[16] = {
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};


char *low_flag_table[16] = {
"32rbgf[^",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};

char *high_flag_table[16] = {
"32rbgf[^",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};


char *lcd_dispcnt_flag_table[16] = {
"BG[h",
"-",
"-",
"BIOSM",
"ʃt[I",
"H-uN Interval Free",
"OBJLN^}bsO",
"Forced Blank",
"BG0ʕ\",
"BG1ʕ\",
"BG2ʕ\",
"BG3ʕ\",
"OBJʕ\",
"Window 0\tO",
"Window 1\tO",
"OBJ Window\tO",
};

char *lcd_dispstat_flag_table[16] = {
"V-uNtO",
"H-uNtO",
"V-JE^tO",
"V-uNIRQ",
"H-uNIRQ",
"V-JE^IRQ",
"",
"",
"V-JEgݒ",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *lcd_vcount_flag_table[16] = {
"̈ʒu",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
"",
"",
"",
"",
"",
"",
};

char *lcd_bgcnt_flag_table[16] = {
"BGDx",
"-",
"LN^x[XubN",
"-",
"<gp> (KO)",
"-",
"Mosaic",
"F/pbg",
"ʃx[XubN",
"-",
"-",
"-",
"-",
"ʃGAI[o[t[",
"ʃTCY (0-3)",
"-",
};

char *lcd_bgscr_flag_table[16] = {
"ItZbg (0-511)",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
"",
"",
"",
"",
"",
};

char *lcd_bgparam_flag_table[16] = {
"",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"-",
"-",
"-",
"-",
"-",
"",
};

char *lcd_bgpointl_flag_table[16] = {
"",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *lcd_bgpointh_flag_table[16] = {
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
"",
"",
"",
};

char *lcd_winh_flag_table[16] = {
"X2, Rightmost coordinate of window, plus 1",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"X1, Leftmost coordinate of window",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *lcd_winv_flag_table[16] = {
"Y2, Bottom-most coordinate of window, plus 1",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"Y1, Top-most coordinate of window",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *lcd_winin_flag_table[16] = {
"Window 0 BG0-BG3rbg",
"-",
"-",
"-",
"Window 0 OBJrbg",
"Window 0 J[GtFNg",
"",
"",
"Window 1 BG0-BG3rbg",
"-",
"-",
"-",
"Window 1 OBJrbg",
"Window 1 J[GtFNg",
"",
"",
};

char *lcd_winout_flag_table[16] = {
"Outside BG0-BG3rbg",
"-",
"-",
"-",
"Outside OBJrbg",
"Outside J[GtFNg",
"",
"",
"OBJ Window BG0-BG3rbg",
"-",
"-",
"-",
"OBJ Window OBJrbg",
"OBJ Window J[GtFNg",
"",
"",
};

char *lcd_mosaic_flag_table[16] = {
"BG Mosaic H-Size  (minus 1)",
"-",
"-",
"-",
"BG Mosaic V-Size  (minus 1)",
"-",
"-",
"-",
"OBJ Mosaic H-Size (minus 1)",
"-",
"-",
"-",
"OBJ Mosaic V-Size (minus 1)",
"-",
"-",
"-",
};

char *lcd_bldcnt_flag_table[16] = {
"BG0 1st Target Pixel",
"BG1 1st Target Pixel",
"BG2 1st Target Pixel",
"BG3 1st Target Pixel",
"OBJ 1st Target Pixel",
"BD  1st Target Pixel",
"J[GtFNg",
"-",
"BG0 2nd Target Pixel",
"BG1 2nd Target Pixel",
"BG2 2nd Target Pixel",
"BG3 2nd Target Pixel",
"OBJ 2nd Target Pixel",
"BD  2nd Target Pixel",
"-",
"-",
};

char *lcd_bldalpha_flag_table[16] = {
"EVA Coefficient (1st Target)",
"-",
"-",
"-",
"",
"",
"",
"",
"EVB Coefficient (2nd Target)",
"-",
"-",
"-",
"",
"",
"",
"",
};

char *lcd_bldy_flag_table[16] = {
"EVY Coefficient (Brightness)",
"-",
"-",
"-",
"-",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};

char **lcd_flagname_table[43] = {
lcd_dispcnt_flag_table,
notused_flag_table,
lcd_dispstat_flag_table,
lcd_vcount_flag_table,

lcd_bgcnt_flag_table,
lcd_bgcnt_flag_table,
lcd_bgcnt_flag_table,
lcd_bgcnt_flag_table,

lcd_bgscr_flag_table,
lcd_bgscr_flag_table,
lcd_bgscr_flag_table,
lcd_bgscr_flag_table,
lcd_bgscr_flag_table,
lcd_bgscr_flag_table,
lcd_bgscr_flag_table,
lcd_bgscr_flag_table,

lcd_bgparam_flag_table,
lcd_bgparam_flag_table,
lcd_bgparam_flag_table,
lcd_bgparam_flag_table,

lcd_bgpointl_flag_table,
lcd_bgpointh_flag_table,
lcd_bgpointl_flag_table,
lcd_bgpointh_flag_table,

lcd_bgparam_flag_table,
lcd_bgparam_flag_table,
lcd_bgparam_flag_table,
lcd_bgparam_flag_table,

lcd_bgpointl_flag_table,
lcd_bgpointh_flag_table,
lcd_bgpointl_flag_table,
lcd_bgpointh_flag_table,

lcd_winh_flag_table,
lcd_winh_flag_table,

lcd_winv_flag_table,
lcd_winv_flag_table,

lcd_winin_flag_table,
lcd_winout_flag_table,

lcd_mosaic_flag_table,
notused_flag_table,
lcd_bldcnt_flag_table,
lcd_bldalpha_flag_table,
lcd_bldy_flag_table,
};


char *sound_sg10l_flag_table[16] = {
"XEB[vVtgԍ",
"-",
"-",
"XEB[vg Direction",
"XEB[v; 7.8msP",
"-",
"-",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};

char *sound_sg10h_flag_table[16] = {
"TEh",
"-",
"-",
"-",
"-",
"-",
"g`p^[Duty",
"-",
"Gx[v Xebv",
"-",
"-",
"Gx[v Direction",
"Gx[v̏",
"",
"",
"",
};

char *sound_sg11_flag_table[16] = {
"g",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
"",
"tO",
"",
};

char *sound_sg30l_flag_table[16] = {
"",
"",
"",
"",
"",
"g`RAMoNԍ",
"g`RAM Dimension",
"TEh`l3 It",
"",
"",
"",
"",
"",
"",
"",
"",
};

char *sound_sg30h_flag_table[16] = {
"TEh",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
"",
"",
"",
"TEh{[",
"-",
"Force{[",
};

char *sound_sgcnt0l_flag_table[16] = {
"TEh1-4}X^[{[ E",
"-",
"-",
"",
"TEh1-4 }X^[{[ ",
"-",
"-",
"",
"TEh1-4 tO E",
"-",
"-",
"-",
"TEh1-4 tO ",
"-",
"-",
"-",
};

char *sound_sgcnt0h_flag_table[16] = {
"TEh# 1-4 {[",
"-",
"DMA TEhA {[",
"DMA TEhB {[",
"",
"",
"",
"",
"DMA TEhA E",
"DMA TEhA ",
"DMA TEhA ^C}[I",
"DMA TEhA ZbgFIFO",
"DMA TEhB E",
"DMA TEhB ",
"DMA TEhB ^C}[I",
"DMA TEhB ZbgFIFO",
};

char *sound_sgcnt1_flag_table[16] = {
"TEh1 ItO",
"TEh2 ItO",
"TEh3 ItO",
"TEh4 ItO",
"",
"",
"",
"STEh I/It",
"",
"",
"",
"",
"",
"",
"",
"",
};

char *sound_sgbias_flag_table[16] = {
"oCAXx",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
"",
"",
"Amplitude Resolution/TvOTCN",
"-",
};

char *sound_sgwr_flag_table[16] = {
"`l3 g`p^[",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *sound_sgfifo_flag_table[16] = {
"TEhFIFO, f[^",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char **sound_flagname_table[39] = {
sound_sg10l_flag_table,/*60h*/
sound_sg10h_flag_table,
sound_sg11_flag_table,

notused_flag_table,
sound_sg10h_flag_table,
notused_flag_table,
sound_sg11_flag_table,
notused_flag_table,

sound_sg30l_flag_table,/*70h*/
sound_sg30h_flag_table,
sound_sg11_flag_table,

notused_flag_table,
sound_sg10h_flag_table,
notused_flag_table,
sound_sg11_flag_table,
notused_flag_table,

sound_sgcnt0l_flag_table,/*80h*/
sound_sgcnt0h_flag_table,
sound_sgcnt1_flag_table,
notused_flag_table,

sound_sgbias_flag_table,
notused_flag_table,
notused_flag_table,
notused_flag_table,

sound_sgwr_flag_table,
sound_sgwr_flag_table,
sound_sgwr_flag_table,
sound_sgwr_flag_table,
sound_sgwr_flag_table,
sound_sgwr_flag_table,
sound_sgwr_flag_table,
sound_sgwr_flag_table,

sound_sgfifo_flag_table,
sound_sgfifo_flag_table,
sound_sgfifo_flag_table,
sound_sgfifo_flag_table,
};


char *dma_adl_flag_table[16] = {
"AhX, 16rbg",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *dma_adh_flag_table[16] = {
"AhX, 16rbg",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *dma_count_flag_table[16] = {
"[hJEg",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
};

char *dma_count3_flag_table[16] = {
"[hJEg",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *dma_cnt_flag_table[16] = {
"",
"",
"",
"",
"",
"]AhXRg[",
"-",
"]AhXRg[",
"-",
"DMAs[g",
"DMA]^Cv",
"Game Pak DRQ  - DMA3̂ -",
"DMA]Jn^C~O",
"-",
"IRQ upon end of [hJEg",
"DMAL",
};

char **dma_flagname_table[24] = {
dma_adl_flag_table,
dma_adh_flag_table,
dma_adl_flag_table,
dma_adh_flag_table,
dma_count_flag_table,
dma_cnt_flag_table,

dma_adl_flag_table,
dma_adh_flag_table,
dma_adl_flag_table,
dma_adh_flag_table,
dma_count_flag_table,
dma_cnt_flag_table,

dma_adl_flag_table,
dma_adh_flag_table,
dma_adl_flag_table,
dma_adh_flag_table,
dma_count_flag_table,
dma_cnt_flag_table,

dma_adl_flag_table,
dma_adh_flag_table,
dma_adl_flag_table,
dma_adh_flag_table,
dma_count3_flag_table,
dma_cnt_flag_table,
};


char *tm_counter_flag_table[16] = {
"JEg",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *tm_cnt_flag_table[16] = {
"Prescaler Selection",
"-",
"JEgAbv^C~O",
"",
"",
"",
"^C}[IRQL",
"^C}[ Jn/~",
"",
"",
"",
"",
"",
"",
"",
"",
};

char **tm_flagname_table[8] = {
tm_counter_flag_table,
tm_cnt_flag_table,
tm_counter_flag_table,
tm_cnt_flag_table,
tm_counter_flag_table,
tm_cnt_flag_table,
tm_counter_flag_table,
tm_cnt_flag_table,
};


char *sio1_scd_flag_table[16] = {
"16rbgf[^",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *sio1_sccntl_flag_table[16] = {
"VtgNbN",
"VtgNbN",
"SI (opponents SO)",
"SO during inactivity",
"",
"",
"",
"Jnrbg",
"",
"",
"",
"",
"]",
"m[}[ĥߕKO",
"IRQL",
"",
};

char **sio1_flagname_table[9] = {
sio1_scd_flag_table,
sio1_scd_flag_table,

sio1_scd_flag_table,
sio1_scd_flag_table,
sio1_scd_flag_table,
sio1_scd_flag_table,

sio1_sccntl_flag_table,

sio1_scd_flag_table,
sio1_scd_flag_table,
};


char *key_p1_flag_table[16] = {
"A{^",
"B{^",
"ZNg",
"X^[g",
"E",
"",
"",
"",
"R{^",
"L{^",
"",
"",
"",
"",
"",
"",
};

char *key_p1cnt_flag_table[16] = {
"A{^",
"B{^",
"ZNg",
"X^[g",
"E",
"",
"",
"",
"R{^",
"L{^",
"",
"",
"",
"",
"IRQtO",
"IRQ Condition",
};

char **key_flagname_table[2] = {
key_p1_flag_table,
key_p1cnt_flag_table,
};


char *sio2_rcnt_flag_table[16] = {
"SCf[^rbg",
"SDf[^rbg",
"SIf[^rbg",
"SOf[^rbg",
"SC Direction",
"SD Direction",
"SI Direction",
"SO Direction",
"荞ݗv",
"",
"",
"",
"",
"",
"Must be 0 for General-Purpose Mode",
"Must be 1 for General-Purpose or JOYBUS Mode",
};

char *sio2_ir_flag_table[16] = {
"]f[^",
"ǂݎ苖",
"Reception Data",
"AMP",
"IRQtO",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"JOYoX[ĥ߂ɕKO",
};

char *sio2_hsctrl_flag_table[16] = {
"foCXZbgtO",
"MtO",
"]tO",
"",
"",
"",
"foCXZbgR}hMɊ荞",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};

char *sio2_stat_flag_table[16] = {
"",
"MXe[^XtO",
"",
"MXe[^XtO",
"General Purpose Flag",
"-",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"JOYoX[ĥߕKO",
};

char **sio2_flagname_table[19] = {
sio2_rcnt_flag_table,
sio2_ir_flag_table,

notused_flag_table,
notused_flag_table,
notused_flag_table,
notused_flag_table,

sio2_hsctrl_flag_table,

notused_flag_table,
notused_flag_table,
notused_flag_table,
notused_flag_table,
notused_flag_table,
notused_flag_table,
notused_flag_table,

low_flag_table,
high_flag_table,
low_flag_table,
high_flag_table,
sio2_stat_flag_table
};


char *irq_ie_flag_table[16] = {
"LCD V-tN",
"LCD H-uN",
"LCD V-JE^v",
"^C}[0 I[o[t[",
"^C}[1 I[o[t[",
"^C}[2 I[o[t[",
"^C}[3 I[o[t[",
"VAʐM",
"DMA 0",
"DMA 1",
"DMA 2",
"DMA 3",
"L[pbh",
"Game Pak (OIRQv)",
"",
"",
};

char *irq_wscnt_flag_table[16] = {
"SRAMEFCgRg[",
"-",
"EFCgXe[^X0 ŏ̃ANZX",
"-",
"EFCƃXe[^X0 ̃ANZX",
"Wait State 1 First Access",
"-",
"Wait State 1 Second Access",
"Wait State 2 First Access",
"-",
"Wait State 2 Second Access",
"PHI Terminal Output",
"-",
"",
"Game Pak Prefetch Buffer",
"Game Pak^CvtO",
};

char *irq_ime_flag_table[16] = {
"ׂĂ̊荞݂֎~",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};

char **irq_flagname_table[6] = {
irq_ie_flag_table,
irq_ie_flag_table,
irq_wscnt_flag_table,
notused_flag_table,
irq_ime_flag_table,
notused_flag_table,
};
