// ChildView.cpp : CChildView NX̓̒`s܂B
//

#include "stdafx.h"
#include "GBAEmu.h"
#include "ChildView.h"

#define	_AGBWIN32_
#include "../include/externs.h"
#include "../include/filters.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

typedef struct{
	BITMAPINFOHEADER	bmiHeader;
	RGBQUAD				bmiColors[256];
}BMPINFO;
BMPINFO bmp_info;

DWORD dwSize;

extern RECT clientSize;

/////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView::CChildView()
{
}

CChildView::~CChildView()
{
}


BEGIN_MESSAGE_MAP(CChildView,CWnd )
	//{{AFX_MSG_MAP(CChildView)
	ON_WM_PAINT()
	ON_MESSAGE(WM_DRAW_LCD, agb_draw_lcd)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildView bZ[W nh

void CChildView::agb_initialize_video(HDC hDC)
{	/*rbg}bv*/
	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= AGB_LCD_X;
	bmp_info.bmiHeader.biHeight		= -AGB_LCD_Y;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 16;

	hBitmap = CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)
	&pSurface, NULL, 0);
	hMemDC	= CreateCompatibleDC(hDC);
	SelectObject(hMemDC, hBitmap);
}

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.dwExStyle &= ~WS_EX_OVERLAPPEDWINDOW;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);

	hDC = GetDC()->m_hDC;
	agb_initialize_video(hDC);
	ReleaseDC(GetDC());

	hBitmap = NULL;
	dwSize = sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256;

	return TRUE;
}

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	agb_draw_lcd();
}

void CChildView::agb_draw_lcd()
{
	memcpy(pSurface, FrameBuffer, AGB_LCD_SIZE * 2);

	hDC = GetDC()->m_hDC;
	StretchBlt(hDC, 0, 0, clientSize.right, clientSize.bottom, hMemDC,
					0, 0, AGB_LCD_X, AGB_LCD_Y, SRCCOPY);
	::ReleaseDC(m_hWnd, hDC);
}

