// DisassemblerSaveDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "gbaemu.h"
#include "DisassemblerSaveDlg.h"
#include "../include/hextoint.h"
#include "../include/file.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDisassemblerSaveDlg _CAO


CDisassemblerSaveDlg::CDisassemblerSaveDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDisassemblerSaveDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDisassemblerSaveDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void CDisassemblerSaveDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDisassemblerSaveDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDisassemblerSaveDlg, CDialog)
	//{{AFX_MSG_MAP(CDisassemblerSaveDlg)
	ON_BN_CLICKED(IDC_BUTTON_SAVE, OnButtonSave)
	ON_BN_CLICKED(IDC_RADIO_ARM, OnRadioArm)
	ON_BN_CLICKED(IDC_RADIO_THUMB, OnRadioThumb)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDisassemblerSaveDlg bZ[W nh

BOOL CDisassemblerSaveDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	SetDlgItemText(IDC_EDIT_ADDRESS, "8000000h");
	SetDlgItemText(IDC_EDIT_SIZE, "100h");

	OnRadioArm();

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CDisassemblerSaveDlg::OnButtonSave() 
{
	char str[32];
	char filename[512];
	OPENFILENAME ofn;
	
	memset(filename, 0, 512);
	memset(&ofn, 0, sizeof(ofn));
	ofn.Flags			= OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrFile		= filename;
	ofn.lpstrFilter		= "Assembly Files (*.asm;*.as;*.s)\0*.asm;*.as;*.s\0All Files (*.*)\0*.*";
	ofn.nMaxFileTitle	= 512;
	ofn.nMaxFile		= 512;
	ofn.lStructSize		= sizeof(OPENFILENAME);
	ofn.hwndOwner		= m_hWnd;

	if(GetSaveFileName(&ofn)){
		strcpy(m_disasm_filename, filename);
		if(!check_extension(filename)){
			strcat(m_disasm_filename, ".asm");
		}
		GetDlgItemText(IDC_EDIT_ADDRESS, str, 32);
		if(CheckHexStr(str)){
			m_disasm_address	= HexToInt(str);
		}else{
			m_disasm_address	= atoi(str);
		}
		GetDlgItemText(IDC_EDIT_SIZE, str, 32);
		if(CheckHexStr(str)){
			m_disasm_size	= HexToInt(str);
		}else{
			m_disasm_size	= atoi(str);
		}
		if(m_disasm_size >= 32 * 1024){
			if(MessageBox("ITCY32KB𒴂Ă܂s܂H\nio̓t@CTCY1MB𒴂ꍇ܂Bj", NULL, MB_YESNO) == IDCANCEL){
				return;
			}
		}
		OnOK();
	}
}

void CDisassemblerSaveDlg::OnRadioArm() 
{
	CheckRadioButton(IDC_RADIO_ARM, IDC_RADIO_THUMB, IDC_RADIO_ARM);
	m_disasm_thumb_state	= FALSE;
}

void CDisassemblerSaveDlg::OnRadioThumb() 
{
	CheckRadioButton(IDC_RADIO_ARM, IDC_RADIO_THUMB, IDC_RADIO_THUMB);
	m_disasm_thumb_state	= TRUE;
}
