// DispcntDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBAEmu.h"
#include "DispcntDlg.h"

#define	_AGBWIN32_
#include "../include/externs.h"
#include "../gbacore/video_frame.c"
/*
extern void agb_draw_mode0_bg(u16* pmap16, u32 bg);
extern void agb_draw_mode3_bg(u16* pmap16);
extern void agb_draw_mode4_bg(u16* pmap16);
extern void agb_draw_mode5_bg(u16* pmap16);
*/

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern DWORD dwSize;
LPBITMAPINFO disp_info;

void _agb_draw_mode4_bg(u16 *dest_ptr, u32 dispcnt)
{	/*mode 4 pbg*/
	u32 i;
	u16	temp16;
	u16 *ppal16;
	u8	*src_ptr;

	ppal16 = (u16*)agb_palram;
	src_ptr = agb_vram;
	if(dispcnt & BIT4)src_ptr += AGB_LCD_SIZE;	/*obNobt@̑I*/
	for(i = 0; i < AGB_LCD_SIZE; i++){
		temp16 = ppal16[*src_ptr++];
		*dest_ptr++ = SWAP_RB(temp16);
	}
}


void _agb_draw_mode5_bg(u16 *dest_ptr, u32 dispcnt)
{	/*mode 5 rbg}bv*/
	s32 x, y;
	u16	temp16;
	u16 *pvram16;

	pvram16 = (u16*)agb_vram;
	if(dispcnt & BIT4)pvram16 += AGB_LCD_MODE5_X * AGB_LCD_MODE5_Y;	/*obNobt@̑I*/
	for(y = 0; y < AGB_LCD_MODE5_Y; y++){
		for(x = 0; x < AGB_LCD_MODE5_X; x++){
			temp16 = *pvram16++;
			*dest_ptr++ = SWAP_RB(temp16);
		}
		dest_ptr += AGB_LCD_X - AGB_LCD_MODE5_X;
	}
}


/////////////////////////////////////////////////////////////////////////////
// CDispcntDlg _CAO


CDispcntDlg::CDispcntDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDispcntDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDispcntDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void CDispcntDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDispcntDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDispcntDlg, CDialog)
	//{{AFX_MSG_MAP(CDispcntDlg)
	ON_WM_CLOSE()
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_BUTTON_UPDATE, OnButtonUpdate)
	ON_BN_CLICKED(IDC_RADIO_MODE0, OnRadioMode0)
	ON_BN_CLICKED(IDC_RADIO_MODE1, OnRadioMode1)
	ON_BN_CLICKED(IDC_RADIO_MODE2, OnRadioMode2)
	ON_BN_CLICKED(IDC_RADIO_MODE3, OnRadioMode3)
	ON_BN_CLICKED(IDC_RADIO_MODE4, OnRadioMode4)
	ON_BN_CLICKED(IDC_RADIO_MODE5, OnRadioMode5)
	ON_BN_CLICKED(IDC_RADIO_MODE6, OnRadioMode6)
	ON_BN_CLICKED(IDC_RADIO_MODE7, OnRadioMode7)
	ON_BN_CLICKED(IDC_BUTTON_DUMMY_PALETTE, OnButtonDummyPalette)
	ON_BN_CLICKED(IDC_CHECK_BG0, OnCheckBg0)
	ON_BN_CLICKED(IDC_CHECK_BG1, OnCheckBg1)
	ON_BN_CLICKED(IDC_CHECK_BG2, OnCheckBg2)
	ON_BN_CLICKED(IDC_CHECK_BG3, OnCheckBg3)
	ON_BN_CLICKED(IDC_CHECK_WIN1, OnCheckWin1)
	ON_BN_CLICKED(IDC_CHECK_WIN2, OnCheckWin2)
	ON_BN_CLICKED(IDC_CHECK_WINOBJ, OnCheckWinobj)
	ON_BN_CLICKED(IDC_CHECK_BACKBUFFER, OnCheckBackbuffer)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDispcntDlg bZ[W nh

void CDispcntDlg::OnOK()
{
	OnClose();
	}

void CDispcntDlg::OnCancel()
{
	OnClose();
}

BOOL CDispcntDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	disp_info = (LPBITMAPINFO)new char[dwSize];

	memset(disp_info, 0, sizeof(BITMAPINFOHEADER));
	disp_info->bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	disp_info->bmiHeader.biWidth	= 240;
	disp_info->bmiHeader.biHeight	= -160;
	disp_info->bmiHeader.biPlanes	= 1;
	disp_info->bmiHeader.biBitCount	= 16;

	memset(DispBuffer, 0, 240 * 160 * 2);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_DISPCNT_LCD), 0, 10, 10,
					240, 160, SWP_NOACTIVATE | SWP_NOZORDER);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_STATIC_PALETTE), 0, 10, 180,
					240, 220, SWP_NOACTIVATE | SWP_NOZORDER);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CDispcntDlg::ShowDispcnt()
{
	u32	dispcnt;
	CButton* pBPchk;

	DrawDispcntPalette();

	dispcnt = agb_read_mem32(REG_DISPCNT);

	m_temp_dispcnt = io_lcd->dispcnt;

	switch((u8)(m_temp_dispcnt & 7)){
	case 0:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE0);
		break;
	case 1:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE1);
		break;
	case 2:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE2);
		break;
	case 3:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE3);
		break;
	case 4:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE4);
		break;
	case 5:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE5);
		break;
	case 6:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE6);
		break;
	case 7:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE7);
		break;
	}

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG0);
	pBPchk->SetCheck((dispcnt & BG0_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG1);
	pBPchk->SetCheck((dispcnt & BG1_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG2);
	pBPchk->SetCheck((dispcnt & BG2_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG3);
	pBPchk->SetCheck((dispcnt & OBJ_ENABLE)?1:0);
	
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_WIN1);
	pBPchk->SetCheck((dispcnt & WIN1_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_WIN2);
	pBPchk->SetCheck((dispcnt & WIN2_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_WINOBJ);
	pBPchk->SetCheck((dispcnt & WINOBJ_ENABLE)?1:0);

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BACKBUFFER);
	pBPchk->SetCheck((dispcnt & BACKBUFFER)?1:0);
}

void CDispcntDlg::DrawDispcntLcd()
{	/*obNobt@\*/
	s32		i;
	u16		*palette;
	HBITMAP	hBitmap, hOldmap;
	HDC		hDC, hMemDC;

	hDC = GetDlgItem(IDC_DISPCNT_LCD)->GetDC()->m_hDC;

	palette = (u16*)agb_palram;

	switch(m_temp_dispcnt & 7){
	case 0:
	case 1:
	case 2:
		memset(DispBuffer, 0, AGB_LCD_SIZE * 2);
		for(i = 3; i >= 0; i--){
			if((io_lcd->bg0cnt & 0x03) == i){
				if(m_temp_dispcnt & BIT8)agb_draw_mode0_bg(DispBuffer, 0);
			}
			if((io_lcd->bg1cnt & 0x03) == i){
				if(m_temp_dispcnt & BIT9)agb_draw_mode0_bg(DispBuffer, 1);
			}
			if((io_lcd->bg2cnt & 0x03) == i){
				if(m_temp_dispcnt & BIT10)agb_draw_mode0_bg(DispBuffer, 2);
			}
			if((io_lcd->bg3cnt & 0x03) == i){
				if(m_temp_dispcnt & BIT11)agb_draw_mode0_bg(DispBuffer, 3);
			}
		}
		break;
	case 4:
	case 6:
		_agb_draw_mode4_bg(DispBuffer, m_temp_dispcnt);
		break;
	case 5:
		_agb_draw_mode5_bg(DispBuffer, m_temp_dispcnt);
		break;
	case 3:
	default:
		agb_draw_mode3_bg(DispBuffer);
		break;
	}

	hMemDC	= CreateCompatibleDC(hDC);
	hBitmap	= CreateDIBitmap(hDC, &disp_info->bmiHeader, CBM_INIT, 
								DispBuffer, disp_info, DIB_RGB_COLORS);
	hOldmap	= (HBITMAP)SelectObject(hMemDC, hBitmap);
	StretchBlt(hDC, 0, 0, 240, 160, hMemDC, 0, 0, 240, 160, SRCCOPY);
	DeleteObject(hBitmap);
}

void CDispcntDlg::DrawDispcntPalette()
{
	u32		x, y, offset_x, offset_y;
	u32		color32;
	u16		color16;
	u16		*palette;
	RECT	rect;
	CDC		*pDC;

	offset_x = 20;
	offset_y = 200;

	palette = (u16*)agb_palram;
	pDC = this->GetDC();
	for(y = 0; y < 16 * 2; y++){
		for(x = 0; x < 16; x++){
			rect.left	= x * 14 + offset_x;
			rect.top	= y * 6 + offset_y;
			rect.right	= rect.left + 10;
			rect.bottom	= rect.top + 4;
			color16		= palette[x + y * 16];
			color16		= SWAP_RB(color16);
			color32		= RGB(((color16 >> 10) & 0x1F) << 3, 
							((color16 >> 5) & 0x1F) << 3, 
							((color16 >> 0) & 0x1F) << 3);
			pDC->FillSolidRect(&rect, (COLORREF)color32);
		}
	}

	ReleaseDC(pDC);
}

void CDispcntDlg::OnClose() 
{
	fDispcntDlg	= FALSE;
	EndDialog(0);
	//CDialog::OnClose();
}

BOOL CDispcntDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(WM_KEYDOWN == pMsg->message){
		switch(pMsg->wParam){
		case VK_ESCAPE:
			return FALSE;
		case VK_RETURN:
			return FALSE;
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CDispcntDlg::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg

	DrawDispcntLcd();
	DrawDispcntPalette();
	// `pbZ[WƂ CDialog::OnPaint() ĂяoĂ͂܂
}

void CDispcntDlg::OnButtonUpdate() 
{
	ShowDispcnt();
	DrawDispcntLcd();
	DrawDispcntPalette();
	m_temp_dispcnt = io_lcd->dispcnt;
}

void CDispcntDlg::OnRadioMode0() 
{
	m_temp_dispcnt = (m_temp_dispcnt & ~7) | 0;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE0);
}

void CDispcntDlg::OnRadioMode1() 
{
	m_temp_dispcnt = (m_temp_dispcnt & ~7) | 1;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE1);
}

void CDispcntDlg::OnRadioMode2() 
{
	m_temp_dispcnt = (m_temp_dispcnt & ~7) | 2;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE2);
}

void CDispcntDlg::OnRadioMode3() 
{
	m_temp_dispcnt = (m_temp_dispcnt & ~7) | 3;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE3);
}

void CDispcntDlg::OnRadioMode4() 
{
	m_temp_dispcnt = (m_temp_dispcnt & ~7) | 4;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE4);
}

void CDispcntDlg::OnRadioMode5() 
{
	m_temp_dispcnt = (m_temp_dispcnt & ~7) | 5;
	memset(DispBuffer, 0, AGB_LCD_SIZE * 2);
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE5);
}

void CDispcntDlg::OnRadioMode6() 
{
	m_temp_dispcnt = (m_temp_dispcnt & ~7) | 6;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE6);
}

void CDispcntDlg::OnRadioMode7() 
{
	m_temp_dispcnt = (m_temp_dispcnt & ~7) | 7;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE7);
}

void CDispcntDlg::OnButtonDummyPalette() 
{
	int i, j, k;

	for(i = j = 0; i < 0x400; i += 2){
		k = j >> 2;
		agb_palram[i] = ((k & 0x1F) << 5) | (k & 0x1F);
		agb_palram[i + 1] = (((k & 0x1F) << 10) | ((k & 0x1F) << 5) >> 8);
		j++;
	} 

	ShowDispcnt();
}

void CDispcntDlg::OnCheckBg0() 
{
	CButton* pBPchk;

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG0);
	if(m_temp_dispcnt & BG0_ENABLE){
		pBPchk->SetCheck(0);
		m_temp_dispcnt &= ~BG0_ENABLE;
	}else{
		pBPchk->SetCheck(1);
		m_temp_dispcnt |= BG0_ENABLE;
	}
	DrawDispcntLcd();
}

void CDispcntDlg::OnCheckBg1() 
{
	CButton* pBPchk;

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG1);
	if(m_temp_dispcnt & BG1_ENABLE){
		pBPchk->SetCheck(0);
		m_temp_dispcnt &= ~BG1_ENABLE;
	}else{
		pBPchk->SetCheck(1);
		m_temp_dispcnt |= BG1_ENABLE;
	}
	DrawDispcntLcd();
}

void CDispcntDlg::OnCheckBg2() 
{
	CButton* pBPchk;

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG2);
	if(m_temp_dispcnt & BG2_ENABLE){
		pBPchk->SetCheck(0);
		m_temp_dispcnt &= ~BG2_ENABLE;
	}else{
		pBPchk->SetCheck(1);
		m_temp_dispcnt |= BG2_ENABLE;
	}
	DrawDispcntLcd();
}

void CDispcntDlg::OnCheckBg3() 
{
	CButton* pBPchk;

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG3);
	if(m_temp_dispcnt & BG3_ENABLE){
		pBPchk->SetCheck(0);
		m_temp_dispcnt &= ~BG3_ENABLE;
	}else{
		pBPchk->SetCheck(1);
		m_temp_dispcnt |= BG3_ENABLE;
	}
	DrawDispcntLcd();
}

void CDispcntDlg::OnCheckWin1() 
{
	CButton* pBPchk;

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_WIN1);
	if(m_temp_dispcnt & WIN1_ENABLE){
		pBPchk->SetCheck(0);
		m_temp_dispcnt &= ~WIN1_ENABLE;
	}else{
		pBPchk->SetCheck(1);
		m_temp_dispcnt |= WIN1_ENABLE;
	}
	DrawDispcntLcd();
}

void CDispcntDlg::OnCheckWin2() 
{
	CButton* pBPchk;

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_WIN2);
	if(m_temp_dispcnt & WIN2_ENABLE){
		pBPchk->SetCheck(0);
		m_temp_dispcnt &= ~WIN2_ENABLE;
	}else{
		pBPchk->SetCheck(1);
		m_temp_dispcnt |= WIN2_ENABLE;
	}
	DrawDispcntLcd();
}

void CDispcntDlg::OnCheckWinobj()
{
	CButton* pBPchk;

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_WINOBJ);
	if(m_temp_dispcnt & WINOBJ_ENABLE){
		pBPchk->SetCheck(0);
		m_temp_dispcnt &= ~WINOBJ_ENABLE;
	}else{
		pBPchk->SetCheck(1);
		m_temp_dispcnt |= WINOBJ_ENABLE;
	}
	DrawDispcntLcd();
}

void CDispcntDlg::OnCheckBackbuffer() 
{
	CButton *pBPchk;

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BACKBUFFER);
	if(pBPchk->GetCheck()){
//		pBPchk->SetCheck(0);
		m_temp_dispcnt &= ~BACKBUFFER;
	}else{
//		pBPchk->SetCheck(1);
		m_temp_dispcnt |= BACKBUFFER;
	}

	DrawDispcntLcd();
}
