// MapDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "gbaemu.h"
#include "MapDlg.h"
#include "../include/externs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern DWORD dwSize;
LPBITMAPINFO map_info;

/////////////////////////////////////////////////////////////////////////////
// CMapDlg _CAO


CMapDlg::CMapDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMapDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMapDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void CMapDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMapDlg)
	DDX_Control(pDX, IDC_SCROLLBAR_Y, m_scrY);
	DDX_Control(pDX, IDC_SCROLLBAR_X, m_scrX);
	DDX_Control(pDX, IDC_SLIDER_MAP, m_sldMap);
	DDX_Control(pDX, IDC_SLIDER_CHAR, m_sldChar);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMapDlg, CDialog)
	//{{AFX_MSG_MAP(CMapDlg)
	ON_WM_CLOSE()
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_RADIO_SIZE_X256, OnRadioSizeX256)
	ON_BN_CLICKED(IDC_RADIO_SIZE_X512, OnRadioSizeX512)
	ON_BN_CLICKED(IDC_RADIO_SIZE_Y256, OnRadioSizeY256)
	ON_BN_CLICKED(IDC_RADIO_SIZE_Y512, OnRadioSizeY512)
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_BUTTON_UPDATE, OnButtonUpdate)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMapDlg bZ[W nh

void CMapDlg::OnOK()
{
	OnClose();
}

void CMapDlg::OnCancel()
{
	OnClose();
}

BOOL CMapDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	map_info = (LPBITMAPINFO)new char[dwSize];

	memset(map_info, 0, sizeof(BITMAPINFOHEADER));
	map_info->bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	map_info->bmiHeader.biWidth		= MAP_LCD_X;
	map_info->bmiHeader.biHeight	= -MAP_LCD_Y;
	map_info->bmiHeader.biPlanes	= 1;
	map_info->bmiHeader.biBitCount	= 16;

	memset(MapBuffer, 0,  MAP_LCD_X * MAP_LCD_Y);

	m_sldChar.SetRange(0, 3, TRUE);
	m_sldMap.SetRange(0, 31, TRUE);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_FRAME_MAP), 0, 10, 10,
					MAP_LCD_X, MAP_LCD_Y, SWP_NOACTIVATE | SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_SCROLLBAR_X), 0, 10, MAP_LCD_X + 10,
					MAP_LCD_X, 16, SWP_NOACTIVATE | SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_SCROLLBAR_Y), 0, MAP_LCD_X + 10,10, 
					16, MAP_LCD_X, SWP_NOACTIVATE | SWP_NOZORDER);

	m_offset_x = 0;
	m_offset_y = 0;

	OnRadioSizeX256();
	OnRadioSizeY256();

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CMapDlg::OnClose() 
{
	fMapDlg = FALSE;
	EndDialog(0);
	//CDialog::OnClose();
}

void CMapDlg::ShowMap()
{
	int pos;

	pos = (io_lcd->bg0cnt >> 2) & 3;
	m_sldChar.SetPos(pos);

	pos = (io_lcd->bg0cnt >> 8) & 0x1F;
	m_sldMap.SetPos(pos);

	DrawMap();
}

void CMapDlg::DrawMap()
{
	u32	map_x, map_y, tile_x, tile_y;
	u32	base_char, base_map, map_offset;
	u16	temp16;
	u16 *ppal16;
	u8	*char_ram;
	HBITMAP	hBitmap, hOldmap;
	HDC		hDC, hMemDC;

	hDC = GetDlgItem(IDC_FRAME_MAP)->GetDC()->m_hDC;

	ppal16		= (u16*)agb_palram;
	base_char	= (m_sldChar.GetPos() & 3) << 14;		/*16KBP*/
	base_map	= (m_sldMap.GetPos() & 0x1F) << 11;	/*2KBP*/
	for(map_y = m_offset_y; map_y < (m_offset_y + 32); map_y++){
		for(map_x = m_offset_x; map_x < (m_offset_x + 32); map_x++){
			map_offset = agb_vram[base_map + ((map_x + map_y * m_size_x) << 1)];
			char_ram = &agb_vram[(map_offset << 6) + base_char];
			for(tile_y = 0; tile_y < 8; tile_y++){
				for(tile_x = 0; tile_x < 8; tile_x++){
					temp16 = ppal16[*char_ram++];
					MapBuffer[tile_x + (map_x << 3) + (tile_y + (map_y << 3)) * MAP_LCD_X] = SWAP_RB(temp16);
				}
			}
		}
	}

	hMemDC	= CreateCompatibleDC(hDC);
	hBitmap	= CreateDIBitmap(hDC, &map_info->bmiHeader, CBM_INIT, 
								MapBuffer, map_info, DIB_RGB_COLORS);
	hOldmap	= (HBITMAP)SelectObject(hMemDC, hBitmap);
	StretchBlt(hDC, 0, 0, MAP_LCD_X, MAP_LCD_X, hMemDC, 0, 0, MAP_LCD_X, MAP_LCD_X, SRCCOPY);
	DeleteObject(hBitmap);
}

void CMapDlg::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	DrawMap();
	// `pbZ[WƂ CDialog::OnPaint() ĂяoĂ͂܂
}

void CMapDlg::OnRadioSizeX256() 
{
	m_size_x = 32;
	m_scrX.SetScrollRange(0, m_size_x - 32, TRUE);
	CheckRadioButton(IDC_RADIO_SIZE_X256, IDC_RADIO_SIZE_X512, IDC_RADIO_SIZE_X256);
	GetDlgItem(IDC_SCROLLBAR_X)->EnableWindow(FALSE);
	DrawMap();
}

void CMapDlg::OnRadioSizeX512() 
{
	m_size_x = 64;
	m_scrX.SetScrollRange(0, m_size_x - 32, TRUE);
	CheckRadioButton(IDC_RADIO_SIZE_X256, IDC_RADIO_SIZE_X512, IDC_RADIO_SIZE_X512);
//	GetDlgItem(IDC_SCROLLBAR_X)->EnableWindow(TRUE);
	DrawMap();
}

void CMapDlg::OnRadioSizeY256() 
{
	m_size_y = 32;
	m_scrY.SetScrollRange(0, m_size_y - 32, TRUE);
	CheckRadioButton(IDC_RADIO_SIZE_Y256, IDC_RADIO_SIZE_Y512, IDC_RADIO_SIZE_Y256);
	GetDlgItem(IDC_SCROLLBAR_Y)->EnableWindow(FALSE);
	DrawMap();
}

void CMapDlg::OnRadioSizeY512() 
{
	m_size_y = 64;
	m_scrY.SetScrollRange(0, m_size_y - 32, TRUE);
	CheckRadioButton(IDC_RADIO_SIZE_Y256, IDC_RADIO_SIZE_Y512, IDC_RADIO_SIZE_Y512);
//	GetDlgItem(IDC_SCROLLBAR_Y)->EnableWindow(TRUE);
	DrawMap();
}

void CMapDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	m_offset_y = m_scrY.GetScrollPos();

	switch(nSBCode) {
		case SB_LINEUP:	/*XN[o[̃{^*/
			if(m_offset_y)m_offset_y--;
			m_scrY.SetScrollPos(m_offset_y, TRUE);
			DrawMap();
			break;
		case SB_LINEDOWN:
			if(m_offset_y < m_size_y)m_offset_y++;
			m_scrY.SetScrollPos(m_offset_y, TRUE);
			DrawMap();
			break;
		case SB_PAGEUP:	/*XN[o[̗]*/
			if(m_offset_y)m_offset_y--;
			m_scrY.SetScrollPos(m_offset_y, TRUE);
			DrawMap();
			break;
		case SB_PAGEDOWN:
			if(m_offset_y < m_size_y)m_offset_y++;
			m_scrY.SetScrollPos(m_offset_y, TRUE);
			DrawMap();
			break;
		case SB_THUMBPOSITION:	/*XN[o[̂܂*/
		case SB_THUMBTRACK:
			m_scrY.SetScrollPos(nPos, TRUE);
			DrawMap();
			break;
	}

	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CMapDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	m_offset_x = m_scrX.GetScrollPos();

	switch(nSBCode) {
		case SB_LINEUP:	/*XN[o[̃{^*/
			if(m_offset_x)m_offset_x--;
			m_scrX.SetScrollPos(m_offset_x, TRUE);
			DrawMap();
			break;
		case SB_LINEDOWN:
			if(m_offset_x < m_size_x)m_offset_x++;
			m_scrX.SetScrollPos(m_offset_x, TRUE);
			DrawMap();
			break;
		case SB_PAGEUP:	/*XN[o[̗]*/
			if(m_offset_x)m_offset_x--;
			m_scrX.SetScrollPos(m_offset_x, TRUE);
			DrawMap();
			break;
		case SB_PAGEDOWN:
			if(m_offset_x < m_size_x)m_offset_x++;
			m_scrX.SetScrollPos(m_offset_x, TRUE);
			DrawMap();
			break;
		case SB_THUMBPOSITION:	/*XN[o[̂܂*/
		case SB_THUMBTRACK:
			m_scrX.SetScrollPos(nPos, TRUE);
			DrawMap();
			break;
	}

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CMapDlg::OnButtonUpdate() 
{
	ShowMap();
}

void CMapDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	delete map_info;
}

BOOL CMapDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(WM_KEYDOWN == pMsg->message){
		switch(pMsg->wParam){
		case VK_RETURN:
			return FALSE;
		case VK_ESCAPE:
			return FALSE;
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}
