// OamDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBAEmu.h"
#include "OamDlg.h"

#define	_AGBWIN32_
#include "../include/externs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


extern DWORD dwSize;
LPBITMAPINFO oam_info;
extern u32	agb_obj_size_table[4][4][2];



/////////////////////////////////////////////////////////////////////////////
// COamDlg _CAO


COamDlg::COamDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COamDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COamDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void COamDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COamDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COamDlg, CDialog)
	//{{AFX_MSG_MAP(COamDlg)
	ON_WM_CLOSE()
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_BUTTON_NEXT, OnButtonNext)
	ON_BN_CLICKED(IDC_BUTTON_RETURN, OnButtonReturn)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COamDlg bZ[W nh

void COamDlg::OnOK()
{
	OnClose();
}

void COamDlg::OnCancel()
{
	OnClose();
}

void COamDlg::ShowOam()
{
	u32 x, y, obj_x, obj_y, index_offset;
	u32	obj_size_x, obj_size_y, obj_pos_x, obj_pos_y;
	u32	obj_tile_x, obj_tile_y;
	u32	obj_number, obj_offset, obj_buf;
	u32	long_size;
	u16 *palette, *word_oam;
	u16	oam0, oam1, color16;
	u16 OamBuffer[64 * 64];
	char str[64];
	CDC* pODC;
	HDC	hMemDC;
	HBITMAP	hBitmap, hOldmap;

	sprintf(str, "%d", m_index);
	SetDlgItemText(IDC_EDIT_INDEX, str);

	/*FɃOf[Vɂ*/
	color16 = (grad_color<<10) | (grad_color<<5) | grad_color;
	for(x = 0; x < 64 * 64; x++)OamBuffer[x] = color16;
	if(grad_down){
		grad_color--;
		if(grad_color == 0){
			grad_down = 0;
		}
	}else{
		grad_color++;
		if(grad_color >= 31){
			grad_down = 1;
		}
	}

	palette		= (u16*)agb_palram;
	palette		+= 256;			/*XvCgpbgɈړ*/
	word_oam	= (u16*)agb_oam;
	oam0		= word_oam[m_index << 2];
	oam1		= word_oam[(m_index << 2) + 1];
	obj_pos_x	= oam1 & 0x1FF;
	obj_pos_y	= oam0 & 0xFF;
	obj_number	= word_oam[(m_index << 2) + 2] & 0x3FF;
	obj_size_x	= agb_obj_size_table[oam0 >> 14][oam1 >> 14][0];
	obj_size_y	= agb_obj_size_table[oam0 >> 14][oam1 >> 14][1];
	index_offset= 0x10000 + (obj_number << 5);

	sprintf(str, "%d, %d", obj_pos_x, obj_pos_y);
	SetDlgItemText(IDC_EDIT_POSITION, str);
	sprintf(str, "%d, %d", obj_size_x, obj_size_y);
	SetDlgItemText(IDC_EDIT_SIZE, str);
	sprintf(str, "%d", obj_number);
	SetDlgItemText(IDC_EDIT_TILE, str);
	sprintf(str, "%08Xh", 0x06000000 + index_offset);
	SetDlgItemText(IDC_EDIT_ADDRESS, str);

	/*IuWFNgTCY^C̕Kv߂*/
	obj_tile_x = obj_size_x >> 3;
	obj_tile_y = obj_size_y >> 3;
	for(obj_offset = y = 0; y < obj_tile_y; y++){
		for(x = 0; x < obj_tile_x; x++, obj_offset++){
			for(obj_y = 0; obj_y < 8; obj_y++){
				for(obj_x = 0; obj_x < 8; obj_x++){
					obj_buf = agb_vram[(obj_offset << 6) + obj_x + (obj_y << 3) + index_offset];
					if(obj_buf){
					color16 = palette[obj_buf];
					OamBuffer[(x << 3) + (((y << 3) + obj_y) << 6) + obj_x] = SWAP_RB(color16);
					}
				}
			}
		}
	}

	/*傫ɃIuWFNĝPӂ̒킹*/
	long_size = (obj_size_x > obj_size_y)?obj_size_x:obj_size_y;

	pODC = GetDlgItem(IDC_IMAGE_OAM)->GetDC();
	hMemDC	= ::CreateCompatibleDC(pODC->m_hDC);
	hBitmap	= ::CreateDIBitmap(pODC->m_hDC, &oam_info->bmiHeader, CBM_INIT, OamBuffer, oam_info, DIB_RGB_COLORS);
	hOldmap	= (HBITMAP)::SelectObject(hMemDC, hBitmap);
	StretchBlt(pODC->m_hDC, 0, 0, 64, 64, hMemDC, 0, 0, long_size, long_size, SRCCOPY);
	DeleteObject(hBitmap);

	ReleaseDC(pODC);
}

void COamDlg::OnClose() 
{
	fOamDlg = FALSE;
	EndDialog(0);
	//CDialog::OnClose();
}

BOOL COamDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	RECT DlgSize;
	GetClientRect(&DlgSize);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_IMAGE_OAM), 
		0, DlgSize.right - 79, 15, 64, 64, SWP_NOACTIVATE|SWP_NOZORDER);

	m_index = 0;

	oam_info = (LPBITMAPINFO)new char[dwSize];

	memset(oam_info, 0, sizeof(BITMAPINFOHEADER));
	oam_info->bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	oam_info->bmiHeader.biWidth		= 64;
	oam_info->bmiHeader.biHeight	= -64;
	oam_info->bmiHeader.biPlanes	= 1;
	oam_info->bmiHeader.biBitCount	= 16;

	grad_color	= 0;
	grad_down	= 0;

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void COamDlg::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	ShowOam();
	// `pbZ[WƂ CDialog::OnPaint() ĂяoĂ͂܂
}

void COamDlg::OnButtonNext() 
{
	if(m_index < 127)m_index++;
	ShowOam();
}

void COamDlg::OnButtonReturn() 
{
	if(m_index)m_index--;
	ShowOam();
}

BOOL COamDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(WM_KEYDOWN == pMsg->message){
		switch(pMsg->wParam){
		case VK_RETURN:
			return FALSE;
		case VK_ESCAPE:
			return FALSE;
		case VK_LEFT:
			OnButtonReturn();
			break;
		case VK_RIGHT:
			OnButtonNext();
			break;
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void COamDlg::OnDestroy() 
{
	CDialog::OnDestroy();

	delete oam_info;
}
