// TraceDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "gbaemu.h"
#include "TraceDlg.h"

#define	_AGBWIN32_
#include "../include/externs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CTraceDlg _CAO


CTraceDlg::CTraceDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTraceDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTraceDlg)
	//}}AFX_DATA_INIT
}


void CTraceDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTraceDlg)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTraceDlg, CDialog)
	//{{AFX_MSG_MAP(CTraceDlg)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, OnButtonClear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTraceDlg bZ[W nh

void CTraceDlg::OnOK()
{
	OnClose();
}

void CTraceDlg::OnCancel()
{
	OnClose();
}

BOOL CTraceDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	Trace(_TITLE_" - Console\n\n");

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CTraceDlg::OnClose() 
{
	fTraceDlg = FALSE;
	EndDialog(0);
	//CDialog::OnClose();
}

void CTraceDlg::OnButtonClear() 
{
	SetDlgItemText(IDC_EDIT_TRACE, "");
}

void CTraceDlg::Trace(char *str) 
{
	char *str_ptr, *buf_ptr;
	char buf[1024 * 5];

	GetDlgItemText(IDC_EDIT_TRACE, buf, 1024 * 4);

	/*sR[hϊ (\n => \r\n)*/
	str_ptr = str;
	buf_ptr = &buf[strlen(buf)];

	do{
		if(*str_ptr == '\n')*buf_ptr++ = '\r';
		*buf_ptr++ = *str_ptr++;
	}while(*str_ptr);

	*buf_ptr = *str_ptr;

	SetDlgItemText(IDC_EDIT_TRACE, buf);
}

BOOL CTraceDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(WM_KEYDOWN == pMsg->message){
		switch((BYTE)pMsg->wParam){
		case VK_RETURN:
			return FALSE;
		case VK_ESCAPE:
			return FALSE;
		}
	}
	
	return CDialog::PreTranslateMessage(pMsg);
}
