
#include <stdio.h>
#include <windows.h>
#include <ddraw.h>
#include <mmsystem.h>
#pragma comment(lib, "ddraw")
#pragma comment(lib, "winmm")

#include "gbdx.h"

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM);


#define SCREEN_WIDTH	320
#define SCREEN_HEIGHT	240
#define SCREEN_BPP		16

DDSURFACEDESC		ddsd;
LPDIRECTDRAWPALETTE	lpDPalette;
LPDIRECTDRAW		lpDD		=	NULL;
LPDIRECTDRAWSURFACE lpDDSPrimary=	NULL;
LPDIRECTDRAWSURFACE lpDDSBack	=	NULL;


int ShowOpenDialog(HWND hwnd, char *name)
{
	OPENFILENAME ofn;
	char filename[512];

	memset(filename, 0, 512);
	memset(&ofn, 0, sizeof(ofn));

	ofn.Flags		= OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrFile	= filename;
	ofn.lpstrFilter	= "Gameboy ROM Files (*.gb;*.bin;*.gbc)\0*.gb;*.bin;*.cgb;*.gbc;\0All Files (*.*)\0*.*\0\0\0";
	ofn.nMaxFileTitle	= 512;
	ofn.nMaxFile	= 512;
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.hwndOwner	= hwnd;
	
	if(GetOpenFileName(&ofn)){
		strcpy(name, filename);
		return 0;
	}

	return 1;
}

int InitializeDxSurface(HWND hwnd, BOOL fullscreen)
{
	DirectDrawCreate(NULL, &lpDD, NULL); // DirectDrawIuWFNg쐬
	if(!lpDD)return -1;
	if(fullscreen){
		lpDD->SetCooperativeLevel(hwnd, DDSCL_ALLOWMODEX | DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);
		lpDD->SetDisplayMode(SCREEN_WIDTH, SCREEN_HEIGHT, color_bit);
	}else{
		lpDD->SetCooperativeLevel(hwnd, DDSCL_NORMAL);
	}

	FillMemory(&ddsd, 0, sizeof(ddsd));
	ddsd.dwSize			= sizeof(ddsd);
	ddsd.dwFlags		= DDSD_CAPS | DDSCAPS_FLIP;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
	lpDD->CreateSurface(&ddsd, &lpDDSPrimary, NULL);
	
	lpDDSPrimary->GetSurfaceDesc(&ddsd);

    DDSCAPS ddscaps;
    ZeroMemory(&ddscaps, sizeof(ddscaps));
    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
	lpDDSPrimary->GetAttachedSurface(&ddscaps, &lpDDSBack);

	bit_r = GetColorShift(ddsd.ddpfPixelFormat.dwRBitMask);
	bit_g = GetColorShift(ddsd.ddpfPixelFormat.dwGBitMask);
	bit_b = GetColorShift(ddsd.ddpfPixelFormat.dwBBitMask);

#ifdef	_DEBUG
	FILE *fp = fopen("stdout.txt", "wt");

fprintf(fp, "%d\n", RGB16_8(0x1f));

	fprintf(fp, "Screen size: %d, %d\n", 
		ddsd.dwWidth, ddsd.dwHeight);
	fprintf(fp, "Pitch: %d\n", 
		ddsd.lPitch);
	fprintf(fp, "RefreshRate: %d\n", 
		ddsd.dwRefreshRate);
	fprintf(fp, "dwSize: %d\n", 
		ddsd.dwSize);
	fprintf(fp, "LinearSize: %d\n", 
		ddsd.dwLinearSize);

	fprintf(fp, "pixelR: %X\n", 
		ddsd.ddpfPixelFormat.dwRBitMask);
	fprintf(fp, "pixelG: %X\n", 
		ddsd.ddpfPixelFormat.dwGBitMask);
	fprintf(fp, "pixelB: %X\n", 
		ddsd.ddpfPixelFormat.dwBBitMask);

	for(int i = 0; i < 0x100; i++){
		z80.A = i;
		fprintf(fp, "%3d,", z80.A);
		_DAA();
		fprintf(fp, "%2X:", z80.A);
		z80.A = i;
		DAA();
		fprintf(fp, "%2X\n", z80.A);
	}

	fclose(fp);
#endif	/*_DEBUG*/

	return 0;
}

void InitializeDxPalette(BOOL bitmapmode)
{
	int i;
	PALETTEENTRY pePal[256];

	if(!bitmapmode){
		for(i = 0; i < 128; i++){
			pePal[i].peRed	= gb_mono_pal[i % 4];
			pePal[i].peGreen= gb_mono_pal[i % 4];
			pePal[i].peBlue	= gb_mono_pal[i % 4];
			pePal[i].peFlags= NULL;
		}

		cgb_initialize_palette(cgb_pal8);
		for(i = 128; i < 256; i++){
			pePal[i].peRed	= cgb_pal8[i - 128][0];
			pePal[i].peGreen= cgb_pal8[i - 128][1];
			pePal[i].peBlue	= cgb_pal8[i - 128][2];
			pePal[i].peFlags= NULL;
		}

		pePal[200].peRed	= 255;
		pePal[200].peGreen	= 0;
		pePal[200].peBlue	= 0;
		pePal[200].peFlags	= NULL;

		lpDD->CreatePalette(DDPCAPS_8BIT, pePal, &lpDPalette, NULL);
		lpDPalette->SetEntries(0, 0, 256, pePal);
		lpDDSPrimary->SetPalette(lpDPalette);
	}
}

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow)
{
	char filename[512];
	HWND hwnd;
	WNDCLASSEX  wndclass;

	gb_initialize_globals();
	strcpy(filename, szCmdLine);

	get_cmdline_filename(szCmdLine, filename);

	color_bit	= SCREEN_BPP;
	fFullscreen	= TRUE;
	fStrech		= TRUE;

	if(check_cmdline_flag(szCmdLine, "-ndib16")){
		fcolor16	= TRUE;
	}
	if(check_cmdline_flag(szCmdLine, "-nfullscreen")){
		fFullscreen	= FALSE;
	}
	if(check_cmdline_flag(szCmdLine, "-nstrech")){
		fStrech		= FALSE;
	}

	if(check_cmdline_flag(szCmdLine, "-bpp8")){
		color_bit	= 8;
	}
	if(check_cmdline_flag(szCmdLine, "-bpp16")){
		color_bit	= 16;
	}
	if(check_cmdline_flag(szCmdLine, "-bpp32")){
		color_bit	= 32;
	}

	color_bit	= 16;
	fcolor16	= (color_bit != 8)?TRUE:FALSE;

	wndclass.cbSize        = sizeof(wndclass);
	wndclass.style         = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc   = WndProc;
	wndclass.cbClsExtra    = 0;
	wndclass.cbWndExtra    = 0;
	wndclass.hInstance     = hInstance;
	wndclass.hIcon         = NULL;
	wndclass.hCursor       = LoadCursor(NULL,IDC_ARROW);
	wndclass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	wndclass.lpszMenuName  = NULL;
	wndclass.lpszClassName = "CWindow";
	wndclass.hIconSm       = NULL;
	RegisterClassEx(&wndclass);

	if(fFullscreen){
		hwnd = CreateWindowEx(WS_EX_TOPMOST, "CWindow", NULL, WS_POPUP, 
			0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, NULL, NULL, hInstance, NULL);
	}else{
		hwnd = CreateWindowEx(WS_EX_TOPMOST, "CWindow", GB_TITLE, WS_OVERLAPPEDWINDOW, 
			0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, NULL, NULL, hInstance, NULL);
	}

	if(!filename[0]){
		if(ShowOpenDialog(hwnd, filename))return -1;
	}
/*
FILE *fp;
SYSTEMTIME  st;
GetLocalTime(&st);
time_t time_sec;
tm *time;

fp = fopen("out.txt", "wt");

fprintf(fp, "%d, ", st.wSecond);
fprintf(fp, "%d, ", st.wMinute);
fprintf(fp, "%d, ", st.wHour);
fprintf(fp, "%d\n", st.wDay);

time = localtime(&time_sec);
fprintf(fp, "%d, ", time->tm_sec);
fprintf(fp, "%d, ", time->tm_min);
fprintf(fp, "%d, ", time->tm_hour);
fprintf(fp, "%d, ", time->tm_yday);
fprintf(fp, "%d\n", time->tm_year);

time = gmtime(&time_sec);
fprintf(fp, "%d, ", time->tm_sec);
fprintf(fp, "%d, ", time->tm_min);
fprintf(fp, "%d, ", time->tm_hour);
fprintf(fp, "%d, ", time->tm_yday);
fprintf(fp, "%d\n", time->tm_year);

tm ti;
_getsystime(&ti);
fprintf(fp, "%d, ", ti.tm_sec);
fprintf(fp, "%d, ", ti.tm_min);
fprintf(fp, "%d, ", ti.tm_hour);
fprintf(fp, "%d, ", ti.tm_yday);
fprintf(fp, "%d\n", ti.tm_year);

fclose(fp);
*/
	gb_open_rom(filename, gb_rom);
	get_filename(filename, openfilename);
/*
	if(!check_extension_name(filename, "zip")){
		OpenRomFile(filename);
	}else{
		OpenZipRomFile(filename);
	}
*/
	ShowWindow(hwnd, iCmdShow);
	UpdateWindow(hwnd);

	InitializeDxSurface(hwnd, fFullscreen);
	InitializeDxPalette(fcolor16);

	offset_screen = (ddsd.dwLinearSize / (color_bit >> 3)) * ((SCREEN_HEIGHT - GB_LCD_Y) / 2);
	offset_screen >>= 2;
	if(!fStrech)offset_screen >>= 1;

	gb_initialize_memory();
	gb_initialize_register();
	gb_open_save(openfilename, gb_rom, gb_exram);
	
	timeBeginPeriod(1);

	gb_mainloop();

	timeEndPeriod(1);

	gb_close_save(openfilename, gb_rom, gb_exram);
	gb_close_rom(gb_rom);

	lpDD->RestoreDisplayMode();
	if(lpDDSPrimary)lpDDSPrimary->Release();
	if(lpDD)lpDD->Release();

	return 0;
}

inline void gb_draw_lcd()
{
	static u32	x, y, color32;
	static u32	*lpVideoMemory32, *DxSurface32;
	static u32	fps_time;
	static u16	*LcdBuffer16, *lpVideoMemory16, *DxSurface16;
	static u16	color16;
	static u16	r, g, b;
	static u8	*LcdBuffer, *lpVideoMemory, *DxSurface;
	static char str[8];

	if(fFps){
		if(fps_time < timeGetTime()){
			fps_time = timeGetTime() + 1000;
			frame_count = (int)(frame_count / 59.0 * 100);
			sprintf(str, "%4d", frame_count);
			frame_count = 0;
		}
		switch(color_bit){
		case 8:
			DrawTextLcd(FrameBuffer8, 128, 134, str);
			break;
		case 16:
		case 32:
			DrawTextLcd16(FrameBuffer16, 128, 134, str);
			break;
		}
	}
	//lpDDSPrimary->Flip(NULL, DDFLIP_WAIT);

	lpDDSPrimary->Lock(NULL, &ddsd, DDLOCK_WAIT, NULL);
	if(fVsync)lpDD->WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN, 0);

	switch(color_bit){
	case 8:
		if(gb.cgb_mode){	// 16bi8bit֌F
			LcdBuffer = FrameBuffer8;
			LcdBuffer16 = FrameBuffer16;
			for(x = 0; x < GB_LCD_X * GB_LCD_Y; x++){
				color16 = *LcdBuffer16;
				*LcdBuffer = RGB16_8(color16) + 128;
				LcdBuffer++;
				LcdBuffer16++;
			}
		}
/*
for(x=0; x < 64; x++)FrameBuffer[x] = x + 128;
FrameBuffer[0] = 
FrameBuffer[1] = 
FrameBuffer[2] = 
FrameBuffer[3] = 
RGB16_8(0x1F);
*/
		if(fFps)DrawTextLcd(FrameBuffer8, 128, 134, str);
		lpVideoMemory = (unsigned char*)ddsd.lpSurface;
		lpVideoMemory += offset_screen;
		if(fStrech){
			for(y = 0; y < GB_LCD_Y; y++){
				for(x = 0; x < GB_LCD_X * 2; x += 2){
					LcdBuffer = &FrameBuffer8[(x>>1) + y * GB_LCD_X];
					DxSurface = &lpVideoMemory[x + y * 3 / 2 * ddsd.dwLinearSize];
					*DxSurface = *LcdBuffer;
					*(DxSurface + 1) = *LcdBuffer;
					if(y & 1){
						DxSurface += SCREEN_WIDTH;
						*DxSurface = *LcdBuffer;
						*(DxSurface + 1) = *LcdBuffer;
					}
				}
			}
		}else{
			LcdBuffer = FrameBuffer8;
			for(y = (SCREEN_HEIGHT - GB_LCD_Y) / 2; y<(SCREEN_HEIGHT - GB_LCD_Y) / 2 + GB_LCD_Y; y++){
				DxSurface = &lpVideoMemory[(ddsd.dwLinearSize - GB_LCD_X) / 2 + y * ddsd.dwLinearSize];
				for(x = 0; x < GB_LCD_X; x++){
					*DxSurface = *LcdBuffer;
					LcdBuffer++;
					DxSurface++;
				}
			}
		}
		break;
	case 16:
		lpVideoMemory16 = (unsigned short*)ddsd.lpSurface;
		lpVideoMemory16 += offset_screen;
		LcdBuffer16 = FrameBuffer16;
		if(fStrech){	/*2{, c1.5{*/
			for(y = 0; y < GB_LCD_Y; y++){
				for(x = 0; x < GB_LCD_X * 2; x += 2){
					DxSurface16 = &lpVideoMemory16[x + y * 3 / 2 * (ddsd.dwLinearSize / 2)];
					color16 = *LcdBuffer16;
					r = (color16>>10) & 0x1F;
					g = (color16>>5) & 0x1F;
					b = (color16>>0) & 0x1F;
					color16 = RGB16(r, g, b);
					*DxSurface16 = color16;
					*(DxSurface16 + 1) = color16;
					if(y & 1){
						DxSurface16 += ddsd.dwLinearSize / 2;
						*DxSurface16 = color16;
						*(DxSurface16 + 1) = color16;
					}
					LcdBuffer16++;
				}
			}
		}else{
			for(y = (SCREEN_HEIGHT - GB_LCD_Y) / 2; y<(SCREEN_HEIGHT - GB_LCD_Y) / 2 + GB_LCD_Y; y++){
				DxSurface16 = &lpVideoMemory16[(SCREEN_WIDTH - GB_LCD_X) / 2 + y * (ddsd.dwLinearSize / 2)];
				for(x = 0; x < GB_LCD_X; x++){
					color16 = *LcdBuffer16;
					r = (color16>>10) & 0x1F;
					g = (color16>>5) & 0x1F;
					b = (color16>>0) & 0x1F;
					color16 = RGB16(r, g, b);
					*DxSurface16 = color16;
					LcdBuffer16++;
					DxSurface16++;
				}
			}
		}
		break;
	case 32:
		lpVideoMemory32 = (unsigned int*)ddsd.lpSurface;
		lpVideoMemory32 += offset_screen;
		LcdBuffer16 = FrameBuffer16;
		if(fStrech){	/*2{, c1.5{*/
			for(y = 0; y < GB_LCD_Y; y++){
				for(x = 0; x < GB_LCD_X * 2; x += 2){
					DxSurface32 = &lpVideoMemory32[x + y * 3 / 2 * (ddsd.dwLinearSize / 4)];
					color32 = RGB16_32(*LcdBuffer16);
					*DxSurface32 = color32;
					*(DxSurface32 + 1) = color32;
					if(y & 1){
						DxSurface32 += ddsd.dwLinearSize / 4;
						*DxSurface32 = color32;
						*(DxSurface32 + 1) = color32;
					}
					LcdBuffer16++;
				}
			}
		}else{
			for(y = (SCREEN_HEIGHT - GB_LCD_Y) / 2; y<(SCREEN_HEIGHT - GB_LCD_Y) /2 + GB_LCD_Y; y++){
				DxSurface32 = &lpVideoMemory32[(SCREEN_WIDTH - GB_LCD_X) / 2 + y * (ddsd.dwLinearSize / 4)];
				for(x = 0; x < GB_LCD_X; x++){
					*DxSurface32 = RGB16_32(*LcdBuffer16);
					LcdBuffer16++;
					DxSurface32++;
				}
			}
		}
		break;
	default:
		z80.running = FALSE;
	}

	lpDDSPrimary->Unlock(NULL);
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	switch(iMsg){
		case WM_DESTROY:
		//case WM_KILLFOCUS:
			z80.running = FALSE;
			break;
		case WM_KEYDOWN:
			switch(wParam){
			case VK_RIGHT:
				gb.keyflag &= ~0x01;
				gb.keyint = 1;
				break;
			case VK_LEFT:
				gb.keyflag &= ~0x02;
				gb.keyint = 1;
				break;
			case VK_UP:
				gb.keyflag &= ~0x04;
				gb.keyint = 1;
				break;
			case VK_DOWN:
				gb.keyflag &= ~0x08;
				gb.keyint = 1;
				break;
			case 'Z':
				gb.keyflag &= ~0x10;
				gb.keyint = 1;
				break;
			case 'X':
				gb.keyflag &= ~0x20;
				gb.keyint = 1;
				break;
			case ' ':
				gb.keyflag &= ~0x40;
				gb.keyint = 1;
				break;
			case VK_RETURN:
				gb.keyflag &= ~0x80;
				gb.keyint = 1;
				break;
			case VK_ESCAPE:
				z80.running = FALSE;
				break;
			case 'S':
				fVsync = !fVsync;
				frame_skip = fVsync?0:6;
				break;
			case 'F':
				fFps = !fFps;
				break;
			case VK_F1:
				gb_close_save_state();
				break;
			case VK_F2:
				gb_open_save_state();
				break;
			}
			break;
		case WM_KEYUP:
			switch(wParam){
			case VK_RIGHT:
				gb.keyflag |= 0x01;
				gb.keyint = 2;
				break;
			case VK_LEFT:
				gb.keyflag |= 0x02;
				gb.keyint = 2;
				break;
			case VK_UP:
				gb.keyflag |= 0x04;
				gb.keyint = 2;
				break;
			case VK_DOWN:
				gb.keyflag |= 0x08;
				gb.keyint = 2;
				break;
			case 'Z':
				gb.keyflag |= 0x10;
				gb.keyint = 2;
				break;
			case 'X':
				gb.keyflag |= 0x20;
				gb.keyint = 2;
				break;
			case ' ':
				gb.keyflag |= 0x40;
				gb.keyint = 2;
				break;
			case VK_RETURN:
				gb.keyflag |= 0x80;
				gb.keyint = 2;
				break;
			}
			break;
	}

	return DefWindowProc(hwnd, iMsg, wParam, lParam);
}

