
/*	
	GameboyVM - Nintendo Gameboy Emulator
		Copyright 2002 Y_N y_n@users.sourceforge.jp
		Homepage https://sourceforge.jp/projects/gbemu/
*/



static void DrawLine()
{	/*8bitpbg*/
	static u8	tdd, tds, tilebit, tmp8, bgp[4], obp[3];
	static u16	tdba, tda, tma, tmpx;
	static u8	Start, tpy, mpy, mpx;
	static s32	fba, offset, tma_offset;

	static u8 LineBuffer[176];

	/*if(MEM[R_LY]>=144)return;*/	/*A͕`悵Ȃ*/

	tma_offset=0;

	bgp[0]=MEM[R_BGP]&0x03;	/*BG,WNDppbg*/
	bgp[1]=(MEM[R_BGP]>>2)&0x03+4;
	bgp[2]=(MEM[R_BGP]>>4)&0x03+8;
	bgp[3]=(MEM[R_BGP]>>6)&0x03+12;

	memset(LineBuffer, 0, 176);

	if(MEM[R_LCDC]&0x10){	/*^Cf[^̃x[XAhX̑I*/
		tdba=0x8000;
		offset=0x00;
	}else{
		tdba=0x8800;
		offset=0x80;	/*t*/
	}

	Start=MEM[R_SCX];
	mpx=Start/8;	/*^C}bvX*/
	Start%=8;	/*^Cf[^̃CX*/
	
	tpy=MEM[R_SCY]+MEM[R_LY];
	mpy=tpy/8;	/*^C}bvY*/
	tpy%=8;	/*^Cf[^̃CY*/

	if((MEM[R_LCDC]&0x01) && EnableBG){	/*BG̕\*/
		tma=(MEM[R_LCDC]&0x08)?0x9C00:0x9800;	/*^C}bṽAhXI*/
		tma+=mpx+(mpy<<5);
		for(tmpx=0; tmpx<168; tmpx+=8){
			if((31-mpx)<(tmpx>>3))tma_offset=32;	/*^C̃I[o[bv*/
/*			if(offset)tda=0x9000+((s8)(MEM[(tma++)-tma_offset])<<4)+(tpy<<1);
			else tda=tdba+((u8)(MEM[(tma++)-tma_offset])<<4)+(tpy<<1);*/
			tda=tdba+((u8)(MEM[(tma++)-tma_offset]-offset)<<4)+(tpy<<1);
			tdd=MEM[tda++];
			tds=MEM[tda];
			fba=tmpx+8;
			for(tilebit=0x80; tilebit; tilebit>>=1, fba++){
				if(~tdd&~tds&tilebit)LineBuffer[fba]=bgp[0];
				if(tdd&~tds&tilebit)LineBuffer[fba]=bgp[1];
				if(~tdd&tds&tilebit)LineBuffer[fba]=bgp[2];
				if(tdd&tds&tilebit)LineBuffer[fba]=bgp[3];
			}
		}
	}

	if((MEM[R_LCDC]&0x20) && EnableWND){	/*EBhE̕\*/
		if(MEM[R_WY]<144 && MEM[R_LY]>=MEM[R_WY] && MEM[R_WX]<167 && MEM[R_WX]>=7){
			tpy=MEM[R_LY]-MEM[R_WY];
			mpy=tpy/8;	/*^C}bvY*/
			tpy%=8;	/*^Cf[^̃CY*/
			tma=(MEM[R_LCDC]&0x40)?0x9C00:0x9800;
			tma+=mpy<<5;
			for(tmpx=MEM[R_WX]; tmpx<168; tmpx+=8){
				tda=tdba+((u8)(MEM[tma++]+offset)<<4)+(tpy<<1);
				tdd=MEM[tda++];
				tds=MEM[tda];
				fba=tmpx+Start;
				for(tilebit=0x80; tilebit; tilebit>>=1, fba++){
					if(~tdd&~tds&tilebit)LineBuffer[fba]=bgp[0];
					if(tdd&~tds&tilebit)LineBuffer[fba]=bgp[1];
					if(~tdd&tds&tilebit)LineBuffer[fba]=bgp[2];
					if(tdd&tds&tilebit)LineBuffer[fba]=bgp[3];
				}
			}
		}
	}

	if((MEM[R_LCDC]&0x02) && EnableOBJ){
		for(tma=0xFE02; tma<0xFEA2; tma+=4){
			if(OBJ_X && OBJ_Y){	/*XvCg͈͊Oɂ:Е̍WO*/
				fba=0;	/*͈͓ɏ*/
				tpy=MEM[R_LY]-OBJ_Y+16;
				if(MEM[R_LCDC]&0x04){	/*8*16[h*/
					if(tpy>=16)fba=255;	/*YW͈͊O*/
					else fba=OBJ_X+Start;
					tmp8=MEM[tma]&0xFE;	/*LSB͖*/
					offset=tpy<<1;
					if(OBJ_F&0x40)offset=0x1E-offset;	/*Y]*/
				}else{	/*8*8[h*/
					if(tpy>=8)fba=255;	/*YW͈͊O*/
					else fba=OBJ_X+Start;
					tmp8=MEM[tma];
					offset=tpy<<1;
					if(OBJ_F&0x40)offset=0x0E-offset;	/*Y]*/
				}
				if(0<=fba && fba<176){	/*XvCgʊȌꍇI[o[t[*/
					tda=0x8000+(tmp8<<4)+offset;
					tdd=MEM[tda++];
					tds=MEM[tda];	
					/*OBJppbg, ʂQrbg͓F*/
					obp[0]=(OBJ_F&0x10)?0x03&(MEM[R_OBP1]>>2):0x03&(MEM[R_OBP0]>>2);
					obp[1]=(OBJ_F&0x10)?0x03&(MEM[R_OBP1]>>4):0x03&(MEM[R_OBP0]>>4);
					obp[2]=(OBJ_F&0x10)?0x03&(MEM[R_OBP1]>>6):0x03&(MEM[R_OBP0]>>6);
					for(tilebit=OBJ_F&0x20?0x01:0x80; tilebit;	/*XvCĝX]*/
						tilebit=OBJ_F&0x20?tilebit*2:tilebit/2, fba++){
						if(OBJ_F & 0x80){	/*DxႢXvCg̕\*/
							if(!LineBuffer[fba]){	/*pbgԍO*/
								if(tdd&~tds&tilebit)LineBuffer[fba]=obp[0];
								if(~tdd&tds&tilebit)LineBuffer[fba]=obp[1];
								if(tdd&tds&tilebit)LineBuffer[fba]=obp[2];
							}
						}else{	/*DxXvCg\*/
							if(tdd&~tds&tilebit)LineBuffer[fba]=obp[0];
							if(~tdd&tds&tilebit)LineBuffer[fba]=obp[1];
							if(tdd&tds&tilebit)LineBuffer[fba]=obp[2];
						}
					}
				}
			}
		}
	}

	Start+=8;
	fba=MEM[R_LY]*160;
	for(tmpx=0; tmpx<160; tmpx++){
		FrameBuffer[fba+tmpx]=LineBuffer[tmpx+Start];
	}

}



#ifdef	_WIN32_GDI
static void DrawLine16()
{	/*16bitrbg}bv*/
	u8	tdd, tds, tilebit, tmp8;
	u16	tdba, tda, tma, tmpx;
	u8	Start, tpy, mpy, mpx, offset, tma_offset;
	u32	fba;
	u16 bgp[4], obp[3];
	static u16 LineBuffer[176];

	/*if(MEM[R_LY]>=144)return;*/	/*A͕`悵Ȃ*/

	tma_offset=0;

	bgp[0]=Colours16[(MEM[R_BGP]&0x03)];	/*BG,WNDppbg*/
	bgp[1]=Colours16[(MEM[R_BGP]>>2&0x03)]+1;
	bgp[2]=Colours16[(MEM[R_BGP]>>4&0x03)]+2;
	bgp[3]=Colours16[(MEM[R_BGP]>>6&0x03)]+3;

	memset(LineBuffer, 0, 176);

	if(MEM[R_LCDC]&0x10){	/*^Cf[^̃x[XAhX̑I*/
		tdba=0x8000;
		offset = 0x00;
	}else{
		tdba=0x8800;
		offset = 0x80;	/*t*/
	}

	Start=MEM[R_SCX];
	mpx=Start/8;	/*^C}bvX*/
	Start%=8;	/*^Cf[^̃CX*/
	
	tpy=MEM[R_SCY]+MEM[R_LY];
	mpy=tpy/8;	/*^C}bvY*/
	tpy%=8;	/*^Cf[^̃CY*/

	if((MEM[R_LCDC]&0x01) && EnableBG){	/*BG̕\*/
		tma=(MEM[R_LCDC]&0x08)?0x9C00:0x9800;	/*^C}bṽAhXI*/
		tma+=mpx+(mpy<<5);
		for(tmpx=0; tmpx<168; tmpx+=8){
			if((31-mpx)<(tmpx>>3))tma_offset=32;	/*^C̃I[o[bv*/
			tda=tdba+((u8)(MEM[(tma++)-tma_offset]-offset)<<4)+(tpy<<1);
			tdd=MEM[tda++];
			tds=MEM[tda];
			fba=tmpx+8;
			for(tilebit=0x80; tilebit; tilebit>>=1, fba++){
				if(~tdd&~tds&tilebit)LineBuffer[fba]=bgp[0];
				if(tdd&~tds&tilebit)LineBuffer[fba]=bgp[1];
				if(~tdd&tds&tilebit)LineBuffer[fba]=bgp[2];
				if(tdd&tds&tilebit)LineBuffer[fba]=bgp[3];
			}
		}
	}

	if((MEM[R_LCDC]&0x20) && EnableWND){	/*EBhE̕\*/
		if(MEM[R_WY]<144 && MEM[R_LY]>=MEM[R_WY] && MEM[R_WX]<167 && MEM[R_WX]>=7){
			tpy=MEM[R_LY]-MEM[R_WY];
			mpy=tpy/8;	/*^C}bvY*/
			tpy%=8;	/*^Cf[^̃CY*/
			tma=(MEM[R_LCDC]&0x40)?0x9C00:0x9800;
			tma+=mpy<<5;
			for(tmpx=MEM[R_WX]; tmpx<168; tmpx+=8){
				tda=tdba+((u8)(MEM[tma++]+offset)<<4)+(tpy<<1);
				tdd=MEM[tda++];
				tds=MEM[tda];
				fba=tmpx+Start;
				for(tilebit=0x80; tilebit; tilebit>>=1, fba++){
					if(~tdd&~tds&tilebit)LineBuffer[fba]=bgp[0];
					if(tdd&~tds&tilebit)LineBuffer[fba]=bgp[1];
					if(~tdd&tds&tilebit)LineBuffer[fba]=bgp[2];
					if(tdd&tds&tilebit)LineBuffer[fba]=bgp[3];
				}
			}
		}
	}

	if((MEM[R_LCDC]&0x02) && EnableOBJ){
		for(tma=0xFE02; tma<0xFEA2; tma+=4){
			if(OBJ_X && OBJ_Y){	/*XvCg͈͊Oɂ:Е̍WO*/
				fba=0;	/*͈͓ɏ*/
				tpy=MEM[R_LY]-OBJ_Y+16;
				if(MEM[R_LCDC]&0x04){	/*8*16[h*/
					if(tpy>=16)fba=255;	/*YW͈͊O*/
					else fba=OBJ_X+Start;
					tmp8=MEM[tma]&0xFE;	/*LSB͖*/
					offset=tpy<<1;
					if(OBJ_F&0x40)offset=0x1E-offset;	/*Y]*/
				}else{	/*8*8[h*/
					if(tpy>=8)fba=255;	/*YW͈͊O*/
					else fba=OBJ_X+Start;
					tmp8=MEM[tma];
					offset=tpy<<1;
					if(OBJ_F&0x40)offset=0x0E-offset;	/*Y]*/
				}
				if(0<=fba && fba<176){	/*XvCgʊȌꍇI[o[t[*/
					tda=0x8000+(tmp8<<4)+offset;
					tdd=MEM[tda++];
					tds=MEM[tda];	
					/*OBJppbg, ʂQrbg͓F*/
					obp[0]=(OBJ_F&0x10)?0x03&(MEM[R_OBP1]>>2):0x03&(MEM[R_OBP0]>>2);
					obp[1]=(OBJ_F&0x10)?0x03&(MEM[R_OBP1]>>4):0x03&(MEM[R_OBP0]>>4);
					obp[2]=(OBJ_F&0x10)?0x03&(MEM[R_OBP1]>>6):0x03&(MEM[R_OBP0]>>6);
					obp[0]=Colours16[(obp[0])];
					obp[1]=Colours16[(obp[1])];
					obp[2]=Colours16[(obp[2])];
					for(tilebit=OBJ_F&0x20?0x01:0x80; tilebit;	/*XvCĝX]*/
						tilebit=OBJ_F&0x20?tilebit*2:tilebit/2, fba++){
						if(OBJ_F & 0x80){	/*DxႢXvCg̕\*/
							if(LineBuffer[fba]==Colours16[0]){	/*pbgԍO*/
								if(tdd&~tds&tilebit)LineBuffer[fba]=obp[0];
								if(~tdd&tds&tilebit)LineBuffer[fba]=obp[1];
								if(tdd&tds&tilebit)LineBuffer[fba]=obp[2];
							}
						}else{	/*DxXvCg\*/
							if(tdd&~tds&tilebit)LineBuffer[fba]=obp[0];
							if(~tdd&tds&tilebit)LineBuffer[fba]=obp[1];
							if(tdd&tds&tilebit)LineBuffer[fba]=obp[2];
						}
					}
				}
			}
		}
	}

	Start+=8;
	fba=MEM[R_LY]*160;
	for(tmpx=0; tmpx<160; tmpx++){
		FrameBuffer16[fba+tmpx]=LineBuffer[tmpx+Start];
	}
}



void Smoothing()
{
	int	x0=10,y0=10,x1=160,y1=144;
	int i,j,k,l;
	int	ra,ga,ba,rb,gb,bb,rc,gc,bc,rd,gd,bd;
	int	rab,rcd,gab,gcd,bab,bcd,rabcd,gabcd,babcd;
	int	size=5;
	u16	color;

	for(j=size/2;j<143-size/2;j+=size){
		for(i=size/2;i<159-size/2;i+=size){
		color=FrameBuffer16[x1+i,y0+j];
		ra=(color>>10)&0x1F;
		ga=(color>>5)&0x1F;
		ba=color&0x1F;
		color=FrameBuffer16[x1+i+size,y0+j];
		rb=(color>>10)&0x1F;
		gb=(color>>5)&0x1F;
		bb=color&0x1F;
		color=FrameBuffer16[x1+i,y0+j+size];
		rc=(color>>10)&0x1F;
		gc=(color>>5)&0x1F;
		bc=color&0x1F;
		color=FrameBuffer16[x1+i+size,y0+j+size];
		rd=(color>>10)&0x1F;
		gd=(color>>5)&0x1F;
		bd=color&0x1F;
		for(k=0;k<size;k++)
			for(l=0;l<size;l++){
				rab=(rb-ra)*k/size+ra;
				rcd=(rd-rc)*k/size+rc;
				rabcd=(rcd-rab)*l/size+rab;
				gab=(gb-ga)*k/size+ga;
				gcd=(gd-gc)*k/size+gc;
				gabcd=(gcd-gab)*l/size+gab;
				bab=(bb-ba)*k/size+ba;
				bcd=(bd-bc)*k/size+bc;
				babcd=(bcd-bab)*l/size+bab;
				FrameBuffer16[(x0+i+k)*(y1+j+l)]=(rabcd<<10)+(gabcd<<5)+babcd;
			}
		}
	}
}
#endif	/*_WIN32_GDI*/

