// GBEmuDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBEmu.h"
#include "TilesDlg.h"
#include "Maps.h"
#include "Disasm.h"
#include "GBEmuDlg.h"
#include "AboutDlg.h"
#include <mmsystem.h>
#pragma comment(lib, "winmm.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define	_WIN32_GDI
#define	_WIN_CMN

CGBEmuDlg GBEmu;

static void CPU();					// CPUG~[V
void InitializeMemory();			// IOWX^̏
void InitializeRegister();			// CPUWX^̏
void InitializeVideo(HDC hDC);		// obNobt@̏
static void DrawLine();				// LYWX^̃C쐬
static void DrawLine16();
static void Interrupt();
static void EndInterrupt();
void InitializeVideo16(HDC hDC);
int OpenRomFile(char*);
int CloseGBMemory();

#include "../include/defines.h"
#include "../gbcore/memory.c"
#include "../gbcore/rom.c"
#include "../gbcore/cpu_cb.c"
#include "../gbcore/cpu.c"
#include "../gbcore/sound.c"
#include "../gbcore/video.c"
#include "../gbcore/mainloop.c"

/////////////////////////////////////////////////////////////////////////////
// CGBEmuDlg _CAO

CGBEmuDlg::CGBEmuDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGBEmuDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGBEmuDlg)
		// : ̈ʒu ClassWizard ɂăȍǉ܂B
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	
	m_pTMain	=	NULL;
	m_pTGUI		=	NULL;
	m_pTileDlg	=	NULL;
	m_pMapDlg	=	NULL;
	m_pMemDlg	=	NULL;
	m_pDasm		=	NULL;
	m_pObjDlg	=	NULL;
	m_pKeyDlg	=	NULL;
}

void CGBEmuDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGBEmuDlg)
		// : ̏ꏊɂ ClassWizard ɂ DDX  DDV ̌Ăяoǉ܂B
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGBEmuDlg, CDialog)
	//{{AFX_MSG_MAP(CGBEmuDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_MENU_EXIT, OnMenuExit)
	ON_COMMAND(ID_MENU_ABOUT, OnMenuAbout)
	ON_COMMAND(ID_MENU_OPEN, OnMenuOpen)
	ON_COMMAND(ID_MENU_RESET, OnMenuReset)
	ON_COMMAND(ID_SHOW_FPS, OnShowFps)
	ON_WM_CLOSE()
	ON_COMMAND(ID_PRIORITY_NORMAL, OnPriorityNormal)
	ON_COMMAND(ID_PRIORITY_HIGHEST, OnPriorityHighest)
	ON_COMMAND(ID_PRIORITY_LOWEST, OnPriorityLowest)
	ON_COMMAND(ID_PRIORITY_ABOVE, OnPriorityAbove)
	ON_COMMAND(ID_PRIORITY_BELOW, OnPriorityBelow)
	ON_COMMAND(ID_SHOW_TILES, OnShowTiles)
	ON_COMMAND(ID_SHOW_MAP, OnShowMap)
	ON_COMMAND(ID_VSYNC, OnVsync)
	ON_WM_DROPFILES()
	ON_COMMAND(ID_SHOW_MEMORY, OnShowMemory)
	ON_WM_SIZE()
	ON_COMMAND(ID_ZOOM1, OnZoom1)
	ON_COMMAND(ID_ZOOM2, OnZoom2)
	ON_COMMAND(ID_ZOOM3, OnZoom3)
	ON_COMMAND(ID_ZOOM4, OnZoom4)
	ON_COMMAND(ID_SHOW_DEBUG, OnShowDebug)
	ON_WM_ACTIVATE()
	ON_COMMAND(ID_SKIP0, OnSkip0)
	ON_COMMAND(ID_SKIP5, OnSkip5)
	ON_COMMAND(ID_SKIP1, OnSkip1)
	ON_COMMAND(ID_SKIP2, OnSkip2)
	ON_COMMAND(ID_SKIP3, OnSkip3)
	ON_COMMAND(ID_SKIP4, OnSkip4)
	ON_COMMAND(ID_LAYER_BG, OnLayerBg)
	ON_COMMAND(ID_LAYER_OBJ, OnLayerObj)
	ON_COMMAND(ID_LAYER_WND, OnLayerWnd)
	ON_COMMAND(ID_PALETTE1, OnPalette1)
	ON_COMMAND(ID_PALETTE2, OnPalette2)
	ON_COMMAND(ID_PALETTE3, OnPalette3)
	ON_COMMAND(ID_MENU_DISABLE_ALL, OnMenuDisableAll)
	ON_COMMAND(ID_SHOW_OAM, OnShowOam)
	ON_COMMAND(ID_SOUND_ENABLE, OnSoundEnable)
	ON_COMMAND(ID_MENU_16BITDIB, OnMenu16bitdib)
	ON_COMMAND(ID_MENU_8BITDIB, OnMenu8bitdib)
	ON_COMMAND(ID_SOUND_CH1, OnSoundCh1)
	ON_COMMAND(ID_SOUND_CH2, OnSoundCh2)
	ON_COMMAND(ID_SOUND_CH3, OnSoundCh3)
	ON_COMMAND(ID_MENU_KEY, OnMenuKey)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGBEmuDlg bZ[W nh

BOOL CGBEmuDlg::OnInitDialog()
{ // _CAȌ
	CDialog::OnInitDialog();

	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIcon, FALSE);		// ACRݒ

	// LCDpɉʂ̃foCXReLXg擾
	hDC = ::GetDC(m_hWnd);
	InitializeVideo(hDC);					// LCDprbg}bv
	::ReleaseDC(m_hWnd, hDC);
	CDialog::GetClientRect(&DlgSize);
	timeBeginPeriod(1);					// ^C}̐xŏ

	fTileDlg=fMapDlg=fMemDlg=fAsmDlg=fObjDlg=fKeyDlg=false;
	fUpdate=fNext=fBreak=f16Dib=Os9x=fRun=fStop=fTMain=false;

/*	HMODULE	hZipDll = LoadLibrary("unzip32.dll");
	if(hZipDll){
		GBEmu.MessageBox(NULL, NULL, MB_OK);
	}
	typedef HANDLE (__stdcall *GETFUNCTION)(const HWND, LPCSTR,const DWORD);
	GETFUNCTION UnZipOpenArchive = (GETFUNCTION)GetProcAddress(hZipDll, "UnZipOpenArchive");
*/
	OSVERSIONINFO	osInfo;
	osInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&osInfo);
	if(osInfo.dwPlatformId==VER_PLATFORM_WIN32_WINDOWS)Os9x=true;

	//  NCAg̈LCD̉𑜓xƍ킹
	SetRect(&DlgSize, 0, 0, GB_LCD_X, GB_LCD_Y);
	AdjustWindowRect(&DlgSize, (WS_OVERLAPPEDWINDOW&~WS_THICKFRAME) | WS_DLGFRAME, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	memset(FrameBuffer, 3, GB_LCD_X*GB_LCD_Y);
	MEM[R_LCDC]|=0x80;

	if(__argv[1]){
		if(OpenRomFile(__argv[1]))return TRUE;
/*		fp = fopen(__argv[1] ,"rb");
		fread(ROM, 1, ROM_SIZE, fp);*/
		OnMenuReset();
	}
	
	//OnSoundEnable();
	
	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CGBEmuDlg::OnPaint() 
{ // EBhEANeBu̍ĕ`
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	} else {
		CDialog::OnPaint();

		DrawLCD();

	}
}

void CGBEmuDlg::ShowFps()
{	/*t[b\*/
	if(FpsTime < timeGetTime()){
		FpsTime = timeGetTime() + 1000;
		strcpy(title, _TITLE" - ");
		_itoa((int)((FrameCount)/59.0*100), frame, 10);
		FrameCount = 0;
		strcat(frame, "%");
		strcat(title, frame);
		CDialog::SetWindowText(title);
	}
}

void CGBEmuDlg::UpdateGUI()
{	/*fobK̍XV*/
	u16 Wait_A = 1000;
	u16 Wait_B = 28;
	DWORD Time_A = timeGetTime() + Wait_A;

	while(CPUIsRunning && !fUpdate){
		if(Time_A < timeGetTime()){
			Time_A = timeGetTime() + Wait_A;
			if(fTileDlg)m_pTileDlg->ShowTiles();	// ^Cr[A̍XV
			if(fMapDlg)m_pMapDlg->ShowMaps();		// }bvr[A̍XV
			if(fObjDlg)m_pObjDlg->ShowObj();		// OAMr[A̍XV
			if(fAsmDlg)m_pDasm->UpdateStack(true);	// X^bNr[A̍XV
		}
		if(fAsmDlg){
			m_pDasm->UpdateRegs();	// WX^r[AXV
			m_pDasm->UpdateStack(false);	// X^bNr[ȂI
			m_pDasm->SetDisasm();	// tAZȗI
		}
		if(fMemDlg)m_pMemDlg->ShowMemory();
		Sleep(Wait_B);
	}
	
	CDialog::SetWindowText(_TITLE);
}

void CGBEmuDlg::OnMenuOpen()
{ // ROMt@C̑I
	OPENFILENAME ofn;
	char filename[512];
	bool tmpfRun;

	memset(filename, 0, 512);
	memset(&ofn, 0, sizeof(ofn));
	ofn.Flags		= OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrFile	= filename;
	ofn.lpstrFilter	= "Gameboy ROM Files (*.gb;*.bin)\0*.gb;*.gbc;*.bin\0All Files (*.*)\0*.*";
	ofn.nMaxFileTitle	= 512;
	ofn.nMaxFile	= 512;
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.hwndOwner	= m_hWnd;

	tmpfRun=fRun;
	fRun=true;	/*XbhI邽߂ɃW[*/
	if(GetOpenFileName(&ofn)){
		if(fp!=NULL)fclose(fp);
		if(CPUIsRunning)WaitForTMain();
		if(OpenRomFile(filename)){
			MessageBox("mۂł܂łB", 0, MB_ICONSTOP);
			return;
		}
		OnMenuReset();
	}
	fRun=tmpfRun;
}

void CGBEmuDlg::OnMenuReset() 
{	// WX^ƃ̏,s
	BYTE tmp8;

	if(fp!=NULL){
		WaitForTMain();
		tmp8=ROM[0][0x0148];
		if(!(tmp8>=0x00 && tmp8<=0x04)){
				MessageBox("Unsupported ROM size", NULL, MB_ICONSTOP);
				return;
		}
		InitializeRegister();
		InitializeMemory();
		m_pTGUI = AfxBeginThread(ThreadGUI, this);
		m_pTMain = AfxBeginThread(ThreadMain, this);
		OnPriorityAbove();
	}
}

void CGBEmuDlg::WaitForTMain()
{	// C[vXbh̏I҂
	CPUIsRunning=0;
//	CDialog::SetWindowText("Waiting...");
	if(fTMain)Sleep(10);
	if(fTMain)Sleep(50);
	if(fTMain)Sleep(200);
	if(fTMain)Sleep(500);
	if(fTMain){
		CDialog::SetWindowText("Error");
		ResumeThread(m_pTMain->m_hThread);
		Sleep(2000);
		if(!fTMain)return;
		CloseGBMemory();
/*		DestroyWindow();*/
	}
}

UINT CGBEmuDlg::ThreadMain(LPVOID pParam)
{
	((CGBEmuDlg*)pParam)->MainLoop();

	return 0;
}

UINT CGBEmuDlg::ThreadGUI(LPVOID pParam)
{
	((CGBEmuDlg*)pParam)->UpdateGUI();

	return 0;
}

void CGBEmuDlg::OnClose()
{	// I
	WaitForTMain();
	timeEndPeriod(1);
	if(fp!=NULL)fclose(fp);
	if(fSound)midiOutClose(hMidiOut);

	m_pTileDlg = NULL;
	m_pMapDlg = NULL;
	m_pMemDlg = NULL;
	m_pDasm = NULL;
	m_pObjDlg = NULL;
	m_pKeyDlg = NULL;

	delete m_pTileDlg;
	delete m_pMapDlg;
	delete m_pMemDlg;
	delete m_pDasm;
	delete m_pObjDlg;
	delete m_pKeyDlg;

	free(FrameBuffer16);
	CloseGBMemory();
	DestroyWindow();
}

void CGBEmuDlg::OnDropFiles(HDROP hDropInfo) 
{	// _CAOփhbvꂽt@Cs
	char filename[MAX_PATH];

	DragQueryFile(hDropInfo, 0, filename, sizeof(filename));
	if(filename){
		WaitForTMain();
		if(OpenRomFile(filename))return;
/*		fp = fopen(filename ,"rb");
		fread(ROM, 1, ROM_SIZE, fp);*/
		OnMenuReset();
	}

	CDialog::OnDropFiles(hDropInfo);
}

void InitializeVideo(HDC hDC)
{	/*rbg}bv*/
	int i;

	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 8;

	for(i=0; i<16; i++){
		bmp_info.bmiColors[i].rgbRed = 
		bmp_info.bmiColors[i].rgbGreen = 
		bmp_info.bmiColors[i].rgbBlue = Colours[i%4];
		bmp_info.bmiColors[i].rgbReserved = 0;
	}

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
}

void CGBEmuDlg::DrawLCD()
{
/*	
	if(Os9x){
		while(1){	//A҂
			if(_inp(0x03da)&0x08)break;
			else Sleep(1);
		}
	}
*/	
//	if(REG[r_LCDC]&0x80){
	if(f16Dib){
		//Smoothing();
		memcpy(pBitmap, FrameBuffer16, GB_LCD_X * GB_LCD_Y*2);
	}
		else memcpy(pBitmap, FrameBuffer, GB_LCD_X * GB_LCD_Y);

		hDC = ::GetDC(m_hWnd);
		::StretchBlt(hDC, 0, 0, DlgSize.right, DlgSize.bottom, hMemDC,
						0, 0, GB_LCD_X, GB_LCD_Y, SRCCOPY);
		::ReleaseDC(m_hWnd, hDC);
//	}
}

BOOL CGBEmuDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message==WM_KEYDOWN){
		switch(pMsg->wParam){
		case VK_ESCAPE:
			return false;
		case VK_RIGHT:	/*high-to-low*/
			keyflag&=~0x01;
			keyint=1;
			break;
		case VK_LEFT:
			keyflag&=~0x02;
			keyint=1;
			break;
		case VK_UP:
			keyflag&=~0x04;
			keyint=1;
			break;
		case VK_DOWN:
			keyflag&=~0x08;
			keyint=1;
			break;
		case 'Z':
			keyflag&=~0x10;
			keyint=1;
			break;
		case 'X':
			keyflag&=~0x20;
			keyint=1;
			break;
		case ' ':
			keyflag&=~0x40;
			keyint=1;
			break;
		case VK_RETURN:
			keyflag&=~0x80;
			keyint=1;
			break;
		default:
			break;
		}
	}
	if(pMsg->message==WM_KEYUP){
		switch(pMsg->wParam){
		case VK_RIGHT:	/*low-to-high*/
			keyflag|=0x01;
			keyint=2;
			break;
		case VK_LEFT:
			keyflag|=0x02;
			keyint=2;
			break;
		case VK_UP:
			keyflag|=0x04;
			keyint=2;
			break;
		case VK_DOWN:
			keyflag|=0x08;
			keyint=2;
			break;
		case 'Z':
			keyflag|=0x10;
			keyint=2;
			break;
		case 'X':
			keyflag|=0x20;
			keyint=2;
			break;
		case ' ':
			keyflag|=0x40;
			keyint=2;
			break;
		case VK_RETURN:
			keyflag|=0x80;
			keyint=2;
			break;
		default:
			break;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CGBEmuDlg::OnPalette1() 
{
	hDC = ::GetDC(m_hWnd);
	PaletteNo=0;
	InitializeVideo(hDC);
	::ReleaseDC(m_hWnd, hDC);
	DrawLCD();
}

void CGBEmuDlg::OnPalette2() 
{
	hDC = ::GetDC(m_hWnd);
	PaletteNo=1;
	InitializeVideo(hDC);
	::ReleaseDC(m_hWnd, hDC);
	DrawLCD();
}

void CGBEmuDlg::OnPalette3() 
{
	hDC = ::GetDC(m_hWnd);
	PaletteNo=2;
	InitializeVideo(hDC);
	::ReleaseDC(m_hWnd, hDC);
	DrawLCD();
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CGBEmuDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CGBEmuDlg::OnMenuExit() 
{ // I{^
	CGBEmuDlg::OnClose();
}

void CGBEmuDlg::OnMenuAbout() 
{ // 쌠_CAO̕\
	CAboutDlg about_dlg;
	about_dlg.DoModal();
}

void CGBEmuDlg::OnShowMemory() 
{	// _v\
	if(!fMemDlg){	// Tiles_CAO\
		if(m_pMemDlg==NULL){
			m_pMemDlg = new CMemDlg;
			m_pMemDlg->Create(IDD_MEMORY_DIALOG);
		}
		m_pMemDlg->ShowWindow(SW_SHOW);
		fMemDlg=true;
	}
	else m_pMemDlg->SetFocus();

	m_pMemDlg->ShowMemory();
}

void CGBEmuDlg::OnShowDebug() 
{	// fobK\
	if(!fAsmDlg){
		if(m_pDasm==NULL){
			m_pDasm = new CDisasm;
			m_pDasm->Create(IDD_DISASM_DIALOG);
		}
		m_pDasm->ShowWindow(SW_SHOW);
		fAsmDlg=true;
	}
	else m_pDasm->SetFocus();	

	m_pDasm->ShowDebug();
}

void CGBEmuDlg::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{	/*ANeBuɃXbhꎞ~*/
	CDialog::OnActivate(nState, pWndOther, bMinimized);
	if(CPUIsRunning){
		if(fAsmDlg){
			if(fStop){
				SuspendThread(m_pTMain->m_hThread);
				SuspendThread(m_pTGUI->m_hThread);
			}else{
				ResumeThread(m_pTMain->m_hThread);
				ResumeThread(m_pTGUI->m_hThread);
			}
		}else{
			if(nState==WA_INACTIVE && !fRun){
				SuspendThread(m_pTMain->m_hThread);
				SuspendThread(m_pTGUI->m_hThread);
			}else{
				ResumeThread(m_pTMain->m_hThread);
				ResumeThread(m_pTGUI->m_hThread);
			}
		}
		if(fSound)midiOutShortMsg(hMidiOut, 0x00000090|(0x00007F00&old_wave1));
	}
}

void CGBEmuDlg::OnLayerBg() 
{	/*C[̕\ؑ*/
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_LAYER_BG, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_LAYER_BG, MF_UNCHECKED);
		EnableBG=0;
	}else EnableBG=1;
}

void CGBEmuDlg::OnLayerWnd() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_LAYER_WND, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_LAYER_WND, MF_UNCHECKED);
		EnableWND=0;
	}else EnableWND=1;
}

void CGBEmuDlg::OnLayerObj() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_LAYER_OBJ, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_LAYER_OBJ, MF_UNCHECKED);
		EnableOBJ=0;
	}else EnableOBJ=1;
}

void CGBEmuDlg::OnSkip0() 
{
	FrameSkip = 0;
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP0, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip1() 
{
	FrameSkip = 1;
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP1, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip2() 
{
	FrameSkip = 2;
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP2, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip3() 
{
	FrameSkip = 3;
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP3, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip4() 
{
	FrameSkip = 4;
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP4, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip5() 
{
	FrameSkip = 5;
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP5, MF_BYCOMMAND);
}

void CGBEmuDlg::OnOK()
{

}

void CGBEmuDlg::OnCancel()
{
	EndDialog(0);
}

void CGBEmuDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	CDialog::GetClientRect(&DlgSize);
}

void CGBEmuDlg::OnZoom1()
{
	SetRect(&DlgSize, 0, 0, GB_LCD_X, GB_LCD_Y);
	AdjustWindowRect(&DlgSize, (WS_OVERLAPPEDWINDOW&~WS_THICKFRAME) | WS_DLGFRAME, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	GetMenu()->CheckMenuRadioItem(ID_ZOOM1, ID_ZOOM4, ID_ZOOM1, MF_BYCOMMAND);
}

void CGBEmuDlg::OnZoom2() 
{
	SetRect(&DlgSize, 0, 0, GB_LCD_X*2, GB_LCD_Y*2);
    AdjustWindowRect(&DlgSize, (WS_OVERLAPPEDWINDOW&~WS_THICKFRAME) | WS_DLGFRAME, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	GetMenu()->CheckMenuRadioItem(ID_ZOOM1, ID_ZOOM4, ID_ZOOM2, MF_BYCOMMAND);
}

void CGBEmuDlg::OnZoom3() 
{
	SetRect(&DlgSize, 0, 0, GB_LCD_X*3, GB_LCD_Y*3);
	AdjustWindowRect(&DlgSize, (WS_OVERLAPPEDWINDOW&~WS_THICKFRAME) | WS_DLGFRAME, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	GetMenu()->CheckMenuRadioItem(ID_ZOOM1, ID_ZOOM4, ID_ZOOM3, MF_BYCOMMAND);
}

void CGBEmuDlg::OnZoom4() 
{
	SetRect(&DlgSize, 0, 0, GB_LCD_X*4, GB_LCD_Y*4);
    AdjustWindowRect(&DlgSize, (WS_OVERLAPPEDWINDOW&~WS_THICKFRAME) | WS_DLGFRAME, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	GetMenu()->CheckMenuRadioItem(ID_ZOOM1, ID_ZOOM4, ID_ZOOM4, MF_BYCOMMAND);
}

void CGBEmuDlg::OnPriorityNormal()
{
	if(CPUIsRunning){	// Xbh쎞̂ݕύX
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_NORMAL)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_NORMAL, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnPriorityHighest()
{
	if(CPUIsRunning){
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_HIGHEST)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_HIGHEST, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnPriorityLowest()
{
	if(CPUIsRunning){
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_LOWEST)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_LOWEST, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnPriorityAbove()
{
	if(CPUIsRunning){
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_ABOVE_NORMAL)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_ABOVE, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnPriorityBelow() 
{
	if(CPUIsRunning){
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_BELOW_NORMAL)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_BELOW, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnShowFps()
{	// t[b^Cgo[ɂ邽߂̃`FbN
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_SHOW_FPS, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_SHOW_FPS, MF_UNCHECKED);
		fFps=0;
		CDialog::SetWindowText(_TITLE);
	}else fFps=1;
}

void CGBEmuDlg::OnVsync() 
{	// ̂߂̃`FbN
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_VSYNC, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_VSYNC, MF_UNCHECKED);
		fVsync=0;
	}else fVsync=1;
}

void CGBEmuDlg::OnShowTiles() 
{	// ^Cf[^ׂĕ\
	
	if(!fTileDlg){	// Tiles_CAO\
		if(m_pTileDlg==NULL){
			m_pTileDlg = new CTilesDlg;
			m_pTileDlg->Create(IDD_TILES_DIALOG);
		}
		m_pTileDlg->ShowWindow(SW_SHOW);
		fTileDlg = true;
	}
	else m_pTileDlg->SetFocus();

	m_pTileDlg->ShowTiles();
}

void CGBEmuDlg::OnShowMap() 
{	// ^Cf[^ׂĕ\

	if(!fMapDlg){	// Maps_CAO\
		if(m_pMapDlg==NULL){
			m_pMapDlg = new CMaps;
			m_pMapDlg->Create(IDD_MAPS_DIALOG);
		}
		m_pMapDlg->ShowWindow(SW_SHOW);
		fMapDlg=true;
	}
	else m_pMapDlg->SetFocus();

	m_pMapDlg->ShowMaps();
}

u32 HexToInt(char *hexstr)
{	/*PUi̕𐔒lɕϊiAXL[R[hpj*/
	int tmp=17, ret=0, loop, size=1;
	unsigned char tmpc;

	if(hexstr[0]=='\0'||hexstr[0]==' ')return 0xFFFFFFFE;
	for(loop=strlen(hexstr)-1; loop>=0; loop--){
		tmpc=hexstr[loop];
		if(tmpc>='0' && tmpc<='9')tmp=tmpc-0x30;
		else if(tmpc>='A' && tmpc<='F')tmp=tmpc-0x37;
		else if(tmpc>='a' && tmpc<='f')tmp=tmpc-0x57;
		else return 0xFFFFFFFF;
		ret+=tmp*size;
		size*=16;
	}
	if(tmp==17)return 0xFFFFFFFF;

	return ret;
}

void CGBEmuDlg::OnMenuDisableAll() 
{	/*fobKXVȂ*/
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_MENU_DISABLE_ALL, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_MENU_DISABLE_ALL, MF_UNCHECKED);
		fUpdate=true;
	}else {
		fUpdate=false;
		if(CPUIsRunning)m_pTGUI = AfxBeginThread(ThreadGUI, this);
	}
}

void CGBEmuDlg::OnShowOam() 
{	/*OAMr[A\*/
	if(!fObjDlg){
		if(m_pObjDlg==NULL){
			m_pObjDlg = new CObjDlg;
			m_pObjDlg->Create(IDD_OBJ_DIALOG);
		}
		m_pObjDlg->ShowWindow(SW_SHOW);
		fObjDlg=true;
	}
	else m_pObjDlg->SetFocus();

	m_pObjDlg->ShowObj();	
}

void CGBEmuDlg::OnSoundEnable() 
{
//	OnShowFps();
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_SOUND_ENABLE, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_SOUND_ENABLE, MF_UNCHECKED);
		fSound=0;
		midiOutReset(hMidiOut);
		midiOutClose(hMidiOut);
	}else {
		fSound=1;
		midiOutOpen(&hMidiOut,(UINT)MIDI_MAPPER, NULL, 0L, 0L);
		midiOutShortMsg(hMidiOut, 0x000014C0);	/*F̑I*/
		//midiOutShortMsg(hMidiOut, 0x000034C0);
//		midiOutShortMsg(hMidiOut, 0x0000007E);	/*mtHjbN*/
	}
}

void InitializeVideo16(HDC hDC)
{	/*rbg}bv*/

	FrameBuffer16=(u16*)malloc(GB_LCD_X*GB_LCD_Y*2);
	if(FrameBuffer16==NULL)GBEmu.MessageBox("error", NULL, MB_ICONSTOP);

	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 16;

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
}

void CGBEmuDlg::OnMenu16bitdib() 
{	/*16bitrbg}bv[h*/
	GetMenu()->CheckMenuRadioItem(ID_MENU_8BITDIB, ID_MENU_16BITDIB, ID_MENU_16BITDIB, MF_BYCOMMAND);

	hDC = ::GetDC(m_hWnd);
	InitializeVideo16(hDC);
	::ReleaseDC(m_hWnd, hDC);

	f16Dib=true;
}


void CGBEmuDlg::OnMenu8bitdib()
{	/*8bitpbg[h*/
	if(f16Dib)free(FrameBuffer16);
	GetMenu()->CheckMenuRadioItem(ID_MENU_8BITDIB, ID_MENU_16BITDIB, ID_MENU_8BITDIB, MF_BYCOMMAND);

	hDC = ::GetDC(m_hWnd);
	InitializeVideo(hDC);
	::ReleaseDC(m_hWnd, hDC);

	f16Dib=false;
}

void CGBEmuDlg::OnSoundCh1() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_SOUND_CH1, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_SOUND_CH1, MF_UNCHECKED);
		fChannel&=~0x01;
		midiOutShortMsg(hMidiOut, 0x00000080|(0x00007F00&old_wave1));	/*TEh̏*/
	}else {
		fChannel|=0x01;
	}
}

void CGBEmuDlg::OnSoundCh2() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_SOUND_CH2, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_SOUND_CH2, MF_UNCHECKED);
		fChannel&=~0x02;
		midiOutShortMsg(hMidiOut, 0x00000081|(0x00007F00&old_wave2));	/*TEh̏*/
	}else {
		fChannel|=0x02;
	}
}

void CGBEmuDlg::OnSoundCh3() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_SOUND_CH3, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_SOUND_CH3, MF_UNCHECKED);
		fChannel&=~0x04;
		midiOutShortMsg(hMidiOut, 0x00000082|(0x00007F00&old_wave3));	/*TEh̏*/
	}else {
		fChannel|=0x04;
	}
}


void CGBEmuDlg::OnMenuKey() 
{
	if(!fKeyDlg){
		if(m_pKeyDlg==NULL){
			m_pKeyDlg = new CKeyDlg;
			m_pKeyDlg->Create(IDD_KEY_DIALOG);
		}
		m_pKeyDlg->ShowWindow(SW_SHOW);
		fKeyDlg=true;
	}
	else m_pKeyDlg->SetFocus();
}

void CGBEmuDlg::DebugNextStep()
{	/*C[vꎞ~iXebvsj*/
	fNext=false;
	SuspendThread(m_pTMain->m_hThread);
	SuspendThread(m_pTGUI->m_hThread);
	m_pDasm->UpdateStack(true);
	m_pDasm->UpdateRegs();
	m_pDasm->SetDisasm();
}

void CGBEmuDlg::DebugBreakPoint()
{	/*C[vɃu[N|Cg𒣂*/
	if((cpu.PC==bp1)||(cpu.PC==bp2)||(cpu.PC==bp3)){
		SuspendThread(m_pTMain->m_hThread);
		SuspendThread(m_pTGUI->m_hThread);
		m_pDasm->UpdateStack(true);
		m_pDasm->UpdateRegs();
		m_pDasm->SetDisasm();
	}
}

