// Maps.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "gbemu.h"
#include "Maps.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define R_BGP	0xFF47
extern DWORD dwSize;
LPBITMAPINFO maps_info = (LPBITMAPINFO)new char[dwSize];

CDC* pMDC;						// ^C}bvr[p̃foCXReLXg
extern bool fMapDlg;
extern BYTE RMem(WORD);
extern BYTE MEM[0x10000];
extern BYTE Colours[4];

/////////////////////////////////////////////////////////////////////////////
// CMaps _CAO


CMaps::CMaps(CWnd* pParent /*=NULL*/)
	: CDialog(CMaps::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMaps)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void CMaps::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMaps)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMaps, CDialog)
	//{{AFX_MSG_MAP(CMaps)
	ON_WM_CLOSE()
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_MAP_ADR1, OnMapAdr1)
	ON_BN_CLICKED(IDC_MAP_ADR2, OnMapAdr2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMaps bZ[W nh

BOOL CMaps::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// Mapspɉʂ̃foCXReLXg擾
	pMDC = this->GetDC();
	
	RECT	DlgSize;
	SetRect(&DlgSize, 0, 0, 265, 285);
	AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left,
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_GROUP_LCDC), 0, 10, 265, 245, 35, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_MAP_ADR1), 0, 30, 280, 70, 15, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_MAP_ADR2), 0, 150, 280, 70, 15, SWP_NOACTIVATE|SWP_NOZORDER);
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CMaps::OnClose() 
{	// tO߂ă_CAO
	fMapDlg=false;
	CDialog::OnClose();
}

void CMaps::ShowMaps()
{	
	unsigned int tdpy, tmpx, tmpy;
	unsigned char tdd, tds, tilebit, offset;
	unsigned short tdba, tda, tma;
	unsigned char MapsBuffer[256*256];	
	unsigned int fba;

	if(GetCheckedRadioButton(IDC_MAP_ADR1, IDC_MAP_ADR2)==0){
		CheckRadioButton(IDC_MAP_ADR1, IDC_MAP_ADR2, IDC_MAP_ADR1);
	}

	if(GetCheckedRadioButton(IDC_MAP_ADR1, IDC_MAP_ADR2)==IDC_MAP_ADR2){
		tma=0x9800;
	}else tma=0x9C00;

	if(MEM[0xFF40]&0x10){	/*^Cf[^̃x[XAhX̑I*/
		tdba=0x8000;
		offset = 0x00;
	}else{
		tdba=0x8800;
		offset = 0x80;	/*t*/
	}

	for(tmpy=0; tmpy<256; tmpy+=8){		// }bvf[^
		for(tmpx=0; tmpx<256; tmpx+=8){
			tda=tdba+((BYTE)(MEM[tma++]+offset)<<4);
			for(tdpy=0; tdpy<8; tdpy++){	// ^Cf[^
				tdd=MEM[tda++];		// 1oCgڂ̃^Cf[^
				tds=MEM[tda++];		// 2oCgڂ̃^Cf[^
				fba=tmpx+((tmpy+tdpy)<<8);
				for(tilebit=0x80; tilebit; tilebit/=2,fba++){
					if((~(tdd&tilebit))&(~(tds&tilebit)))MapsBuffer[fba]=0;
					if((tdd&tilebit)&(~(tds&tilebit)))MapsBuffer[fba]=1;
					if((~(tdd&tilebit))&(tds&tilebit))MapsBuffer[fba]=2;
					if((tdd&tilebit)&(tds&tilebit))MapsBuffer[fba]=3;
				}
			}
		}
	}

	memset(maps_info, 0, sizeof(BITMAPINFOHEADER));
	maps_info->bmiHeader.biSize	= sizeof(BITMAPINFOHEADER);
	maps_info->bmiHeader.biWidth	= 256;
	maps_info->bmiHeader.biHeight	= -256;
	maps_info->bmiHeader.biPlanes	= 1;
	maps_info->bmiHeader.biBitCount	= 8;

	// BGPWX^pbgϊ
	maps_info->bmiColors[0].rgbBlue		=
	maps_info->bmiColors[0].rgbGreen	=
	maps_info->bmiColors[0].rgbRed		= Colours[(MEM[R_BGP]&0x03)];
	maps_info->bmiColors[0].rgbReserved = 0;
	maps_info->bmiColors[1].rgbBlue		=
	maps_info->bmiColors[1].rgbGreen	=
	maps_info->bmiColors[1].rgbRed		= Colours[(MEM[R_BGP]>>2&0x03)];
	maps_info->bmiColors[1].rgbReserved	= 0;
	maps_info->bmiColors[2].rgbBlue		=
	maps_info->bmiColors[2].rgbGreen	=
	maps_info->bmiColors[2].rgbRed		= Colours[(MEM[R_BGP]>>4&0x03)];
	maps_info->bmiColors[2].rgbReserved	= 0;
	maps_info->bmiColors[3].rgbBlue		=
	maps_info->bmiColors[3].rgbGreen	=
	maps_info->bmiColors[3].rgbRed		= Colours[(MEM[R_BGP]>>6&0x03)];
	maps_info->bmiColors[3].rgbReserved = 0;

	HDC	hMemDC	= ::CreateCompatibleDC(pMDC->m_hDC);
	HBITMAP	hBitmap	= ::CreateDIBitmap(pMDC->m_hDC, &maps_info->bmiHeader, CBM_INIT, MapsBuffer, maps_info, DIB_RGB_COLORS);
	HBITMAP	hOldmap	= (HBITMAP)::SelectObject(hMemDC, hBitmap);

	::BitBlt(pMDC->m_hDC, 5, 5, 256, 256, hMemDC, 0, 0, SRCCOPY);
	::DeleteObject(hBitmap);
}

void CMaps::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	ShowMaps();
}

void CMaps::OnMapAdr1() 
{	// LCDC̃WIύX
	ShowMaps();
}

void CMaps::OnMapAdr2() 
{	// LCDC̃WIύX
	ShowMaps();
}

void CMaps::OnOK()
{

}

void CMaps::OnCancel()
{
	EndDialog(0);
}

BOOL CMaps::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message==WM_KEYDOWN){
		switch(pMsg->wParam){
		case VK_ESCAPE:
			return false;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}
