

/*	
	GameboyVM - Nintendo Gameboy Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbemu/
*/


#include <stdio.h>
#include <string.h>
#include "../include/defines.h"
#define	_ASM_


int ShowHeaderInfo(unsigned char* pRom, char* str)
{
	char sum;
	char tmp[64];
	int	i;
#ifdef	_ASM_
	char fsup;
#endif	/*_ASM_*/
	if(!pRom){
		strcpy(str, "please load cartridge.");
		return 1;
	}

	for(i=0; i<15; i++){
		if(!pRom[0x0134+i])break;
		tmp[i] = pRom[0x0134+i];
	}

	strcpy(str, "Title: ");
	strcat(str, tmp);

	strcat(str, "\nColor: ");
	if(pRom[0x0143]==0x80 || pRom[0x143]==0xC0){
		strcat(str, "Color GB");
	}else{
		strcat(str, "Not color GB");
	}

	sprintf(tmp, "\nLicensee code: %02Xh", pRom[0x0144]);
	strcat(str, tmp);

	strcat(str, "\nSGB function: ");
	if(pRom[0x0146]==0x03){
		strcat(str, "yes");
	}else{
		strcat(str, "no");
	}

	strcat(str, "\nCatridge type: ");
	
	switch(pRom[0x0147]){
		case 0x00: strcat(str, "ROM Only");break;
		case 0x01: strcat(str, "ROM + MBC1");break;
		case 0x02: strcat(str, "ROM + MBC1 + RAM");break;
		case 0x03: strcat(str, "ROM + MBC1 + RAM + BATTERY");break;
		case 0x05: strcat(str, "ROM + MBC2");break;
		case 0x06: strcat(str, "ROM + MBC2 + BATTERY");break;
		case 0x08: strcat(str, "ROM + RAM");break;
		case 0x09: strcat(str, "RAM + BATTERY");break;
		case 0x0B: strcat(str, "ROM + MMMO1");break;
		case 0x0C: strcat(str, "ROM + MMMO1 + SRAM");break;
		case 0x0D: strcat(str, "ROM + MMMO1 + SRAM + BATTERY");break;
		case 0x0F: strcat(str, "ROM + MBC3 + TIMER + BATTERY");break;
		case 0x10: strcat(str, "ROM + MBC3 + TIMER + RAM + BATTERY");break;
		case 0x11: strcat(str, "ROM + MBC3");break;
		case 0x12: strcat(str, "ROM + MBC3 + RAM");break;
		case 0x13: strcat(str, "ROM + MBC3 + RAM + BATTERY");break;
		case 0x19: strcat(str, "ROM + MBC5");break;
		case 0x1A: strcat(str, "ROM + MBC5 + RAM");break;
		case 0x1B: strcat(str, "ROM + MBC5 + RAM + BATTERY");break;
		case 0x1C: strcat(str, "ROM + MBC5 + RUMBLE");break;
		case 0x1D: strcat(str, "ROM + MBC5 + RUMBLE + SRAM");break;
		case 0x1E: strcat(str, "ROM + MBC5 + RUMBLE + SRAM + BATTERY");break;
		case 0x1F: strcat(str, "POCKET CAMERA");break;
		case 0xFD: strcat(str, "BANDAI TAMA5");break;
		case 0xFE: strcat(str, "HUDSON HuC3");break;
		case 0xFF: strcat(str, "ROM + HUDSON HuC1 + RAM + BATTERY");break;
		default: strcat(str, "unknow");
	}

	strcat(str, "\nROM size: ");
	switch(pRom[0x0148]){
		case 0x00: strcat(str, "32KByte");break;
		case 0x01: strcat(str, "64KByte");break;
		case 0x02: strcat(str, "128KByte");break;
		case 0x03: strcat(str, "256KByte");break;
		case 0x04: strcat(str, "512KByte");break;
		case 0x05: strcat(str, "1MByte");break;
		case 0x06: strcat(str, "2MByte");break;
		case 0x07: strcat(str, "4MByte");break;
		case 0x08: strcat(str, "8MByte");break;
		case 0x52: strcat(str, "1.1MByte");break;
		case 0x53: strcat(str, "1.2MByte");break;
		case 0x54: strcat(str, "1.5MByte");break;
		default: strcat(str, "unknow");
	}

	strcat(str, "\nRAM size: ");
	switch(pRom[0x0149]){
		case 0x00: strcat(str, "None");break;
		case 0x01: strcat(str, "2KByte");break;
		case 0x02: strcat(str, "8KByte");break;
		case 0x03: strcat(str, "32KByte");break;
		case 0x04: strcat(str, "128KByte");break;
		default: strcat(str, "unknow");
	}

	strcat(str, "\nDestination code: ");
	if(pRom[0x014A]==0){
		strcat(str, "Japanese");
	}else{
		strcat(str, "Non Japanese");
	}
	
	sprintf(tmp, "\nMask ROM version: %02Xh", pRom[0x015B]);
	strcat(str, tmp);

	strcat(str, "\nChecksum: ");
	sum = 25;
	for(i=0x134; i<=0x14D; i++)sum+=pRom[i];
	if(sum==0){
		sprintf(tmp, "ok");
	}else{
		sprintf(tmp, "error (%02Xh -> %02Xh)", pRom[0x14D], (unsigned int)(256-sum));
	}
	strcat(str, tmp);

#ifdef	_ASM_
	strcat(str, "\n");

	__asm
	{
		mov		eax, 1
		cpuid
		bt		edx, 23
		setc	fsup
	}

	strcat(str, "\nMMX support: ");
	if(fsup){
		strcat(str, "yes");
	}else{
		strcat(str, "no");
	}
#endif

	return 0;
}
