
/*	
	GameboyVM - Nintendo Gameboy Emulator
		Copyright 2002 Y_N y_n@users.sourceforge.jp
		Homepage https://sourceforge.jp/projects/gbemu/
*/



void InitializeRegister()
{ /*CPUWX^̏*/
	cpu.AF=0x01B0;
	cpu.BC=0x0013;
	cpu.DE=0x00D8;
	cpu.HL=0x014D;
	cpu.SP=0xFFFE;
	cpu.PC=0x0100;
    cpu.ime=0;
    cpu.halt=0;
    cpu.stop=0;

	keyflag=0xFF;
	keyint=0;
	rom_mbc=1;
	ram_mbc=0;
	vram_mbc=0;
	enable_ram_mbc=0;
	e_rtc0=0;
	e_rtc1=0;
    CPUIsRunning=1;
	irq_type=-1;
	irqs[0]=0;
	irqs[1]=0;
	irqs[2]=0;
	irqs[3]=0;
	irqs[4]=0;

	if(fcgb_mode)cpu.A=0x11;
}

_inline void EndInterrupt()
{
	u32	irq_sp;

	MEM[R_IF]&=~bit_mask[irq_type];
	irqs[irq_type]=0;
	irq_type=-1;

	for(irq_sp=0; irq_sp<5; irq_sp++){
		if(irqs[irq_sp]){	/*荞ݏɔ荞݂s*/
			cpu.ime=0;
			MEM[R_IF]|=bit_mask[irq_sp];
			if(cpu.halt){
				cpu.halt=0;
				cpu.PC++;
			}
/*			PUSH(cpu.H,cpu.L);
			PUSH(cpu.D,cpu.E);
			PUSH(cpu.B,cpu.C);
			PUSH(cpu.A,cpu.F);*/
			PUSH(cpu.PC);
			cpu.PC=irq_adr[irq_sp];
			irq_type=irq_sp;
			return;
		}
	}
}

_inline void Interrupt(int irq)
{
	if((MEM[R_IE] & bit_mask[irq]) && cpu.ime){
		if(irq_type==-1){
			cpu.ime=0;
			MEM[R_IF]|=bit_mask[irq];
			if(cpu.halt){
				cpu.halt=0;
				cpu.PC++;
			}
			PUSH(cpu.PC);
			cpu.PC=irq_adr[irq];
			irq_type=irq;
		}else{
			irqs[irq]=1;
		}
	}
}


#ifdef	_WIN32_GDI
void CGBEmuDlg::MainLoop()
#endif
#ifdef	_WINCE_GDI
//void CGBEmuDlg::MainLoop()
void CChildView::MainLoop()
#endif
#ifdef	_SDL
static void MainLoop()
#endif
#ifdef	_WIN32_LITE
void MainLoop()
#endif
{
	static int	htime=456;		/*70224/154=456clk:1087s*/
	static long	ttime=0;
	static u32	r_div=0;
	static u32	cycle;
	static u32	tmppc;
	static u32	irq_flags=0;
	static const u32 tac_table[]={4096, 262144, 65536, 16384};
	static DWORD WaitTime;	/*^C}[1000/59.73=16.74*/

#ifdef	_WIN32_GDI
	fTMain = true;
#endif

	WaitTime = timeGetTime() + 17;

	while(CPUIsRunning){

		if(RMem(cpu.PC)==0xCB){	/*CBvtBbNX*/
			cycle=Cycles_cb[RMem(cpu.PC)];
			tmppc=2;	/*TCY͌Œ*/
			Cpu_cb();
		}else{					/*m[}IyR[h*/
			cycle=Cycles[RMem(cpu.PC)];
			tmppc=PC_table[RMem(cpu.PC)];
			Cpu();
		}

		cpu.PC+=tmppc;

		MEM[R_STAT]&=~0x07;	/*modetȌ init mode flags*/

		htime-=cycle;
		if(htime<=0){
			htime+=456;	/* H-Sync*/
			irq_flags=0;
			MEM[R_LY]=(MEM[R_LY]>=154)?0:MEM[R_LY]+1;
			if((MEM[R_LY]<144) && (MEM[R_LCDC]&0x80)/* && !fSkip*/){
#ifdef	_WIN32
				if(f16Dib){
					if(fcgb_mode)DrawLineCgb();
					else DrawLine16();
				}else
#endif	/*_WIN32*/
				DrawLine();
			}
			if(!MEM[R_LY]){	/*0̎ V-Sync*/
				DrawLCD();
				FrameCount++;
#ifdef	_WIN32_GDI
				if(fSound && (MEM[R_NR52]&0x80))PlayGBSound();
#endif	/*_WIN32_GDI*/
				if(fFps)ShowFps();
#ifdef	_SDL
				SDLEventLoop();
#endif	/*_SDL*/
				while(WaitTime > timeGetTime()){
					if(fVsync){
						Sleep(1);	/*ҋ@*/
						fSkip=0;
					}else{
						fSkip=1;
						break;
					}
				};
				WaitTime = timeGetTime() + 17;
			}
		}

		if(MEM[R_LCDC]&0x80){	/*LCDғ LCD running*/
			if(MEM[R_LY]>=144){	/*A*/
				MEM[R_STAT]|=0x01;
				if(MEM[R_LY]==144){	/* AJn V-blank*/
					if(!(irq_flags&0x20)){
						irq_flags|=0x20;
						Interrupt(IRQ_VBLANK);
					}else if((MEM[R_STAT]&0x10) && !(irq_flags&0x02)){
						irq_flags|=0x02;
						Interrupt(IRQ_LCDC);	/*Mode01*/
					}
				}
				if(MEM[R_LY]==MEM[R_LYC])MEM[R_STAT]|=0x04;/*LYC+01*/
			}else if(MEM[R_LY]==MEM[R_LYC]){
				MEM[R_STAT]|=0x04;
				if((MEM[R_STAT]&0x40) && !(irq_flags&0x80)){
					irq_flags|=0x80;
					Interrupt(IRQ_LCDC);	/*LY==LYC*/
					if(htime<=204){/*LYC+00*/}
					else if(htime<=376)MEM[R_STAT]|=0x03;/*LYC+11*/
					else MEM[R_STAT]|=0x02;/*LYC+10*/
				}
			}else if(htime<=204){	/*A h-blank*/
				if((MEM[R_STAT]&0x08) && !(irq_flags&0x04)){
					irq_flags|=0x04;
					Interrupt(IRQ_LCDC);	/*mode00*/
				}
			}else if(htime<=376){	/*OAM,VRAMANZX*/
				MEM[R_STAT]|=0x03;	/*mode11*/
			}else{	/*OAMANZX*/
				MEM[R_STAT]|=0x02;
				if((MEM[R_STAT]&0x20) && !(irq_flags&0x10)){
					irq_flags|=0x10;
					Interrupt(IRQ_LCDC);	/*Mode10*/
				}
			}
		}

		r_div+=cycle;	/*256NbNłP*/
		if(r_div>=256){
			r_div-=256;
			MEM[R_DIV]++;
		}

		if(MEM[R_TAC]&0x04){  /*TIMA^C}[Jn*/
			ttime+=cycle;
			if((tac_table[(MEM[R_TAC]&0x03)]-ttime)<=0){	/*̓NbN̑I*/
				ttime-=tac_table[(MEM[R_TAC]&0x03)];
				MEM[R_TIMA]++;
				if(!MEM[R_TIMA]){	/*if((u8)(MEM[R_TIMA]+1)==0){*/
					MEM[R_TIMA]=MEM[R_TMA];
					Interrupt(IRQ_TIMER);
				}
			}
		}

/*		if(MEM[R_SC]==0x80){*/	/*f[^]*/
/*			MEM[R_SC]&=~0x80;
			MEM[R_SB]=0xFF;*/	/*Ms*/
/*			Interrupt(IRQ_SERIAL);
		}*/
	
		/*{^̒e*//*High-to-Low*/
		if(keyint){
			if(keyint==1)Interrupt(IRQ_KEY);	
			keyint=0;
		}
/*TRACE("LY=%2x, %2x\n", MEM[R_LY], MEM[R_STAT]);*/
#ifdef	_WIN32_GDI
		if(fSound)Sound_ch1(cycle);
		if(fNext)DebugNextStep();
		if(fBreak)DebugBreakPoint();
		if(fAsmDlg)while(fStop)Sleep(10);
		else while(!fActive)Sleep(10);
#endif	/*_WIN32_GDI*/

	}
#ifdef	_WIN32_GDI
	fTMain = false;	/*XbhItO*/
#endif
}

