
/*	
	GameboyVM - Nintendo Gameboy Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbemu/
*/

#include "../include/defines.h"


void InitializeMemory();
_inline void WMem(u16 adr, u8 val);
_inline void WMem16(u16 adr, u16 val);
_inline u8 RMem(u16 adr);
_inline u16 RMem16(u16 adr);


	/*wb_[148hɂ؂ւoN*/
u8 bank_size[256]={
	1,3,7,15,31,63,127,255,
};

	/*wb_[148hɂ؂ւoN*/
u32 rom_size[256]={	/*05h=|PS[h*/
	2,4,8,16,32,64,128,256,512,
};

u32 ram_size[256]={
	0,1,1,4,16,
};


void InitializeMemory()
{ /*}bvhWX^̏*/
	u32 i;

/*	for(copy_loop=0; copy_loop<S32_SIZE; copy_loop++)
		MEM[copy_loop]=ROM[0][copy_loop];*/
	memset(MEM, 0x00, MEM_SIZE);

	MEM[R_P1]=0xCF;	/*L[IO*/
	MEM[R_STAT]=0x00;

	MEM[R_TIMA]=0x00;	/*^C}[WX^*/
	MEM[R_TMA]=0x00;
	MEM[R_TAC]=0x00;

	MEM[R_NR10]=0x80;	/*TEhWX^*/
	MEM[R_NR11]=0xBF;
	MEM[R_NR12]=0xF3;
	MEM[R_NR14]=0xBF;
	MEM[R_NR21]=0x3F;
	MEM[R_NR22]=0x00;
	MEM[R_NR24]=0xBF;
	MEM[R_NR30]=0x7F;
	MEM[R_NR31]=0xFF;
	MEM[R_NR32]=0x9F;
	MEM[R_NR34]=0xBF;
	MEM[R_NR41]=0xFF;
	MEM[R_NR42]=0x00;
	MEM[R_NR43]=0x00;
	MEM[R_NR44]=0xBF;
	MEM[R_NR50]=0x77;
	MEM[R_NR51]=0xF3;
	MEM[R_NR52]=0xF1;

	MEM[R_LCDC]=0x91;
	MEM[R_SCY]=0x00;
	MEM[R_SCX]=0x00;
	MEM[R_LYC]=0x00;
	MEM[R_BGP]=0xFC;
	MEM[R_OBP0]=0xFF;
	MEM[R_OBP1]=0xFF;
	MEM[R_WY]=0x00;
	MEM[R_WX]=0x00;
	MEM[R_IE]=0x00;

	MEM[R_LY]=144;

	mbc_type=ROM[0][0x147];
	max_rom_mbc=bank_size[(ROM[0][0x148])];

	/*Q[{[CJ[o*/
	if((ROM[0][0x143]==0x80 || ROM[0][0x143]==0xC0) && gb_mode){
		fcgb_mode = 1;
		for(i=0; i<0x3F; i++){	/*CGBpbg̏*/
			cgb_bg_pal[i]=0;
			cgb_obj_pal[i]=0;
		}
	}else{
		fcgb_mode = 0;
	}

	vram_mbc=0;	/*VRAMoN*/
}

_inline void WMem(u16 adr, u8 val)
{	/*(1=ݕs,0=݉)*/
	static u16 copy_loop, tmp16;
	u16	dma_dest, dma_transfer;
	u8	tmp8;

	if(0x01<=mbc_type && mbc_type<=0x03){	/*MBC1:ROM*/
		if(0x2000<=adr && adr<0x4000){
			val&=0x1F;	/*XXXBBBBB*/
			val&=max_rom_mbc;	/*I[ot[΍*/
			if(!val)val++;	/*ROM Bank#10͎włȂ*/
			rom_mbc=val;
			return;
		}
		if(0x02<=mbc_type){					/*MBC1:RAM*/
			if(0x0000<=adr && adr<0x2000){	/*RAMoNtO*/
				enable_ram_mbc=((val&0x0F)==0x0A)?1:0;
				return;
			}
			if(0x4000<=adr && adr<0x6000){	/*oN̑I*/
				ram_mbc=val&0x03;	/*XXXXXXBB 4bank*/
				return;
			}
			if(0xA000<=adr && adr<0xC000){
				if(enable_ram_mbc)RAM[ram_mbc][adr-0xA000]=val;	/*tOLȂ*/
				return;
			}
		}
	}

	if(mbc_type==0x05 || mbc_type==0x06){	/*MBC2:ROM*/
		if(0x2000<=adr && adr<0x4000){
			val&=0x0F;	/*XXXXBBBB 32bank*/
			val&=max_rom_mbc;	/*I[ot[΍*/
			if(!val)val++;	/*ROM Bank#10͎włȂ*/
			rom_mbc=val;
			return;
		}
	}

	if(0x0F<=mbc_type && mbc_type<=0x13){	/*MBC3:ROM*/
		if(0x2000<=adr && adr<0x4000){
			val&=0x7F;	/*XBBBBBBB 128bank*/
			val&=max_rom_mbc;
			if(!val)val++;	/*ROM Bank#10͎włȂ*/
			rom_mbc=val;
			return;
		}
		if(0x02<=mbc_type){					/*MBC3:RAM*/
			if(0x0000<=adr && adr<0x2000){	/*RAMoNtO*/
				enable_ram_mbc=((val&0x0F)==0x0A)?1:0;
				return;
			}
			if(0x4000<=adr && adr<0x6000){	/*oN̑I*/
				ram_mbc=val&0x03;	/*XXXXXXBB 4bank*/
				return;
			}
			if(0x6000<=adr && adr<0x8000){	/*oN̑I*/
				if(!val)e_rtc0=1;	/*RTC̓ǂݎ苖*/
				if(e_rtc0){
					if(val==1)e_rtc1=1;
				}
				return;
			}
			if(0xA000<=adr && adr<0xC000){
				if(enable_ram_mbc)RAM[ram_mbc][adr-0xA000]=val;	/*tOLȂ*/
				return;
			}
		}
	}

	if(0x0F<=mbc_type && mbc_type<=0x13){	/*MBC5:ROM*/
		if(0x2000<=adr && adr<0x4000){/*BBBBBBBB 512bank*/
			if(0x3000<=adr && (val&0x01))rom_mbc=0x100;
			else rom_mbc&=~0x100;
			rom_mbc|=val;
			rom_mbc&=max_rom_mbc;
			return;	/*MBC5łROM Bank#10wł*/
		}
		if(0x02<=mbc_type){					/*MBC5:RAM*/
			if(0x0000<=adr && adr<0x2000){	/*RAMoNtO*/
				enable_ram_mbc=((val&0x0F)==0x0A)?1:0;
				return;
			}
			if(0x4000<=adr && adr<0x6000){	/*oN̑I*/
				ram_mbc=val&0x0F;	/*XXXXBBBB 16bank*/
				return;
			}
			if(0xA000<=adr && adr<0xC000){
				if(enable_ram_mbc)RAM[ram_mbc][adr-0xA000]=val;	/*tOLȂ*/
				return;
			}
		}
	}
	
	if(0xA000<=adr && adr<0xC000){	/*J[gbWRAM*/
		adr-=0xA000;
		RAM[0][adr]=val;
		return;
	}

	/*if(0xFEA0<=adr && adr<0xFF00)return;*/	/*\ς݃*/

	/*R_STATɂ菑݂𐧌*/
/*	if(MEM[R_STAT] & 0x02){
		if(0xFE00<=adr && adr<0xFEA0) return;*/	/*mode2*/
/*		if(MEM[R_STAT] & 0x01){
			if(0x8000<=adr && adr<0xA000) return;*/	/*mode3*/
/*		}
	}*/

	
	if(0xC000<=adr && adr<0xDE00){	/*RAM(DE00h-E000h̓~[Ȃ)*/
		if(fcgb_mode){
			if(0xD000<=adr){
				tmp8=MEM[R_SVBK]&0x7;	/*RAMoN*/
				if(!tmp8)tmp8++;		/*ʂɃoNO͎włȂ*/
				InRAM[tmp8][adr-0xD000]=val;
			}else{
				InRAM[0][adr-0xC000]=val;/*Œ̃oNO*/
			}
		}
		else{
			MEM[adr]=val;
			adr+=0x2000;
			MEM[adr]=val;
		}
		return;
	}

	if(0xE000<=adr && adr<0xFE00){	/*RAM̃~[*/
		MEM[adr]=val;
		adr-=0x2000;
		MEM[adr]=val;
		return;
	}

	/*3bitmodetO*/
/*	if(R_STAT==adr){
		MEM[adr]=val&0xF8;	
		return;
	}*/

	/*4-5bit݂oȂ*/
/*	if(R_P1==adr){
		if(val&0x10)MEM[adr]|=0x10;
		else MEM[adr]&=0xEF;
		if(val&0x20)MEM[adr]|=0x20;
		else MEM[adr]&=0xDF;
		return;
	}*/

	if(R_DIV==adr){	/*łOɏ*/
		MEM[adr]=0x00;
		return;
	}

	if(R_DMA==adr){	/*DMA]*/
		MEM[adr]=val;
		tmp16=(u16)(val<<8);	/*0x100PʂŎwł*/
		if(0xF100<=tmp16)return;	/*͈͊O̓]*/
		copy_loop=0xFE00;
		while(copy_loop<0xFEA0){
			MEM[copy_loop++]=RMem(tmp16++);
		}
	}

	/*Q[{[CJ[̓*/
	if(fcgb_mode){			/*VRAMoN*/
		if(0x8000<=adr && adr<0xA000){
			if(vram_mbc){
				VRAM[adr-0x8000]=val;
				return;
			}
		}
		if(adr==R_BGPD){	/*CGBpbg*/
			tmp8=MEM[R_BGPI];
			cgb_bg_pal[(tmp8&0x3F)]=val;
			if(tmp8&0x80){
				MEM[R_BGPI]=0x80|((tmp8+1)&0x3F);
				/*tmp8=(tmp8+1)>0x3F?0:tmp8+1;
				MEM[R_BGPI]=0x80|(tmp8&0x3F);*/
			}
			return;
		}
		if(adr==R_OBPD){	/*CGBpbg*/
			tmp8=MEM[R_OBPI];
			cgb_obj_pal[(tmp8&0x3F)]=val;
			if(tmp8&0x80){
				MEM[R_OBPI]=0x80|((tmp8+1)&0x3F);
				/*tmp8=(tmp8+1)>0x3F?0:tmp8+1;
				MEM[R_BGPI]=0x80|(tmp8&0x3F);*/
			}
			return;
		}
		if(adr==R_VBK){	/*VRAMoN̐؂ւ*/
			if(val&0x01)vram_mbc=1;
			else vram_mbc=0;
		}
		if(adr==R_HDMA5){
			dma_transfer=((val&0x7F)+1)*0x10;
			while(dma_transfer){
				tmp16=(MEM[R_HDMA1]<<8)|(MEM[R_HDMA2]&0xF0);
				dma_dest=(MEM[R_HDMA3]<<8)|(MEM[R_HDMA4]&0xF0);
				WMem(dma_dest, RMem(tmp16));
				dma_transfer--;
			}
			return;
		}
		if(adr==R_KEY1){/*VXeNbN̐ؑ*/
		
		}
	}

	if(0x0000<=adr && adr<0x8000)return;	/*ROMJ[gbẄ*/
	if(R_LY==adr)return;	/*LY͓ǎp*/

	MEM[adr]=val;
}

_inline void WMem16(u16 adr, u16 val)
{
	WMem(adr++, (u8)val);
	WMem(adr, (u8)(val>>8));
}

_inline u8 RMem(u16 adr)
{
	u8 tmp8;

	if(0x0000<=adr && adr<0x4000){
		return ROM[0][adr];/*oNO*/
	}

	if(0x4000<=adr && adr<0x8000){
		adr-=0x4000;
		return ROM[rom_mbc][adr];/*oNP` ŃG[II*/
	}

	if(0xA000<=adr && adr<0xC000){
		if(ram_mbc==0x0F || ram_mbc==0x10){
		
		}
		adr-=0xA000;
		return RAM[ram_mbc][adr];/*J[gbWRAM*/
	}

	if(0x8000<=adr && adr<0xA000){
		if(vram_mbc){
			return VRAM[adr-0x8000];
		}
	}

	if(R_P1==adr){	/*L[*/
		tmp8=MEM[adr];
		MEM[adr]=(tmp8&0xF0)|(((tmp8&0x10)?0xF:(keyflag&0xF))&
				((tmp8&0x20)?0xF:((keyflag>>4)&0xF)));
	}

	if(fcgb_mode){
		if(0xC000<=adr && adr<0xDE00){	/*RAM(DE00h-E000h̓~[Ȃ)*/
			if(0xD000<=adr){
				tmp8=MEM[R_SVBK]&0x7;	/*RAMoN*/
				if(!tmp8)tmp8++;		/*ʂɃoNO͎włȂ*/
				return InRAM[tmp8][adr-0xD000];
			}else{
				return InRAM[0][adr-0xC000];/*Œ̃oNO*/
			}
		}
		if(R_BGPD==adr){
			return cgb_bg_pal[(MEM[R_BGPI]&0x3F)];
		}
		if(R_OBPD==adr){
			return cgb_obj_pal[(MEM[R_OBPI]&0x3F)];
		}
	}
	
	return MEM[adr];
}

_inline u16 RMem16(u16 adr)
{
	return (u16)(RMem(adr) + (RMem((u16)(adr+1))<<8));
}

u8 Rmem(u16 adr)
{	/*J[gbWǂݍłȂꍇׂĂOԂifobKpj*/
	if(ROM[0]){
		return RMem(adr);
	}else{
		return 0;
	}

	return 0;
}

void Wmem(u16 adr, u8 val)
{	/*J[gbWǂݍłȂꍇȂifobKpj*/
	if(ROM[0]){
		if(0x0000<=adr && adr<0x4000){
			ROM[0][adr]=val;/*oNO*/
		}

		if(0x4000<=adr && adr<0x8000){
			adr-=0x4000;
			ROM[rom_mbc][adr]=val;/*oNP`*/
		}
	}
}

u8 RmemB(u32 bank, u16 adr)
{	/*J[gbWǂݍłȂꍇׂĂOԂioN؂ւtfobKpj*/
	if(ROM[0]){
		if(bank>bank_size[(ROM[0][0x148])])return 0;
		if(0x0000<=adr && adr<0x4000){
			return ROM[0][adr];
		}
		if(0x4000<=adr && adr<0x8000){
			adr-=0x4000;
			return ROM[bank][adr];
		}
/*		if(0x0000<=adr && adr<0x4000){
			return ROM[bank][adr];
		}
		if(0x4000<=adr && adr<0x8000){
			adr-=0x4000;
			return ROM[bank][adr];
		}*/
	}else{
		return 0;
	}

	return 0;
}

void WmemB(u32 bank, u16 adr, u8 val)
{	/*J[gbWǂݍłȂꍇȂioN؂ւtfobKpj*/
	if(ROM[0]){
		if(bank>bank_size[(ROM[0][0x148])])return;
		if(0x0000<=adr && adr<0x4000){
			ROM[0][adr]=val;/*oNO*/
		}
		if(0x4000<=adr && adr<0x8000){
			adr-=0x4000;
			ROM[bank][adr]=val;/*oNP`*/
		}
	}
}
