

/*	
	GameboyVM - Nintendo Gameboy Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbemu/
*/

#include "../include/defines.h"

#ifdef	_WIN32_GDI
#include "../zlib/unzip.h"
#endif

#ifndef	_SDL

int CheckExtensionName(char* filename, char* extension)
{	/*t@CƊgqvOȊOԂ*/
	unsigned int flen, xlen;

	flen = strlen(filename);	/*t@C̕*/
	xlen = strlen(extension);	/*gq̕*/

	if(extension[xlen]=='*')return 0;/*SẴt@C*/

	while(xlen!=0){
		if(isupper(filename[flen]))filename[flen]+=0x20;
		if(isupper(extension[xlen]))extension[xlen]+=0x20;
		if(filename[flen]!=extension[xlen])return 0;
		flen--;
		xlen--;
	}

	return 1;
}

int IsGBFilename(char* filename)
{	/*gq.gb(*.gbc;*.bin)ȂOȊOԂ*/

	if(CheckExtensionName(filename, ".gb")){
		return 1;
	}
	if(CheckExtensionName(filename, ".gbc")){
		return 1;
	}
	if(CheckExtensionName(filename, ".cgb")){
		return 1;
	}
	if(CheckExtensionName(filename, ".bin")){
		return 1;
	}

	return 0;
}

#endif

int OpenRomFile(char* filename)
{	/*t@C̓ǂݍ݂ƃ̊m*/
	FILE *fp;
	u8 s_rom/*, s_ram*/;
	u32 i;
	u8	Header[0x151];

	fp = fopen(filename ,"rb");
	fread(Header, 1, 0x150, fp);	/*wb_[ǂݍ*/
	s_rom = rom_size[(Header[0x148])];	/*ROM̃TCY擾*/
/*	s_ram = ram_size[(Header[0x149])];*/	/*RAM̃TCY擾*/
	fclose(fp);

	fp = fopen(filename ,"rb");

	CloseGBMemory(ROM[0]);

	/*ROMTCY̕m*/
	for(i=0; i<s_rom; i++){
		ROM[i] = (u8*)malloc(BANK_SIZE);
		if(ROM[i]==NULL)return 1;
		fread(ROM[i], 1, BANK_SIZE, fp);
	}
	/*RAMTCY̕m*/
/*	for(i=0; i<s_ram; i++){
		ROM[i] = (u8*)malloc(BANK_SIZE);
		if(RAM[i]==NULL)return 1;
		fread(RAM[i], 1, BANK_SIZE, fp);
	}VCł͕s̂ŃRgAEg*/

	return 0;
}

#ifdef	_WIN32_GDI
int OpenZipRomFile(char* filename)
{	/*ZIPt@CROM̓ǂݍ݂ƃ̊m*/	
	u8	s_rom/*, s_ram*/;
	u32 i;
	int		err, sizeRead;
	char	strConFilename[512];
	char*	pConFileName, *p;
	unzFile	hUnzipFile;
	unz_file_info	fileInfo;

	hUnzipFile = NULL;

	hUnzipFile = unzOpen(filename, 0);
	if(hUnzipFile == NULL)return FALSE;

	do{
		err = unzGetCurrentFileInfo(hUnzipFile, &fileInfo, strConFilename, 
									sizeof(strConFilename), NULL, 0, NULL, 0);
		if(err!=UNZ_OK){
			unzClose(hUnzipFile);
			return 1;	/*ZIPt@C*/
		}

		p = pConFileName = strConFilename;	/*t@Co*/
		while(*p!='\0'){
			if (*p=='\\' ||*p=='/')pConFileName=p+1;
			p++;
		}

		if(IsGBFilename(strConFilename)){	/*GBt@Cgq̔*/
			if(unzOpenCurrentFile(hUnzipFile)!=UNZ_OK){
				unzClose(hUnzipFile);
				return 2;	/*w肳ꂽt@CĂ*/
			}
			ROM[0] = (u8*)malloc(BANK_SIZE);
			if(ROM[0]==NULL)return 3;	/*̊mۂɎs*/
			sizeRead = unzReadCurrentFile(hUnzipFile, (void*)ROM[0], BANK_SIZE);
			s_rom = rom_size[(ROM[0][0x148])];
			for(i=1; i<s_rom; i++){
				ROM[i] = (u8*)malloc(BANK_SIZE);
				if(ROM[i]==NULL)return 3;
				sizeRead = unzReadCurrentFile(hUnzipFile, (void*)ROM[i], BANK_SIZE);
			}
		}

		unzCloseCurrentFile(hUnzipFile);

		if(IsGBFilename(strConFilename))break;/*ROMt@Cǂ񂾂I*/

	}while(unzGoToNextFile(hUnzipFile) != UNZ_END_OF_LIST_OF_FILE);

	unzClose(hUnzipFile);

	return 0;
}
#endif	/*_WIN32_GDI*/

int ____CloseGBMemory(unsigned char* pRom)
{	/*GB̉*/
	u8 s_rom/*, s_ram*/;
	u32 i;

	if(pRom==NULL)return 0;
	s_rom=rom_size[(pRom[0x148])];
/*	s_ram=rom_size[(pRom[0x149])];*/

	for(i=0; i<s_rom; i++){
		free(pRom++);
		pRom=NULL;
	}

/*	for(i=0; i<s_rom; i++){
		free(pRam[i]);
		pRam[i]=NULL;
	}*/

	return 0;
}


int CloseGBMemory(unsigned char* pRom)
{	/*GB̉*/
	u8 s_rom/*, s_ram*/;
	u32 i;

	if(ROM[0]==NULL)return 0;
	s_rom=rom_size[(ROM[0][0x148])];
/*	s_ram=rom_size[(ROM[0][0x149])];*/

	for(i=0; i<s_rom; i++){
		free(ROM[i]);
		ROM[i]=NULL;
	}

/*	for(i=0; i<s_rom; i++){
		free(RAM[i]);
		RAM[i]=NULL;
	}*/

	return 0;
}


void StaticOpenRomFile(char* filename)
{	/*ÓIROMɃt@Cǂݍ*/
	FILE *fp;

	fp = fopen(filename ,"rb");
	fread(ROM, 1, BANK_SIZE*32, fp);
}


#ifdef	_WINCE_GDI
int OpenRomhFile(CString filename)
{	/*t@C̓ǂݍ݂ƃ̊m*/
	HANDLE hfile;
	DWORD dwByte;
	u8 s_rom/*, s_ram*/;
	u32 i;
	u8	Header[0x151];

	hfile = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, 
			NULL, OPEN_EXISTING, FILE_ATTRIBUTE_READONLY, NULL);
	
	ReadFile(hFile, Header, 0x150, &dwByte, NULL);
	s_rom = rom_size[(Header[0x148])];	/*ROM̃TCY擾*/
	CloseHandle(hfile);

	hfile = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, 
			NULL, OPEN_EXISTING, FILE_ATTRIBUTE_READONLY, NULL);

	CloseGBMemory(ROM[0]);

	/*ROMTCY̕m*/
	for(i=0; i<s_rom; i++){
		ROM[i] = (u8*)malloc(BANK_SIZE);
		if(ROM[i]==NULL)return 1;
		ReadFile(hFile, ROM[i], BANK_SIZE, &dwByte, NULL);
	}

	CloseHandle(hfile);

	return 0;
}
#endif	/*_WINCE_GDI*/
