

/*	
	GameboyVM - Nintendo Gameboy Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbemu/
*/

#include "../include/defines.h"


int OpenSaveFile()
{	/*savt@C(openfilename)SRAMɓWJ*/
	FILE* sfp;
	int i, s_bank;

	s_bank = ram_size[(ROM[0][0x149])];

	sfp = fopen(openfilename, "rb");
	if(sfp){
		for(i=0; i<s_bank; i++){
			fread(RAM[i], 1, 0x2000, sfp);
		}
		fclose(sfp);
	}else{
		return 1;
	}

	return 0;
}

int CloseSaveFile()
{	/*savt@C(openfilename)ɕۑ*/
	FILE* sfp;
	int i, fsram, s_bank;

	if(ROM[0]){
		s_bank = ram_size[(ROM[0][0x149])];

		fsram = 0;	/*SRAM̒̃f[^mF*/
		for(i=0x0000; i<0x2000; i++){
			if(RAM[0][i]){
				fsram=1;
				break;
			}
		}

		if(fsram && s_bank){
			sfp = fopen(openfilename, "wb");
			if(sfp){
				for(i=0; i<s_bank; i++){
					fwrite(RAM[i], 1, 0x2000, sfp);
				}
			}else{
				return 1;
			}
			fclose(sfp);
		}
	}else{
		return 2;
	}

	return 0;
}

#ifdef	_WIN32_GDI
void GetFileName(char* ofn)
{	/*̓t@Cۑ̃t@C*/
	char exename[512], drivename[16], dirname[512];
	char filename[512], extname[16], sfname[512];

	GetModuleFileName(NULL, exename, 512);
	_tsplitpath(exename, drivename, dirname, filename, extname);
	strcpy(sfname, drivename);
	strcat(sfname, dirname);

	strcat(sfname, "save\\");	/*savefBNg̍쐬*/
	_mkdir(sfname);

	_tsplitpath(ofn, 0, 0, filename, extname);
	strcat(sfname, filename);
	strcat(sfname, ".sav");

	strcpy(openfilename, sfname);
}
#endif	/*_WIN32_GDI*/
