// GBEmuWin32.cpp : AvP[Vp̃Gg |Cg̒`
//

#include "stdafx.h"
#include "resource.h"
#include <windows.h>
#include <commdlg.h>
#include <stdio.h>
#include <process.h>

#pragma comment(lib, "msvcrt")
#pragma comment(lib, "libcmt")

#define	_WIN32_LITE

static void DrawLCD();
void OpenRomFile(HWND);
void Reset();
void InitializeVideo(HDC);
void EndInterrupt();
int CloseGBMemory();

#include "../include/defines.h"				// IOWX^̒`
#include "../include/global.h"				// IOWX^̒`
#include "../gbcore/memory.c"					// R,W
#include "../gbcore/cpu_cb.c"
#include "../gbcore/cpu.c"					// CPURAPC,Cyclee[u
#include "../gbcore/video.c"
#include "../gbcore/rom.c"
#include "../gbcore/mainloop.c"

#define MAX_LOADSTRING 100
HWND	hwnd;
unsigned long tMain;
// O[oϐ:
HINSTANCE hInst;					// ݂̃CX^X
TCHAR szTitle[MAX_LOADSTRING];				// ^Cg o[ eLXg
TCHAR szWindowClass[MAX_LOADSTRING];			// ^Cg o[ eLXg

// ̃R[h W[Ɋ܂܂֐̑O錾:
ATOM			MyRegisterClass( HINSTANCE hInstance );
BOOL			InitInstance( HINSTANCE, int );
LRESULT CALLBACK	WndProc( HWND, UINT, WPARAM, LPARAM );
LRESULT CALLBACK	About( HWND, UINT, WPARAM, LPARAM );

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
 	// TODO: ̈ʒuɃR[hLqĂB
	MSG msg;
	HACCEL hAccelTable;

	// O[o XgO܂
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_GBEMUWIN32, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass( hInstance );

	// AvP[V̏s܂:
	if( !InitInstance( hInstance, nCmdShow ) ) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_GBEMUWIN32);

	// C bZ[W [v:
	while(true){
		if(CPUIsRunning){
			if(PeekMessage(&msg, hwnd, 0, 0, PM_NOREMOVE)){
				if(!GetMessage(&msg, NULL, 0, 0))break;
				TranslateMessage( &msg );
				DispatchMessage( &msg );
			}else{
			
			}
		}else{
			if(!GetMessage(&msg, NULL, 0, 0))break; 
			if(!TranslateAccelerator (msg.hwnd, hAccelTable, &msg)){
				TranslateMessage( &msg );
				DispatchMessage( &msg );
			}
		}
	}

	return msg.wParam;
}



//
//  ֐: MyRegisterClass()
//
//  pr: EBhE NX̓o^
//
//  Rg:
//
//    ̊֐т̎gp͂̃R[h Windows 95 Őɒǉꂽ
//    'RegisterClassEx' ֐ Win32 VXě݊ێꍇ
//    ̂ݕKvƂȂ܂BAvP[VAAvP[VɊ֘At
//    ꂽX[ ACR擾ł悤Å֐ĂяoƂ
//    dvłB
//
ATOM MyRegisterClass( HINSTANCE hInstance )
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style		= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon		= LoadIcon(hInstance, (LPCTSTR)IDI_GBEMUWIN32);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCSTR)IDC_GBEMUWIN32;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx( &wcex );
}

//
//   ֐: InitInstance(HANDLE, int)
//
//   pr: CX^X nh̕ۑƃC EBhE̍쐬
//
//   Rg:
//
//        ̊֐ł́ACX^X nhO[oϐɕۑAvO
//        C EBhE쐬\܂B
//
BOOL InitInstance( HINSTANCE hInstance, int nCmdShow )
{
	HWND hWnd;

	hInst = hInstance; // O[oϐɃCX^X nhۑ܂

	hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

	GetClientRect(hWnd, &DlgSize);
	
	//  NCAg̈LCD̉𑜓xƍ킹
	SetRect(&DlgSize, 0, 0, GB_LCD_X, GB_LCD_Y);
	AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW, TRUE);
	SetWindowPos(hWnd, hwnd, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	hwnd = hWnd;
	hDC = GetDC(hWnd);
	InitializeVideo(hDC);
	ReleaseDC(hWnd, hDC);
	memset(FrameBuffer, 3, GB_LCD_X*GB_LCD_Y);
	MEM[R_LCDC]|=0x80;

	if( !hWnd ) 
	{
	  return FALSE;
	}

	ShowWindow( hWnd, nCmdShow );
	UpdateWindow( hWnd );

	return TRUE;
}

//
//  ֐: WndProc(HWND, unsigned, WORD, LONG)
//
//  pr: C EBhẼbZ[W܂B
//
//  WM_COMMAND	- AvP[V j[̏
//  WM_PAINT	- C EBhE̕`
//  WM_DESTROY	- IbZ[W̒ʒmƃ^[
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch( message ) 
	{
		case WM_INITDIALOG:
				break;
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// j[Ỉ:
			switch( wmId ) 
			{
				case IDM_OPEN:
					OpenRomFile(hWnd);
					break;
				case IDM_RESET:
					Reset();
					break;
				case IDM_ABOUT:
				   DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				   break;
				case IDM_EXIT:
					CPUIsRunning = 0;
					Sleep(200);
				   DestroyWindow( hWnd );
				   exit(-1);
				   break;
				default:
				   return DefWindowProc( hWnd, message, wParam, lParam );
			}
			break;
		case WM_PAINT:
			hdc = BeginPaint (hWnd, &ps);
			hwnd = hWnd;
			DrawLCD();
			EndPaint( hWnd, &ps );
			break;
		case WM_SIZE:
			GetClientRect(hWnd, &DlgSize);
			break;
		case WM_KEYDOWN:
			switch(wParam){
				case VK_RIGHT:	/*high-to-low*/
					keyflag&=~0x01;
					keyint=1;
					break;
				case VK_LEFT:
					keyflag&=~0x02;
					keyint=1;
					break;
				case VK_UP:
					keyflag&=~0x04;
					keyint=1;
					break;
				case VK_DOWN:
					keyflag&=~0x08;
					keyint=1;
					break;
				case 'Z':
					keyflag&=~0x10;
					keyint=1;
					break;
				case 'X':
					keyflag&=~0x20;
					keyint=1;
					break;
				case ' ':
					keyflag&=~0x40;
					keyint=1;
					break;
				case VK_RETURN:
					keyflag&=~0x80;
					keyint=1;
					break;
				case VK_ESCAPE:
					exit(1);
					break;
				default:
					break;
			}
			break;
		case WM_KEYUP:
			switch(wParam){
				case VK_RIGHT:	/*low-to-high*/
					keyflag|=0x01;
					keyint=2;
					break;
				case VK_LEFT:
					keyflag|=0x02;
					keyint=2;
					break;
				case VK_UP:
					keyflag|=0x04;
					keyint=2;
					break;
				case VK_DOWN:
					keyflag|=0x08;
					keyint=2;
					break;
				case 'Z':
					keyflag|=0x10;
					keyint=2;
					break;
				case 'X':
					keyflag|=0x20;
					keyint=2;
					break;
				case ' ':
					keyflag|=0x40;
					keyint=2;
					break;
				case VK_RETURN:
					keyflag|=0x80;
					keyint=2;
					break;
				default:
					break;
			}
			break;
		case WM_DESTROY:
			PostQuitMessage( 0 );
			break;
		default:
			return DefWindowProc( hWnd, message, wParam, lParam );
   }
   return 0;
}

// o[W{bNXpbZ[W nh
LRESULT CALLBACK About( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	switch( message )
	{
		case WM_INITDIALOG:
				return TRUE;

		case WM_COMMAND:
			if( LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL ) 
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

void OpenRomFile(HWND hWnd)
{
	OPENFILENAME ofn;
	char filename[512];

	memset(filename, 0, 512);
	memset(&ofn, 0, sizeof(ofn));
	ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrFile = filename;
	ofn.lpstrFilter = "Gameboy ROM Files (*.gb;*.bin)\0*.gb;*.bin\0All Files (*.*)\0*.*";
	ofn.nMaxFileTitle = 512;
	ofn.nMaxFile = 512;
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWnd;

	if(GetOpenFileName(&ofn)){
/*		if(fp!=NULL)fclose(fp);
		fp = fopen(filename ,"rb");
		fread(ROM, 1, ROM_SIZE, fp);*/
		OpenRomFile(filename);
		Reset();
	}
}

void Reset()
{
	CPUIsRunning = 0;
	Sleep(200);
	InitializeMemory();
	InitializeRegister();
	//tMain = _beginthread((void (__cdecl *)(void *))MainLoop, 0, NULL);
	MainLoop();
}

static void DrawLCD()
{
	memcpy(pBitmap, FrameBuffer, GB_LCD_X * GB_LCD_Y);

	hDC = GetDC(hwnd);
	StretchBlt(hDC, 0, 0, DlgSize.right, DlgSize.bottom, hMemDC,
					0, 0, GB_LCD_X, GB_LCD_Y, SRCCOPY);
	ReleaseDC(hwnd, hDC);
};

void InitializeVideo(HDC hDC)
{	/*rbg}bv*/
	int i;

	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 8;

	for(i=0; i<16; i++){
		bmp_info.bmiColors[i].rgbRed = 
		bmp_info.bmiColors[i].rgbGreen = 
		bmp_info.bmiColors[i].rgbBlue = Colours[i&3];
		bmp_info.bmiColors[i].rgbReserved = 0;
	}

	hBitmap = CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= CreateCompatibleDC(hDC);
	SelectObject(hMemDC, hBitmap);
}
