// GBEmuDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBEmu.h"
#include "GBEmuDlg.h"
#include "AboutDlg.h"
#include <mmsystem.h>
#include <direct.h>
#pragma comment(lib, "winmm.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "gbwin32.h"


/////////////////////////////////////////////////////////////////////////////
// CGBEmuDlg _CAO

CGBEmuDlg::CGBEmuDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGBEmuDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGBEmuDlg)
		// : ̈ʒu ClassWizard ɂăȍǉ܂B
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	
	m_pTMain	=	NULL;
	m_pTGUI		=	NULL;
	m_pTileDlg	=	NULL;
	m_pMapDlg	=	NULL;
	m_pMemDlg	=	NULL;
	m_pDasm		=	NULL;
	m_pObjDlg	=	NULL;
	m_pKeyDlg	=	NULL;
	m_pDmaDlg	=	NULL;
}

void CGBEmuDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGBEmuDlg)
		// : ̏ꏊɂ ClassWizard ɂ DDX  DDV ̌Ăяoǉ܂B
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGBEmuDlg, CDialog)
	//{{AFX_MSG_MAP(CGBEmuDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_MENU_EXIT, OnMenuExit)
	ON_COMMAND(ID_MENU_ABOUT, OnMenuAbout)
	ON_COMMAND(ID_MENU_OPEN, OnMenuOpen)
	ON_COMMAND(ID_MENU_RESET, OnMenuReset)
	ON_COMMAND(ID_SHOW_FPS, OnShowFps)
	ON_WM_CLOSE()
	ON_COMMAND(ID_PRIORITY_NORMAL, OnPriorityNormal)
	ON_COMMAND(ID_PRIORITY_HIGHEST, OnPriorityHighest)
	ON_COMMAND(ID_PRIORITY_LOWEST, OnPriorityLowest)
	ON_COMMAND(ID_PRIORITY_ABOVE, OnPriorityAbove)
	ON_COMMAND(ID_PRIORITY_BELOW, OnPriorityBelow)
	ON_COMMAND(ID_SHOW_TILES, OnShowTiles)
	ON_COMMAND(ID_SHOW_MAP, OnShowMap)
	ON_COMMAND(ID_VSYNC, OnVsync)
	ON_WM_DROPFILES()
	ON_COMMAND(ID_SHOW_MEMORY, OnShowMemory)
	ON_WM_SIZE()
	ON_COMMAND(ID_ZOOM1, OnZoom1)
	ON_COMMAND(ID_ZOOM2, OnZoom2)
	ON_COMMAND(ID_ZOOM3, OnZoom3)
	ON_COMMAND(ID_ZOOM4, OnZoom4)
	ON_COMMAND(ID_SHOW_DEBUG, OnShowDebug)
	ON_WM_ACTIVATE()
	ON_COMMAND(ID_SKIP0, OnSkip0)
	ON_COMMAND(ID_SKIP5, OnSkip5)
	ON_COMMAND(ID_SKIP1, OnSkip1)
	ON_COMMAND(ID_SKIP2, OnSkip2)
	ON_COMMAND(ID_SKIP3, OnSkip3)
	ON_COMMAND(ID_SKIP4, OnSkip4)
	ON_COMMAND(ID_LAYER_BG, OnLayerBg)
	ON_COMMAND(ID_LAYER_OBJ, OnLayerObj)
	ON_COMMAND(ID_LAYER_WND, OnLayerWnd)
	ON_COMMAND(ID_PALETTE1, OnPalette1)
	ON_COMMAND(ID_PALETTE2, OnPalette2)
	ON_COMMAND(ID_PALETTE3, OnPalette3)
	ON_COMMAND(ID_MENU_DISABLE_ALL, OnMenuDisableAll)
	ON_COMMAND(ID_SHOW_OAM, OnShowOam)
	ON_COMMAND(ID_SOUND_ENABLE, OnSoundEnable)
	ON_COMMAND(ID_MENU_16BITDIB, OnMenu16bitdib)
	ON_COMMAND(ID_MENU_8BITDIB, OnMenu8bitdib)
	ON_COMMAND(ID_SOUND_CH1, OnSoundCh1)
	ON_COMMAND(ID_SOUND_CH2, OnSoundCh2)
	ON_COMMAND(ID_SOUND_CH3, OnSoundCh3)
	ON_COMMAND(ID_MENU_KEY, OnMenuKey)
	ON_COMMAND(ID_ZOOM_FULL, OnZoomFull)
	ON_WM_CREATE()
	ON_COMMAND(ID_FILTER_NORMAL, OnFilterNormal)
	ON_COMMAND(ID_FILTER_2XSAI, OnFilter2xsai)
	ON_COMMAND(ID_FILTER_SUPER2XSAI, OnFilterSuper2xsai)
	ON_COMMAND(ID_FILTER_SUPEREAGLE, OnFilterSupereagle)
	ON_COMMAND(IDM_DMA_DUMP, OnDmaDump)
	ON_COMMAND(IDM_HEADER_INFO, OnHeaderInfo)
	ON_COMMAND(ID_FILTER_PIXELATE, OnFilterPixelate)
	ON_COMMAND(ID_FILTER_MOTIONBLUR, OnFilterMotionblur)
	ON_COMMAND(ID_FILTER_TVMODE, OnFilterTvmode)
	ON_COMMAND(IDM_LOAD, OnLoad)
	ON_COMMAND(IDM_SAVE, OnSave)
	ON_COMMAND(IDM_AUTO_SAVE, OnAutoSave)
	ON_COMMAND(IDM_AUTO_LOAD, OnAutoLoad)
	ON_COMMAND(IDM_MODE_AUTO, OnModeAuto)
	ON_WM_KEYDOWN()
	ON_COMMAND(IDM_MODE_COLOR, OnModeColor)
	ON_COMMAND(IDM_CLASSIC, OnClassic)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGBEmuDlg bZ[W nh

BOOL CGBEmuDlg::OnInitDialog()
{ // _CAȌ
	CDialog::OnInitDialog();

	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIcon, FALSE);		// ACRݒ

	CDialog::GetClientRect(&DlgSize);
	timeBeginPeriod(1);					// ^C}̐xŏ

	fTileDlg=fMapDlg=fMemDlg=fAsmDlg=fObjDlg=fKeyDlg=false;
	fUpdate=fNext=fBreak=f16Dib=Os9x=fStop=fTMain=false;
	fActive=true;
	
	iFilter=0;

	if(joyGetPos(JOYSTICKID1,&joyinfo)==JOYERR_NOERROR){
		joyGetDevCaps(JOYSTICKID1,&joycaps,sizeof(JOYCAPS));
	}

	OSVERSIONINFO	osInfo;
	osInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&osInfo);
	if(osInfo.dwPlatformId==VER_PLATFORM_WIN32_WINDOWS)Os9x=true;
	
	GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_NORMAL, MF_BYCOMMAND);

	CString message;

	if(__argv[1]){
		GetFileName(__argv[1]);
		if(CheckExtensionName(__argv[1], "zip")){	/*gqZIP*/
			if(OpenZipRomFile(__argv[1])){
				message.LoadString(IDS_NOT_ZIP_FILE);
				MessageBox(message, 0, MB_ICONSTOP);
				return TRUE;
			}
		}else if(OpenRomFile(__argv[1])){
			message.LoadString(IDS_MEMORY_ALLOC_ERROR);
			MessageBox(message, 0, MB_ICONSTOP);
			return TRUE;
		}
/*		fp = fopen(__argv[1] ,"rb");
		fread(ROM, 1, ROM_SIZE, fp);
*/
		OnMenuReset();
	}

//	InitializeKeyCode();
	OnMenu16bitdib();
	OnModeAuto();

	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CGBEmuDlg::OnPaint() 
{ // EBhEANeBu̍ĕ`
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	} else {
		CDialog::OnPaint();

		DrawLCD();

	}
}

void CGBEmuDlg::ShowFps()
{	/*t[b\*/
	char str[30];
	static DWORD FpsTime;

	if(FpsTime < timeGetTime()){
		FpsTime = timeGetTime() + 1000;
		sprintf(str, _TITLE" - %d%%", (int)((FrameCount)/59.0*100));
		FrameCount = 0;
		CDialog::SetWindowText(str);
	}
}

void CGBEmuDlg::UpdateGUI()
{	/*fobK̍XV*/
	u16 Wait_A = 1000;
	u16 Wait_B = 28;
	DWORD Time_A = timeGetTime() + Wait_A;

	while(CPUIsRunning && !fUpdate){
		
		if(fAsmDlg)while(fStop)Sleep(10);
		else while(!fActive)Sleep(10);

		if(Time_A < timeGetTime()){
			Time_A = timeGetTime() + Wait_A;
			if(fTileDlg)m_pTileDlg->ShowTiles();	// ^Cr[A̍XV
			if(fMapDlg)m_pMapDlg->ShowMaps();		// }bvr[A̍XV
			if(fObjDlg)m_pObjDlg->ShowObj();		// OAMr[A̍XV
			if(fAsmDlg)m_pDasm->UpdateStack(true);	// X^bNr[A̍XV
		}
		
		if(fAsmDlg){
			m_pDasm->UpdateRegs();	// WX^r[AXV
			m_pDasm->UpdateStack(false);	// X^bNr[ȂI
			m_pDasm->SetDisasm();	// tAZȗI
		}
		
		if(fMemDlg)m_pMemDlg->ShowMemory();
		
		Sleep(Wait_B);
	}
	
	CDialog::SetWindowText(_TITLE);
}

void CGBEmuDlg::OnMenuOpen()
{ // ROMt@C̑I
	OPENFILENAME ofn;
	char filename[512];
	bool tmpfActive;
	CString	message;

	memset(filename, 0, 512);
	memset(&ofn, 0, sizeof(ofn));

	ofn.Flags		= OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrFile	= filename;
	ofn.lpstrFilter	= "Gameboy ROM Files (*.gb;*.bin;*.gbc;*.zip)\0*.gb;*.bin;*.zip;*.cgb;*.gbc;\0All Files (*.*)\0*.*";
	ofn.nMaxFileTitle	= 512;
	ofn.nMaxFile	= 512;
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.hwndOwner	= m_hWnd;
	ofn.lpstrInitialDir	= FilePath.GetBuffer(512);
	FilePath.ReleaseBuffer();

	tmpfActive=fActive;
	fActive=true;	/*Xbh邽߂̏*/
	
	if(GetOpenFileName(&ofn)){
		GetFileName(filename);
		FilePath=filename;
		/*if(fp)fclose(fp);*/
		if(CPUIsRunning)WaitForTMain();
		if(CheckExtensionName(filename, "zip")){	/*gqZIP*/
			if(OpenZipRomFile(filename)){
				message.LoadString(IDS_NOT_ZIP_FILE);
				MessageBox(message, 0, MB_ICONSTOP);
				return;
			}
		}else if(OpenRomFile(filename)){
			message.LoadString(IDS_MEMORY_ALLOC_ERROR);
			MessageBox(message, 0, MB_ICONSTOP);
			return;
		}
		OnMenuReset();
	}

	fActive=tmpfActive;
}

void CGBEmuDlg::OnMenuReset()
{	// WX^ƃ̏,s
	CString message;
	BYTE cart_type;
	BYTE fUnSupport;

	fActive=true;

	if(ROM[0]!=NULL){
		WaitForTMain();
		cart_type=ROM[0][0x0148];
		switch(cart_type){
		case 0x00:	/*ROM only*/
		case 0x01:	/*MBC1*/
		case 0x02:
		case 0x03:
					case 0x04:
		case 0x05:	/*MBC2*/
		case 0x06:
		case 0x08:	/*RON+RAM*/
		case 0x09:
		case 0x0B:	/*MMM01*/
		case 0x0C:
		case 0x0D:
		case 0x0F:	/*MBC3*/
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x19:	/*MBC5*/
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
			fUnSupport=0;
			break;
		default:
			fUnSupport=1;
			break;
		}
		if(fUnSupport){
				message.Format(IDS_UNSUPPORTED_ROM_SIZE, cart_type);
				//if(IDCANCEL==MessageBox(message, NULL, MB_ICONQUESTION|MB_RETRYCANCEL))return;
				MessageBox(message, NULL, MB_ICONQUESTION);
				return;
		}
		InitializeMemory();
		InitializeRegister();
		InitializeSound();
		if(fAutoLoad)OpenSaveFile();
		m_pTGUI = AfxBeginThread(ThreadGUI, this);
		m_pTMain = AfxBeginThread(ThreadMain, this);
	}
}

void CGBEmuDlg::WaitForTMain()
{	// C[vXbh̏I҂
	CString message;

	CPUIsRunning=0;
	fStop=false;
	fActive=true;

	if(fTMain)Sleep(10);
	if(fTMain)Sleep(100);
	if(fTMain)Sleep(500);
	if(fTMain){
		Sleep(3000);
		message.LoadString(IDS_ERROR_MAIN_THREAD);
		MessageBox(message, "Wait for closing the mainloop thread.", MB_ICONSTOP);
		if(!fTMain)return;
		CloseGBMemory(ROM[0]);
	}
}

UINT CGBEmuDlg::ThreadMain(LPVOID pParam)
{
	((CGBEmuDlg*)pParam)->MainLoop();

	return 0;
}

UINT CGBEmuDlg::ThreadGUI(LPVOID pParam)
{
	((CGBEmuDlg*)pParam)->UpdateGUI();

	return 0;
}

void CGBEmuDlg::OnClose()
{	// I
	if(fAutoSave)CloseSaveFile();

	WaitForTMain();
	timeEndPeriod(1);
	/*if(fp!=NULL)fclose(fp);*/
	if(fSound)midiOutClose(hMidiOut);

	m_pTileDlg = NULL;
	m_pMapDlg = NULL;
	m_pMemDlg = NULL;
	m_pDasm = NULL;
	m_pObjDlg = NULL;
	m_pKeyDlg = NULL;

	delete m_pTileDlg;
	delete m_pMapDlg;
	delete m_pMemDlg;
	delete m_pDasm;
	delete m_pObjDlg;
	delete m_pKeyDlg;

//	free(FrameBuffer16);

	CloseGBMemory(ROM[0]);
	
	WINDOWPLACEMENT wpl;
	GetWindowPlacement(&wpl);

	CWinApp* pApp = AfxGetApp();	//ݒۑ
	pApp->WriteProfileString("GameboyVM", "Version", "0.07");
	pApp->WriteProfileString("General", "FileDirectry", FilePath);
	pApp->WriteProfileInt("General", "WindowPositionX", wpl.rcNormalPosition.left);
	pApp->WriteProfileInt("General", "WindowPositionY", wpl.rcNormalPosition.top);
	pApp->WriteProfileInt("General", "ClientSize", iZoom);
	pApp->WriteProfileInt("General", "EnableVsync", fVsync);
	pApp->WriteProfileInt("General", "EnableFPS", fFps);
	pApp->WriteProfileInt("Video", "16bitDIBMode", f16Dib);
	pApp->WriteProfileInt("Video", "GraphicFilter", iFilter);
	pApp->WriteProfileInt("Video", "EnableBG", EnableBG);
	pApp->WriteProfileInt("Video", "EnableWindow", EnableWND);
	pApp->WriteProfileInt("Video", "EnableSprite", EnableOBJ);
	pApp->WriteProfileInt("Sound", "EnableSound", fSound);
	pApp->WriteProfileInt("Sound", "ChannelFlags", fChannel);
	pApp->WriteProfileInt("Control", "KeyCodeA", KeyCodeA);
	pApp->WriteProfileInt("Control", "KeyCodeB", KeyCodeB);
	pApp->WriteProfileInt("Control", "KeyCodeStart", KeyCodeStart);
	pApp->WriteProfileInt("Control", "KeyCodeSelect", KeyCodeSelect);
	pApp->WriteProfileInt("Control", "KeyCodeUp", KeyCodeUp);
	pApp->WriteProfileInt("Control", "KeyCodeDown", KeyCodeDown);
	pApp->WriteProfileInt("Control", "KeyCodeLeft", KeyCodeLeft);
	pApp->WriteProfileInt("Control", "KeyCodeRight", KeyCodeRight);

	DestroyWindow();
}

void CGBEmuDlg::OnDropFiles(HDROP hDropInfo) 
{	// _CAOփhbvꂽt@Cs
	CString message;
	char filename[MAX_PATH];

	DragQueryFile(hDropInfo, 0, filename, sizeof(filename));
	
	if(filename){
		WaitForTMain();
		GetFileName(filename);
		if(CheckExtensionName(filename, "zip")){	/*gqZIP*/
			if(OpenZipRomFile(filename)){
				message.LoadString(IDS_NOT_ZIP_FILE);
				MessageBox(message, 0, MB_ICONSTOP);
				return;
			}
		}else if(OpenRomFile(filename)){
			message.LoadString(IDS_MEMORY_ALLOC_ERROR);
			MessageBox(message, 0, MB_ICONSTOP);
			return;
		}
/*		fp = fopen(filename ,"rb");
		fread(ROM, 1, ROM_SIZE, fp);*/
		OnMenuReset();
	}

	CDialog::OnDropFiles(hDropInfo);
}

void InitializeVideo(HDC hDC)
{	/*rbg}bv*/
	int i;

	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));

	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 8;

	for(i=0; i<16; i++){
		bmp_info.bmiColors[i].rgbRed = 
		bmp_info.bmiColors[i].rgbGreen = 
		bmp_info.bmiColors[i].rgbBlue = Colours[i&3];
		bmp_info.bmiColors[i].rgbReserved = 0;
	}

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
}

void CGBEmuDlg::DrawLCD()
{
	static u8 deltaPtr[1];

	if(f16Dib){
		switch(iFilter){
		case 1:
			_2xSaI((unsigned char*)FrameBuffer16, 160*2, deltaPtr,
					pBitmap, 160*4, 160, 144);
			break;
		case 2:
			Super2xSaI((unsigned char*)FrameBuffer16, 160*2, deltaPtr,
					pBitmap, 160*4, 160, 144);
			break;
		case 3:
			SuperEagle((unsigned char*)FrameBuffer16, 160*2, deltaPtr,
					pBitmap, 160*4, 160, 144);
			break;
		case 4:
			Pixelate((unsigned char*)FrameBuffer16, 160*2, deltaPtr,
					pBitmap, 160*4, 160, 144);
			break;
		case 5:
			MotionBlur((unsigned char*)FrameBuffer16, 160*2, deltaPtr,
					pBitmap, 160*4, 160, 144);
			break;
		case 6:
			TVMode((unsigned char*)FrameBuffer16, 160*2, deltaPtr,
					pBitmap, 160*4, 160, 144);
/*			Simple2x((unsigned char*)FrameBuffer16, 160*2, deltaPtr,
					pBitmap, 160*4, 160, 144);*/
			break;
		default:
			memcpy(pBitmap, FrameBuffer16, GB_LCD_X * GB_LCD_Y*2);
			hDC = ::GetDC(m_hWnd);
			::StretchBlt(hDC, 0, 0, DlgSize.right, DlgSize.bottom, hMemDC,
							0, 0, GB_LCD_X, GB_LCD_Y, SRCCOPY);
			::ReleaseDC(m_hWnd, hDC);
			return;
		}
		hDC = ::GetDC(m_hWnd);
		::StretchBlt(hDC, 0, 0, DlgSize.right, DlgSize.bottom, hMemDC,
						0, 0, GB_LCD_X*2, GB_LCD_Y*2, SRCCOPY);
		::ReleaseDC(m_hWnd, hDC);
	}else{
		memcpy(pBitmap, FrameBuffer, GB_LCD_X * GB_LCD_Y);
		hDC = ::GetDC(m_hWnd);
		::StretchBlt(hDC, 0, 0, DlgSize.right, DlgSize.bottom, hMemDC,
						0, 0, GB_LCD_X, GB_LCD_Y, SRCCOPY);
		::ReleaseDC(m_hWnd, hDC);
	}
}

BOOL CGBEmuDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message==WM_KEYDOWN){	/*high-to-low*/
		if(pMsg->wParam==KeyCodeA){
			keyflag&=~0x10;
			keyint=1;
			return TRUE;
		}
		if(pMsg->wParam==KeyCodeB){
			keyflag&=~0x20;
			keyint=1;
			return TRUE;
		}
		if(pMsg->wParam==KeyCodeStart){
			keyflag&=~0x80;
			keyint=1;
			return TRUE;
		}
		if(pMsg->wParam==KeyCodeSelect){
			keyflag&=~0x40;
			keyint=1;
			return TRUE;
		}
		if(pMsg->wParam==KeyCodeUp){
			keyflag&=~0x04;
			keyint=1;
			return TRUE;
		}
		if(pMsg->wParam==KeyCodeDown){
			keyflag&=~0x08;
			keyint=1;
			return TRUE;
		}
		if(pMsg->wParam==KeyCodeLeft){
			keyflag&=~0x02;
			keyint=1;
			return TRUE;
		}
		if(pMsg->wParam==KeyCodeRight){
			keyflag&=~0x01;
			keyint=1;
			return TRUE;
		}
		switch(pMsg->wParam){	/*high-to-low*/
/*		case VK_RIGHT:
			keyflag&=~0x01;
			keyint=1;
			break;
		case VK_LEFT:
			keyflag&=~0x02;
			keyint=1;
			break;
		case VK_UP:
			keyflag&=~0x04;
			keyint=1;
			break;
		case VK_DOWN:
			keyflag&=~0x08;
			keyint=1;
			break;
		case 'Z':
			keyflag&=~0x10;
			keyint=1;
			break;
		case 'X':
			keyflag&=~0x20;
			keyint=1;
			break;
		case ' ':
			keyflag&=~0x40;
			keyint=1;
			break;
		case VK_RETURN:
			keyflag&=~0x80;
			keyint=1;
			break;*/
		case VK_ESCAPE:
			return false;
		case 'S':
			OnVsync();
			break;
		default:
			break;
		}
	}

	if(pMsg->message==WM_KEYUP){	/*low-to-high*/
		if(pMsg->wParam==KeyCodeA){
			keyflag|=0x10;
			keyint=2;
			return TRUE;
		}
		if(pMsg->wParam==KeyCodeB){
			keyflag|=0x20;
			keyint=2;
			return TRUE;
		}
		if(pMsg->wParam==KeyCodeStart){
			keyflag|=0x80;
			keyint=2;
			return TRUE;
		}
		if(pMsg->wParam==KeyCodeSelect){
			keyflag|=0x40;
			keyint=2;
			return TRUE;
		}
		if(pMsg->wParam==KeyCodeUp){
			keyflag|=0x04;
			keyint=2;
			return TRUE;
		}
		if(pMsg->wParam==KeyCodeDown){
			keyflag|=0x08;
			keyint=2;
			return TRUE;
		}
		if(pMsg->wParam==KeyCodeLeft){
			keyflag|=0x02;
			keyint=2;
			return TRUE;
		}
		if(pMsg->wParam==KeyCodeRight){
			keyflag|=0x01;
			keyint=2;
			return TRUE;
		}
/*		switch(pMsg->wParam){
		case VK_RIGHT:
			keyflag|=0x01;
			keyint=2;
			break;
		case VK_LEFT:
			keyflag|=0x02;
			keyint=2;
			break;
		case VK_UP:
			keyflag|=0x04;
			keyint=2;
			break;
		case VK_DOWN:
			keyflag|=0x08;
			keyint=2;
			break;
		case 'Z':
			keyflag|=0x10;
			keyint=2;
			break;
		case 'X':
			keyflag|=0x20;
			keyint=2;
			break;
		case ' ':
			keyflag|=0x40;
			keyint=2;
			break;
		case VK_RETURN:
			keyflag|=0x80;
			keyint=2;
			break;
		default:
			break;
		}*/
	}
	
	return CDialog::PreTranslateMessage(pMsg);
}

void CGBEmuDlg::OnPalette1() 
{
	hDC = ::GetDC(m_hWnd);
	PaletteNo=0;
	InitializeVideo(hDC);
	::ReleaseDC(m_hWnd, hDC);
	
	DrawLCD();
}

void CGBEmuDlg::OnPalette2() 
{
	hDC = ::GetDC(m_hWnd);
	PaletteNo=1;
	InitializeVideo(hDC);
	::ReleaseDC(m_hWnd, hDC);
	
	DrawLCD();
}

void CGBEmuDlg::OnPalette3() 
{
	hDC = ::GetDC(m_hWnd);
	PaletteNo=2;
	InitializeVideo(hDC);
	::ReleaseDC(m_hWnd, hDC);
	
	DrawLCD();
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CGBEmuDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CGBEmuDlg::OnMenuAbout() 
{ // 쌠_CAO̕\
	CAboutDlg about_dlg;
	
	about_dlg.DoModal();
/*
	int x;
	char str[150];
	char col[50];

	*str='\0';
	for(x=0; x<0x3F; x+=8){
		sprintf(col, "%02d | %04X,%04X,%04X,%04X\n", x/8,
			(cgb_palette[x+1]<<8)|cgb_palette[x+0],
			(cgb_palette[x+3]<<8)|cgb_palette[x+2],
			(cgb_palette[x+5]<<8)|cgb_palette[x+4],
			(cgb_palette[x+7]<<8)|cgb_palette[x+6]);
		strcat(str, col);
	}
	strcat(str, "\n");
	MessageBox(str);*/
}

void CGBEmuDlg::OnShowMemory() 
{	// _v\
	if(!fMemDlg){	// Tiles_CAO\
		if(m_pMemDlg==NULL){
			m_pMemDlg = new CMemDlg;
			m_pMemDlg->Create(IDD_MEMORY_DIALOG);
		}
		m_pMemDlg->ShowWindow(SW_SHOW);
		fMemDlg=true;
	}else{
		m_pMemDlg->SetFocus();
	}

	m_pMemDlg->ShowMemory();
}

void CGBEmuDlg::OnShowDebug() 
{	// fobK\
	if(!fAsmDlg){
		if(m_pDasm==NULL){
			m_pDasm = new CDisasm;
			m_pDasm->Create(IDD_DISASM_DIALOG);
		}
		m_pDasm->ShowWindow(SW_SHOW);
		fAsmDlg=true;
	}else{
		m_pDasm->SetFocus();
	}

	m_pDasm->ShowDebug();
}

void CGBEmuDlg::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{	/*ANeBuɃXbhꎞ~*/
	CDialog::OnActivate(nState, pWndOther, bMinimized);

//	if(nState==WA_INACTIVE)fActive=false;
//	else fActive=true;

	if(CPUIsRunning){
		if(fSound)midiOutShortMsg(hMidiOut, 0x00000090|(0x00007F00&old_wave1));
	}
}

void CGBEmuDlg::OnOK()
{

}

void CGBEmuDlg::OnCancel()
{
	EndDialog(0);
}

void CGBEmuDlg::OnMenuExit() 
{ // I{^
	CGBEmuDlg::OnClose();
}

void CGBEmuDlg::OnLayerBg() 
{	/*C[̕\ؑ*/
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_LAYER_BG, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_LAYER_BG, MF_UNCHECKED);
		EnableBG=0;
	}else{
		EnableBG=1;
	}
}

void CGBEmuDlg::OnLayerWnd() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_LAYER_WND, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_LAYER_WND, MF_UNCHECKED);
		EnableWND=0;
	}else{
		EnableWND=1;
	}
}

void CGBEmuDlg::OnLayerObj() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_LAYER_OBJ, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_LAYER_OBJ, MF_UNCHECKED);
		EnableOBJ=0;
	}else{
		EnableOBJ=1;
	}
}

void CGBEmuDlg::OnSkip0() 
{
	FrameSkip = 0;
	
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP0, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip1() 
{
	FrameSkip = 1;
	
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP1, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip2() 
{
	FrameSkip = 2;
	
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP2, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip3() 
{
	FrameSkip = 3;
	
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP3, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip4() 
{
	FrameSkip = 4;
	
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP4, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip5() 
{
	FrameSkip = 5;
	
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP5, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	CDialog::GetClientRect(&DlgSize);
}

void CGBEmuDlg::OnZoom1()
{
	iZoom=1;

	SetRect(&DlgSize, 0, 0, GB_LCD_X, GB_LCD_Y);
	AdjustWindowRect(&DlgSize, (WS_OVERLAPPEDWINDOW&~WS_THICKFRAME) | WS_DLGFRAME, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	
	GetMenu()->CheckMenuRadioItem(ID_ZOOM1, ID_ZOOM4, ID_ZOOM1, MF_BYCOMMAND);
}

void CGBEmuDlg::OnZoom2() 
{	
	iZoom=2;

	SetRect(&DlgSize, 0, 0, GB_LCD_X*2, GB_LCD_Y*2);
    AdjustWindowRect(&DlgSize, (WS_OVERLAPPEDWINDOW&~WS_THICKFRAME) | WS_DLGFRAME, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	
	GetMenu()->CheckMenuRadioItem(ID_ZOOM1, ID_ZOOM4, ID_ZOOM2, MF_BYCOMMAND);
}

void CGBEmuDlg::OnZoom3() 
{	
	iZoom=3;

	SetRect(&DlgSize, 0, 0, GB_LCD_X*3, GB_LCD_Y*3);
	AdjustWindowRect(&DlgSize, (WS_OVERLAPPEDWINDOW&~WS_THICKFRAME) | WS_DLGFRAME, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	
	GetMenu()->CheckMenuRadioItem(ID_ZOOM1, ID_ZOOM4, ID_ZOOM3, MF_BYCOMMAND);
}

void CGBEmuDlg::OnZoom4() 
{	
	iZoom=4;

	SetRect(&DlgSize, 0, 0, GB_LCD_X*4, GB_LCD_Y*4);
    AdjustWindowRect(&DlgSize, (WS_OVERLAPPEDWINDOW&~WS_THICKFRAME) | WS_DLGFRAME, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	
	GetMenu()->CheckMenuRadioItem(ID_ZOOM1, ID_ZOOM4, ID_ZOOM4, MF_BYCOMMAND);
}

void CGBEmuDlg::OnZoomFull() 
{
	iZoom=5;

	AfxGetMainWnd()->PostMessage(WM_SYSCOMMAND, SC_MAXIMIZE);
}

void CGBEmuDlg::OnPriorityNormal()
{
	if(CPUIsRunning){	// Xbh쎞̂ݕύX
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_NORMAL)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_NORMAL, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnPriorityHighest()
{
	if(CPUIsRunning){
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_HIGHEST)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_HIGHEST, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnPriorityLowest()
{
	if(CPUIsRunning){
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_LOWEST)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_LOWEST, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnPriorityAbove()
{
	if(CPUIsRunning){
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_ABOVE_NORMAL)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_ABOVE, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnPriorityBelow() 
{
	if(CPUIsRunning){
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_BELOW_NORMAL)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_BELOW, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnShowFps()
{	// t[b^Cgo[ɂ邽߂̃`FbN
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_SHOW_FPS, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_SHOW_FPS, MF_UNCHECKED);
		fFps=0;
		CDialog::SetWindowText(_TITLE);
	}else{
		fFps=1;
	}
}

void CGBEmuDlg::OnVsync()
{	// ̂߂̃`FbN
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_VSYNC, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_VSYNC, MF_UNCHECKED);
		fVsync=0;
	}else{
		fVsync=1;
	}
}

void CGBEmuDlg::OnShowTiles() 
{	// ^Cf[^ׂĕ\
	if(!fTileDlg){	// Tiles_CAO\
		if(m_pTileDlg==NULL){
			m_pTileDlg = new CTilesDlg;
			m_pTileDlg->Create(IDD_TILES_DIALOG);
		}
		m_pTileDlg->ShowWindow(SW_SHOW);
		fTileDlg = true;
	}else{
		m_pTileDlg->SetFocus();
	}

	m_pTileDlg->ShowTiles();
}

void CGBEmuDlg::OnShowMap() 
{	// ^Cf[^ׂĕ\
	if(!fMapDlg){	// Maps_CAO\
		if(m_pMapDlg==NULL){
			m_pMapDlg = new CMaps;
			m_pMapDlg->Create(IDD_MAPS_DIALOG);
		}
		m_pMapDlg->ShowWindow(SW_SHOW);
		fMapDlg=true;
	}else{
		m_pMapDlg->SetFocus();
	}

	m_pMapDlg->ShowMaps();
}

void CGBEmuDlg::OnMenuDisableAll() 
{	/*fobKXVȂ*/
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_MENU_DISABLE_ALL, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_MENU_DISABLE_ALL, MF_UNCHECKED);
		fUpdate=true;
	}else {
		fUpdate=false;
		if(CPUIsRunning)m_pTGUI = AfxBeginThread(ThreadGUI, this);
	}
}

void CGBEmuDlg::OnShowOam() 
{	/*OAMr[A\*/
	if(!fObjDlg){
		if(m_pObjDlg==NULL){
			m_pObjDlg = new CObjDlg;
			m_pObjDlg->Create(IDD_OBJ_DIALOG);
		}
		m_pObjDlg->ShowWindow(SW_SHOW);
		fObjDlg=true;
	}else{
		m_pObjDlg->SetFocus();
	}

	m_pObjDlg->ShowObj();	
}

void CGBEmuDlg::OnSoundEnable() 
{
//	OnShowFps();
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_SOUND_ENABLE, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_SOUND_ENABLE, MF_UNCHECKED);
		fSound=0;
		midiOutReset(hMidiOut);
		midiOutClose(hMidiOut);
	}else {
		fSound=1;
		midiOutOpen(&hMidiOut,(UINT)MIDI_MAPPER, NULL, 0L, 0L);
		midiOutShortMsg(hMidiOut, 0x000014C0);	/*F̑I*/
		//midiOutShortMsg(hMidiOut, 0x000034C0);
//		midiOutShortMsg(hMidiOut, 0x0000007E);	/*mtHjbN*/
	}
}

void InitializeVideo16(HDC hDC)
{	/*rbg}bv*/


/*	if(FrameBuffer16==NULL){
		FrameBuffer16=(u16*)malloc(GB_LCD_X*GB_LCD_Y*2);
	}
	if(FrameBuffer16==NULL)GBEmu.MessageBox("error", NULL, MB_ICONSTOP);
*/
	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 16;

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
}

void CGBEmuDlg::OnMenu16bitdib()
{	/*16bitrbg}bv[h*/
	f16Dib=true;

	GetMenu()->CheckMenuRadioItem(ID_MENU_8BITDIB, ID_MENU_16BITDIB, ID_MENU_16BITDIB, MF_BYCOMMAND);

	hDC = ::GetDC(m_hWnd);
	InitializeVideo16(hDC);
	::ReleaseDC(m_hWnd, hDC);
}


void CGBEmuDlg::OnMenu8bitdib()
{	/*8bitpbg[h*/
	f16Dib=false;

//	if(f16Dib)free(FrameBuffer16);
	GetMenu()->CheckMenuRadioItem(ID_MENU_8BITDIB, ID_MENU_16BITDIB, ID_MENU_8BITDIB, MF_BYCOMMAND);

	hDC = ::GetDC(m_hWnd);
	InitializeVideo(hDC);
	::ReleaseDC(m_hWnd, hDC);
}

void CGBEmuDlg::OnSoundCh1() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_SOUND_CH1, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_SOUND_CH1, MF_UNCHECKED);
		fChannel&=~0x01;
		midiOutShortMsg(hMidiOut, 0x00000080|(0x00007F00&old_wave1));	/*TEh̏*/
	}else {
		fChannel|=0x01;
	}
}

void CGBEmuDlg::OnSoundCh2() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_SOUND_CH2, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_SOUND_CH2, MF_UNCHECKED);
		fChannel&=~0x02;
		midiOutShortMsg(hMidiOut, 0x00000081|(0x00007F00&old_wave2));	/*TEh̏*/
	}else {
		fChannel|=0x02;
	}
}

void CGBEmuDlg::OnSoundCh3() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_SOUND_CH3, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_SOUND_CH3, MF_UNCHECKED);
		fChannel&=~0x04;
		midiOutShortMsg(hMidiOut, 0x00000082|(0x00007F00&old_wave3));	/*TEh̏*/
	}else {
		fChannel|=0x04;
	}
}


void CGBEmuDlg::OnMenuKey() 
{
	if(!fKeyDlg){
		if(m_pKeyDlg==NULL){
			m_pKeyDlg = new CKeyDlg;
			m_pKeyDlg->Create(IDD_KEY_DIALOG);
		}
		m_pKeyDlg->ShowWindow(SW_SHOW);
		fKeyDlg=true;
	}else{
		m_pKeyDlg->SetFocus();
	}
}

void CGBEmuDlg::DebugNextStep()
{	/*C[vꎞ~iXebvsj*/
	fNext=false;
	fStop=true;

	m_pDasm->UpdateStack(true);
	m_pDasm->UpdateRegs();
	m_pDasm->SetDisasm();

	DrawLCD();
}

void CGBEmuDlg::DebugBreakPoint()
{	/*C[vɃu[N|Cg𒣂*/
	if((cpu.PC==bp1)||(cpu.PC==bp2)||(cpu.PC==bp3)){
		fStop=true;
		m_pDasm->UpdateStack(true);
		m_pDasm->UpdateRegs();
		m_pDasm->SetDisasm();
	}
}

int CGBEmuDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;

	UINT	posx,posy;

	CWinApp* pApp = AfxGetApp();	//ݒۑ
//	pApp->GetProfileString("General", "Version", "0.06");
	FilePath	=	pApp->GetProfileString("General", "FileDirectry", "");
	posx		=	pApp->GetProfileInt("General", "WindowPositionX", 0);
	posy		=	pApp->GetProfileInt("General", "WindowPositionY", 0);
	iZoom		=	pApp->GetProfileInt("General", "ClientSize", 1);
	fVsync		=	pApp->GetProfileInt("General", "EnableVsync", 1);
	fFps		=	pApp->GetProfileInt("General", "EnableFPS", 1);
	f16Dib		=	pApp->GetProfileInt("Video", "16bitDIBMode", 0);
	iFilter		=	pApp->GetProfileInt("Video", "GraphicFilter", 0);
	EnableBG	=	pApp->GetProfileInt("Video", "EnableBG", 1);
	EnableWND	=	pApp->GetProfileInt("Video", "EnableWindow", 1);
	EnableOBJ	=	pApp->GetProfileInt("Video", "EnableSprite", 1);
	fSound		=	pApp->GetProfileInt("Sound", "EnableSound", 0);
	fChannel	=	pApp->GetProfileInt("Sound", "ChannelFlags", 7);

	KeyCodeA	=	pApp->GetProfileInt("Control", "KeyCodeA", 'Z');
	KeyCodeB	=	pApp->GetProfileInt("Control", "KeyCodeB", 'X');
	KeyCodeStart=	pApp->GetProfileInt("Control", "KeyCodeStart", VK_RETURN);
	KeyCodeSelect=	pApp->GetProfileInt("Control", "KeyCodeSelect", ' ');
	KeyCodeUp	=	pApp->GetProfileInt("Control", "KeyCodeUp", VK_UP);
	KeyCodeDown	=	pApp->GetProfileInt("Control", "KeyCodeDown", VK_DOWN);
	KeyCodeLeft	=	pApp->GetProfileInt("Control", "KeyCodeLeft", VK_LEFT);
	KeyCodeRight=	pApp->GetProfileInt("Control", "KeyCodeRight", VK_RIGHT);

	//  NCAg̈LCD̉𑜓xƍ킹
	SetRect(&DlgSize, posx, posy, GB_LCD_X, GB_LCD_Y);
	AdjustWindowRect(&DlgSize, (WS_OVERLAPPEDWINDOW&~WS_THICKFRAME) | WS_DLGFRAME, TRUE);
/*	SetWindowPos(&wndTop, posx, posy, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, 0);

	CDialog::MoveWindow(posx, posy, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, FALSE);*/

//	if(!::IsRectEmpty(&DlgSize))MoveWindow(&DlgSize, FALSE);

	if(fFps)OnShowFps();
	if(fVsync)OnVsync();
	if(fSound)OnSoundEnable();
	if(f16Dib)OnMenu16bitdib();
	if(EnableBG)OnLayerBg();
	if(EnableWND)OnLayerWnd();
	if(EnableOBJ)OnLayerObj();
	if(fChannel&0x01)OnSoundCh1();
	if(fChannel&0x02)OnSoundCh2();
	if(fChannel&0x04)OnSoundCh3();

//	UINT	tmpiFilter=iFilter;
	OnFilterNormal();
//	Sleep(100);
	switch(iFilter){
	case 1:
		OnFilter2xsai();break;
	case 2:
		OnFilterSuper2xsai();break;
	case 3:
		OnFilterSupereagle();break;
	default:
		iFilter=0;
		OnFilterNormal();
	}

	switch(iZoom){
	case 1:
		OnZoom1();break;
	case 2:
		OnZoom2();break;
	case 3:
		OnZoom3();break;
	case 4:
		OnZoom4();break;
	case 5:
		OnZoomFull();break;
	default:
		iZoom=1;
		OnZoom1();
	}

	/*memset(FrameBuffer, 3, GB_LCD_X*GB_LCD_Y);
	MEM[R_LCDC]|=0x80;*/

	OnAutoSave();
	OnAutoLoad();
	
	return 0;
}

void CGBEmuDlg::OnFilterNormal() 
{
	iFilter=0;

	GetMenu()->CheckMenuRadioItem(ID_FILTER_2XSAI, ID_FILTER_TVMODE, ID_FILTER_NORMAL, MF_BYCOMMAND);

	OnMenu8bitdib();
}

void CGBEmuDlg::OnFilter2xsai()
{
	iFilter=1;
	f16Dib=true;

	GetMenu()->CheckMenuRadioItem(ID_FILTER_2XSAI, ID_FILTER_TVMODE, ID_FILTER_2XSAI, MF_BYCOMMAND);
	GetMenu()->CheckMenuRadioItem(ID_MENU_8BITDIB, ID_MENU_16BITDIB, ID_MENU_16BITDIB, MF_BYCOMMAND);

	Init_2xSaI(555);

/*	if(FrameBuffer16==NULL){
		FrameBuffer16=(u16*)malloc(GB_LCD_X*GB_LCD_Y*2);
	}
	if(FrameBuffer16==NULL)GBEmu.MessageBox("error", NULL, MB_ICONSTOP);
*/
	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X*2;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y*2;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 16;

	hDC = ::GetDC(m_hWnd);

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
	
	::ReleaseDC(m_hWnd, hDC);
	
	if(1>=iZoom)OnZoom2();
}

void CGBEmuDlg::OnFilterSuper2xsai() 
{
	iFilter=2;
	f16Dib=true;

	GetMenu()->CheckMenuRadioItem(ID_FILTER_2XSAI, ID_FILTER_TVMODE, ID_FILTER_SUPER2XSAI, MF_BYCOMMAND);
	GetMenu()->CheckMenuRadioItem(ID_MENU_8BITDIB, ID_MENU_16BITDIB, ID_MENU_16BITDIB, MF_BYCOMMAND);

	Init_2xSaI(555);

/*	if(FrameBuffer16==NULL){
		FrameBuffer16=(u16*)malloc(GB_LCD_X*GB_LCD_Y*2);
	}
	if(FrameBuffer16==NULL)GBEmu.MessageBox("error", NULL, MB_ICONSTOP);
*/
	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X*2;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y*2;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 16;

	hDC = ::GetDC(m_hWnd);

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
	
	::ReleaseDC(m_hWnd, hDC);
	
	if(1>=iZoom)OnZoom2();
}


void CGBEmuDlg::OnFilterSupereagle() 
{
	iFilter=3;
	f16Dib=true;

	GetMenu()->CheckMenuRadioItem(ID_FILTER_2XSAI, ID_FILTER_TVMODE, ID_FILTER_SUPEREAGLE, MF_BYCOMMAND);
	GetMenu()->CheckMenuRadioItem(ID_MENU_8BITDIB, ID_MENU_16BITDIB, ID_MENU_16BITDIB, MF_BYCOMMAND);

	Init_2xSaI(555);

/*	if(FrameBuffer16==NULL){
		FrameBuffer16=(u16*)malloc(GB_LCD_X*GB_LCD_Y*2);
	}
	if(FrameBuffer16==NULL)GBEmu.MessageBox("error", NULL, MB_ICONSTOP);
*/
	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X*2;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y*2;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 16;

	hDC = ::GetDC(m_hWnd);

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
	
	::ReleaseDC(m_hWnd, hDC);
	
	if(1>=iZoom)OnZoom2();
}

void CGBEmuDlg::OnFilterPixelate() 
{
	iFilter=4;
	f16Dib=true;

	GetMenu()->CheckMenuRadioItem(ID_FILTER_2XSAI, ID_FILTER_TVMODE, ID_FILTER_PIXELATE, MF_BYCOMMAND);
	GetMenu()->CheckMenuRadioItem(ID_MENU_8BITDIB, ID_MENU_16BITDIB, ID_MENU_16BITDIB, MF_BYCOMMAND);

	memset(FrameBuffer16, 0, 160*144*2);

/*	if(FrameBuffer16==NULL){
		FrameBuffer16=(u16*)malloc(GB_LCD_X*GB_LCD_Y*2);
	}
	if(FrameBuffer16==NULL)GBEmu.MessageBox("error", NULL, MB_ICONSTOP);
*/
	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X*2;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y*2;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 16;

	hDC = ::GetDC(m_hWnd);

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
	
	::ReleaseDC(m_hWnd, hDC);
	
	if(1>=iZoom)OnZoom2();
}

void CGBEmuDlg::OnFilterMotionblur() 
{
	iFilter=5;
	f16Dib=true;

	GetMenu()->CheckMenuRadioItem(ID_FILTER_2XSAI, ID_FILTER_TVMODE, ID_FILTER_MOTIONBLUR, MF_BYCOMMAND);
	GetMenu()->CheckMenuRadioItem(ID_MENU_8BITDIB, ID_MENU_16BITDIB, ID_MENU_16BITDIB, MF_BYCOMMAND);

/*	if(FrameBuffer16==NULL){
		FrameBuffer16=(u16*)malloc(GB_LCD_X*GB_LCD_Y*2);
	}
	if(FrameBuffer16==NULL)GBEmu.MessageBox("error", NULL, MB_ICONSTOP);
*/
	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X*2;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y*2;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 16;

	hDC = ::GetDC(m_hWnd);

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
	
	::ReleaseDC(m_hWnd, hDC);
	
	if(1>=iZoom)OnZoom2();
}

void CGBEmuDlg::OnFilterTvmode() 
{
	iFilter=6;
	f16Dib=true;

	memset(FrameBuffer16, 0, 160*144*2);

	GetMenu()->CheckMenuRadioItem(ID_FILTER_2XSAI, ID_FILTER_TVMODE, ID_FILTER_TVMODE, MF_BYCOMMAND);
	GetMenu()->CheckMenuRadioItem(ID_MENU_8BITDIB, ID_MENU_16BITDIB, ID_MENU_16BITDIB, MF_BYCOMMAND);

/*	if(FrameBuffer16==NULL){
		FrameBuffer16=(u16*)malloc(GB_LCD_X*GB_LCD_Y*2);
	}
	if(FrameBuffer16==NULL)GBEmu.MessageBox("error", NULL, MB_ICONSTOP);
*/
	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X*2;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y*2;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 16;

	hDC = ::GetDC(m_hWnd);

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
	
	::ReleaseDC(m_hWnd, hDC);
	
	if(1>=iZoom)OnZoom2();
}

void CGBEmuDlg::OnDmaDump() 
{
	if(!fDmaDlg){
		if(m_pDmaDlg==NULL){
			m_pDmaDlg = new CDmaDlg;
			m_pDmaDlg->Create(IDD_DMA_DIALOG);
		}
		m_pDmaDlg->ShowWindow(SW_SHOW);
		fDmaDlg = true;
	}else{
		m_pDmaDlg->SetFocus();
	}
	
	m_pDmaDlg->ShowDma();

/*	CDmaDlg DmaDlg;
	DmaDlg.DoModal();*/
}

void CGBEmuDlg::OnHeaderInfo() 
{
	char str[512];

	ShowHeaderInfo(ROM[0], str);
	MessageBox(str, "Header info", 0);
}

void CGBEmuDlg::OnLoad() 
{
	OpenSaveFile();
}

void CGBEmuDlg::OnSave() 
{
	CloseSaveFile();
}

void CGBEmuDlg::OnAutoSave()
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(IDM_AUTO_SAVE, MF_CHECKED)){
		GetMenu()->CheckMenuItem(IDM_AUTO_SAVE, MF_UNCHECKED);
		fAutoSave = false;
	}else{
		fAutoSave = true;
	}
}

void CGBEmuDlg::OnAutoLoad() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(IDM_AUTO_LOAD, MF_CHECKED)){
		GetMenu()->CheckMenuItem(IDM_AUTO_LOAD, MF_UNCHECKED);
		fAutoLoad = false;
	}else{
		fAutoLoad = true;
	}
}

void CGBEmuDlg::OnModeAuto()
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(IDM_MODE_AUTO, MF_CHECKED)){
		GetMenu()->CheckMenuItem(IDM_MODE_AUTO, MF_UNCHECKED);
		gb_mode=0;
	}else{
		gb_mode=1;
	}
}

void CGBEmuDlg::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{

	CDialog::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CGBEmuDlg::InitializeKeyCode()
{
	KeyCodeA = 'Z';
	KeyCodeB = 'X';
	KeyCodeStart = VK_RETURN;
	KeyCodeSelect = ' ';
	KeyCodeUp = VK_UP;
	KeyCodeDown = VK_DOWN;
	KeyCodeLeft = VK_LEFT;
	KeyCodeRight = VK_RIGHT;
}

void CGBEmuDlg::OnModeColor() 
{
	fcgb_mode=1;
}

void CGBEmuDlg::OnClassic() 
{
	fcgb_mode=0;
}
