// KeyDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "gbemu.h"
#include "KeyDlg.h"
#include "../include/hextoint.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern bool fKeyDlg;
UINT	KeyNum;

extern BYTE	KeyCodeA, KeyCodeB, KeyCodeStart, KeyCodeSelect;
extern BYTE	KeyCodeUp, KeyCodeDown, KeyCodeLeft, KeyCodeRight;

/////////////////////////////////////////////////////////////////////////////
// CKeyDlg _CAO

CKeyDlg::CKeyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CKeyDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CKeyDlg)
	m_KeyA = _T("");
	m_KeyB = _T("");
	m_KeyD = _T("");
	m_KeyE = _T("");
	m_KeyL = _T("");
	m_KeyR = _T("");
	m_KeyS = _T("");
	m_KeyU = _T("");
	//}}AFX_DATA_INIT
}


void CKeyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CKeyDlg)
	DDX_Text(pDX, IDC_KEY_A, m_KeyA);
	DDV_MaxChars(pDX, m_KeyA, 2);
	DDX_Text(pDX, IDC_KEY_B, m_KeyB);
	DDV_MaxChars(pDX, m_KeyB, 2);
	DDX_Text(pDX, IDC_KEY_D, m_KeyD);
	DDV_MaxChars(pDX, m_KeyD, 2);
	DDX_Text(pDX, IDC_KEY_E, m_KeyE);
	DDV_MaxChars(pDX, m_KeyE, 2);
	DDX_Text(pDX, IDC_KEY_L, m_KeyL);
	DDV_MaxChars(pDX, m_KeyL, 2);
	DDX_Text(pDX, IDC_KEY_R, m_KeyR);
	DDV_MaxChars(pDX, m_KeyR, 2);
	DDX_Text(pDX, IDC_KEY_S, m_KeyS);
	DDV_MaxChars(pDX, m_KeyS, 2);
	DDX_Text(pDX, IDC_KEY_U, m_KeyU);
	DDV_MaxChars(pDX, m_KeyU, 2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CKeyDlg, CDialog)
	//{{AFX_MSG_MAP(CKeyDlg)
	ON_WM_CLOSE()
	ON_EN_UPDATE(IDC_KEY_A, OnUpdateKeyA)
	ON_EN_SETFOCUS(IDC_KEY_A, OnSetfocusKeyA)
	ON_EN_SETFOCUS(IDC_KEY_B, OnSetfocusKeyB)
	ON_EN_SETFOCUS(IDC_KEY_S, OnSetfocusKeyS)
	ON_EN_SETFOCUS(IDC_KEY_E, OnSetfocusKeyE)
	ON_EN_SETFOCUS(IDC_KEY_U, OnSetfocusKeyU)
	ON_EN_SETFOCUS(IDC_KEY_D, OnSetfocusKeyD)
	ON_EN_SETFOCUS(IDC_KEY_L, OnSetfocusKeyL)
	ON_EN_SETFOCUS(IDC_KEY_R, OnSetfocusKeyR)
	ON_BN_CLICKED(ID_CMD_OK, OnCmdOk)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CKeyDlg bZ[W nh

void CKeyDlg::OnOK()
{
	fKeyDlg=FALSE;
	OnClose();
}

void CKeyDlg::OnCancel()
{
	fKeyDlg=FALSE;
	EndDialog(0);
}

void CKeyDlg::OnClose() 
{
	fKeyDlg=false;
	CDialog::OnClose();
}

BOOL CKeyDlg::PreTranslateMessage(MSG* pMsg) 
{
	char str[5];

	if(pMsg->message==WM_KEYDOWN){
		switch(pMsg->wParam){
		case VK_ESCAPE:
			return false;
		}
		switch(KeyNum){
		case 1:
			sprintf(str, "%02X", pMsg->wParam);
			UpdateData(true);
			m_KeyA=str;
			UpdateData(false);
			KeyNum=0;
			GetDlgItem(IDC_KEY_B)->SetFocus();
			break;
		case 2:
			sprintf(str, "%02X", pMsg->wParam);
			UpdateData(true);
			m_KeyB=str;
			UpdateData(false);
			KeyNum=0;
			GetDlgItem(IDC_KEY_S)->SetFocus();
			break;
		case 3:
			sprintf(str, "%02X", pMsg->wParam);
			UpdateData(true);
			m_KeyS=str;
			UpdateData(false);
			KeyNum=0;
			GetDlgItem(IDC_KEY_E)->SetFocus();
			break;
		case 4:
			sprintf(str, "%02X", pMsg->wParam);
			UpdateData(true);
			m_KeyE=str;
			UpdateData(false);
			KeyNum=0;
			GetDlgItem(IDC_KEY_U)->SetFocus();
			break;
		case 5:
			sprintf(str, "%02X", pMsg->wParam);
			UpdateData(true);
			m_KeyU=str;
			UpdateData(false);
			KeyNum=0;
			GetDlgItem(IDC_KEY_D)->SetFocus();
			break;
		case 6:
			sprintf(str, "%02X", pMsg->wParam);
			UpdateData(true);
			m_KeyD=str;
			UpdateData(false);
			KeyNum=0;
			GetDlgItem(IDC_KEY_L)->SetFocus();
			break;
		case 7:
			sprintf(str, "%02X", pMsg->wParam);
			UpdateData(true);
			m_KeyL=str;
			UpdateData(false);
			KeyNum=0;
			GetDlgItem(IDC_KEY_R)->SetFocus();
			break;
		case 8:
			sprintf(str, "%02X", pMsg->wParam);
			UpdateData(true);
			m_KeyR=str;
			UpdateData(false);
			KeyNum=0;
			GetDlgItem(ID_CMD_OK)->SetFocus();
			break;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CKeyDlg::OnUpdateKeyA() 
{
}

BOOL CKeyDlg::OnInitDialog() 
{
	char str[5];

	CDialog::OnInitDialog();
	
	UpdateData(TRUE);
	sprintf(str, "%02X", KeyCodeA);
	m_KeyA = str;
	sprintf(str, "%02X", KeyCodeB);
	m_KeyB = str;
	sprintf(str, "%02X", KeyCodeDown);
	m_KeyD = str;
	sprintf(str, "%02X", KeyCodeSelect);
	m_KeyE = str;
	sprintf(str, "%02X", KeyCodeLeft);
	m_KeyL = str;
	sprintf(str, "%02X", KeyCodeRight);
	m_KeyR = str;
	sprintf(str, "%02X", KeyCodeStart);
	m_KeyS = str;
	sprintf(str, "%02X", KeyCodeUp);
	m_KeyU = str;
	UpdateData(FALSE);

	KeyNum=0;

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CKeyDlg::OnSetfocusKeyA() 
{
	KeyNum=1;
}

void CKeyDlg::OnSetfocusKeyB() 
{
	KeyNum=2;
}

void CKeyDlg::OnSetfocusKeyS() 
{
	KeyNum=3;
}

void CKeyDlg::OnSetfocusKeyE() 
{
	KeyNum=4;
}

void CKeyDlg::OnSetfocusKeyU() 
{
	KeyNum=5;
}

void CKeyDlg::OnSetfocusKeyD() 
{
	KeyNum=6;
}

void CKeyDlg::OnSetfocusKeyL() 
{
	KeyNum=7;
}

void CKeyDlg::OnSetfocusKeyR() 
{
	KeyNum=8;
}

void CKeyDlg::OnCmdOk() 
{
	UpdateData(TRUE);
	KeyCodeA = HexToInt(m_KeyA.GetBuffer(3));
	m_KeyA.ReleaseBuffer();
	KeyCodeB = HexToInt(m_KeyB.GetBuffer(3));
	m_KeyB.ReleaseBuffer();
	KeyCodeDown = HexToInt(m_KeyD.GetBuffer(3));
	m_KeyD.ReleaseBuffer();
	KeyCodeSelect = HexToInt(m_KeyE.GetBuffer(3));
	m_KeyE.ReleaseBuffer();
	KeyCodeLeft = HexToInt(m_KeyL.GetBuffer(3));
	m_KeyL.ReleaseBuffer();
	KeyCodeRight = HexToInt(m_KeyR.GetBuffer(3));
	m_KeyR.ReleaseBuffer();
	KeyCodeStart = HexToInt(m_KeyS.GetBuffer(3));
	m_KeyS.ReleaseBuffer();
	KeyCodeUp = HexToInt(m_KeyU.GetBuffer(3));
	m_KeyU.ReleaseBuffer();
	UpdateData(FALSE);

	fKeyDlg=FALSE;
	EndDialog(0);
}
