// TilesDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBEmu.h"
#include "TilesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define	_ASM_

#define R_BGP	0xFF47
extern DWORD dwSize;
LPBITMAPINFO tiles_info = (LPBITMAPINFO)new char[dwSize];
LPBITMAPINFO tile_info = (LPBITMAPINFO)new char[dwSize];

int t_num=0;
CDC* pTDC;						// rfIr[p̃foCXReLXg
extern bool fTileDlg, fObjDlg;
extern BYTE Rmem(WORD);
extern BYTE MEM[0x10000];
extern BYTE Colours[4];

/////////////////////////////////////////////////////////////////////////////
// CTilesDlg _CAO


CTilesDlg::CTilesDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTilesDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTilesDlg)
	m_txtTileAdr = _T("");
	m_txtTileNo = _T("");
	//}}AFX_DATA_INIT
}


void CTilesDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTilesDlg)
	DDX_Text(pDX, IDC_TILE_ADDRESS, m_txtTileAdr);
	DDX_Text(pDX, IDC_TILE_NO, m_txtTileNo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTilesDlg, CDialog)
	//{{AFX_MSG_MAP(CTilesDlg)
	ON_WM_PAINT()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTilesDlg bZ[W nh

BOOL CTilesDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// LCDpɉʂ̃foCXReLXg擾
	pTDC = this->GetDC();

	RECT	DlgSize;
	SetRect(&DlgSize, 0, 0,380, 135);
	AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left,
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_GROUP_STATUS), 0, 235, 5, 140, 95, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_GROUP_BGP), 0, 235, 105, 140, 45, SWP_NOACTIVATE|SWP_NOZORDER);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_STATIC_ADDRESS), 0, 320, 55, 45, 15, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_TILE_ADDRESS), 0, 320, 70, 45, 15, SWP_NOACTIVATE|SWP_NOZORDER);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_STATIC_NO), 0, 320, 20, 45, 15, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_TILE_NO), 0, 320, 35, 45, 15, SWP_NOACTIVATE|SWP_NOZORDER);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CTilesDlg::OnPaint()
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	ShowTiles();
}

void CTilesDlg::OnClose() 
{	// tO߂ă_CAO
	fTileDlg=false;	
	CDialog::OnClose();
}

void CTilesDlg::ShowTiles()
{
	unsigned int tdpy, tmpx, tmpy;
	unsigned char tdd, tds;
	unsigned short tda=0x8000;
	unsigned char TilesBuffer[216*144];
	unsigned int fba;
	COLORREF SysBGPalette, rectcolor;

	for(tmpy=0; tmpy<144; tmpy++){
		for(tmpx=0; tmpx<216; tmpx++){
			TilesBuffer[tmpx+tmpy*216]=4;
		}
	}

	for(tmpy=0; tmpy<144; tmpy+=9){		// }bvf[^
		for(tmpx=0; tmpx<216; tmpx+=9){
			for(tdpy=0; tdpy<8; tdpy++){	// ^Cf[^
				tdd = MEM[tda++];		// 1oCgڂ̃^Cf[^
				tds = MEM[tda++];	// 2oCgڂ̃^Cf[^
				fba=tdpy*216+tmpx+tmpy*216;
#ifdef	_ASM_
				__asm{
					mov		dl, 80h
					mov		eax, fba
					lea		edi, [TilesBuffer+eax]
bg_start_loop:
					mov		al, tdd		; tdd&tds&tilebit
					mov		cl, tds
					and		al, cl
					and		al, dl
					cmp		al, dl
					jnz		bg_palette0
					mov		cl, 3
					mov		[edi], cl
					jmp		bg_palette3
bg_palette0:
					mov		al, tdd		; ~tdd&tds&tilebit
					mov		cl, tds
					not		al
					and		al, cl
					and		al, dl
					cmp		al, dl
					jnz		bg_palette1
					mov		cl, 2
					mov		[edi], cl
					jmp		bg_palette3
bg_palette1:
					mov		al, tdd		; tdd&~tds&tilebit, 
					mov		cl, tds
					not		cl
					and		al, cl
					and		al, dl
					cmp		al, dl
					jnz		bg_palette2
					mov		cl, 1
					mov		[edi], cl
					jmp		bg_palette3
bg_palette2:
					mov		al, tdd		; ~tdd&~tds&tilebit
					mov		cl, tds
					and		al, cl
					and		al, dl
					cmp		al, dl
					jz		bg_palette3
					xor		ecx, ecx
					mov		[edi], cl
bg_palette3:
					inc		edi
					shr		dl, 1
					jnz		bg_start_loop
				}
#else
				unsigned char *tbuf=&TilesBuffer[fba];
				for(unsigned char tilebit=0x80; tilebit; tilebit>>=1, tbuf++){
					if(~tdd&~tds&tilebit)*tbuf=0;
					if(tdd&~tds&tilebit)*tbuf=1;
					if(~tdd&tds&tilebit)*tbuf=2;
					if(tdd&tds&tilebit)*tbuf=3;
				}
#endif	/*_ASM_*/
			}
		}
	}

	memset(tiles_info, 0, sizeof(BITMAPINFOHEADER));
	tiles_info->bmiHeader.biSize	= sizeof(BITMAPINFOHEADER);
	tiles_info->bmiHeader.biWidth	= 216;
	tiles_info->bmiHeader.biHeight	= -144;
	tiles_info->bmiHeader.biPlanes	= 1;
	tiles_info->bmiHeader.biBitCount= 8;

	// BGPWX^pbgϊ
	tiles_info->bmiColors[0].rgbBlue =
	tiles_info->bmiColors[0].rgbGreen =
	tiles_info->bmiColors[0].rgbRed = Colours[0];
	tiles_info->bmiColors[0].rgbReserved = 0;
	tiles_info->bmiColors[1].rgbBlue =
	tiles_info->bmiColors[1].rgbGreen =
	tiles_info->bmiColors[1].rgbRed = Colours[1];
	tiles_info->bmiColors[1].rgbReserved = 0;
	tiles_info->bmiColors[2].rgbBlue =
	tiles_info->bmiColors[2].rgbGreen =
	tiles_info->bmiColors[2].rgbRed = Colours[2];
	tiles_info->bmiColors[2].rgbReserved = 0;
	tiles_info->bmiColors[3].rgbBlue =
	tiles_info->bmiColors[3].rgbGreen =
	tiles_info->bmiColors[3].rgbRed = Colours[3];;
	tiles_info->bmiColors[3].rgbReserved = 0;
	SysBGPalette=GetSysColor(COLOR_3DLIGHT);
	tiles_info->bmiColors[4].rgbBlue = (unsigned char)(SysBGPalette>>16);
	tiles_info->bmiColors[4].rgbGreen = (unsigned char)(SysBGPalette>>8);
	tiles_info->bmiColors[4].rgbRed = (unsigned char)(SysBGPalette);
	tiles_info->bmiColors[4].rgbReserved = 0;
	HDC	hMemDC	= ::CreateCompatibleDC(pTDC->m_hDC);
	HBITMAP	hBitmap	= ::CreateDIBitmap(pTDC->m_hDC, &tiles_info->bmiHeader, CBM_INIT, TilesBuffer, tiles_info, DIB_RGB_COLORS);
	HBITMAP	hOldmap	= (HBITMAP)::SelectObject(hMemDC, hBitmap);

	rectcolor=RGB(Colours[MEM[R_BGP]&0x03], Colours[MEM[R_BGP]&0x03], Colours[MEM[R_BGP]&0x03]);
	pTDC->FillSolidRect(250, 120, 20, 20, rectcolor);
	pTDC->SetTextColor(~rectcolor);
	pTDC->TextOut(256, 120, "0");
	rectcolor=RGB(Colours[(MEM[R_BGP]>>2)&0x03], Colours[(MEM[R_BGP]>>2)&0x03], Colours[(MEM[R_BGP]>>2)&0x03]);
	pTDC->FillSolidRect(280, 120, 20, 20, rectcolor);
	pTDC->SetTextColor(~rectcolor);
	pTDC->TextOut(286, 120, "1");
	rectcolor=RGB(Colours[(MEM[R_BGP]>>4)&0x03], Colours[(MEM[R_BGP]>>4)&0x03], Colours[(MEM[R_BGP]>>4)&0x03]);
	pTDC->FillSolidRect(310, 120, 20, 20, rectcolor);
	pTDC->SetTextColor(~rectcolor);
	pTDC->TextOut(316, 120, "2");
	rectcolor=RGB(Colours[(MEM[R_BGP]>>6)&0x03], Colours[(MEM[R_BGP]>>6)&0x03], Colours[(MEM[R_BGP]>>6)&0x03]);
	pTDC->FillSolidRect(340, 120, 20, 20, rectcolor);
	pTDC->SetTextColor(~rectcolor);
	pTDC->TextOut(346, 120, "3");

	::BitBlt(pTDC->m_hDC, 5, 5, 215, 143, hMemDC, 0, 0, SRCCOPY);
	::DeleteObject(hBitmap);

	CBrush cbrush;
	RECT setrect;

	int tx1, ty1;
	int tx, ty;

	tx1=t_num;
	ty1=0;
	while(tx1>=24){
		tx1-=24;
		ty1++;
	}
	if(t_num>=384)ty1=200;	/*384ȏ̏ꍇ͈͂܂Ȃ*/

	tx=4+9*tx1;
	ty=4+9*ty1;

	cbrush.CreateSolidBrush(SysBGPalette);	/*Ot[̍폜*/
	SetRect(&setrect, 4, 4, 221, 149);
	pTDC->FrameRect(&setrect, &cbrush);
	cbrush.DeleteObject();

	cbrush.CreateSolidBrush(RGB(255, 0, 0));	/*^C̑I*/
	SetRect(&setrect, tx, ty, 10+tx, 10+ty);
	pTDC->FrameRect(&setrect, &cbrush);
	cbrush.DeleteObject();

	ShowTileObj();
}


void CTilesDlg::ShowTileObj()
{
	unsigned int tdpy;
	unsigned char tdd, tds;
	unsigned short tda=0x8000;
	unsigned char TileBuffer[8*8];
	unsigned int fba;

	tda=0x8000+(0x10*t_num);
	UpdateData(true);
	m_txtTileAdr.Format("%Xh", tda);
	m_txtTileNo.Format("%d/384", t_num);
	UpdateData(false);
	for(tdpy=0; tdpy<8; tdpy++){	// ^Cf[^
		tdd = MEM[tda++];		// 1oCgڂ̃^Cf[^
		tds = MEM[tda++];	// 2oCgڂ̃^Cf[^
		fba=tdpy*8;
#ifdef	_ASM_
		__asm{
			mov		dl, 80h
			mov		eax, fba
			lea		edi, [TileBuffer+eax]
bg_start_loop:
			mov		al, tdd		; tdd&tds&tilebit
			mov		cl, tds
			and		al, cl
			and		al, dl
			cmp		al, dl
			jnz		bg_palette0
			mov		cl, 3
			mov		[edi], cl
			jmp		bg_palette3
bg_palette0:
			mov		al, tdd		; ~tdd&tds&tilebit
			mov		cl, tds
			not		al
			and		al, cl
			and		al, dl
			cmp		al, dl
			jnz		bg_palette1
			mov		cl, 2
			mov		[edi], cl
			jmp		bg_palette3
bg_palette1:
			mov		al, tdd		; tdd&~tds&tilebit, 
			mov		cl, tds
			not		cl
			and		al, cl
			and		al, dl
			cmp		al, dl
			jnz		bg_palette2
			mov		cl, 1
			mov		[edi], cl
			jmp		bg_palette3
bg_palette2:
			mov		al, tdd		; ~tdd&~tds&tilebit
			mov		cl, tds
			and		al, cl
			and		al, dl
			cmp		al, dl
			jz		bg_palette3
			xor		ecx, ecx
			mov		[edi], cl
bg_palette3:
			inc		edi
			shr		dl, 1
			jnz		bg_start_loop
		}
#else
		unsigned char *tbuf=&TileBuffer[fba];
		for(unsigned char tilebit=0x80; tilebit; tilebit>>=1, tbuf++){
			if(~tdd&~tds&tilebit)*tbuf=0;
			if(tdd&~tds&tilebit)*tbuf=1;
			if(~tdd&tds&tilebit)*tbuf=2;
			if(tdd&tds&tilebit)*tbuf=3;
		}
#endif	/*_ASM_*/
	}

	memset(tile_info, 0, sizeof(BITMAPINFOHEADER));
	tile_info->bmiHeader.biSize	= sizeof(BITMAPINFOHEADER);
	tile_info->bmiHeader.biWidth	= 8;
	tile_info->bmiHeader.biHeight	= -8;
	tile_info->bmiHeader.biPlanes	= 1;
	tile_info->bmiHeader.biBitCount	= 8;

	// BGPWX^pbgϊ
	tile_info->bmiColors[0].rgbBlue =
	tile_info->bmiColors[0].rgbGreen =
	tile_info->bmiColors[0].rgbRed = Colours[(MEM[R_BGP]&0x03)];;
	tile_info->bmiColors[0].rgbReserved = 0;
	tile_info->bmiColors[1].rgbBlue =
	tile_info->bmiColors[1].rgbGreen =
	tile_info->bmiColors[1].rgbRed = Colours[(MEM[R_BGP]>>2&0x03)];;
	tile_info->bmiColors[1].rgbReserved = 0;
	tile_info->bmiColors[2].rgbBlue =
	tile_info->bmiColors[2].rgbGreen =
	tile_info->bmiColors[2].rgbRed = Colours[(MEM[R_BGP]>>4&0x03)];;
	tile_info->bmiColors[2].rgbReserved = 0;
	tile_info->bmiColors[3].rgbBlue =
	tile_info->bmiColors[3].rgbGreen =
	tile_info->bmiColors[3].rgbRed = Colours[(MEM[R_BGP]>>6&0x03)];;
	tile_info->bmiColors[3].rgbReserved = 0;

	HDC	hMemDC	= ::CreateCompatibleDC(pTDC->m_hDC);
	HBITMAP	hBitmap	= ::CreateDIBitmap(pTDC->m_hDC, &tile_info->bmiHeader, CBM_INIT, TileBuffer, tile_info, DIB_RGB_COLORS);
	HBITMAP	hOldmap	= (HBITMAP)::SelectObject(hMemDC, hBitmap);
	::StretchBlt(pTDC->m_hDC, 245, 20, 70, 70, hMemDC, 0, 0, 8, 8, SRCCOPY);
	::DeleteObject(hBitmap);
}


BOOL CTilesDlg::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message==WM_KEYDOWN){
		switch(pMsg->wParam){
		case VK_ESCAPE:
			return false;
		case VK_RIGHT:
			if(t_num>=383){
				t_num=0;
				ShowTiles();
			}else{
				t_num++;
				ShowTiles();
			}
			break;
		case VK_LEFT:
			if(t_num==0){
				t_num=383;
				ShowTiles();
			}else{
				t_num--;
				ShowTiles();
			}
			break;
		case VK_DOWN:
			if(t_num>=360){
				t_num-=360;
				ShowTiles();
			}else{
				t_num+=24;
				ShowTiles();
			}
			break;
		case VK_UP:
			if(t_num<24){
				t_num+=360;
				ShowTiles();
			}else{
				t_num-=24;
				ShowTiles();
			}
			break;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CTilesDlg::OnOK()
{

}

void CTilesDlg::OnCancel()
{
	EndDialog(0);
}
