// ChildView.cpp : implementation of the CChildView class
//

#include "stdafx.h"
#include "GBEmu.h"
#include "ChildView.h"

#define	__GAPI__

#ifdef	__GAPI__

#ifdef	ARM
#include <gx.h>
#pragma	comment(lib, "../lib/ARM/gx.lib")
GXDisplayProperties gxdp;
#endif	/*ARM*/
#ifdef	MIPS
#include <gx.h>
#pragma	comment(lib, "../lib/MIPS/gx.lib")
#endif	/*MIPS*/
#ifdef	SHx
#include <gx.h>
#pragma	comment(lib, "../lib/SH/gx.lib")
#endif	/*SHx*/

#endif	/*__GAPI__*/

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define	_WINCE_GDI
#define	_WIN_CMN

CChildView ChildView;
static void CPU();					// CPUG~[V
void InitializeMemory();			// IOWX^̏
void InitializeRegister();			// CPUWX^̏
void InitializeVideo(HDC hDC);		// obNobt@̏
void InitializeVideo16(HDC hDC);
void DrawLine();					// LYWX^̃C쐬
void Interrupt();
void EndInterrupt();
int CloseGBMemory(unsigned char* pRom);
int OpenRomhFile(CString filename);

#include "../include/defines.h"
#include "../include/globals.h"
#include "../include/info.h"
#include "../gbcore/memory.c"
//#include "../gbcore/rom.c"
#include "../gbcore/cpu_cb.c"
#include "../gbcore/cpu.c"
#include "../gbcore/video.c"
#include "../gbcore/mainloop.c"

BOOL fKeyDlg;
int Zoom;
int lcd_posx, lcd_posy;


/////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView::CChildView()
{
	hDC = ::GetDC(m_hWnd);
	//InitializeVideo(hDC);
	InitializeVideo16(hDC);
	::ReleaseDC(m_hWnd, hDC);

#ifdef	GXDLL_API
	if(!GXOpenDisplay(m_hWnd, GX_FULLSCREEN)){
		MessageBox(_T("GAPI open error."), NULL, MB_OK);
	}
#endif	/*GXDLL_API*/

/*	if(AfxGetApp()->m_lpCmdLine[0]){
		if(OpenRomhFile(AfxGetApp()->m_lpCmdLine)){
			AfxMessageBox(_T("memory allocation error."), NULL, MB_ICONQUESTION);
		}else{
			OnReset();
		}
	}*/

	m_pTMain = NULL;
	f16Dib = 1;
	Zoom = 0;
}

CChildView::~CChildView()
{
}


BEGIN_MESSAGE_MAP(CChildView,CWnd )
	//{{AFX_MSG_MAP(CChildView)
	ON_WM_PAINT()
	ON_COMMAND(IDM_OPEN, OnOpen)
	ON_COMMAND(IDM_RESET, OnReset)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildView message handlers

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		NULL, HBRUSH(COLOR_WINDOW+1), NULL);

	return TRUE;
}

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
		
	DrawLCD();
}

UINT CChildView::ThreadMain(LPVOID pParam)
{
	((CChildView*)pParam)->MainLoop();

	return 0;
}

int CloseGBMemory(unsigned char* pRom)
{	/*GB̉*/
	u8 s_rom/*, s_ram*/;
	u32 i;

	if(ROM[0]==NULL)return 0;
	s_rom=rom_size[(ROM[0][0x148])];

	for(i=0; i<s_rom; i++){
		free(ROM[i]);
		ROM[i]=NULL;
	}

	return 0;
}

int OpenRomhFile(CString filename)
{	/*t@C̓ǂݍ݂ƃ̊m*/
	HANDLE hfile;
	DWORD dwByte;
	u8 s_rom;
	u32 i;
	u8	Header[0x151];

	hfile = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, 
			NULL, OPEN_EXISTING, FILE_ATTRIBUTE_READONLY, NULL);
	ReadFile(hfile, Header, 0x150, &dwByte, NULL);
	s_rom = rom_size[(Header[0x148])];	/*ROM̃TCY擾*/
	CloseHandle(hfile);

	hfile = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, 
			NULL, OPEN_EXISTING, FILE_ATTRIBUTE_READONLY, NULL);

	CloseGBMemory(ROM[0]);

	/*ROMTCY̕m*/
	for(i=0; i<s_rom; i++){
		ROM[i] = (u8*)malloc(BANK_SIZE);
		if(ROM[i]==NULL)return 1;
		ReadFile(hfile, &ROM[i][0], BANK_SIZE, &dwByte, NULL);
	}
	CloseHandle(hfile);

	return 0;
}

void InitializeVideo(HDC hDC)
{	/*rbg}bv*/

	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 8;

	for(int i=0; i<16; i++){
		bmp_info.bmiColors[i].rgbRed = 
		bmp_info.bmiColors[i].rgbGreen = 
		bmp_info.bmiColors[i].rgbBlue = Colours[i&3];
		bmp_info.bmiColors[i].rgbReserved = 0;
	}

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
}

void InitializeVideo16(HDC hDC)
{	/*rbg}bv*/
	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 16;

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
}

void CChildView::DrawLCD()
{ // LCDʂ̃G~[Vƕ\

	
#ifdef	GXDLL_API
	byte *pGapi;

	pGapi = (byte*)GXBeginDraw();
	memcpy(pGapi, FrameBuffer16, GB_LCD_X * GB_LCD_Y*2);
	GXEndDraw();
#else
	if(f16Dib){
		memcpy(pBitmap, FrameBuffer16, GB_LCD_X * GB_LCD_Y*2);
	}else{
		memcpy(pBitmap, FrameBuffer, GB_LCD_X * GB_LCD_Y);
	}

	hDC = ::GetDC(m_hWnd);
	if(Zoom){
		StretchBlt(hDC, 0, 0, DlgSize.right, DlgSize.bottom, hMemDC, 0, 0, GB_LCD_X, GB_LCD_Y, SRCCOPY);
	}else{
		BitBlt(hDC, lcd_posx, lcd_posy, GB_LCD_X, GB_LCD_Y, hMemDC, 0, 0, SRCCOPY);
	}
	::ReleaseDC(m_hWnd, hDC);
#endif	/*GXDLL_API*/
}

void CChildView::OnOpen() 
{
	OPENFILENAME ofn;
	CString filename;

	memset(&ofn, 0, sizeof(ofn));
	ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrFile = filename.GetBuffer(512);
	ofn.lpstrFilter = _T("Gameboy ROM Files (*.gb;*.bin;*.gbc)\0*.gb;*.bin;*.gbc\0All Files (*.*)\0*.*\0\0\0");
	ofn.nMaxFileTitle = 512;
	ofn.nMaxFile = 512;
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = ChildView.m_hWnd;

	if(GetOpenFileName(&ofn)){
		if(OpenRomhFile(filename)){
			AfxMessageBox(_T("memory allocation error."), NULL, MB_ICONQUESTION);
		}else{
			OnReset();
		}
	}	
}

void CChildView::OnReset() 
{
	BYTE fUnSupport;
	BYTE cart_type;

	CPUIsRunning = 0;
	Sleep(300);

	if(ROM[0]){
		cart_type=ROM[0][0x0148];
		switch(cart_type){
		case 0x00:	/*ROM only*/
		case 0x01:	/*MBC1*/
		case 0x02:
		case 0x03:
					case 0x04:
		case 0x05:	/*MBC2*/
		case 0x06:
		case 0x08:	/*RON+RAM*/
		case 0x09:
		case 0x0B:	/*MMM01*/
		case 0x0C:
		case 0x0D:
		case 0x0F:	/*MBC3*/
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x19:	/*MBC5*/
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
			fUnSupport=0;
			break;
		default:
			fUnSupport=1;
			break;
		}
		if(fUnSupport){
			wchar_t str[50];
			swprintf(str, _T("Unsuppurted%x"), cart_type);
			AfxMessageBox(str, NULL, MB_ICONQUESTION);
			return;
		}
		InitializeMemory();
		InitializeRegister();
		m_pTMain = AfxBeginThread((AFX_THREADPROC)ThreadMain, this);
	}
}

void CChildView::ShowFps()
{	/*t[b\*/
/*	wchar_t str[30];
	static DWORD FpsTime;

	if(FpsTime < timeGetTime()){
		FpsTime = timeGetTime() + 1000;
		swprintf(str, _T("GameboyVM - %d%%"), (int)((FrameCount)/59.0*100));
		FrameCount = 0;
		::SetWindowText(m_hWnd, str);
	}*/
}


BOOL CChildView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{

	return CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);
}

BOOL CChildView::PreTranslateMessage(MSG* pMsg) 
{

	return CWnd ::PreTranslateMessage(pMsg);
}

BOOL CChildView::DestroyWindow() 
{
#ifdef	GXDLL_API
	if(!GXCloseDisplay()){
		MessageBox(_T("GAPI close error."), NULL, MB_OK);
	}
#endif	/*GXDLL_API*/
	return CWnd ::DestroyWindow();
}
