// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "GBEmu.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const DWORD dwAdornmentFlags = 0; // exit button

extern BOOL fKeyDlg;
extern BYTE	EnableBG, EnableWND, EnableOBJ;
extern BYTE	KeyCodeA, KeyCodeB, KeyCodeStart, KeyCodeSelect;
extern BYTE	KeyCodeUp, KeyCodeDown, KeyCodeLeft, KeyCodeRight;
extern BYTE	keyflag, keyint;
extern BYTE	fVsync, fFps;
extern RECT DlgSize;
extern int Zoom, f16Dib, lcd_posx, lcd_posy;
#define GB_LCD_X		160
#define GB_LCD_Y		144


/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_WM_CLOSE()
	ON_COMMAND(IDM_VSYNC, OnVsync)
	ON_COMMAND(IDM_CONTROL, OnControl)
	ON_COMMAND(IDM_ZOOM_FULL, OnZoomFull)
	ON_COMMAND(IDM_ZOOM_1, OnZoom1)
	ON_WM_SHOWWINDOW()
	ON_COMMAND(IDM_SHOW_FPS, OnShowFps)
	ON_COMMAND(IDM_LAYER_BG, OnLayerBg)
	ON_COMMAND(IDM_LAYER_WND, OnLayerWnd)
	ON_COMMAND(IDM_LAYER_OBJ, OnLayerObj)
	ON_COMMAND(IDM_DIB_MODE16, OnDibMode16)
	ON_COMMAND(IDM_DIB_MODE8, OnDibMode8)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	CWinApp* pApp = AfxGetApp();	//ݒۑ
	KeyCodeA	=	pApp->GetProfileInt(_T("Control"), _T("KeyCodeA"), 'Z');
	KeyCodeB	=	pApp->GetProfileInt(_T("Control"), _T("KeyCodeB"), 'X');
	KeyCodeStart=	pApp->GetProfileInt(_T("Control"), _T("KeyCodeStart"), VK_RETURN);
	KeyCodeSelect=	pApp->GetProfileInt(_T("Control"), _T("KeyCodeSelect"), ' ');
	KeyCodeUp	=	pApp->GetProfileInt(_T("Control"), _T("KeyCodeUp"), VK_UP);
	KeyCodeDown	=	pApp->GetProfileInt(_T("Control"), _T("KeyCodeDown"), VK_DOWN);
	KeyCodeLeft	=	pApp->GetProfileInt(_T("Control"), _T("KeyCodeLeft"), VK_LEFT);
	KeyCodeRight=	pApp->GetProfileInt(_T("Control"), _T("KeyCodeRight"), VK_RIGHT);

//	OnVsync();

	m_pKeyDlg = NULL;

}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	// create a view to occupy the client area of the frame
	if (!m_wndView.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
		CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
	{
		TRACE0("Failed to create view window\n");
		return -1;
	}
	
	if(!m_wndCommandBar.Create(this) ||
	   !m_wndCommandBar.InsertMenuBar(IDR_MAINFRAME) ||
	   !m_wndCommandBar.AddAdornments(dwAdornmentFlags))
	{
		TRACE0("Failed to create CommandBar\n");
		return -1;      // fail to create
	}

	m_wndCommandBar.SetBarStyle(m_wndCommandBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_FIXED);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;

	cs.lpszClass = AfxRegisterWndClass(0);
	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
void CMainFrame::OnSetFocus(CWnd* pOldWnd)
{
	// forward focus to the view window
	m_wndView.SetFocus();
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// let the view have first crack at the command
	if (m_wndView.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;

	// otherwise, do default handling
	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

void CMainFrame::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
}


void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	CFrameWnd::OnSize(nType, cx, cy);

	GetClientRect(&DlgSize);

	lcd_posx = DlgSize.right/2-GB_LCD_X/2;
	lcd_posy = DlgSize.bottom/2-GB_LCD_Y/2;
	if(!KeyCodeA)InitializeKeyCode();
}

void CMainFrame::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{

	CFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CMainFrame::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{

	CFrameWnd::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CMainFrame::OnClose() 
{
	CWinApp* pApp = AfxGetApp();	//ݒۑ
	pApp->WriteProfileString(_T("GameboyVM"), _T("Version"), _T("0.07"));
	pApp->WriteProfileInt(_T("Control"), _T("KeyCodeA"), KeyCodeA);
	pApp->WriteProfileInt(_T("Control"), _T("KeyCodeB"), KeyCodeB);
	pApp->WriteProfileInt(_T("Control"), _T("KeyCodeStart"), KeyCodeStart);
	pApp->WriteProfileInt(_T("Control"), _T("KeyCodeSelect"), KeyCodeSelect);
	pApp->WriteProfileInt(_T("Control"), _T("KeyCodeUp"), KeyCodeUp);
	pApp->WriteProfileInt(_T("Control"), _T("KeyCodeDown"), KeyCodeDown);
	pApp->WriteProfileInt(_T("Control"), _T("KeyCodeLeft"), KeyCodeLeft);
	pApp->WriteProfileInt(_T("Control"), _T("KeyCodeRight"), KeyCodeRight);

	CFrameWnd::OnClose();
}

BOOL CMainFrame::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message==WM_KEYDOWN){
		if((BYTE)pMsg->wParam==KeyCodeA){
			keyflag&=~0x10;
			keyint=1;
		}
		if((BYTE)pMsg->wParam==KeyCodeB){
			keyflag&=~0x20;
			keyint=1;
		}
		if((BYTE)pMsg->wParam==KeyCodeStart){
			keyflag&=~0x80;
			keyint=1;
		}
		if((BYTE)pMsg->wParam==KeyCodeSelect){
			keyflag&=~0x40;
			keyint=1;
		}
		if((BYTE)pMsg->wParam==KeyCodeUp){
			keyflag&=~0x04;
			keyint=1;
		}
		if((BYTE)pMsg->wParam==KeyCodeDown){
			keyflag&=~0x08;
			keyint=1;
		}
		if((BYTE)pMsg->wParam==KeyCodeLeft){
			keyflag&=~0x02;
			keyint=1;
		}
		if((BYTE)pMsg->wParam==KeyCodeRight){
			keyflag&=~0x01;
			keyint=1;
		}
		if((BYTE)pMsg->wParam==VK_ESCAPE){
			DestroyWindow();
		}
	}

	if(pMsg->message==WM_KEYUP){
		if((BYTE)pMsg->wParam==KeyCodeA){
			keyflag|=0x10;
			keyint=2;
		}
		if((BYTE)pMsg->wParam==KeyCodeB){
			keyflag|=0x20;
			keyint=2;
		}
		if((BYTE)pMsg->wParam==KeyCodeStart){
			keyflag|=0x80;
			keyint=2;
		}
		if((BYTE)pMsg->wParam==KeyCodeSelect){
			keyflag|=0x40;
			keyint=2;
		}
		if((BYTE)pMsg->wParam==KeyCodeUp){
			keyflag|=0x04;
			keyint=2;
		}
		if((BYTE)pMsg->wParam==KeyCodeDown){
			keyflag|=0x08;
			keyint=2;
		}
		if((BYTE)pMsg->wParam==KeyCodeLeft){
			keyflag|=0x02;
			keyint=2;
		}
		if((BYTE)pMsg->wParam==KeyCodeRight){
			keyflag|=0x01;
			keyint=2;
		}
	}

	return CFrameWnd::PreTranslateMessage(pMsg);
}

void CMainFrame::InitializeKeyCode()
{
	KeyCodeA = 'Z';
	KeyCodeB = 'X';
	KeyCodeStart = 'S';
	KeyCodeSelect = 'A';
	KeyCodeUp = VK_UP;
	KeyCodeDown = VK_DOWN;
	KeyCodeLeft = VK_LEFT;
	KeyCodeRight = VK_RIGHT;
}

void CMainFrame::OnVsync()
{
/*if(MF_CHECKED==GetMenu()->CheckMenuItem(IDM_VSYNC, MF_CHECKED)){
		GetMenu()->CheckMenuItem(IDM_VSYNC, MF_UNCHECKED);*/
	if(fVsync){
		fVsync=0;
	}else{
		fVsync=1;
	}
}

void CMainFrame::OnControl() 
{
	if(!fKeyDlg){
//		if(m_pKeyDlg==NULL){
			m_pKeyDlg = new CKeyDlg;
			m_pKeyDlg->Create(IDD_KEY_DIALOG);
//		}
		m_pKeyDlg->ShowWindow(SW_SHOW);
		fKeyDlg=true;
	}else{
		m_pKeyDlg->SetFocus();
	}
}

void CMainFrame::OnZoomFull() 
{
	Zoom=1;
}

void CMainFrame::OnZoom1() 
{
	Zoom=0;
}

void CMainFrame::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CFrameWnd::OnShowWindow(bShow, nStatus);
	
	SetWindowText(_T("GameboyVM"));
}

void CMainFrame::OnShowFps() 
{
	if(fFps){
		fFps=0;
		SetWindowText(_T("GameboyVM"));
	}else{
		fFps=1;
	}
}

void CMainFrame::OnLayerBg() 
{
	if(EnableBG){
		EnableBG=0;
	}else{
		EnableBG=1;
	}
}

void CMainFrame::OnLayerWnd() 
{
	if(EnableWND){
		EnableWND=0;
	}else{
		EnableWND=1;
	}
}

void CMainFrame::OnLayerObj() 
{
	if(EnableOBJ){
		EnableOBJ=0;
	}else{
		EnableOBJ=1;
	}
}

void CMainFrame::OnDibMode16() 
{
	f16Dib=1;
}

void CMainFrame::OnDibMode8() 
{
	f16Dib=0;
}
