
/*	
	GameboyVM - Nintendo Gameboy Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbemu/
*/



void InitializeRegister()
{ /*CPUWX^̏*/
	AF=0x01B0;
	BC=0x0013;
	DE=0x00D8;
	HL=0x014D;
	SP=0xFFFE;
	PC=START_ADDRESS;
    IME=0;
    HALT=0;
    STOP=0;
	keyflag=0xFF;
	keyint=0;
	mbc=1;
	rambc=0;
	e_rambc=0;
    CPUIsRunning=1;
	irq_type=-1;
	irq_sp=0;
	irq_stack[0]=-1;
	irq_stack[1]=-1;
	irq_stack[2]=-1;
	irq_stack[3]=-1;
	irq_stack[4]=-1;
}

_inline void EndInterrupt()
{
	MEM[R_IF]&=~bit_mask[irq_type];
	if(irq_sp){	/*irq_stack̊荞݂s*/
		irq_type=irq_stack[irq_sp];
		IME=0;
		MEM[R_IF]|=bit_mask[irq_stack[irq_sp]];
		PUSH(PCH,PCL);
		PC=irq_adr[irq_stack[irq_sp]];
		irq_stack[irq_sp]=-1;	/*irq_stack͕ŏ init stack*/
		irq_sp--;
	}else irq_type=-1;
}

_inline void Interrupt(int irq)
{
	int irq_flag;

	if((MEM[R_IE] & bit_mask[irq]) && IME){
		if(irq_type>=0){	/*荞ݒɔ荞݂irq_stackɓ*/
			if(irq==irq_stack[0]||irq==irq_stack[1]||irq==irq_stack[2]||
				irq==irq_stack[3]||irq==irq_stack[4])irq_flag=0;
			else irq_flag=1;
			if(irq_flag){
				irq_stack[irq_sp]=irq;
				irq_sp++;
			}
		}else{
			/*if(HALT){HALT=0;PC++;}*/
			irq_type=irq;
			IME=0;
			MEM[R_IF]|=bit_mask[irq];
			PUSH(PCH,PCL);
			PC=irq_adr[irq];
		}
	}
}

#ifdef	_WIN32
void CGBEmuDlg::MainLoop()
#else
void MainLoop()
#endif	/*_WIN32*/
{
	static int htime=456;		/*70224/154=456clock:1087s*/
	static long ttime=0;
	static u32 r_tac=0;
	static u32 r_div=0;
	static u32 cycle=0;
	static u32 tmppc;
	static u32 irq_flags=0;
	static DWORD WaitTime;	/*^C}[1000/59.73=16.74*/
	static const u32 tac_table[]={4096, 262144, 65536, 16384};
	
	WaitTime = timeGetTime() + 17;

	while(CPUIsRunning){

		MEM[R_STAT]&=~0x07;	/*modetȌ init mode flags*/

		htime-=cycle;
		if(htime<=0){
			htime+=456;	/* h-sync*/
			irq_flags=0;
			if(MEM[R_LCDC]&0x80){
				MEM[R_LY]=(MEM[R_LY]>=154)?0:MEM[R_LY]+1;
				DrawLine();
				if(MEM[R_LY]==0){	/* v-sync*/
					DrawLCD();
					FrameCount++;
#ifdef	_WIN32_GDI
					if(fSound && (MEM[R_NR52]&0x80)){
						PlayGBSound();
					}
					if(fFps)ShowFps();
#endif	/*_WIN32_GDI*/
					while((WaitTime > timeGetTime()) && fVsync){Sleep(1);};	/*ҋ@*/
					WaitTime = timeGetTime() + 17;
				}
			}else{
				MEM[R_STAT]&=~0x04;
				MEM[R_LY]=0;
			}
		}

		if(MEM[R_LCDC]&0x80){	/*LCDғ lcd running*/
			if(MEM[R_LY]>=144){	/*A*/
				MEM[R_STAT]|=0x01;
				if(MEM[R_LY]==144){	/* AJn v-blank*/
					if(!(irq_flags&0x20)){
						irq_flags=0x20;
						Interrupt(IRQ_VBLANK);
					}else if((MEM[R_STAT]&0x10) && !(irq_flags&0x02)){
						irq_flags=0x02;
						Interrupt(IRQ_LCDC);	/*Mode01*/
					}
				}
				if(MEM[R_LY]==MEM[R_LYC])MEM[R_STAT]|=0x04;
			}else if(MEM[R_LY]==MEM[R_LYC]){
				MEM[R_STAT]|=0x04;
				if((MEM[R_STAT]&0x40) && !(irq_flags&0x80)){
					irq_flags=0x80;
					Interrupt(IRQ_LCDC);	/*LY==LYC*/
					if(htime<=204){/*mode00*/}
					else if(htime<=376)MEM[R_STAT]|=0x03;
					else MEM[R_STAT]|=0x02;
				}
			}else if(htime<=204){	/*A h-blank*/
				if((MEM[R_STAT]&0x08) && !(irq_flags&0x04)){
					irq_flags=0x04;
					Interrupt(IRQ_LCDC);	/*mode00*/
				}
			}else if(htime<=376){	/*OAM,VRAMANZX*/
				MEM[R_STAT]|=0x03;	/*mode11*/
			}else{	/*OAMANZX*/
				MEM[R_STAT]|=0x02;
				if((MEM[R_STAT]&0x20) && !(irq_flags&0x10)){
					irq_flags=0x10;
					Interrupt(IRQ_LCDC);	/*Mode10*/
				}
			}
		}

		r_div+=cycle;	/*256NbNłP*/
		if(r_div>=256){
			r_div-=256;
			MEM[R_DIV]++;
		}

		if(MEM[R_TAC]&0x04){  /*TIMA^C}[Jn*/
			r_tac=tac_table[(MEM[R_TAC]&0x03)];	/* ̓NbN̑I*/
			ttime+=cycle;
			if(r_tac-ttime<=0){
				MEM[R_TIMA]++;
				ttime-=r_tac;
				if((u8)(MEM[R_TIMA]+1)==0){
					MEM[R_TIMA]=MEM[R_TMA];
					Interrupt(IRQ_TIMER);
				}
			}
		}

		if(MEM[R_SC]==0x80){	/*f[^]*/
			MEM[R_SC]&=~0x80;
			MEM[R_SB]=0xFF;	/*Ms*/
			/*Interrupt(IRQ_SERIAL);*/
		}

		if(keyint){	/*{^̒e*/
			/*if(keyint==1)Interrupt(IRQ_KEY);*/	/*High-to-Low*/
			keyint=0;
		}

		if(RMem(PC)==0xCB){
			cycle=Cycles_cb[RMem(PC)];
			tmppc=2;
			Cpu_cb();	
		}else{
			cycle=Cycles[RMem(PC)];
			tmppc=PC_table[RMem(PC)];
			Cpu();
		}
		PC+=tmppc;
	}

}

