# -*- coding: ascii -*-
#
#  channeldialog.py - Channel selection dialog for GBottler
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: channeldialog.py,v 1.1 2004/09/19 07:30:51 atzm Exp $
#

import gtk, gobject
from common import open_error_dialog

class ChannelDialog(gtk.Dialog):
	def __init__(self, master, channels):
		self.selection = []
		self.channels  = channels

		gtk.Dialog.__init__(self, unicode(_("Select Channels"), "utf-8"), master,
							gtk.DIALOG_DESTROY_WITH_PARENT|gtk.DIALOG_MODAL|gtk.DIALOG_NO_SEPARATOR,
							(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
							 gtk.STOCK_OK, gtk.RESPONSE_OK))
		self.set_default_size(370, 290)
		self.connect("destroy", self.cancel, "WM destroy")
		self.connect('response', self.res_caught)

		liststore = gtk.ListStore(gobject.TYPE_BOOLEAN, # join
								  gobject.TYPE_STRING,  # channel name
								  gobject.TYPE_STRING,  # type
								  gobject.TYPE_STRING,  # ghost
								  gobject.TYPE_STRING,  # count
								  gobject.TYPE_STRING)  # description
		self.treeview = gtk.TreeView(liststore)
		self.treeview.set_rules_hint(gtk.TRUE)
		self.treeview.set_search_column(gtk.TRUE)
		self.treeview.set_reorderable(gtk.FALSE)
		self.treeview.connect('select-cursor-row', self.selected)
		self.treeview.connect('cursor-changed', self.cursor_changed)

		join_and_channel_col = gtk.TreeViewColumn(unicode(_("Channel"), "utf-8"))
		self.treeview.append_column(join_and_channel_col)

		join_cell    = gtk.CellRendererToggle()
		channel_cell = gtk.CellRendererText()

		join_cell.connect('toggled', self.toggled, liststore, 0)

		join_and_channel_col.pack_start(join_cell, gtk.FALSE)
		join_and_channel_col.pack_start(channel_cell, gtk.FALSE)

		join_and_channel_col.add_attribute(join_cell, 'active', 0)
		join_and_channel_col.add_attribute(channel_cell, 'text', 1)
		join_and_channel_col.set_resizable(gtk.TRUE)
		join_and_channel_col.set_clickable(gtk.FALSE)

		other_cols = [
			gtk.TreeViewColumn(unicode(_("Type"), "utf-8")),
			gtk.TreeViewColumn(unicode(_("Ghost"), "utf-8")),
			gtk.TreeViewColumn(unicode(_("Count"), "utf-8")),
			gtk.TreeViewColumn(unicode(_("Description"), "utf-8")),
			]

		for i in range(len(other_cols)):
			self.treeview.append_column(other_cols[i])
			cell = gtk.CellRendererText()
			other_cols[i].pack_start(cell, gtk.FALSE)
			other_cols[i].add_attribute(cell, 'text', i+2)
			other_cols[i].set_resizable(gtk.TRUE)
			other_cols[i].set_clickable(gtk.FALSE)

		for n in range(len(self.channels)):
			if self.channels[n]["nopost"]:
				type = unicode(_("Reception only"), "utf-8")
			else:
				type = unicode(_("Standard"), "utf-8")

			liststore.append((gtk.TRUE, self.channels[n]["name"], type, self.channels[n]["ghost"],
							  str(self.channels[n]["count"]), self.channels[n]["info"]))

		sw = gtk.ScrolledWindow()
		sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		sw.set_shadow_type(gtk.SHADOW_IN)
		sw.add(self.treeview)

		textview = gtk.TextView()
		textview.set_editable(gtk.FALSE)
		textview.set_cursor_visible(gtk.FALSE)
		textview.set_wrap_mode(gtk.WRAP_CHAR)
		self.textbuffer = textview.get_buffer()

		tsw = gtk.ScrolledWindow()
		tsw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		tsw.set_shadow_type(gtk.SHADOW_IN)
		tsw.add(textview)

		p = gtk.VPaned()
		p.pack1(sw, gtk.TRUE, gtk.FALSE)
		p.pack2(tsw, gtk.FALSE)

		self.vbox.pack_start(p)

		self.show_all()
		self.treeview.grab_focus()
		ok_button = self.action_area.get_children()[0]
		ok_button.grab_focus()

	def aggregate(self):
		self.selection = []
		liststore = self.treeview.get_model()
		for i in range(len(liststore)):
			if liststore[i][0]:
				self.selection.append(i)

	def toggled(self, cell, path, liststore, column):
		liststore[path][column] = not liststore[path][column]

	def cursor_changed(self, treeview, start_editing=gtk.FALSE):
		treeview.emit('select-cursor-row', start_editing)

	def selected(self, treeview, start_editing=gtk.FALSE):
		selection = treeview.get_selection()
		liststore, treeiter = selection.get_selected()
		if not treeiter or not liststore:
			return gtk.FALSE
		path = liststore.get_path(treeiter)[0]
		self.textbuffer.set_text(liststore[path][5])
		return gtk.TRUE

	def res_caught(self, dialog, response_id):
		if response_id == gtk.RESPONSE_OK:
			self.aggregate()
			if not self.selection:
				open_error_dialog(unicode(_('Channels are not selected.'), 'utf-8'),
								  parent=self)
				self.run()
			self.hide()
		else:
			self.cancel()

	def cancel(self, widget=None, data=None):
		self.selection = []
		self.hide()
