# -*- coding: ascii -*-
#
#  client.py - bottle client part of GBottler
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: client.py,v 1.2 2004/09/21 14:25:52 atzm Exp $
#

import time, StringIO, mimetools

from bottlelib  import BottleClient
from downloader import Downloader
from common     import APP, VOTE, AGREE

class Bottler(BottleClient):
	def __init__(self, app, prefs):
		BottleClient.__init__(self)
		self.app = app
		self.prefs = prefs

		self.download_pattern = self.prefs.get_all()
		self.download_logging = self.prefs.get('download_log')

	def set_pattern(self, dic):
		self.download_pattern = dic

	def set_dl_logging(self, logging):
		self.download_logging = logging

	def handle_sstp_message(self, message, unicast, forced):
		# dispatch SSTP message to local SSTP server
		if not message:
			return

		# get unique values
		mid = self.headers.get('mid', '')
		sender = APP #self.headers.get('sender', 'SSTP Bottle')
		receive_time = time.localtime(float(eval("0x%s" % mid[:8])))
		if unicast:
			channel = 'unicast'
		elif forced:
			channel = 'broadcast'
		else:
			channel = self.headers.get('channel', '')

		# parse SSTP message
		file = StringIO.StringIO(message)
		request = file.readline()
		headers = mimetools.Message(file)

		try:
			script = headers["script"]
		except KeyError:
			return
		charset = headers.get("charset", "Shift_JIS")
		ifghost = headers.get('ifghost', 'default')

		# log message
		self.app.notify_log_update(mid[:], channel, ifghost, script, receive_time)

		# forward local SSTP server?
		if self.prefs.get('forward'):

			# Forward all messages?
			if self.prefs.get('accept_all'):
				self.app.send_local_message(channel, ifghost, script, sender, charset, mid[:])

			# Forward only installed ghosts?
			elif self.prefs.get('forward_listed'):
				if ifghost in self.app.local_ghost:
					self.app.send_local_message(channel, ifghost, script, sender, charset, mid[:])

		# download
		if self.prefs.get('autodl'):
			downloader = Downloader(verbose=True, dic=self.download_pattern,
									logging=self.download_logging, script=script)
			downloader.start()

	def handle_dialog_message(self, message):
		self.app.monitor_clear()
		self.app.monitor_insert(message)

	def handle_broadcast_information(self, type, forced):
		BottleClient.handle_broadcast_information(self, type, forced)
		if type in [VOTE, AGREE]:
			self.app.log_votes(self.headers["mid"], type, int(self.headers["num"]))

	def handle_all_users(self):
		self.app.show_users()

	def handle_channel_users(self, channel):
		self.app.show_users_of(channel)

	def handle_close_channel(self, channel):
		self.app.close_channel(channel)
