# -*- coding: ascii -*-
#
#  logfetcher.py - Log Downloader
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: logfetcher.py,v 1.1 2004/09/19 05:23:23 atzm Exp $
#

import mimetools, socket, httplib
import string
from common import HOST, AGENT_NAME

class LogFetcher:
	def __init__(self):
		pass

	def fetch(self, request, action='/fetchlog.cgi'):
		try:
			http = httplib.HTTP(HOST)

			http.putrequest("POST", action)
			http.putheader("Host", HOST)
			http.putheader("From", AGENT_NAME)
			http.putheader("Accept", "text/html, text/plain")
			http.putheader("Content-type", "application/x-www-form-urlencoded")
			http.putheader("Content-length", str(len(request)))
			http.endheaders()

			http.send(request)
		except socket.error, e:
			print e
			return str(e)

		try:
			code, message, headers = http.getreply()
		except socket.error, e:
			print e
			return str(e)

		file = http.getfile()
		headers = mimetools.Message(file, 0)

		if code != 200:
			#print code, message, headers
			return str(headers) or str(code)
		if not headers.has_key("Result") or headers["Result"] != "OK":
			#print code, message, headers
			return str(headers) or str(code)
		if not headers.has_key("Limit"):
			#print code, message, headers
			return str(headers) or str(code)

		lines = []
		while True:
			line = file.readline()
			if not line:
				break
			if line[-2:] == '\r\n':
				line = line[:-2]
			if not line:
				continue
			line = unicode(line, 'sjis', 'replace')
			[date, mid, channel, ghost, users, votes, agrees, script] = string.split(line, '\t', 7)
			lines.append([date, mid, votes, agrees, channel, ghost, script])

		return lines
