# -*- coding: ascii -*-
#
#  svgmanager.py - The Manager of SVG
#  Copyright (C) 2004 by Takuya KAWAHARA <num@sann.ne.jp>
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: svgmanager.py,v 1.32 2004/09/21 07:29:43 tkawa Exp $

import pygtk
import gtk
import os
import shutil
import sys
import string
import re

from common              import *
from showingsurface      import ShowingSurface
from viewer.ghostmanager import GhostManager
from viewer.viewercommon import *

class SVGManager(gtk.Window):
	def __init__(self, app, prefs, base_dir, ghost_file='ghost.txt'):
		self.app = app
		self.prefs = prefs
		self.base_dir = base_dir
		self.ghost_file = ghost_file
		self.gm = GhostManager(self.ghost_file, True)
		accel_group = gtk.AccelGroup()

## Create status (left) window
		## Create GhostList window
		self.gn_str = gtk.ListStore('gboolean', str, str, str)

		self.gn = gtk.TreeView(self.gn_str)
		self.gn.set_enable_search(gtk.TRUE)
		self.gn.set_rules_hint(gtk.TRUE)
		self.gn.set_search_column(gtk.TRUE)
		self.gn.set_reorderable(gtk.TRUE)
		self.gn.connect("cursor-changed", self.cc)
		self.gn.connect("select-cursor-row", self.select_row)

		# generate ghost_list
		if not os.path.exists(self.base_dir):
			os.makedirs(self.base_dir)
			self.set_config(self.ghost_file)

		self.get_config(ghost_file)

		# make ghostlist column
		columns = [
			gtk.TreeViewColumn(unicode(_('Use'), 'utf-8')),
			gtk.TreeViewColumn(unicode(_('Ghost'), 'utf-8')),
			gtk.TreeViewColumn(unicode(_('FMO'), 'utf-8')),
			gtk.TreeViewColumn(unicode(_('Path'), 'utf-8')),
			]
		for i in range(len(columns)):
			columns[i].set_resizable(gtk.TRUE)
			columns[i].set_clickable(gtk.TRUE)
			columns[i].connect("clicked", self.sort, i)
			self.gn.append_column(columns[i])

			if i == 0:
				cell = gtk.CellRendererToggle()
				cell.connect("toggled", self.check_use_toggle)
				columns[i].pack_start(cell, gtk.TRUE)
				columns[i].add_attribute(cell, 'active', i)
			else:
				cell = gtk.CellRendererText()
				columns[i].pack_start(cell, gtk.TRUE)
				columns[i].add_attribute(cell, 'text', i)
				if   i == 1: cell.set_property('width', 80)
				elif i == 2: cell.set_property('width', 40)
				else:        cell.set_property('width', 140) # XXX: kimeuchi ikunai...

		self.sw = gtk.ScrolledWindow()
		self.sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		self.sw.set_shadow_type(gtk.SHADOW_IN)
		self.sw.add(self.gn)

		# Create GhostInformation main
		self.sakura_box = gtk.Image()
		self.unyuu_box  = gtk.Image()

		sakura_f = gtk.Frame()
		sakura_f.set_border_width(0)
		sakura_f.set_size_request(SIZE_SURFACE_H + 1, SIZE_SURFACE_V + 1)
		sakura_f.set_shadow_type(gtk.SHADOW_NONE)
		sakura_f.add(self.sakura_box)

		unyuu_f = gtk.Frame()
		unyuu_f.set_border_width(0)
		unyuu_f.set_size_request(SIZE_SURFACE_H + 1, SIZE_SURFACE_V + 1)
		unyuu_f.set_shadow_type(gtk.SHADOW_NONE)
		unyuu_f.add(self.unyuu_box)

		#info_ghost is 'showing surface [0] and [10]'
		info_ghost = gtk.HBox(gtk.FALSE)
		info_ghost.pack_start(unyuu_f, gtk.TRUE, gtk.FALSE, 0)
		info_ghost.pack_start(sakura_f, gtk.TRUE, gtk.FALSE, 0)

		self.button_id = None
		self.url_button = get_icon_button(gtk.STOCK_JUMP_TO, size=gtk.ICON_SIZE_BUTTON,
										  relief=gtk.RELIEF_NORMAL, label=unicode(_('URL'), 'utf-8'))
		self.url_button.set_sensitive(gtk.FALSE)
		self.url_button.add_accelerator("clicked",  accel_group, ord('J'),
										gtk.gdk.CONTROL_MASK|gtk.gdk.MOD1_MASK,
										gtk.ACCEL_VISIBLE)

		self.button_id_s = None
		self.sur_button = get_icon_button(gtk.STOCK_INDEX, size=gtk.ICON_SIZE_BUTTON,
										  relief=gtk.RELIEF_NORMAL, label=unicode(_('Surface'), 'utf-8'))
		self.sur_button.set_sensitive(gtk.FALSE)
		self.sur_button.add_accelerator("clicked",  accel_group, ord('S'),
										gtk.gdk.CONTROL_MASK|gtk.gdk.MOD1_MASK,
										gtk.ACCEL_VISIBLE)

		buttonbox = gtk.HBox(gtk.TRUE)
		buttonbox.pack_start(self.url_button, gtk.FALSE, gtk.FALSE, 0)
		buttonbox.pack_start(self.sur_button, gtk.FALSE, gtk.FALSE, 0)

		info_ghost_a = gtk.VBox(gtk.FALSE)
		info_ghost_a.pack_start(info_ghost, gtk.TRUE, gtk.FALSE, 0)
		info_ghost_a.pack_start(buttonbox, gtk.FALSE, gtk.FALSE, 0)

		#info_svg is 'showing information of selected svg_file (from *.txt)'
		info_svg = gtk.TextView()
		info_svg.set_editable(gtk.FALSE)
		info_svg.set_cursor_visible(gtk.FALSE)
		self.info_buffer = info_svg.get_buffer()

		isv = gtk.ScrolledWindow()
		isv.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		isv.set_size_request(200, 200)
		isv.set_shadow_type(gtk.SHADOW_IN)
		isv.add(info_svg)

		info_hbox = gtk.HBox()
		info_hbox.pack_start(info_ghost_a, gtk.FALSE, gtk.FALSE, 0)
		info_hbox.pack_start(isv, gtk.TRUE, gtk.TRUE, 0)

		v_paned = gtk.VPaned()
		v_paned.pack1(info_hbox)
		v_paned.pack2(self.sw)

		self.ghost_name = gtk.Entry()
		self.ghost_name.set_editable(gtk.FALSE)

		# Create Search Entry
		self.msg = unicode(_("Search"), "utf-8")
		self.search_entry = gtk.Entry()
		self.search_entry.set_text(self.msg)
		self.search_entry.connect("activate", self.search)
		self.search_entry.connect("key-press-event", self.entry_keypress)
		self.search_entry.connect("focus-in-event", self.set_entry_guide, 'in')
		self.search_entry.connect("focus-out-event", self.set_entry_guide, 'out')

		self.s_arrow = gtk.Arrow(gtk.ARROW_DOWN, gtk.SHADOW_NONE)

		search_allow_button = gtk.ToggleButton()
		search_allow_button.add(self.s_arrow)
		search_allow_button.connect('clicked', 
				lambda x: self.s_arrow.set((not self.s_arrow.get_property('arrow-type')),
				gtk.SHADOW_NONE))
		search_allow_button.connect('focus-in-event', lambda x, y: self.search_entry.grab_focus())

		search_box = gtk.HBox()
		search_box.pack_start(search_allow_button, gtk.FALSE, gtk.TRUE, 0)
		search_box.pack_start(self.search_entry)

		status_vbox = gtk.VBox(gtk.FALSE, 0)
		status_vbox.pack_start(self.ghost_name, gtk.FALSE, gtk.FALSE, 0)
		status_vbox.pack_start(v_paned, gtk.TRUE, gtk.TRUE, 5)
		status_vbox.pack_start(search_box, gtk.FALSE, gtk.FALSE, 0)

## Create Bottons (right) window
		ctrl_vbox = gtk.VBox(gtk.FALSE, 0)
		for item in [
			[gtk.STOCK_ADD,     unicode(_('Add'),    'utf-8'), self.add_ghost,    None],
			[gtk.STOCK_YES,     unicode(_('FMO'),    'utf-8'), self.check_fmo,    None],
			[gtk.STOCK_NO,      unicode(_('Use'),    'utf-8'), self.check_fmo,    None],
			[gtk.STOCK_REMOVE,  unicode(_('Remove'), 'utf-8'), self.delete_ghost, [ord('D'), gtk.gdk.CONTROL_MASK]],
			[gtk.STOCK_REFRESH, unicode(_('Reload'), 'utf-8'), self.reload,       [ord('R'), gtk.gdk.CONTROL_MASK]],
			[gtk.STOCK_SAVE,    unicode(_('Save'),   'utf-8'), self.save,         [ord('S'), gtk.gdk.CONTROL_MASK]],
			[gtk.STOCK_CLOSE,   unicode(_('Close'),  'utf-8'), self.close,        [ord('Q'), gtk.gdk.CONTROL_MASK]],
			]:
			btn = get_icon_button(item[0], size=gtk.ICON_SIZE_BUTTON, relief=gtk.RELIEF_NORMAL, label=item[1])
			btn.connect('clicked', item[2])

			if item[3] is not None:
				btn.add_accelerator('clicked', accel_group, item[3][0], item[3][1], gtk.ACCEL_VISIBLE)

			ctrl_vbox.pack_start(btn, gtk.TRUE, gtk.TRUE, 5)

		main_hbox = gtk.HBox(gtk.FALSE, 0)
		main_hbox.pack_start(status_vbox, gtk.TRUE, gtk.TRUE, 0)
		main_hbox.pack_start(ctrl_vbox, gtk.FALSE, gtk.FALSE, 5)

## Create Base Window
		gtk.Window.__init__(self, gtk.WINDOW_TOPLEVEL)
		self.connect("delete-event", self.close)
		self.set_title(unicode(_(APP), "utf-8") + ": " + unicode(_("SVGManager"), "utf-8"))
		self.set_default_size(450, 450)
		self.add_accel_group(accel_group)
		self.add(main_hbox)

	def open(self, widget=None, data=None):
		self.show_all()
		self.gn.grab_focus()

	def close(self, widget=None, event=None, data=None):
		self.hide()
		return gtk.TRUE

	def sort(self, treeviewcol, col_num):
		id = self.gn_str.get_sort_column_id()
		if id[0] == col_num:
			self.gn_str.set_sort_column_id(col_num, not id[1])
		else:
			self.gn_str.set_sort_column_id(col_num, gtk.SORT_DESCENDING)

	def search(self, widget=None, data=None):
		pat = re.compile(self.search_entry.get_text(), re.IGNORECASE)
		current = self.selection()
		rng = []

		if self.s_arrow.get_property('arrow-type') == gtk.ARROW_UP:
			if current == None: current = len(self.gn_str)
			rng = range(0, current)
			rng.reverse()
		elif self.s_arrow.get_property('arrow-type') == gtk.ARROW_DOWN:
			if current == None: current = 0
			rng = range(current+1, len(self.gn_str))

		for i in rng:
			for j in range(1, 3):
				m = pat.search(self.gn_str.get_value(self.gn_str.get_iter(i), j))
				if m:
					self.gn.set_cursor(i)
					return None

	def is_selected(self):
		try:
			treeselection = self.gn.get_selection()
			[liststore, treeiter] = treeselection.get_selected()
			if not treeiter:
				return False
		except:
			return False
		return True

	def selection(self):
		if self.is_selected():
			treeselection = self.gn.get_selection()
			[liststore, treeiter] = treeselection.get_selected()
			pathes = liststore.get_path(treeiter)
			return pathes[0]
		else:
			return None

	def entry_keypress(self, widget, event):
		return self.scroll(widget, event)

	def set_entry_guide(self, widget, event, data):
		if data == 'in':
			if widget.get_text() == self.msg:
				widget.set_text('')
		elif data == 'out':
			if not widget.get_text():
				widget.set_text(self.msg)

	def scroll(self, widget, event):
		if event.state == 1: # shift
			if event.keyval == 65362: # up
				self.sw.emit('scroll-child', gtk.SCROLL_PAGE_UP, gtk.FALSE)
				return gtk.TRUE
			elif event.keyval == 65364: # down
				self.sw.emit('scroll-child', gtk.SCROLL_PAGE_DOWN, gtk.FALSE)
				return gtk.TRUE
			return gtk.FALSE
		return gtk.FALSE

## 'cursor-changed' signal gtk.TreeView
	def cc(self, treeview):
		treeview.emit("select-cursor-row", gtk.FALSE)

	EXPAND_QUOTE_REGEX = re.compile('"(.+?)"')
	def select_row(self, treeview, se=gtk.FALSE):
		ifg = self.gn_str.get_value(self.gn_str.get_iter(self.gn.get_cursor()[0][0]), 3)
		try:
			ifg = self.EXPAND_QUOTE_REGEX.match(ifg).group(1)
		except AttributeError:
			pass
		g = self.gm.nominate_ghost_txt(os.path.join(self.base_dir, ifg), \
									   os.path.join(self.base_dir, 'Ghost'))

		## get and show sakura, unyuu surfaces
		sur_sakura = g.get_surface(0)
		sur_unyuu = g.get_surface(10)

		self.sakura_box.set_from_pixbuf(sur_sakura)
		self.unyuu_box.set_from_pixbuf(sur_unyuu)

		## get and show ghost information
		sakura = g.get_sakura()
		unyuu = g.get_unyu()
		craftman = g.get_craftman()
		hpname = g.get_hpname()
		hpurl = g.get_url()
		surfacefile = g.get_surfacefile()
		update = g.get_update()
		ghostname = g.get_ghostname()
		supported = g.get_supported()
		sakura_action = g.get_sakura_action()
		inform = g.get_inform()

		self.ghost_name.set_text(ghostname)

		information = sakura + '\n  &\n' + unyuu + '\n'
		if craftman:      information = information + '\nby:\t' + craftman
		if hpname:        information = information + '\nHP Name:\t' + hpname
		if hpurl:         information = information + '\nHP URL:\n' + hpurl + '\n'
		if supported:     information = information + '\n' + supported
		if sakura_action: information = information + '\nSakuraAct:\t' + sakura_action
		information = information + '\nDEF.:./' + ifg
		if surfacefile:   information = information + '\nSUF.:./Ghost/' + surfacefile
		if update:        information = information + '\n\nVer.' + update
		if inform:        information = information + '\n' + inform

		self.info_buffer.set_text(information)

		if self.button_id:
			self.url_button.disconnect(self.button_id)
		self.button_id = None

		if self.button_id_s:
			self.sur_button.disconnect(self.button_id_s)
		self.button_id_s = None

		if hpurl:
			self.url_button.set_sensitive(gtk.TRUE)
			self.button_id = self.url_button.connect("clicked", self.url_jump, hpurl)
		else:
			self.url_button.set_sensitive(gtk.FALSE)

		self.sur_button.set_sensitive(gtk.TRUE)
		self.button_id_s = self.sur_button.connect("clicked", self.show_surface, g)

## if pressed button
	def add_ghost(self, button):
		def file_ok_sel(w):
			filename = filew.get_filename()
			filew.destroy()
			## call Ghost(filename)
			new_svg_dir = os.path.split(filename)[0]
			g = self.gm.nominate_ghost_txt(filename, new_svg_dir)
			new_ghost_name = g.get_sakura2()

			if not new_ghost_name:
				new_ghost_name = g.get_sakura()
			if not new_ghost_name and not g.get_ghostname():
				open_error_dialog(unicode(_("Can't open file"), 'utf-8'), self)
				return -1

			self.gn_str.append([gtk.TRUE, '%s' % new_ghost_name, '',
					'"%s"' % os.path.join('Ghost', os.path.split(filename)[-1])])

			## added new_svg_txt if not same ghost_dir
			if not ghost_dir == new_svg_dir:
				shutil.copyfile(filename, os.path.join(ghost_dir, os.path.split(filename)[-1]))
				if os.path.exists(os.path.join(new_svg_dir, g.get_surfacefile())):
					shutil.copyfile(os.path.join(new_svg_dir, g.get_surfacefile()), \
					         os.path.join(ghost_dir, g.get_surfacefile()))
			self.gn.set_cursor(len(self.gn_str)-1)

		filew = gtk.FileSelection()
		filew.set_select_multiple(gtk.FALSE)
		filew.connect("destroy", lambda x: filew.destroy())

		ghost_dir = os.path.join(self.base_dir, 'Ghost')
		if not os.path.exists(ghost_dir):
			os.makedirs(ghost_dir)
		filew.set_filename(os.path.normpath(os.path.join(ghost_dir, '*.txt')))
		filew.ok_button.connect("clicked", file_ok_sel)
		filew.cancel_button.connect("clicked", lambda x: filew.destroy())
		filew.show()

	def check_fmo(self, button):
		try:
			i = self.gn.get_cursor()[0][0]
			now = self.gn.get_selection()
			[model, iter] = now.get_selected()
			if model.get_value(iter, 2) == 'FMO':
				self.delete_fmo(model, iter)
			else:
				self.set_fmo(model, iter)
			self.gn.set_cursor(i)
			self.gn.grab_focus()
		except:
			open_error_dialog(unicode(_('No selected Ghost!'), 'utf-8'), self)

	def check_use(self, button):
		try:
			i = self.gn.get_cursor()[0][0]
			now = self.gn.get_selection()
			[model, iter] = now.get_selected()
			if model.get_value(iter, 0):
				self.unuse_ghost(model, iter)
			else:
				self.use_ghost(model, iter)
			self.gn.set_cursor(i)
			self.gn.grab_focus()
		except:
			open_error_dialog(unicode(_('No selected Ghost!'), 'utf-8'), self)

	def delete_ghost(self, button):
		try:
			i = self.gn.get_cursor()[0][0]
			self.gn_str.remove(self.gn_str.get_iter(i))
			if i == len(self.gn_str):
				self.gn.set_cursor(i-1)
			else:
				self.gn.set_cursor(i)
		except:
			open_error_dialog(unicode(_('No selected Ghost!'), 'utf-8'), self)

	def reload(self, button):
		self.get_config()
		self.gn.grab_focus()

	def save(self, button):
		self.set_config()
		self.app.notify_svg_changed()

	def check_use_toggle(self, cellrenderer, path):
		model = self.gn_str
		iter = model.get_iter(path)
		try:
			if self.gn_str.get_value(iter, 0):
				self.unuse_ghost(model, iter)
			else:
				self.use_ghost(model, iter)
		except:
			open_error_dialog(unicode(_('No selected Ghost!'), 'utf-8'), self)

	def url_jump(self, button, hpurl):
		try:
			os.system(self.prefs.get('browser') % hpurl + ' &')
		except:
			open_error_dialog(unicode(_('No selected Ghost!'), 'utf-8'), self)

	def show_surface(self, button, ghost):
		path = os.path.join(self.base_dir, 'Ghost', ghost.get_surfacefile())
		try:
			pixbuf = gtk.gdk.pixbuf_new_from_file(path)
		except:
			return
		ss = ShowingSurface(self.app, pixbuf, ghost)

## operate the CONFIG_FILE
	def get_config(self, config_file='ghost.txt'):
		self.gn_str.clear()
		## read a config_file, make a list, and return the list
		config_file = os.path.join(self.base_dir, config_file)
		try:
			file = open(config_file)
		except IOError:
			print "cannot open ", config_file
			return None

		## read ghost.txt
		flag = False
		while 1:
			#read file and hogehoge
			line = file.readline()
			if not line:
				continue
			if line[:4] == '/EOF':
				break
			if line[:7] == 'INSTALL' or not flag:
				flag = True
				continue

			key = line.strip()
			if not key:
				continue
			key = unicode(key, 'sjis', 'replace')
			key = key.replace('\\', r'/')
			tmp = key.split(',')
			if tmp[0] == 'GHOST':
				self.gn_str.append([gtk.TRUE, tmp[1], tmp[2], tmp[3]])
			else:
				self.gn_str.append([gtk.FALSE, tmp[1], tmp[2], tmp[3]])
		file.close()

	def set_config(self, config_file='ghost.txt'):
		## save config, (write to CONFIG_FILE)
		config_file = os.path.join(self.base_dir, config_file)
		try:
			file = open(config_file, "w")
		except IOError:
			print "can't write to file"

		file.write('INSTALL,,,"Ghost\\"\n')
		for i in range(0, len(self.gn_str)):
			iter = self.gn_str.get_iter(i)
			def_file = self.gn_str.get_value(iter, 3)
			def_file = def_file.replace(r'/', '\\')
			if self.gn_str.get_value(iter, 0):
				ghost = 'GHOST'
			else:
				ghost = '#GHOST'
			tmp = ghost + ',' + self.gn_str.get_value(iter, 1) + ',' + self.gn_str.get_value(iter, 2) + ',' + def_file + '\n'
			tmp = tmp.encode('sjis')
			file.write(tmp)
		file.write('/EOF')
		file.close()

	def use_ghost(self, model, iter):
		## delete '#' from  first item '#GHOST'
		self.gn_str.set_value(iter, 0, gtk.TRUE)

	def unuse_ghost(self, model, iter):
		## insert '#' in first item 'GHOST'
		self.gn_str.set_value(iter, 0, gtk.FALSE)

	def set_fmo(self, model, iter):
		## insert 'FMO' the third item
		self.gn_str.set_value(iter, 2, 'FMO')

	def delete_fmo(self, model, iter):
		## delete 'FMO' the third item 'FMO'
		self.gn_str.set_value(iter, 2, '')

if __name__ == "__main__":
	sm = SVGManager()
	gtk.main()
