# -*- coding: ascii -*-
#
#  ghostmanager.py - The Manager of Ghosts
#  Copyright (C) 2004 by Takuya KAWAHARA <num@sann.ne.jp>
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: ghostmanager.py,v 1.11 2004/09/10 16:07:41 atzm Exp $
#

import os
import re
import sys
import string

from ghost import Ghost
from viewercommon import *

class GhostManager:
	def __init__(self, textfile='ghost.txt', debug=DEBUG):
		self.ghost_dic = {}
		self.fmo_ghost_list = []
		self.debug = debug

		self.generate_dictionary(textfile)

	def set_debug(self, flag):
		self.debug = bool(flag)

	def nominate_ghost(self, ifghost, svg_dir='Ghost'):
		if ifghost == NAME_SAKURA:
			if self.ghost_dic.has_key(NAME_SAKURA_KAWAKAMI):
				ifghost = NAME_SAKURA_KAWAKAMI
			elif self.ghost_dic.has_key(NAME_SAKURA_KUROI):
				ifghost = NAME_SAKURA_KUROI

		try:
			return Ghost(self.ghost_dic[ifghost], svg_dir)
		except KeyError:
			if self.debug:
				sys.stderr.write('%s\n' % ('-' * 20))
				sys.stderr.write('no such ghost: %s\n' % ifghost)
			return None

	def nominate_ghost_txt(self, svg_txt, svg_dir='Ghost'):
		try:
			return Ghost(svg_txt, svg_dir)
		except KeyError:
			if self.debug:
				sys.stderr.write('%s\n' % ('-' * 20))
				sys.stderr.write('no such svg_txt: %s\n' % svg_txt)
			return None

	def get_fmo_ghosts(self):
		return self.fmo_ghost_list

	def generate_dictionary(self, textfile='ghost.txt'):
		try:
			file = open(textfile)
		except IOError:
			return -1

		self.ghost_dic = {}
		self.fmo_ghost_list = []

		base_dir = os.path.dirname(textfile)
		quote = re.compile('"(.+?)"')
		while 1:
			line = file.readline()
			if not line:
				continue
			if line[:4] == '/EOF':
				break
			if line[0] == '#':
				continue

			key = line.strip()
			if not key:
				continue

			[define, ghostname, fmo, path] = key.split(',')
			if not define == 'GHOST':
				continue

			m = quote.match(path)
			if m:
				path = m.group(1)
			path = path.replace('\\', r'/')
			path = os.path.join(base_dir, path)
			path = os.path.normpath(path)
			ghostname = unicode(ghostname, 'sjis', 'replace')
			self.ghost_dic[ghostname] = path

			if fmo == "FMO":
				ghost = self.nominate_ghost_txt(path, os.path.dirname(path))
				name  = ghost.get_sakura()
				self.fmo_ghost_list.append(name)
