/***************************************************************/
//
//
//		DirectX	[ model.cpp ]
//
//											Author	kazuki tanaka
//											Date	2016 10/26
/*---------------------------------------------------------------
Update : 2016/10/26
			model.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

#include "main.h"
#include "model.h"
#include "base_player.h"

#define _USE_MATH_DEFINES
#include <math.h>
#include <time.h>
#include "input.h"
#include "keyboard.h"

// ֗֐Q
#include "game_equation.h"
#include "game_system.h"
#include "import.h"

#include "shadow.h"
#include "bullet.h"
#include "explosion.h"

#include "navi.h"

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }
#define RADIAN( theta ) ((( theta ) * D3DX_PI ) / 180 )	// WApւ̕ϊ

// AtBϊ
#define AFFINE_TRANSFORM_X( radiusX, radiusY, theta ) \
(( radiusX ) * cosf( RADIAN( theta )) - ( radiusY ) * sinf( RADIAN( theta )))

#define AFFINE_TRANSFORM_Y( radiusX, radiusY, theta ) \
(( radiusX ) * sinf( RADIAN( theta )) + ( radiusY ) * cosf( RADIAN( theta )))


/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

/*---------------------------------------------------------------
	X^eBbNoϐ̏
---------------------------------------------------------------*/


// MODEL̏
CBasePlayer::CBasePlayer( )
{

	// oϐ̏
	playerType = TYPE_CPU;
	rotParent = D3DXVECTOR3( 0, 0, 0 );			// vC[
	speed     = D3DXVECTOR3( 0, 0, 0 );			// vC[̑x
	lookAt    = D3DXVECTOR3( 0, 0, 0 );			// vC[̒_
	acceleration = 0.0f;
	life      = 0;
	cost      = 0;
	contact   = false;
	shadow    = NULL;
	pInput    = NULL;

	NUM_MODEL = 0;								// ǂݍރf
	NUM_PARTS = 0;								// \p[c

	keyframe = 0;								// [Vt[
	actKey = 0;									// ݂̃L[
	nextKey = 1;								// ̃L[
	teamNo  = -1;

	// \p[c
	parts = nullptr;							// p[c(p[cnew)

	// [V
	motion = nullptr;							// [V
	actMotion = MOTION_DEFAULT;					// ݍsĂ郂[V
	nextStandbyMotion = MOTION_DEFAULT;			// X^oC̃[V

	frame = 0;
	
}

// MODEL̏
CBasePlayer::~CBasePlayer( )
{
	


}

// MODEL̏
void CBasePlayer::Init( void )
{

	// foCX̎󂯎
	//LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	HRESULT hr;

	// motion.txt̓ǂݍ
	LoadTxt( "data\\motion.txt", this );	// this:gIuWFNg̃|C^
	
	// Xe[^X̐ݒ
	SetMotionInfo( );

	// Registry Controller
	pInput = CInput::Access( "keyboard" );


}

// MODEL̏
void CBasePlayer::Init( const char* TXT_FILE_NAME )
{

	// foCX̎󂯎
	//LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	HRESULT hr;

	// motion.txt̓ǂݍ
	LoadTxt( TXT_FILE_NAME, this );	// this:gIuWFNg̃|C^
	
	// Xe[^X̐ݒ
	SetMotionInfo( );

	// Cpu Navi
	pNavi = CNavi::Create( );
	pNavi ->Init( &D3DXVECTOR3( 100, 100, 0 ) );

}

// MODEL̏I
void CBasePlayer::Uninit( void )
{


	// [Vf[^
	if( motion ){

		for( int motionCount = 0; motionCount < MOTION_MAX; motionCount++ ){
			for( int key = 0; key < motion[motionCount].NUM_KEY; key++ ){
				SAFE_DELETE_ARRAY( motion[motionCount].keyFrameMotion[ key ].pose )
			}
		}

		// S[V
		for( int motionCount = 0; motionCount < MOTION_MAX; motionCount++ ){
			SAFE_DELETE_ARRAY( motion[motionCount].keyFrameMotion )
		}

		SAFE_DELETE_ARRAY( motion )

	}

	// p[c̉
	for( int index = 0; index < NUM_PARTS; index++ ){
		parts[index].Uninit( );
	}
	SAFE_DELETE_ARRAY( parts )

}

// MODEL̍XV
void CBasePlayer::Update( void )
{


	if( CInputKeyboard::Access( )->GetKeyTrigger( DIK_RETURN ) ){

		actMotion = MOTION_2;
		keyframe  = 0;
		actKey    = 0;
		nextKey   = actKey + 1;
	}

	// [VΏ
	if( motion ){

		// L[tO
		if( !(keyframe < motion[actMotion].keyFrameMotion[ actKey ].NUM_FREME) ){

			keyframe = 0;					// L[t[
			actKey = nextKey;
			nextKey++;
		}

		// [VtO
		if( nextKey >= motion[actMotion].NUM_KEY ){
		
			keyframe = 0;					// L[t[
			if( motion[actMotion].LOOP_FLAG == true ){
		
				actKey = motion[actMotion].NUM_KEY-1;
				nextKey = 0;
				actMotion = actMotion;
				// ݂̃[V̍ŌƍŏŕԂs

			}else{
		
				actMotion = MOTION_DEFAULT;
				// ݂ƃftHg[V̂OԖڂŕԂs
			}
		}
	}

		for( int index = 0; index < NUM_PARTS; index++ ){

			// L[t[Aj[V
			if( motion ){
				if( keyframe < motion[actMotion].keyFrameMotion[ actKey ].NUM_FREME ){

					__KFA_AngleLinearInterpolation(
						&parts[index].rot,
						&motion[actMotion].keyFrameMotion[actKey].pose[index],
						&motion[actMotion].keyFrameMotion[nextKey].pose[index],
						(int)motion[actMotion].keyFrameMotion[actKey].NUM_FREME,
						(int)keyframe );
				}
			}

			// [h}gNXPROCESS // fW̕ϊ
			D3DXMatrixRotationYawPitchRoll( &parts[index].rotationMtx, D3DX_PI - parts[index].rot.y, parts[index].rot.x, parts[index].rot.z );
			D3DXMatrixTranslation( &parts[index].translationMtx, parts[index].pos.x, parts[index].pos.y, parts[index].pos.z );

		} // END -> MODEL MOTION PROCESS


	// L[t[XV
	keyframe++;

	// [hs̎Zo
	for( int index = 0; index < NUM_PARTS; index++ ){
	
		D3DXMatrixIdentity( &parts[index].worldMtx );
		parts[index].worldMtx = parts[index].rotationMtx * parts[index].translationMtx;
	}

	// e]
	
	D3DXMATRIX rotWorld;
	D3DXMatrixRotationYawPitchRoll( &rotWorld, M_PI - rotParent.y, rotParent.x, rotParent.z );
	parts[0].worldMtx = parts[0].rotationMtx *  rotWorld * parts[0].translationMtx;

	// Calc World Matrix
	for( int i = 0; i < NUM_PARTS; i++ ){
		// PARENT PROCESS
		if( parts[i].parentStatus >= 0 && i != 0 ){

			parts[i].worldMtx *= parts[ parts[i].parentStatus ].worldMtx;
		}
	}

	// eZbg
	shadow->SetCoord( &parts[0].pos );	


}

// MODEL̕`
void CBasePlayer::Draw( void )
{


	// -- f` --

	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	//pDevice->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );		
	//pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );	
	//pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );

	// ݃foCXɐݒ肳Ă}eA̎擾
	D3DMATERIAL9 matDef;
	pDevice -> GetMaterial( &matDef );

	for( int i = 0; i < NUM_PARTS; i++ ){
		
		//worldMtx = worldMtx * parts[i].translationMtx * parts[i].rotationMtx;// * parts[i].offsetMtx;

		// foCXɃ[hϊsݒ
		pDevice ->SetTransform( D3DTS_WORLD, &parts[i].worldMtx );

		// }eÃ|C^ƂăAhX擾
		D3DXMATERIAL* pMat =( D3DXMATERIAL*)parts[i].pBufMatModel -> GetBufferPointer( );
		

		for( int index = 0; index < (int)parts[i].nNumMatModel; index++ ){

			// foCXɃ}eAݒ
			pDevice -> SetMaterial( &pMat[ index ].MatD3D );

			// eNX`ݒ
			if( parts[i].pTexture[index] ){
				pDevice -> SetTexture( 0, parts[i].pTexture[index] );
			}else{
				pDevice -> SetTexture( 0, NULL );
			}

			// MODEL`
			parts[i].pMeshModel->DrawSubset( index );
		}

	}

	pDevice -> SetMaterial( &matDef );

	//pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	//pDevice->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );


}

// [JWs̎擾
D3DXMATRIX CBasePlayer::GetWorldMtx( void )
{

	return parts[0].worldMtx;

}

// qbg|Cg擾
int CBasePlayer::GetLife( void )
{

	return life;

}

// qbg|Cg擾
float CBasePlayer::GetLifePercent( void )
{

	return (float)life/life;

}

// qbg|Cgݒ
void CBasePlayer::SetLife( const int value )
{

	// PlayerHP̍XV
	life += value;
	//Player01.contact     = true;

	life = LIMIT_MIM( life, 0 );

}

// vC[^Cv̐ݒ
void CBasePlayer::SetType( PLAYER_TYPE type )
{

	playerType = type;

}

// vC[Rg[
void CBasePlayer::Controler( void )
{
	
	// vC[Rg[[

}

// vC[Zbg
void CBasePlayer::ResetPlayer( void )
{

	srand( (unsigned int) time( NULL ) );

	// vC[Zbg
	int select = rand()%4;

	switch( select ){

	case 0:
		parts[0].pos = D3DXVECTOR3( 1800, 0, 1800 );
		break;
	case 1:
		parts[0].pos = D3DXVECTOR3( -1800, 0, 1800 );
		break;
	case 2:
		parts[0].pos = D3DXVECTOR3( 1800, 0, -1800 );
		break;
	case 3:
		parts[0].pos = D3DXVECTOR3( -1800, 0, -1800 );
		break;
	}

	// CtĐݒ
	life = 1300;

}

// CPU̓
void CBasePlayer::AI_move( void )
{

	// CPU̓
	frame++;

	if( (frame)%90 == 0 ){
	
		D3DXVECTOR3 shotPosition;//= D3DXVECTOR3( parts[2].pos.x, parts[2].pos.y, parts[2].pos.z );
		D3DXVec3TransformCoord( &shotPosition, &D3DXVECTOR3( -60, 0, 0 ), &parts[2].worldMtx );
		D3DXVECTOR3 vec( -60, 0, 0 );
		D3DXMATRIX  mtx;
		D3DXMatrixRotationY( &mtx, D3DX_PI - parts[1].rot.y + D3DX_PI - parts[0].rot.y ); 
		D3DXVec3TransformCoord( &vec, &vec, &mtx );
		SetBullet( &shotPosition, &D3DXVECTOR3( -vec.x, -vec.y, -vec.z ), &D3DXCOLOR( 1.0f, 1.0f, 1.0f, 1.0f ), 15.0, 200 );
	}

	speed.x = -5.0f *sinf( (D3DX_PI*0.5f)-parts[0].rot.z )*cosf( parts[0].rot.y );
	speed.y = -5.0f *cosf( (D3DX_PI*0.5f)-parts[0].rot.z );
	speed.z = -5.0f *sinf( (D3DX_PI*0.5f)-parts[0].rot.z )*sinf( parts[0].rot.y );

	D3DXVECTOR3 vec;
	vec = parts[0].pos + speed;
	__ObjectFieldOut( 3000, 3000, &vec, 30, &speed );

	parts[0].pos += speed;

	if( GameSystem::ObjectSquareField( &parts[0].pos, &D3DXVECTOR3( radius, radius, radius ), &D3DXVECTOR3( 1000, 0, 1000 ), &D3DXVECTOR3( 718, 200, 718 ) )){
		parts[0].pos -= speed;
	}
	else if( GameSystem::ObjectSquareField( &parts[0].pos, &D3DXVECTOR3( radius, radius, radius ), &D3DXVECTOR3( -1000, 0, 1000 ), &D3DXVECTOR3( 718, 200, 718 ) )){
		parts[0].pos -= speed;
	}
	else  if( GameSystem::ObjectSquareField( &parts[0].pos, &D3DXVECTOR3( radius, radius, radius ), &D3DXVECTOR3( 1000, 0, -1000 ), &D3DXVECTOR3( 718, 200, 718 ) )){
		parts[0].pos -= speed;
	}
	else if( GameSystem::ObjectSquareField( &parts[0].pos, &D3DXVECTOR3( radius, radius, radius ), &D3DXVECTOR3( -1000, 0, -1000 ), &D3DXVECTOR3( 718, 200, 718 ) )){
		parts[0].pos -= speed;
	}

	pNavi ->Navigation( &parts[0].rot, &parts[0].pos, &speed );



}

// Registry Controller Pointer
void CBasePlayer::Registry( CInput* controller )
{

	// Registry Controller Pointer
	pInput = controller;

}

// vC[̍쐬
CBasePlayer* CBasePlayer::Create( void )
{

	// IuWFNg̍쐬
	CBasePlayer* pObject;
	pObject = new CBasePlayer;

	// eZbg
	pObject->shadow = CShadow::Create( 50.0f );
	pObject->shadow->Init( );

	return pObject;


}
 
// [V̐ݒ
void CBasePlayer::SetMotionInfo( void )
{


	if( NUM_PARTS ){

		//NUM_PARTS = NUM_PARTS_OFFSET;
	}else{
		#ifdef _DEBUG
		MessageBox( NULL, "MEMORY DONT ALLOCATER !! \n maybe new number broken !!", "ERROR", MB_OK | MB_ICONWARNING );
		#endif
		return;
	}

	//parts = new CModel[ NUM_PARTS ];

	// 
	for( int index = 0; index < NUM_PARTS; index++ ){

		//parts[index].LoadXFile( XFILE_NAME[index] ); 
	}

	// MODELItZbg
	for( int index = 0; index < NUM_PARTS; index++ ){

		//parts[index].parentStatus = PARENT_OFFSET[index];
		//parts[index].pos      = POS_OFFSET[index];
		//parts[index].rot      = ROT_OFFSET[index];

		parts[index].rotationValue = D3DXVECTOR3( 0, 0, 0 );
		parts[index].translateValue = D3DXVECTOR3( 0, 0, 0 );
	}

	//motion = new MOTION[5];

	// L[t[ftHgAj[V
	actMotion = MOTION_DEFAULT;
	actKey = 0;									// L[[V̏߂͕Ks
	nextKey = actKey+1;
	keyframe = 0;

	{
		//motion[MOTION_DEFAULT].NUM_KEY = NUM_KEY_MOTION1;
		//motion[MOTION_DEFAULT].LOOP_FLAG = LOOP_MOTION1;

		// ftHgAj[VAj[Vm
		//motion[MOTION_DEFAULT].keyFrameMotion = new MOTION_DATA[motion[0].NUM_KEY];

		// 񑩏_p[clm
		/*
		for( int key = 0; key < motion[MOTION_DEFAULT].NUM_KEY; key++ ){
			//motion[MOTION_DEFAULT].keyFrameMotion[ key ].pose = new D3DXVECTOR3[ NUM_PARTS ];
		}*/
	
		// t[ݒ
		//motion[MOTION_DEFAULT].keyFrameMotion[ 0 ].NUM_FREME = FRAME_MOTION1_KEY0;

		// L[t[Aj[VP
		/*
		for( int index = 0; index < NUM_PARTS; index++ ){
			//motion[MOTION_DEFAULT].keyFrameMotion[ 0 ].pose[index] = ROT_MOTION1_KEY0[index];
		}
	
		// t[ݒ
		//motion[MOTION_DEFAULT].keyFrameMotion[ 1 ].NUM_FREME = FRAME_MOTION1_KEY1;

		// L[t[Aj[VQ
		for( int index = 0; index < NUM_PARTS; index++ ){
			//motion[MOTION_DEFAULT].keyFrameMotion[ 1 ].pose[index] = ROT_MOTION1_KEY1[index];
		}
	}

	{
		//motion[MOTION_1].NUM_KEY = NUM_KEY_MOTION2;
		//motion[MOTION_1].LOOP_FLAG = LOOP_MOTION2;

		// ftHgAj[VAj[Vm
		//motion[MOTION_1].keyFrameMotion = new MOTION_DATA[motion[MOTION_1].NUM_KEY];

		// 񑩏_p[clm
		for( int key = 0; key < motion[MOTION_1].NUM_KEY; key++ ){
			//motion[MOTION_1].keyFrameMotion[ key ].pose = new D3DXVECTOR3[ NUM_PARTS ];
		}
	
		// t[ݒ
		//motion[MOTION_1].keyFrameMotion[ 0 ].NUM_FREME = FRAME_MOTION2_KEY0;

		// L[t[Aj[VP
		for( int index = 0; index < NUM_PARTS; index++ ){
			//motion[MOTION_1].keyFrameMotion[ 0 ].pose[index] = ROT_MOTION2_KEY0[index];
		}
	
	}

	{
		//motion[MOTION_2].NUM_KEY = NUM_KEY_MOTION3;
		//motion[MOTION_2].LOOP_FLAG = LOOP_MOTION3;

		// ftHgAj[VAj[Vm
		//motion[MOTION_2].keyFrameMotion = new MOTION_DATA[motion[MOTION_2].NUM_KEY];

		// 񑩏_p[clm
		for( int key = 0; key < motion[MOTION_2].NUM_KEY; key++ ){
			//motion[MOTION_2].keyFrameMotion[ key ].pose = new D3DXVECTOR3[ NUM_PARTS ];
		}
	
		// t[ݒ
		//motion[MOTION_2].keyFrameMotion[ 0 ].NUM_FREME = FRAME_MOTION3_KEY0;

		// L[t[Aj[VP
		for( int index = 0; index < NUM_PARTS; index++ ){
			//motion[MOTION_2].keyFrameMotion[ 0 ].pose[index] = ROT_MOTION3_KEY0[index];
		}

		// t[ݒ
		//motion[MOTION_2].keyFrameMotion[ 1 ].NUM_FREME = FRAME_MOTION3_KEY1;

		// L[t[Aj[VP
		for( int index = 0; index < NUM_PARTS; index++ ){
			//motion[MOTION_2].keyFrameMotion[ 1 ].pose[index] = ROT_MOTION3_KEY1[index];
		}

		// t[ݒ
		//motion[MOTION_2].keyFrameMotion[ 2 ].NUM_FREME = FRAME_MOTION3_KEY2;

		// L[t[Aj[VP
		for( int index = 0; index < NUM_PARTS; index++ ){
			//motion[MOTION_2].keyFrameMotion[ 2 ].pose[index] = ROT_MOTION3_KEY2[index];
		}

	
	}
		
	{
		//motion[MOTION_3].NUM_KEY = NUM_KEY_MOTION4;
		//motion[MOTION_3].LOOP_FLAG = LOOP_MOTION4;

		// ftHgAj[VAj[Vm
		//motion[MOTION_3].keyFrameMotion = new MOTION_DATA[motion[MOTION_3].NUM_KEY];

		// 񑩏_p[clm
		for( int key = 0; key < motion[MOTION_3].NUM_KEY; key++ ){
			//motion[MOTION_3].keyFrameMotion[ key ].pose = new D3DXVECTOR3[ NUM_PARTS ];
		}
	
		// t[ݒ
		//motion[MOTION_3].keyFrameMotion[ 0 ].NUM_FREME = FRAME_MOTION4_KEY0;

		// L[t[Aj[VP
		for( int index = 0; index < NUM_PARTS; index++ ){
			//motion[MOTION_3].keyFrameMotion[ 0 ].pose[index] = ROT_MOTION4_KEY0[index];
		}
	
		// t[ݒ
		//motion[MOTION_3].keyFrameMotion[ 1 ].NUM_FREME = FRAME_MOTION4_KEY1;

		// L[t[Aj[VP
		for( int index = 0; index < NUM_PARTS; index++ ){
			//motion[MOTION_3].keyFrameMotion[ 1 ].pose[index] = ROT_MOTION4_KEY1[index];
		}

	}

	{
		//motion[MOTION_END].NUM_KEY = NUM_KEY_MOTION5;
		//motion[MOTION_END].LOOP_FLAG = LOOP_MOTION5;

		// ftHgAj[VAj[Vm
		//motion[MOTION_END].keyFrameMotion = new MOTION_DATA[motion[MOTION_END].NUM_KEY];

		// 񑩏_p[clm
		for( int key = 0; key < motion[MOTION_END].NUM_KEY; key++ ){
			//motion[MOTION_END].keyFrameMotion[ key ].pose = new D3DXVECTOR3[ NUM_PARTS ];
		}
	
		// t[ݒ
		//motion[MOTION_END].keyFrameMotion[ 0 ].NUM_FREME = FRAME_MOTION5_KEY0;

		// L[t[Aj[VP
		for( int index = 0; index < NUM_PARTS; index++ ){
			//motion[MOTION_END].keyFrameMotion[ 0 ].pose[index] = ROT_MOTION5_KEY0[index];
		}

		// t[ݒ
		//motion[MOTION_END].keyFrameMotion[ 1 ].NUM_FREME = FRAME_MOTION5_KEY1;

		// L[t[Aj[VP
		for( int index = 0; index < NUM_PARTS; index++ ){
			//motion[MOTION_END].keyFrameMotion[ 1 ].pose[index] = ROT_MOTION5_KEY1[index];
		}*/

	
	}



}





