/***************************************************************/
//
//
//		DirectX	[ import.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 1/15
/*---------------------------------------------------------------
Update : 2017/1/15
			import.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

#include "main.h"
#include "import.h"

#include "base_player.h"
#include "model.h"

#ifdef _DEBUG
#include "d_console.h"
#include "d_manager.h"				// JX^msg̎gp
#endif // _DEBUG

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")

#include "team_manager.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/


#define CHARACTERSET     (  2 )		// LN^[Zbgʒu
#define END_CHARACTERSET ( 17 )		// LN^[Zbgʒu
#define PARTSSET         (  4 )		// LN^[Zbgʒu
#define END_PARTSSET     ( 16 )		// LN^[Zbgʒu
#define MOTIONSET        ( 10 )		// LN^[Zbgʒu
#define END_MOTIONSET    ( 20 )		// LN^[Zbgʒu
#define KEYSET           ( 13 )		// LN^[Zbgʒu
#define END_KEYSET       ( 19 )		// LN^[Zbgʒu
#define KEY              ( 15 )		// LN^[Zbgʒu
#define END_KEY          ( 18 )		// LN^[Zbgʒu

#define DEFAULT_MOTION_CREATE (5)	// ݒ肳ĂȂꍇ̃[V쐬


// f[^\
typedef struct{
	D3DXVECTOR3 pos;
	D3DXVECTOR3 rot;
}STATUS;

// f[^\
typedef struct{
	STATUS status;
	int index;
	int parentNumber;
}OFFSET_DATA;


// ֐|C^̌^
typedef void (*MadeFunc)( CBasePlayer*, char*, int* );

typedef CTeamManager* (*pFunc)( void );

// `Nf[^̒萔
const int NUM_CHANK = 16;

// f[^`N
const char* CHANK_DATA[ ] = {

	"NUM_MODEL",					// 1:
	"MODEL_FILENAME",				// 2:
	"CHARACTERSET",					// 3:
	"NUM_PARTS",					// 4:
	"PARTSSET",						// 5:
	"INDEX",						// 6:
	"PARENT",						// 7:
	"POS",							// 8:
	"ROT",							// 9:
	"NUM_MOTION",					// 10:
	"MOTIONSET",					// 11:
	"LOOP",							// 12:
	"NUM_KEY",						// 13:
	"KEYSET",						// 14:
	"FRAME",						// 15:
	"KEY",							// 16:
	"END_PARTSSET",					// 17:
	"END_CHARACTERSET",				// 18:
	"END_KEY",						// 19:
	"END_KEYSET",					// 20:
	"END_MOTIONSET",				// 21:
	"END_SCRIPT",					// 22:

	"MOVE",							// 23:
	"JUMP",							// 24:
	"COLLISION",					// 25:

};

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

// f[^ꎞi[p
static OFFSET_DATA* dataBox = nullptr;

static int motionIndex = 0;
static int keyIndex    = 0;
static int partsIndex  = 0;

// ֐|C^
MadeFunc AddressProcessFunc[ NUM_CHANK ] = {

	CNK_LoadModelNumber,
	CNK_PartsLoad,
	CNK_CharSet,
	CNK_LoadPartsNumber,
	CNK_PartsOffset,
	CNK_LoadOffsetIndexNumber,
	CNK_LoadOffsetParentNumber,
	CNK_LoadOffsetPosition,
	CNK_LoadOffsetRotation,
	CNK_LoadMotionNumber,
	CNK_MotionSet,
	CNK_LoadMotionLoopFlag,
	CNK_LoadMotionKeyNumber,
	CNK_MotionKeySet,
	CNK_LoadKeyframe,
	CNK_MotionKeyInfo,
};

pFunc pFunction[ 1 ] = {

	CTeamManager::Create,
};




// txtf[^̓ǂݍ
void LoadTxt( const char* FILE_NAME, CBasePlayer* pData )
{

	FILE* pfile;

	// f[^i[p
	char* txtData;
	

	// t@CTCY𒲂ׂăt@Cǂݍ
	pfile = fopen( FILE_NAME, "rb" );
	if( pfile != NULL )	{
		// t@CTCY擾
		fseek( pfile, 0, SEEK_END );
		unsigned int size = ftell( pfile );						// t@CTCY擾
		fseek( pfile, 0, SEEK_SET );

		// obt@m
		txtData = new char[ size ]; 

		// t@Cǂݍ
		fread( txtData, size, 1, pfile );

		// t@CI
		fclose( pfile );

	}else{
		#ifdef _DEBUG
		#ifdef _DEBUGMANAGER_H_
		CDebugManager::DebugMsg( " TXT_FILE_NAME : %s ", FILE_NAME );
		#endif // _DEBUGMANAGER_H_
		#endif // _DEBUG
		return;
	}


	// i[p
	char buf[256] = {};
	int  bufIndex = 0;
	motionIndex = 0;
	keyIndex    = 0;
	partsIndex  = 0;

	#ifdef _DEBUG
	int i = strlen( txtData );
	#endif // _DEBUG

	// txtf[^̓ǂݍ
	for( int index = 0; index < strlen( txtData ); index++ ){


		// ' '()Ȃ玟
		if( txtData[index] == ' ' ){
			continue;
		}

		// RgAEg
		CommentSkip( txtData, &index );
		
		// obt@ւ̃f[^̃C|[g
		ImportData( buf, &bufIndex, txtData, index );
		
		// f[^GNX|[g
		if( txtData[index] == '\n' || txtData[index] == '=' ){
			
			// Zo
			for( int search = 0; search < NUM_CHANK; search++ ){
				if( strcmp( buf, CHANK_DATA[search] ) == 0 ){
					AddressProcessFunc[ search ]( pData, txtData, &index );
					break;
				}
			}
			DeleteBuffer( buf, &bufIndex );
			continue;
		}

	}


	// t@CI
	SAFE_DELETE_ARRAY( dataBox )  
	SAFE_DELETE_ARRAY( txtData )



}

// `Nf[^̎擾
void CNK_LoadModelNumber( CBasePlayer* pOut, char* buf, int* index )
{

	char dataBuf[256] = { };
	int dataIndex = 0;


	// txtf[^̓ǂݍ
	for( ; buf[*index] != '\n'; (*index)++ ){

		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			continue;
		}

		// RgAEg
		CommentSkip( buf, index );

		// obt@ւ̃f[^̃C|[g
		ImportStatus( dataBuf, &dataIndex, buf, *index );

	}

	// ff[^쐬
	if( atoi( dataBuf ) ){
	
		// f[h
		pOut->NUM_MODEL = atoi( dataBuf );

		pOut->parts = new CModel[ pOut->NUM_MODEL ];
	}


}

// `Nf[^̎擾
void CNK_PartsLoad( CBasePlayer* pOut, char* buf, int* index )
{

	char dataBuf[256] = { };
	int dataIndex = 0;

	if( !pOut->NUM_MODEL ){
		return;
	}

	// txtf[^̓ǂݍ
	for( ; buf[*index] ; (*index)++ ){
	
		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			continue;
		}

		// RgAEg
		CommentSkip( buf, index );

		if( buf[*index] == '=' ){
			DeleteBuffer( dataBuf, &dataIndex );
			continue;
		}

		// obt@ւ̃f[^̃C|[g
		ImportData( dataBuf, &dataIndex, buf, *index );
		
		// sȂ玟
		if( buf[*index] == '\n' ){
			break;
		}

	}

	// gΏ
	if( dataBuf ){

		// Xt@C[h
		for( int i = 0; i < pOut->NUM_MODEL; i++ ){
			if( !pOut->parts[i].pBufMatModel ){

				pOut->parts[i].LoadXFile( dataBuf );
				DeleteBuffer( dataBuf, &dataIndex );
				break;
			}
		}
	}


}

// `Nf[^̎擾
void CNK_CharSet( CBasePlayer* pOut, char* buf, int* index )
{

	char dataBuf[256] = { };
	int dataIndex = 0;

	bool flag = true;

	// f[^{bNX쐬
	SAFE_DELETE_ARRAY( dataBox );
	dataBox = new OFFSET_DATA[1];

	// txtf[^̓ǂݍ
	for( ; flag ; (*index)++ ){
	
		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			continue;
		}

		// RgAEg
		CommentSkip( buf, index );

		// obt@ւ̃f[^̃C|[g
		ImportData( dataBuf, &dataIndex, buf, *index );

		// f[^GNX|[g
		if( buf[*index] == '\n' || buf[*index] == '=' ){

			// `NI
			if( strcmp( CHANK_DATA[ END_CHARACTERSET ], dataBuf ) == 0 ){
				flag = false;
			}
		
			// Zo
			for( int search = 0; search < NUM_CHANK; search++ ){
				if( strcmp( dataBuf, CHANK_DATA[search] ) == 0 ){
					if( search != CHARACTERSET ){
						AddressProcessFunc[ search ]( pOut, buf, index );
						break;
					}
				}
			}
			DeleteBuffer( dataBuf, &dataIndex );
			continue;
		}

	}

	// Ô߃obt@폜
	SAFE_DELETE_ARRAY( dataBox )

}

// `Nf[^̎擾
void CNK_LoadPartsNumber( CBasePlayer* pOut, char* buf, int* index )
{

	char dataBuf[256] = { };
	int dataIndex = 0;


	// txtf[^̓ǂݍ
	for( ; buf[*index] != '\n'; (*index)++ ){
	
		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			continue;
		}

		// RgAEg
		CommentSkip( buf, index );

		// obt@ւ̃f[^̃C|[g
		ImportStatus( dataBuf, &dataIndex, buf, *index );

	}

	// p[c[h
	pOut->NUM_PARTS = atoi( dataBuf );


}

// `Nf[^̎擾
void CNK_PartsOffset( CBasePlayer* pOut, char* buf, int* index )
{

	char dataBuf[256] = { };
	int dataIndex = 0;

	bool flag = true;


	// LZbg`Nݒ肵ĂȂꍇ
	if( !dataBox ){
		return;
	}

	// txtf[^̓ǂݍ
	for( ; flag ; (*index)++ ){
	
		// RgAEg
		CommentSkip( buf, index );

		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			continue;
		}

		// obt@ւ̃f[^̃C|[g
		ImportData( dataBuf, &dataIndex, buf, *index );

		if( strcmp( CHANK_DATA[ END_PARTSSET ], dataBuf ) == 0 ){
			flag = false;
		}

		// f[^GNX|[g
		if( buf[*index] == '=' ){
		
			// Zo
			for( int search = 0; search < NUM_CHANK; search++ ){
				if( strcmp( dataBuf, CHANK_DATA[search] ) == 0 ){
					if( search != PARTSSET ){
						AddressProcessFunc[ search ]( pOut, buf, index );
						break;
					}
				}
			}
			DeleteBuffer( dataBuf, &dataIndex );
			continue;
		}

		// sȂ玟
		if( buf[*index] == '\n' ){

			// Zo
			for( int search = 0; search < NUM_CHANK; search++ ){
				if( strcmp( dataBuf, CHANK_DATA[search] ) == 0 ){
					if( search != CHARACTERSET ){
						AddressProcessFunc[ search ]( pOut, buf, index );
						break;
					}
				}
			}
			DeleteBuffer( dataBuf, &dataIndex );
			continue;
		}


	}

	// f[^{bNXJ
	pOut->parts[ dataBox->index ].pos = dataBox->status.pos;
	pOut->parts[ dataBox->index ].rot = dataBox->status.rot;
	pOut->parts[ dataBox->index ].parentStatus = dataBox->parentNumber;

	/*
	// f[^{bNXj
	SAFE_DELETE_ARRAY( dataBox )
	*/

}

// `Nf[^̎擾
void CNK_LoadOffsetIndexNumber( CBasePlayer* pOut, char* buf, int* index )
{

	char dataBuf[256] = { };
	int dataIndex = 0;


	// txtf[^̓ǂݍ
	for( ; buf[*index] ; (*index)++ ){
	
		// RgAEg
		CommentSkip( buf, index );

		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			continue;
		}

		if( buf[*index] == '\n' ){
			break;
		}

		// obt@ւ̃f[^̃C|[g
		ImportData( dataBuf, &dataIndex, buf, *index );

	}

	// p[c[h
	if( atoi( dataBuf ) < 100 && atoi( dataBuf ) >= 0 ){
		dataBox->index = atoi( dataBuf );
	}


}

// `Nf[^̎擾
void CNK_LoadOffsetParentNumber( CBasePlayer* pOut, char* buf, int* index )
{

	char dataBuf[256] = { };
	int dataIndex = 0;


	// txtf[^̓ǂݍ
	for( ; buf[*index] ; (*index)++ ){
	
		// RgAEg
		CommentSkip( buf, index );

		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			continue;
		}

		if( buf[*index] == '\n' ){
			break;
		}

		// obt@ւ̃f[^̃C|[g
		ImportData( dataBuf, &dataIndex, buf, *index );

	}

	// p[c[h
	dataBox->parentNumber = atoi( dataBuf );



}

// `Nf[^̎擾
void CNK_LoadOffsetPosition( CBasePlayer* pOut, char* buf, int* index )
{

	char dataBuf[3][256] = { };
	int dataCount = 0;
	int dataIndex = 0;


	// txtf[^̓ǂݍ
	for( ; buf[*index] ; (*index)++ ){
	
		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			
			if( dataIndex ){
				dataCount++;
				dataIndex = 0;
			}
			continue;
		}

		// RgAEg
		CommentSkip( buf, index );

		if( buf[*index] == '\n' ){
			break;
		}

		// obt@ւ̃f[^̃C|[g
		ImportStatus( dataBuf[dataCount], &dataIndex, buf, *index );

	}


	// W擾
	if(  partsIndex < pOut->NUM_PARTS ) {
		dataBox[ partsIndex ].status.pos.x = atof( dataBuf[0] );
		dataBox[ partsIndex ].status.pos.y = atof( dataBuf[1] );
		dataBox[ partsIndex ].status.pos.z = atof( dataBuf[2] );
	}


}

// `Nf[^̎擾
void CNK_LoadOffsetRotation( CBasePlayer* pOut, char* buf, int* index )
{

	char dataBuf[3][256] = { };
	int dataCount = 0;
	int dataIndex = 0;


	// txtf[^̓ǂݍ
	for( ; buf[*index] ; (*index)++ ){
	
		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			
			if( dataIndex ){
				dataCount++;
				dataIndex = 0;
			}
			continue;
		}

		// RgAEg
		CommentSkip( buf, index );

		if( buf[*index] == '\n' ){
			break;
		}

		// obt@ւ̃f[^̃C|[g
		ImportStatus( dataBuf[dataCount], &dataIndex, buf, *index );

	}

	// W擾
	if( partsIndex < pOut->NUM_PARTS ) {
		dataBox[ partsIndex ].status.rot.x = atof( dataBuf[0] );
		dataBox[ partsIndex ].status.rot.y = atof( dataBuf[1] );
		dataBox[ partsIndex ].status.rot.z = atof( dataBuf[2] );
	}

	#ifdef _DEBUG
	//CConsole::DebugLog( "key[%d] : [%d] rot : %f, %f, %f \n", keyIndex, partsIndex, dataBox[ partsIndex ].status.rot.x, dataBox[ partsIndex ].status.rot.y, dataBox[ partsIndex ].status.rot.z ); 
	#endif


}

// `Nf[^̎擾
void CNK_EmptyProcess( CBasePlayer* pOut, char* buf, int* index )
{

	// Ȃ

}

// `Nf[^̎擾
void CNK_LoadMotionNumber( CBasePlayer* pOut, char* buf, int* index )
{

	char dataBuf[256] = { };
	int dataIndex = 0;


	// txtf[^̓ǂݍ
	for( ; buf[*index] ; (*index)++ ){
	
		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			continue;
		}

		// RgAEg
		CommentSkip( buf, index );

		if( buf[*index] == '\n' ){
			break;
		}

		// obt@ւ̃f[^̃C|[g
		ImportStatus( dataBuf, &dataIndex, buf, *index );

	}

	// 쐬[Vi[
	int motionNumber = atoi( dataBuf );

	// [Vf[^쐬
	pOut->motion = new MOTION[ motionNumber ];


}

// `Nf[^̎擾
void CNK_MotionSet( CBasePlayer* pOut, char* buf, int* index )
{

	char dataBuf[256] = { };
	int dataIndex = 0;

	bool flag = true;


	// ݒȂ
	if( !pOut->motion ){
		pOut->motion = new MOTION[5];
	}

	// f[^{bNX쐬
	if( !dataBox ){
		// p[cm
		dataBox = new OFFSET_DATA[ pOut->NUM_PARTS ];
	}


	// q̃CfbNX
	keyIndex   = 0;
	partsIndex = 0;

	// txtf[^̓ǂݍ
	for( ; flag ; (*index)++ ){
	

		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			continue;
		}

		// RgAEg
		CommentSkip( buf, index );

		// obt@ւ̃f[^̃C|[g
		ImportData( dataBuf, &dataIndex, buf, *index );

		// `NI
		if( strcmp( CHANK_DATA[ END_MOTIONSET ], dataBuf ) == 0 ){
			flag = false;
		}


		// f[^GNX|[g
		if( buf[*index] == '\n' || buf[*index] == '=' ){
		
			// Zo
			for( int search = 0; search < NUM_CHANK; search++ ){
				if( strcmp( dataBuf, CHANK_DATA[search] ) == 0 ){
					if( search != MOTIONSET ){
						AddressProcessFunc[ search ]( pOut, buf, index );
						break;
					}
				}
			}
			DeleteBuffer( dataBuf, &dataIndex );
			continue;
		}

	}

	// ҏW̃[VCfbNXXV
	motionIndex++;




}

// `Nf[^̎擾
void CNK_LoadMotionLoopFlag( CBasePlayer* pOut, char* buf, int* index )
{

	char dataBuf[256] = { };
	int dataIndex = 0;


	// txtf[^̓ǂݍ
	for( ; buf[*index] ; (*index)++ ){
	
		// RgAEg
		CommentSkip( buf, index );

		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			continue;
		}

		if( buf[*index] == '\n' ){
			break;
		}

		// obt@ւ̃f[^̃C|[g
		ImportStatus( dataBuf, &dataIndex, buf, *index );

	}

	// 쐬[Vi[
	pOut->motion[motionIndex].LOOP_FLAG = (bool)atoi( dataBuf );




}

// `Nf[^̎擾
void CNK_LoadMotionKeyNumber( CBasePlayer* pOut, char* buf, int* index )
{

	char dataBuf[256] = { };
	int dataIndex = 0;


	// txtf[^̓ǂݍ
	for( ; buf[*index] ; (*index)++ ){
	
		// RgAEg
		CommentSkip( buf, index );

		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			continue;
		}

		if( buf[*index] == '\n' ){
			break;
		}

		// obt@ւ̃f[^̃C|[g
		ImportStatus( dataBuf, &dataIndex, buf, *index );

	}

	// 쐬[Vi[
	pOut->motion[motionIndex].NUM_KEY = atoi( dataBuf );

	// ftHgAj[VAj[Vm
	pOut->motion[ motionIndex ].keyFrameMotion = new MOTION_DATA[ pOut->motion[motionIndex].NUM_KEY ];

	// 񑩏_p[clm
	for( int key = 0; key < pOut->motion[ motionIndex ].NUM_KEY; key++ ){
		pOut->motion[ motionIndex ].keyFrameMotion[ key ].pose = new D3DXVECTOR3[ pOut->NUM_PARTS ];
	}


}

// `Nf[^̎擾
void CNK_MotionKeySet( CBasePlayer* pOut, char* buf, int* index )
{


	char dataBuf[256] = { };
	int dataIndex = 0;

	bool flag = true;

	/*
	// f[^{bNX쐬
	if( dataBox ){
		SAFE_DELETE_ARRAY( dataBox )
	}

	// p[cm
	dataBox = new OFFSET_DATA[ pOut->NUM_PARTS ];
	 */

	// MOTIONSET`Nݒ肳ĂȂꍇ
	if( !dataBox ){
		return;
	}

	// q̃CfbNX
	partsIndex = 0;


	// txtf[^̓ǂݍ
	for( ; flag ; (*index)++ ){
	
		// RgAEg
		CommentSkip( buf, index );

		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			continue;
		}

		// obt@ւ̃f[^̃C|[g
		ImportData( dataBuf, &dataIndex, buf, *index );

		// `NI
		if( strcmp( CHANK_DATA[ END_KEYSET ], dataBuf ) == 0 ){
			flag = false;
		}

		// f[^GNX|[g
		if( buf[*index] == '\n' || buf[*index] == '=' ){
		
			// Zo
			for( int search = 0; search < NUM_CHANK; search++ ){
				if( strcmp( dataBuf, CHANK_DATA[search] ) == 0 ){
					if( search != KEYSET ){
						AddressProcessFunc[ search ]( pOut, buf, index );
						break;
					}
				}
			}
			DeleteBuffer( dataBuf, &dataIndex );
			continue;
		}


	}

	// f[^{bNXJ
	for( int i = 0; i < pOut->NUM_PARTS; i++ ){

		//pOut->parts[ dataBox->index ].pos = dataBox->status.pos;
		pOut->motion[ motionIndex ].keyFrameMotion[ keyIndex ].pose[ i ] = dataBox[ i ].status.rot;
	}

	/*
	// f[^{bNXj
	SAFE_DELETE_ARRAY( dataBox )
	*/

	// ҏW̃L[CfbNXXV 
	keyIndex++;


}

// `Nf[^̎擾
void CNK_LoadKeyframe( CBasePlayer* pOut, char* buf, int* index )
{

	char dataBuf[256] = { };
	int dataIndex = 0;

	if( partsIndex != 0 ){
	
		#ifdef _DEBUG
		MessageBox( NULL, "sȃZbgł", " ERROR !! ", MB_OK | MB_ICONWARNING );
		#endif // _DEBUG
		return;
	}

	// txtf[^̓ǂݍ
	for( ; buf[*index] ; (*index)++ ){
	
		// RgAEg
		CommentSkip( buf, index );

		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			continue;
		}

		if( buf[*index] == '\n' ){
			break;
		}

		// obt@ւ̃f[^̃C|[g
		ImportStatus( dataBuf, &dataIndex, buf, *index );

	}

	// 쐬[Vi[
	pOut->motion[ motionIndex ].keyFrameMotion[ keyIndex ].NUM_FREME = atoi( dataBuf );


}

// `Nf[^̎擾
void CNK_MotionKeyInfo( CBasePlayer* pOut, char* buf, int* index )
{


	char dataBuf[256] = { };
	int dataIndex = 0;

	bool flag = true;


	// txtf[^̓ǂݍ
	for( ; flag ; (*index)++ ){
	
		// RgAEg
		CommentSkip( buf, index );

		// ' '()Ȃ玟
		if( buf[*index] == ' ' ){
			continue;
		}

		// obt@ւ̃f[^̃C|[g
		ImportData( dataBuf, &dataIndex, buf, *index );

		// f[^GNX|[g
		if( buf[*index] == '=' || buf[*index] == '\n' ){
		
			// `NI
			if( strcmp( CHANK_DATA[ END_KEY ], dataBuf ) == 0 ){
				flag = false;
				(*index)--;
			}

			// Zo
			for( int search = 0; search < NUM_CHANK; search++ ){
				if( strcmp( dataBuf, CHANK_DATA[search] ) == 0 ){
					if( search != KEY ){
						AddressProcessFunc[ search ]( pOut, buf, index );
						break;
					}
				}
			}
			DeleteBuffer( dataBuf, &dataIndex );
			continue;
		}


	}

	// ҏW̃L[CfbNXXV 
	partsIndex++;


}

// obt@ւ̃f[^̊i[
void ImportData( char* out, int* pointer, const char* buf, const int index )
{

	// p啶͈͓
	if( buf[index] >= 65 && buf[index] <= 90 ){
	
		// ASCIIf[^i[
		out[ *pointer ] = buf[index];
		(*pointer)++;
		return;
	}

	// oȑꍇi[
	if( ( buf[index] >= 48 && buf[index] <= 57 ) ||			// ͈͓̔
		//( buf[index] >= 65 && buf[index] <= 90 ) ||		// p啶͈͓
		( buf[index] >= 97 && buf[index] <= 122) ||			// p͈͓
		( buf[index] == '_' || 	buf[index] == '.' ||		// vXǂݎ肽
		buf[index] == '/' || buf[index] == '-')){			

		// ASCIIf[^i[
		out[ *pointer ] = buf[index];
		(*pointer)++;
	}

}

// obt@ւ̃f[^i[Zq
void ImportStatus( char* out, int* pointer, const char* buf, const int index )
{

	// ͈͓̔
	if( buf[index] >= 48 && buf[index] <= 57 ){
	
		// ASCIIf[^i[
		out[ *pointer ] = buf[index];
		(*pointer)++;
		return;
	}

	// ZqƓ_
	if( buf[index] == '-' || buf[index] == '.' ){		// vXǂݎ肽

		// ASCIIf[^i[
		out[ *pointer ] = buf[index];
		(*pointer)++;
	}


}

// i[obt@̍폜
void DeleteBuffer( char* buf, int* index )
{

	#ifdef _DEBUG
	//CConsole::DebugLog( buf ); 
	//CConsole::DebugLog( "\n" );
	#endif

	for( ; (*index); (*index)-- ){
	
		buf[ (*index)-1 ] = '\0';
	}

}

// RgAEg
void CommentSkip( char* buf, int* index )
{

	// RgAEg
	if( buf[ (*index) ] == '#' ){
		
		for( ; buf[ (*index) ] != '\n'; ){
			(*index)++;
		}
	}


}


