/***************************************************************/
//
//
//		DirectX	[ model.cpp ]
//
//											Author	kazuki tanaka
//											Date	2016 10/26
/*---------------------------------------------------------------
Update : 2016/10/26
			model.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include "main.h"
#include "model.h"

#define _USE_MATH_DEFINES
#include <math.h>
#include "input.h"

#include "camera.h"

#include "d_console.h"


#include "game_equation.h"

#include "explosion.h"

#include "model_manager.h"

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/

/*---------------------------------------------------------------
	X^eBbNoϐ̏
---------------------------------------------------------------*/



// IuWFNg̃RXgN^
CModel::CModel( )
{

	// oϐ̏
	pMeshModel = nullptr;							// bVC^[tFCX|C^
	pBufMatModel = nullptr;							// }eA
	nNumMatModel = 0;								// }eA

	pTexture = nullptr;								// eNX`|C^̃|C^

	// f[h}gNX
	D3DXMatrixIdentity( &translationMtx );			// sړs
	D3DXMatrixIdentity( &rotationMtx );				// f]ss

	// 1t[̕ω
	translateValue = D3DXVECTOR3( 0, 0, 0 );		// fW
	rotationValue = D3DXVECTOR3( 0, 0, 0 );			// f]

	parentStatus = 0;								// eq

}

// IuWFNg̃fXgN^
CModel::~CModel( )
{

	// Ȃ

}

// IuWFNg̏
void CModel::Init( void )
{

	// Ȃ

}

// IuWFNg̏I
void CModel::Uninit( void )
{
	
	// Ȃ
	D3DXMATERIAL* pMat =( D3DXMATERIAL*)pBufMatModel -> GetBufferPointer( );
	for( int index = 0; index < (int)nNumMatModel; index++ ){
		pTexture[ index ]->Release( );
	}
	SAFE_DELETE_ARRAY( pTexture )
	SAFE_RELEASE( pBufMatModel )
	SAFE_RELEASE( pMeshModel )
	
}

// IuWFNg̍XV
void CModel::Update( void )
{

	// Ȃ

}

// IuWFNg̕`
void CModel::Draw( void )
{
	

	// Pʍsւ̏( sPʍsɂ )
	D3DXMatrixIdentity( &worldMtx );

	// foCXɃ[hϊsݒ
	pDevice ->SetTransform( D3DTS_WORLD, &worldMtx );

	// ݃foCXɐݒ肳Ă}eA̎擾
	D3DMATERIAL9 matDef;
	pDevice -> GetMaterial( &matDef );

	// }eÃ|C^ƂăAhX擾
	D3DXMATERIAL* pMat =( D3DXMATERIAL*)pBufMatModel -> GetBufferPointer( );

	for( int index = 0; index < (int)nNumMatModel; index++ ){

		// foCXɃ}eAݒ
		pDevice -> SetMaterial( &pMat[ index ].MatD3D );

		// eNX`ݒ
		if( !pTexture[index] ){
			pDevice -> SetTexture( 0, pTexture[index] );
		}else{
			pDevice -> SetTexture( 0, NULL );		
		}

		// MODEL`
		pMeshModel->DrawSubset( index );
	}

	pDevice -> SetMaterial( &matDef );


}

// IuWFNg̍쐬
CModel* CModel::Create( void )
{

	// foCX̎擾
	if( !pDevice ){
	
		pDevice = GetDevice( );
	}

	// IuWFNg̍쐬
	CModel* pObject;
	pObject = new CModel;


	return pObject;

}

// Xt@C̃[h
void CModel::LoadXFile( const char* XFILE_NAME )
{

	HRESULT hr;
	char str[256] = { };

	#ifdef _MODELMANAGER_H_ ////////////////////////////////////////////////////
	// t@C}l[W[ꍇ̏

	MODEL_DATA* data = CModelManager::Bind( XFILE_NAME );
	
	if( data ){

		// ff[^i[
		pBufMatModel = data->pBufMat;
		nNumMatModel = data->nNumMat;
		pMeshModel   = data->pMesh;

		// }eÃ|C^ƂăAhX擾
		D3DXMATERIAL* pMat =( D3DXMATERIAL*)pBufMatModel -> GetBufferPointer( );

		// eNX`obt@
		pTexture = new LPDIRECT3DTEXTURE9[ (int)data->nNumMat ];

		// eNX`|C^쐬
		for( int index = 0; index < (int)nNumMatModel; index++ ){

			pTexture[index] = data->pTexture[index];
		}
		return;
	}
	
	#endif // _MODELMANAGER_H_ //////////////////////////////////////////////////


	// Xt@C̃[h	
	hr = D3DXLoadMeshFromX( 
		XFILE_NAME,
		D3DXMESH_MANAGED,
		pDevice,
		NULL,
		&pBufMatModel,
		NULL,
		&nNumMatModel,
		&pMeshModel );
	if( FAILED( hr )){
		#ifdef _DEBUG
			#ifdef _DEBUGMANAGER_H_
			CDebugManager::DebugMsg( " [ %s ] MODEL LOAD ERROR!! \n index : [ %d ] \n ERROR_CODE : 0x%x ", MODEL_NAME, index, hr );
			#endif // _DEBUGMANAGER_H_
		#endif	// _DEBUG
	}else{ 
	// TEXTURE LOAD
	
		// }eÃ|C^ƂăAhX擾
		D3DXMATERIAL* pMat =( D3DXMATERIAL*)pBufMatModel -> GetBufferPointer( );

		// eNX`obt@
		pTexture = new LPDIRECT3DTEXTURE9[ (int)nNumMatModel ];

		for( int index = 0; index < (int)nNumMatModel; index++ ){

			// eNX`̓ǂݍ 
			hr = D3DXCreateTextureFromFile( pDevice, pMat[ index ].pTextureFilename, &pTexture[index] );
			if( FAILED( hr )) {

				// NULLleNX`}eA
				pTexture[index] = NULL;
			}
		}
	}	// -> END TEXTURE LOAD PROCESS



}

