/***************************************************************/
//
//
//		DirectX	[ object.h ]
//
//											Author	kazuki tanaka
//											Date	2017 1/14
/*---------------------------------------------------------------
Update : 2017/1/7
			debugmanager.h̍쐬
			CObject̍쐬
			CLASS : CObject
				CObject::Init̒ǉ
				CObject::Uninit̒ǉ
				CObject::Update̒ǉ
				CObject::Draw̒ǉ

Update : 2016/1/7



/*-------------------------------------------------------------*/
#ifndef _OBJECT_H_

#define _OBJECT_H_


/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include <vector>
#include <map>

using namespace std;      								// WCuOԎw

#define  OBJECT_MAX (512)

/*---------------------------------------------------------------
	CLASS
-----------------------------------------------------------------*/

typedef struct
{
	char name[16];
	int  number; 
}DETABASE;

// x[XIuWFNgNX
class CObject
{
public:
		
	CObject();											// IuWFNg̃RXgN^
	~CObject();											// IuWFNg̃fXgN^
	
	virtual void Init( void );							// IuWFNg̏
	virtual void Uninit( void );						// IuWFNg̏I
	virtual void Update( void );						// IuWFNg̍XV
	virtual void Draw( void );							// IuWFNg̕`揈
	
	D3DXMATRIX CalcObjWorldMtx( void );					// IuWFNg̃[hsZo
	
	// X^eBbNo֐
	static CObject* Create( void );						// IuWFNg̍쐬
	
	static void UpdateAll( void );						// IuWFNgXV
	static void DrawAll( void );						// }i[W[`揈
	static void ReleaseAll( void );						// SIuWFNg̔j	
	
	static CObject* GetObject( void );					// IuWFNgANZX
	static CObject* GetObject( const char* OBJ_NAME );	// IuWFNgANZX(̂ɂ)
	
	D3DXMATRIX  worldMtx;								// IuWFNg[hs
	D3DXVECTOR3 pos;									// IuWFNgʒuW
	D3DXVECTOR3 rot;									// IuWFNg]

	static LPDIRECT3DDEVICE9 pDevice;					// DirectXfoCX̃AhX
	
protected:
	
	void Release( void );								// IuWFNg̉

	static vector< DETABASE > ID;						// IuWFNgf[^x[X

private:
					
	// X^eBbNoϐ
	//static std::vector<CObject*> pObj;				// IuWFNgAhX
	static CObject* pObj[OBJECT_MAX];					// IuWFNgAhX
	static int counter;									// IuWFNǧ
	
	int myNumber;										// CObjectԍ
	
};



#endif	//	_OBJECT_H_


