/***************************************************************/
//
//
//		DirectX	[ fieldmap.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/29
/*---------------------------------------------------------------
Update : 2017/5/29
			fieldmap.cpp̍쐬
		   
		   2017/6/19 
		    t@Cǂݍŕ\@\ǉ
			t@C\
			(*.txt)
			vertical  
			horizonal
			X^[ǧ Shell̗񋓌^Q
			}bv\

			}bvdata/MAPɓĂ
			}bvLfieldmap.hTYPE񋓌^QƂĂ

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "system_component.h"

#include "k_tutorialmap.h"

#include "gameobject.h"
#include "base.h"

#include "game_equation.h"

#include "castdx9.h"

#include <stdio.h>

#include "immortal.h"
#include "shell.h"
#include "octopus.h"
#include "start.h"
#include "keyboard.h"

#include "explosion.h"

#include "k_polygon3D.h"
#include "k_polygon.h"

#include "k_title.h"


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/
//tH_pX By
#define	MAPFOLDER_PATH	("data/MAP/")

#define HOTATE_OKU_BASYO_X ( 24.0f )
#define HOTATE_OKU_BASYO_Z ( 24.0f )

#define TEXT_SHOW_RATE ( 20 )
#define TEXT_SYUKUSYAKU ( 0.4f )

/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/
//fATYPEɑΉ悤
const char* TutorialMap::MODEL_NAME[TYPE_MAX] =
{
	"" , //NONE
	"data\\MODEL\\tablesango.x" , //IMMORTAL
	"data\\MODEL\\octupas.x" , //GOAL
	"data\\MODEL\\hotate_start.x" , //START 
	"data\\MODEL\\hotate.x" , //MOVE
};

const char* TutorialMap::FILE_NAME[] = {
	"data\\TEXTURE\\down.png",
	"data\\TEXTURE\\right.png",
	"data\\TEXTURE\\up.png",
	"data\\TEXTURE\\left.png",
};

const char* TutorialMap::TEXT_TEXTURE_NAME[] ={
	"data\\TEXTURE\\tutorial00_0.png" ,
	"data\\TEXTURE\\tutorial00_1.png" ,
	"data\\TEXTURE\\tutorial01.png" ,
	"data\\TEXTURE\\tutorial02.png" ,
	"data\\TEXTURE\\tutorial03_0.png" ,
	"data\\TEXTURE\\tutorial03_1.png" ,
	"data\\TEXTURE\\tutorial04_0.png" ,
	"data\\TEXTURE\\tutorial04_1.png" ,
	"data\\TEXTURE\\tutorial05.png" ,
};

/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

TutorialMap* TutorialMap::pMap = nullptr;




// TutorialMap Constructor
TutorialMap::TutorialMap( )
: frame(0)
, state( STATE_CROSSBUTTAN )
, arrow(nullptr)
, Counter(0)
{

	// Menber Clear Process
	if( pMap ){
		delete pMap;
	}
	pMap = this;

	for( int j = 0; j < OBJ_PRIORITY; j++ ){
		for( int i = 0 ; i < NUM_OBJECT ; i++ )
		{
			other[j][i] = nullptr;
		}
	}

	for(int i = 0 ; i < TEXT_MAX ; i++ )
	{
		m_pTexture[i] = nullptr;
	}

}

// TutorialMap Destructor
TutorialMap::~TutorialMap( )
{

	// Do Nothing!!

}

// TutorialMap Create Instance 
TutorialMap* TutorialMap::Create( void )
{

	// Create Class Instance
	return new TutorialMap;

}

// TutorialMap Initialize
void TutorialMap::Init( const char* filename )
{

	// Initialize Process
	if( !pMap ){
		return;
	}
	

	//t@Cǂݍ݋@\ǉ@by
	FILE	*fp = NULL ;	//t@Cp

	char mappath[256] = MAPFOLDER_PATH;
	strcat( mappath , filename );

	//ǂݍ߂`FbN
	if ((fp = fopen( mappath , "r")) == NULL)
	{
		//s
		char	message[100] = "}bvt@Cǂݍ߂܂ : ";
		strcat(message , mappath );
		MessageBox( NULL , message , "ERROR[ fieldmap.cpp ]" , MB_OK | MB_ICONEXCLAMATION );
	}

	char h[16];
	fscanf(fp , "%s" , h );		
	char v[16];
	fscanf(fp , "%s" , v );
	

	vertical  = atoi(h);
	horizonal = atoi(v);
	
	char d[16];
	fscanf(fp , "%s" , d );
	int direction = atoi(d);
	
	const int size = MAP_SIZE;
	Vector2 offset( -(size*pMap->vertical)*0.5f  , size*pMap->horizonal*0.5f  );
	Vector2 objOffset( -(size*pMap->vertical)*0.5f + size * 0.5f  , size*pMap->horizonal*0.5f - size*0.5f );


	map  = new int[(vertical)*(horizonal)];
	pObj = new GameObject*[ vertical*horizonal ];

	int otherCounter = 0;
	
	Console::DebugLog( "txt data \n");
	fgetc(fp);

	for(int z = 0; z < pMap->horizonal; z++ ){
		for(int x = 0; x < pMap->vertical; x++ ){
			
			char c = fgetc(fp);
			int  fleld = atoi(&c);

			Console::DebugLog(" %d", fleld );


			//t@CLō쐬IuWFNgύX
			//VIuWFNgꍇ́AɒǉĂ
			switch	(fleld){
			case IMMORTAL:
				other[0][ otherCounter ] = Model::Instance<Immortal>( MODEL_NAME[ IMMORTAL ] , Vector3( objOffset.x+size*x  ,MAP_HEIGHT,objOffset.y - size * z ), Vector3(0,0,0), Vector3(0.1,0.1,0.1));
				other[0][otherCounter]->Init();
				otherCounter++;
				break;

			case GOAL:
				other[1][ otherCounter ] = Model::Instance<Octopus>( MODEL_NAME[ GOAL ] ,  Vector3( objOffset.x+size*x  ,MAP_HEIGHT,objOffset.y - size * z ), Vector3(0,0,0),Vector3( 0.05 , 0.05 , 0.05 ));
				other[1][otherCounter]->Init();
				otherCounter++;
				break;

			case START:
				other[2][ otherCounter ]  = Model::Instance<Start>( MODEL_NAME[ START ] , Vector3( objOffset.x+size*x  ,MAP_HEIGHT,objOffset.y - size * z ), Vector3(0,0,0));
				start = other[2][otherCounter];
				dynamic_cast<Shell*>(other[2][otherCounter])->SetDirection( direction );
				other[2][otherCounter]->Init();
				otherCounter++;
				break;

			case 4:
				other[ 2][otherCounter ]= Model::Instance<Shell>( MODEL_NAME[ MOVE ] , Vector3( objOffset.x+size*x  ,MAP_HEIGHT,objOffset.y - size * z ), Vector3(0,0,0));
				other[2][otherCounter]->Init();
				dynamic_cast<Shell*>(other[2][otherCounter])->SetDirection( Shell::DIR_DOWN );
				otherCounter++;
				break;

			case 5:
				other[ 2][otherCounter ]= Model::Instance<Shell>( MODEL_NAME[ MOVE ] , Vector3( objOffset.x+size*x  ,MAP_HEIGHT,objOffset.y - size * z ), Vector3(0,0,0));
				other[2][otherCounter]->Init();
				dynamic_cast<Shell*>(other[2][otherCounter])->SetDirection( Shell::DIR_RIGHT );
				otherCounter++;		
				break;

			case 6:
				other[ 2][otherCounter ]= Model::Instance<Shell>( MODEL_NAME[ MOVE ] , Vector3( objOffset.x+size*x  ,MAP_HEIGHT,objOffset.y - size * z ), Vector3(0,0,0));
				other[2][otherCounter]->Init();
				dynamic_cast<Shell*>(other[2][otherCounter])->SetDirection( Shell::DIR_UP );
				otherCounter++;
				break;

			case 7:
				other[ 2][otherCounter ]= Model::Instance<Shell>( MODEL_NAME[ MOVE ] , Vector3( objOffset.x+size*x  ,MAP_HEIGHT,objOffset.y - size * z ), Vector3(0,0,0));
				other[2][otherCounter]->Init();
				dynamic_cast<Shell*>(other[2][otherCounter])->SetDirection( Shell::DIR_LEFT );
				otherCounter++;
				break;

			default:
				Console::DebugLog( "Error[%d] ",fleld);
				break;
			};

			Console::DebugLog("\n");

			
		}
		fgetc(fp);
	}

	fclose(fp);


	// 
	player = KTutorialPlayer::Create( Vector3( objOffset.x+size*(int)(vertical*0.5f)  ,MAP_HEIGHT,objOffset.y - size * (int)(horizonal*0.5f)  ) );
	player->Init();
	grid = Grid::Create( Color(0.3f,0.3f,1.0,1.0), vertical, horizonal, MAP_SIZE );
	grid->Init();
	
	select = UserInterface::Create("data\\TEXTURE\\up.jpg", 0.300000, 0.280000, Color(1,1,1,1), Vector3(0.765000,-0.280000,1.000000));
	select->Init();

	backSelect = UserInterface::Create("data\\TEXTURE\\backframe.png", 0.300000, 0.280000, Color(1,1,1,1), Vector3(0.750000,-0.290000,1.000000));
	backSelect->Init();

	float x = (float)450/WINDOW_WIDTH*2;
	float y = (float)140/WINDOW_HEIGHT*1.15;

	stageFrame = UserInterface::Create("data\\TEXTURE\\score_frame001.png", 0.733125, 0.223611, Color(0.3,0.3,1,0.8), Vector3(-0.75,0.5,1.1) );
	stageFrame->Init();

	menu = MenuList::Create( 0.8, 0.01 );
	menu->Init( FILE_NAME, 4, Vector2( 1280, 768 ), Vector2(-0.5,0.45), Color(1,1,1,1), 1 );
	
	const char* BACK_FRAME_NAME[] = {
		"data\\TEXTURE\\backframe.png",
		"data\\TEXTURE\\backframe.png",
		"data\\TEXTURE\\backframe.png",
		"data\\TEXTURE\\backframe.png",
	};

	backframe = MenuList::Create( 0.8, 0.01 );
	backframe->Init(BACK_FRAME_NAME, 4, Vector2( 1280, 1280 ), Vector2(-0.50,0.45), Color(1,1,1,0.6), 1 );


	arrow = new KPolygon3D;
	arrow->Init();
	arrow->LoadTexture("data\\TEXTURE\\arrow.png");
	arrow->SetBoolDraw(false);
	arrow->SetPosition( D3DXVECTOR3( HOTATE_OKU_BASYO_X - 3.0f , 70.0f, HOTATE_OKU_BASYO_Z ) );
	arrow->SetSize( D3DXVECTOR3( 10.0f , 10.0f , 0.0f ) );
	arrow->SetRotate( D3DXVECTOR3( D3DXToRadian(-90.0f) , 0.0f , 0.0f ) );

	for( int i = 0 ; i < TEXT_MAX ; i++ )
	{
		if( TEXT_TEXTURE_NAME[i] == NULL ) break;
		if( FAILED( D3DXCreateTextureFromFile( GetDevice() , TEXT_TEXTURE_NAME[i] , &m_pTexture[i] ) ) )
		{	//FALED}N@s𔻒f
			UINT nID = MessageBox( NULL , "|St@Cǂݍ߂܂\n" , "ERROR[ k_tutorialmap.cpp ]" , MB_OK | MB_ICONEXCLAMATION );		
		}
	}

	for( int i = 0 ; i < TEXT_MAX ; i++ )
	{
		m_TextPolygon[i] = KPolygon::Create();
		m_TextPolygon[i]->BindTexure( m_pTexture[i] );
		m_TextPolygon[i]->SetDrawFrag(false);
	}
}

// TutorialMap Uninitialize
void TutorialMap::Uninit( void )
{
	if( arrow != nullptr ){
		arrow->Uninit();
		delete	arrow ;
		arrow = nullptr;
	}

	for( int i = 0 ; i < TEXT_MAX ; i++ )
	{
		if( m_pTexture[i] != nullptr )
		{
			m_pTexture[i]->Release();
			m_pTexture[i] = nullptr;
		}
	}

	player->Uninit();
	delete player;
	grid->Uninit();
	delete grid; 
	backSelect->Uninit();
	select->Uninit();
	//delete select;
	stageFrame->Uninit();
	//SAFE_DELETE(stageFrame)

	menu->Uninit();
	SAFE_DELETE( menu );
	backframe->Uninit();
	SAFE_DELETE(backframe)


	//delete select;

	for( int priority = 0; priority < OBJ_PRIORITY; priority++ ){
		for( int index = 0; index < NUM_OBJECT; index++ ){
			if( other[priority][index] != NULL ){
				other[priority][index]->Uninit();
			}
		}
	}

	// Uninitialize Process
	SAFE_DELETE_ARRAY(map)
	delete[] pObj;
	pObj = nullptr;
	delete pMap;
	pMap = nullptr;

}

// TutorialMap Update
void TutorialMap::Update( void )
{
	// Update Process
	if( !pMap )
		return;
	// Update Process
	for(int z = 0; z < pMap->horizonal; z++ ){
		for(int x = 0; x < pMap->vertical; x++ ){
			map[z*(vertical) + x]  = NONE;
			pObj[z*(vertical) + x] = nullptr;
		}
	}

	for( int priority = 0; priority < OBJ_PRIORITY; priority++ ){
		for( int index = 0; index < NUM_OBJECT; index++ ){
			if( other[priority][index] != NULL ){
				other[priority][index]->Update();
			}
		}
	}

	if( frame%MAP_SIZE == 0 )
		FieldCheck();

	player->Update();
	grid->Update();

	if( grid )
	menu->Update();
	backframe->Update();
	stageFrame->Update();
	backSelect->Update();
	select->Update();
	select->ChangeTexture( FILE_NAME[player->GetCurrent()] );


	#ifdef _DEBUG
	if( CInputKeyboard::Access()->GetKeyTrigger(DIK_RETURN) ){
		dynamic_cast<Start*>(start)->GameStart();
	}
	#endif // _DEBUG

	switch ( state )
	{
	case STATE_CROSSBUTTAN:
	{
		//vC[\{^ňړ
		bool text1Show = false;

		m_TextPolygon[ TEXT_0_0 ]->SetDrawFrag( true );
	
		Counter++;

		float width = 2219.0f * TEXT_SYUKUSYAKU; 
		float sizex0 = width - ( width - ( Counter * TEXT_SHOW_RATE ) );
		if( sizex0 >= width ) 
		{
			sizex0 = width; 
			text1Show = true;
		}
		m_TextPolygon[ TEXT_0_0 ]->SetPos( D3DXVECTOR3( 50.0f , WINDOW_HEIGHT * 0.7f , 0.0f ) );
		m_TextPolygon[ TEXT_0_0 ]->SetSize( D3DXVECTOR3( sizex0 , 142.0f * TEXT_SYUKUSYAKU , 0.0f ) );
		float u = sizex0/ width ;

		if( u >= 1.0f ){u = 1.0f;}

		m_TextPolygon[ TEXT_0_0 ]->SetTextureUV( D3DXVECTOR2( 0.0f , 0.0f ) , D3DXVECTOR2( u , 1.0f ) );
		
		if( text1Show )
		{

			m_TextPolygon[ TEXT_0_1 ]->SetDrawFrag( true );
			float width = 1659.0f * TEXT_SYUKUSYAKU; 
			float sizex = width - ( width - (  (Counter - width / TEXT_SHOW_RATE ) * TEXT_SHOW_RATE ) );
			if( sizex >= width ) 
			{
				sizex = width; 
			}
			m_TextPolygon[ TEXT_0_1 ]->SetPos( D3DXVECTOR3( 50.0f , WINDOW_HEIGHT * 0.8f , 0.0f ) );
			m_TextPolygon[ TEXT_0_1 ]->SetSize( D3DXVECTOR3( sizex , 142.0f * TEXT_SYUKUSYAKU , 0.0f ) );
			float u = sizex/ width ;

			if( u >= 1.0f ){u = 1.0f;}

			m_TextPolygon[ TEXT_0_1 ]->SetTextureUV( D3DXVECTOR2( 0.0f , 0.0f ) , D3DXVECTOR2( u , 1.0f ) );
	
		}

		if( ( Counter / 20 ) % 2 == 0 )
		{
			arrow->SetBoolDraw( true );
		}else{
			arrow->SetBoolDraw( false );
		}

		arrow->Update();

		if(	player->GetPos().x == HOTATE_OKU_BASYO_X &&
			player->GetPos().z == HOTATE_OKU_BASYO_Z )
		{//ړI 
			m_TextPolygon[ TEXT_0_0 ]->SetDrawFrag( false );
			m_TextPolygon[ TEXT_0_1 ]->SetDrawFrag( false );
			arrow->SetBoolDraw( false );
			Counter = 0;
			state++;
		}
	}
	break;//-->STATE_CROSSBUTTON
	
	case STATE_LRROTATE:
		//LRŉ]
		{

		m_TextPolygon[ TEXT_1 ]->SetDrawFrag( true );
	
		Counter++;

		float width = 1328.0f * TEXT_SYUKUSYAKU; 
		float sizex1 = width - ( width - ( Counter * TEXT_SHOW_RATE ) );
		if( sizex1 >= width ) 
		{
			sizex1 = width; 
		}
		m_TextPolygon[ TEXT_1 ]->SetPos( D3DXVECTOR3( 50.0f , WINDOW_HEIGHT * 0.7f , 0.0f ) );
		m_TextPolygon[ TEXT_1 ]->SetSize( D3DXVECTOR3( sizex1 , 142.0f * TEXT_SYUKUSYAKU , 0.0f ) );
		float u = sizex1/ width ;

		if( u >= 1.0f ){u = 1.0f;}

		m_TextPolygon[ TEXT_1 ]->SetTextureUV( D3DXVECTOR2( 0.0f , 0.0f ) , D3DXVECTOR2( u , 1.0f ) );
	


		if( player->GetCurrent() == 1 )
		{//]I
			state++;
			m_TextPolygon[ TEXT_1 ]->SetDrawFrag(false);
			Counter = 0;
		}
		break; //-->STATE_LRROTATE
		}
	case STATE_ABUTTONSET:
		{
		//A{^ĐݒuiJږ߂tutorialplayerɂ邩炱ł͂Ȃj
		m_TextPolygon[ TEXT_2 ]->SetDrawFrag( true );
	
		Counter++;

		float width = 1106.0f * TEXT_SYUKUSYAKU; 
		float sizex2 = width - ( width - ( Counter * TEXT_SHOW_RATE ) );
		if( sizex2 >= width ) 
		{
			sizex2 = width; 
		}
		m_TextPolygon[ TEXT_2 ]->SetPos( D3DXVECTOR3( 50.0f , WINDOW_HEIGHT * 0.7f , 0.0f ) );
		m_TextPolygon[ TEXT_2 ]->SetSize( D3DXVECTOR3( sizex2 , 142.0f * TEXT_SYUKUSYAKU , 0.0f ) );
		float u = sizex2/ width ;

		if( u >= 1.0f ){u = 1.0f;}

		m_TextPolygon[ TEXT_2 ]->SetTextureUV( D3DXVECTOR2( 0.0f , 0.0f ) , D3DXVECTOR2( u , 1.0f ) );	
		}
		break;

	case STATE_STARTBUTTON:
	{
		//X^[g{^ňړi@Jږ߁iry@j
		m_TextPolygon[ TEXT_2 ]->SetDrawFrag( false );
		
		bool text1Show = false;
		m_TextPolygon[ TEXT_3_0 ]->SetDrawFrag( true );
	
		Counter++;

		float width = 2484.0f * TEXT_SYUKUSYAKU; 
		float sizex3 = width - ( width - ( Counter * TEXT_SHOW_RATE ) );
		if( sizex3 >= width ) 
		{
			sizex3 = width; 
			text1Show = true;
		}
		m_TextPolygon[ TEXT_3_0 ]->SetPos( D3DXVECTOR3( 50.0f , WINDOW_HEIGHT * 0.7f , 0.0f ) );
		m_TextPolygon[ TEXT_3_0 ]->SetSize( D3DXVECTOR3( sizex3 , 142.0f * TEXT_SYUKUSYAKU , 0.0f ) );
		float u = sizex3/ width ;

		if( u >= 1.0f ){u = 1.0f;}

		m_TextPolygon[ TEXT_3_0 ]->SetTextureUV( D3DXVECTOR2( 0.0f , 0.0f ) , D3DXVECTOR2( u , 1.0f ) );
		
		if( text1Show )
		{

			m_TextPolygon[ TEXT_3_1 ]->SetDrawFrag( true );
			float width = 1556.0f * TEXT_SYUKUSYAKU; 
			float sizex4 = width - ( width - (  (Counter - width / TEXT_SHOW_RATE ) * TEXT_SHOW_RATE ) );
			if( sizex4 >= width ) 
			{
				sizex4 = width; 
			}
			m_TextPolygon[ TEXT_3_1 ]->SetPos( D3DXVECTOR3( 50.0f , WINDOW_HEIGHT * 0.8f , 0.0f ) );
			m_TextPolygon[ TEXT_3_1 ]->SetSize( D3DXVECTOR3( sizex4 , 142.0f * TEXT_SYUKUSYAKU , 0.0f ) );
			float u = sizex4/ width ;

			if( u >= 1.0f ){u = 1.0f;}

			m_TextPolygon[ TEXT_3_1 ]->SetTextureUV( D3DXVECTOR2( 0.0f , 0.0f ) , D3DXVECTOR2( u , 1.0f ) );
	
		}

		if( CXboxController::Access("playerController")->GetKeyTrigger(CXboxController::XINPUT_START) )
		{	//
			dynamic_cast<Start*>(start)->GameStart();
			m_TextPolygon[ TEXT_3_0 ]->SetDrawFrag( false );
			m_TextPolygon[ TEXT_3_1 ]->SetDrawFrag( false );
			state++;
			Counter = 0;
		}
		}
		break;

	case STATE_HANEKAERU:
	{
		//ł鎞̂
		bool text1Show = false;
		m_TextPolygon[ TEXT_4_0 ]->SetDrawFrag( true );
	
		Counter++;

		float width = 2220.0f * TEXT_SYUKUSYAKU; 
		float sizex5 = width - ( width - ( Counter * TEXT_SHOW_RATE ) );
		if( sizex5 >= width ) 
		{
			sizex5 = width; 
			text1Show = true;
		}
		m_TextPolygon[ TEXT_4_0 ]->SetPos( D3DXVECTOR3( 50.0f , WINDOW_HEIGHT * 0.7f , 0.0f ) );
		m_TextPolygon[ TEXT_4_0 ]->SetSize( D3DXVECTOR3( sizex5 , 142.0f * TEXT_SYUKUSYAKU , 0.0f ) );
		float u = sizex5/ width ;

		if( u >= 1.0f ){u = 1.0f;}

		m_TextPolygon[ TEXT_4_0 ]->SetTextureUV( D3DXVECTOR2( 0.0f , 0.0f ) , D3DXVECTOR2( u , 1.0f ) );
		
		if( text1Show )
		{

			m_TextPolygon[ TEXT_4_1 ]->SetDrawFrag( true );
			float width = 2629.0f * TEXT_SYUKUSYAKU; 
			float sizex = width - ( width - (  (Counter - width / TEXT_SHOW_RATE ) * TEXT_SHOW_RATE ) );
			if( sizex >= width ) 
			{
				sizex = width; 
			}
			m_TextPolygon[ TEXT_4_1 ]->SetPos( D3DXVECTOR3( 50.0f , WINDOW_HEIGHT * 0.8f , 0.0f ) );
			m_TextPolygon[ TEXT_4_1 ]->SetSize( D3DXVECTOR3( sizex , 142.0f * TEXT_SYUKUSYAKU , 0.0f ) );
			float u = sizex/ width ;

			if( u >= 1.0f ){u = 1.0f;}

			m_TextPolygon[ TEXT_4_1 ]->SetTextureUV( D3DXVECTOR2( 0.0f , 0.0f ) , D3DXVECTOR2( u , 1.0f ) );
			
		}

		//if(  )

		break;
	}

	case STATE_GOAL:{
		m_TextPolygon[ TEXT_4_0 ]->SetDrawFrag(false);
		m_TextPolygon[ TEXT_4_1 ]->SetDrawFrag(false);
		m_TextPolygon[ TEXT_5 ]->SetDrawFrag( true );
		
		Counter++;

		float width = 1690.0f * TEXT_SYUKUSYAKU; 
		float sizex5= width - ( width - ( Counter * TEXT_SHOW_RATE ) );
		if( sizex5 >= width ) 
		{
			sizex5 = width; 
		}
		m_TextPolygon[ TEXT_5 ]->SetPos( D3DXVECTOR3( 50.0f , WINDOW_HEIGHT * 0.7f , 0.0f ) );
		m_TextPolygon[ TEXT_5 ]->SetSize( D3DXVECTOR3( sizex5 , 142.0f * TEXT_SYUKUSYAKU , 0.0f ) );
		float u = sizex5/ width ;

		if( u >= 1.0f ){u = 1.0f;}

		m_TextPolygon[ TEXT_5 ]->SetTextureUV( D3DXVECTOR2( 0.0f , 0.0f ) , D3DXVECTOR2( u , 1.0f ) );
		}
		//S[
		if( Counter > 180 && CXboxController::Access("playerController")->GetKeyTrigger( CXboxController::XINPUT_A ) )
			ScreenTransition::Transition( ScreenTransition::DO_TRANSITION, new KTitle );

		break;
	}


	if( dynamic_cast<Start*>(start)->GetFlag() ){
		frame++;
	}

	
}

// TutorialMap Draw
void TutorialMap::Draw( void )
{

	// Draw Process
	if( !pMap )
		return;

	arrow->Draw();

	for( int i = 0 ; i < TEXT_MAX ; i++ )
	{
		m_TextPolygon[i]->Draw();
	}

}

// TutorialMap
Vector2& TutorialMap::SetObject( Vector3& pos, TYPE type, GameObject* pObj )
{
	

	const int size = MAP_SIZE;
	Vector2 start( -(size*pMap->vertical)*0.5f, size*pMap->horizonal*0.5f );
	for(int z = 0; z < pMap->horizonal; z++ ){
		for(int x = 0; x < pMap->vertical; x++ ){

			Vector3 current = Vector3( start.x + size*x, MAP_HEIGHT, start.y - size*z );
			Vector3 next = Vector3( start.x + size*(x+1), MAP_HEIGHT, start.y - size*(z+1));

			Vector3 center = current + (next - current)*0.5f;

			//if( __CollisionObjectSquare<Vector3>( current, next, pos, size*0.5f ) ){
			if( __CollisionObjectSphere( &CastVec3(center), &CastVec3(pos), size*0.5f, size*0.5f )){
				if( !pMap->map[z*(pMap->vertical)+x] ){
					pMap->map[z*(pMap->vertical)+x]  = type;
					pMap->pObj[z*(pMap->vertical)+x] = pObj;
					return Vector2( x,z );
					break;
				}else{
					
					if( dynamic_cast<Base*>(pObj)->map.x < x ){

						if( dynamic_cast<Base*>(pObj)->map.y < z ){
							pObj->SetPosition( Vector3(dynamic_cast<Base*>(pObj)->prev.x-MAP_SIZE*0.5f,dynamic_cast<Base*>(pObj)->prev.y-MAP_SIZE*0.5f,dynamic_cast<Base*>(pObj)->prev.z) );
							dynamic_cast<Shell*>(pObj)->SetMoveflag(false);
						}else{
							pObj->SetPosition( Vector3(dynamic_cast<Base*>(pObj)->prev.x-MAP_SIZE*0.5f,dynamic_cast<Base*>(pObj)->prev.y,dynamic_cast<Base*>(pObj)->prev.z) );
							dynamic_cast<Shell*>(pObj)->SetMoveflag(false);
						}
					}else{

						if( dynamic_cast<Base*>(pObj)->map.y < z ){
							pObj->SetPosition( Vector3(dynamic_cast<Base*>(pObj)->prev.x,dynamic_cast<Base*>(pObj)->prev.y-MAP_SIZE*0.5f,dynamic_cast<Base*>(pObj)->prev.z) );
							dynamic_cast<Shell*>(pObj)->SetMoveflag(false);
						}else{
							pObj->SetPosition( dynamic_cast<Base*>(pObj)->prev );
							dynamic_cast<Shell*>(pObj)->SetMoveflag(false);
						}
					}

					//pObj->SetPosition( Vector3(dynamic_cast<Base*>(pObj)->map.x, dynamic_cast<Base*>(pObj)->map.y, dynamic_cast<Base*>(pObj)->prev.z ) );
					for(int z = 0; z < pMap->horizonal; z++ ){
						for(int x = 0; x < pMap->vertical; x++ ){
							Vector3 current = Vector3( start.x + size*x, MAP_HEIGHT, start.y - size*z );
							Vector3 next = Vector3( start.x + size*(x+1), MAP_HEIGHT, start.y - size*(z+1));
							Vector3 center = current + (next - current)*0.5f;
							if( __CollisionObjectSphere( &CastVec3(center), &CastVec3(pos), size*0.5f, size*0.5f )){
								if( !pMap->map[z*(pMap->vertical)+x] ){
									pMap->map[z*(pMap->vertical)+x]  = type;
									pMap->pObj[z*(pMap->vertical)+x] = pObj;	
									return Vector2( x,z );
									break;
								}
							}
						}
					}
				}
			}
		}
	}

	return Vector2( -1,-1);

}


// TutorialMap
void TutorialMap::PutObject( TYPE type, Base* pObj )
{

	const int size = MAP_SIZE;
	Vector2 start( -(size*pMap->vertical)*0.5f, size*pMap->horizonal*0.5f );

	for( int index = 0; index < NUM_OBJECT; index++ ){
	
		if( !pMap->other[2][index] ){
			pMap->other[2][index] = pObj;
			pMap->other[2][index] ->Init();
			if( type != -1 ){
				dynamic_cast<Shell*>(pMap->other[2][index])->SetDirection(type);
			}
			break;
		}
	}

}


// TutorialMap
void TutorialMap::FieldCheck( void )
{


	CDebugFont::Access()->SetRenderData( R_RENDER ,"map data \n");

	for(int z = 0; z < pMap->horizonal; z++ ){
		for(int x = 0; x < pMap->vertical; x++ ){

			CDebugFont::Access()->SetRenderData( R_RENDER ," %d", map[z*pMap->vertical+x]);

			if( map[z*pMap->vertical+x] != NONE ){
				switch( map[z*(pMap->vertical)+x] )
				{
				case IMMORTAL:
					break;
				case MOVE:
					Scissor( z, x );
					OnScissor( z, x );
					break;
				case GOAL:
					OnScissor( z, x );
					//Attack(z,x);
					break;
				default:
					break;
				}
			}
		}
		CDebugFont::Access()->SetRenderData( R_RENDER ,"\n");
	}

}


// TutorialMap
int* TutorialMap::GetStatus( void )
{

	return pMap->map;

}

// TutorialMap
bool TutorialMap::Scissor( const int& z, const int& x )
{

	/*if( x <= 1 || z <= 1 || x >= (vertical+1) || z >= (horizonal+1) ){
		return false;
	}*/

	// x axis  
	if( !(x <=  1 || x >= (vertical-2)) ){

		if( map[z*(pMap->vertical)+x] != NONE && map[z*(pMap->vertical)+x-1] != NONE && map[z*(pMap->vertical)+x-2] != NONE  && map[z*(pMap->vertical)+x-1] != IMMORTAL ){
			if( pObj[z*(pMap->vertical)+x] )
				dynamic_cast<Base*>(pObj[z*(pMap->vertical)+x])->Scissor();
			return true;
		}
		if( map[z*(pMap->vertical)+x] != NONE && map[z*(pMap->vertical)+x+1] != NONE && map[z*(pMap->vertical)+x+2] != NONE && map[z*(pMap->vertical)+x+1] != IMMORTAL ){
			if( pObj[z*(pMap->vertical)+x] )
				dynamic_cast<Base*>(pObj[(z)*(pMap->vertical)+x])->Scissor();
			return true;
		}
	}

	/// y axis
	if( !(z <= 1 || z >= (horizonal-2)) ){

		if( map[z*(pMap->vertical)+x] != NONE && map[(z-1)*(pMap->vertical)+x] != NONE && map[(z-2)*(pMap->vertical)+x] != NONE && map[(z-1)*(pMap->vertical)+x] != IMMORTAL ){
			if( pObj[z*(pMap->vertical)+x] )
				dynamic_cast<Base*>(pObj[(z)*(pMap->vertical)+x])->Scissor();
			return true;
		}
		if( map[z*(pMap->vertical)+x] != NONE && map[(z+1)*(pMap->vertical)+x] != NONE && map[(z+2)*(pMap->vertical)+x] != NONE && map[(z+1)*(pMap->vertical)+x] != IMMORTAL ){
			if( pObj[z*(pMap->vertical)+x] )
				dynamic_cast<Base*>(pObj[(z)*(pMap->vertical)+x])->Scissor();
			return true;
		}
	}
	

	return false;

}

// TutorialMap
bool TutorialMap::OnScissor( const int& z, const int& x )
{

	if( map[z*(pMap->vertical)+x+1] != NONE && map[z*(pMap->vertical)+x-1] != NONE && map[z*(pMap->vertical)+x-1] != IMMORTAL || map[z*(pMap->vertical)+x+1] != NONE && map[z*(pMap->vertical)+x-1] != NONE && map[z*(pMap->vertical)+x+1] != IMMORTAL ){
		
		if( z == 1 && x == 4 )
		{
			TransitionState();
			return true;
		}

		dynamic_cast<Base*>(pObj[z*(pMap->vertical)+x])->OnScissor();
		return true;

	}
	if( map[(z+1)*(pMap->vertical)+x] != NONE && map[(z-1)*(pMap->vertical)+x] != NONE && map[(z+1)*(pMap->vertical)+x] != IMMORTAL ||  map[(z+1)*(pMap->vertical)+x] != NONE && map[(z-1)*(pMap->vertical)+x] != NONE && map[(z-1)*(pMap->vertical)+x] != IMMORTAL ){
		if( z == 1 && x == 4 )
		{
			TransitionState();
			return true;
		}

		dynamic_cast<Base*>(pObj[z*(pMap->vertical)+x])->OnScissor();
		return true;
	}

	return false;


}

// TutorialMap
void TutorialMap::Attack( const int& z, const int& x )
{

	Vector2 objOffset( -(MAP_SIZE*pMap->vertical)*0.5f + MAP_SIZE * 0.5f  , MAP_SIZE*pMap->horizonal*0.5f - MAP_SIZE*0.5f );

	if( pObj[z*(vertical)+x+1] || pObj[z*(vertical)+x-1] || pObj[(z+1)*(vertical)+x] || pObj[(z-1)*(vertical)+x] ){
		GameObject* object = pObj[z*(vertical)+x+1];
		for( int index = 0; index < NUM_OBJECT; index++ ){
			if( other[2][index] == object ){
				Vector3 pos = other[2][index]->GetPosition();
				other[2][index]->Uninit();
				//map[z*(pMap->vertical)+x] = NONE;
				//delete other[2][index];
				//other[2][index] = nullptr;
				SetExplosion( &D3DXVECTOR3( pos.x, pos.y, pos.z ) );
			}
		}
	}

}





