/** @file
 *
 */
#if !defined(__GDESTRAIER__BUILDER__BUILDER__HPP__)
#define __GDESTRAIER__BUILDER__BUILDER__HPP__

#include <sys/types.h>
#include <sigc++/signal.h>
#include <libgnomevfs/gnome-vfs-file-info.h>
#include <libgnomevfs/gnome-vfs-uri.h>
#include "model/index.hpp"
#include "hyperestraier/local.hpp"


namespace gdestraier {
  namespace builder {

    class builder {
    public:
      typedef hyperestraier::local_database<hyperestraier::single_threaded> local_db_type;

      gdestraier::model::index_type const* target_index_;

      unsigned int   lock_timeout_; //!< Lock timeout time(sec).
      bool           collect_overwrite_spaces_;
      bool           collect_deleted_spaces_;
      bool           gather_documents_;
      bool           purge_nonexist_documents_;
      bool           optimize_;
      bool           generate_keywords_;
      unsigned int   cache_size_;

    public:
      sigc::signal<void, char const*> signal_stdout_;
      sigc::signal<void, char const*> signal_stderr_;

    protected:
      void run_command(std::vector<std::string> const& args);
      void run_gather(hyperestraier::database& db);
      void put_doc(hyperestraier::database& db,
                   ::GnomeVFSURI* uri,
                   ::GnomeVFSFileInfo* info);
      void run_purge(hyperestraier::database& db);
      void run_extkeys();

      bool canceled_;

    public:
      builder();
      virtual ~builder();

      void launch(gdestraier::model::index_type const* index = 0);

      void cancel();
      bool is_canceled() const { return canceled_; }
      void reset() { canceled_ = false; }
    };

  }
}


#endif

