/** @file
 */
#if !defined(__GDESTRAIER__BUILDER__TEXT_FILTER__HPP__)
#define __GDESTRAIER__BUILDER__TEXT_FILTER__HPP__

#include "filter.hpp"

namespace gdestraier {
  namespace builder {
    namespace filter {

      class from_text : public abstract_filter
      {
      public:
        from_text();
        virtual ~from_text();

        virtual bool operator() (hyperestraier::local_document* doc,
                                 gdestraier::model::index_type const& index,
                                 ::GnomeVFSURI* uri,
                                 char const* text_ur,
                                 ::GnomeVFSFileInfo* info,
                                 char const* mime_type) const;

        static factory const& get_factory();
        static abstract_filter* create();

      protected:
        bool parse_text(char*       text,
                        std::size_t len,
                        gdestraier::model::index_type const& index,
                        hyperestraier::local_document* doc) const;

        static factory::extention_map_type extentions_[];
      };

    }
  }
}

#endif
