/** @file
 */
#if defined(HAVE_CONFIG_H)
#  include "../../config.h"
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <unistd.h>
#include <fcntl.h>
#define GNU_SOURCE
#include <cstring>

#include "hyperestraier/hyperestraier.hpp"
#include "unknown_filter.hpp"


namespace gdestraier {
  namespace builder {
    namespace filter {

      from_unknown::from_unknown()
      {
      }


      from_unknown::~from_unknown()
      {
      }


      factory::extention_map_type from_unknown::extentions_[] = {
        { 0, 0 }
      };

      factory const& from_unknown::get_factory() {
        static factory f("Regular file", &from_unknown::create, from_unknown::extentions_);
        return f;
      }

      abstract_filter* from_unknown::create() { return new from_unknown; }


      bool from_unknown::operator() (hyperestraier::local_document* doc,
                                     gdestraier::model::index_type const& /*index*/,
                                     ::GnomeVFSURI* /*uri*/,
                                     char const* /*text_uri*/,
                                     ::GnomeVFSFileInfo* /*info*/,
                                     char const* mime_type) const
      {
        doc->create();
        doc->set_attr(ESTDATTRTYPE, mime_type? mime_type : "application/octet-stream");
        return true;
      }

    }
  }
}
