/** @file
 */
#if !defined(__GDESTRAIER__CONTEXT_MENU__HPP__)
#define __GDESTRAIER__CONTEXT_MENU__HPP__

#include <list>
#include <sigc++/signal.h>
#include <glibmm/ustring.h>
#include <gtkmm/menu.h>

namespace gdestraier {
  namespace gui {

    class context_menu
    {
    public:
      context_menu();
      virtual ~context_menu();

    protected:
      Gtk::Menu     popup_;

      struct filemenu_type {
        Gtk::Menu* menu_;
        sigc::connection open_connection_;
        sigc::connection open_with_connection_;
        sigc::connection properties_connection_;
      };
      typedef std::list<filemenu_type> filemenus_type;
      filemenus_type filemenus_;

      /* @name Signals */
      /* @{ */
    public:
      typedef sigc::signal<void, Glib::ustring const&> signal_open_type;
      typedef sigc::signal<void>                       signal_open_with_type;
      typedef sigc::signal<void>                       signal_properties_type;
      signal_open_type       signal_open_;
      signal_open_with_type  signal_open_with_;
      signal_properties_type signal_properties_;
      /* @} */

    public:
      Gtk::Menu*  get_popup() { return &popup_; }
      Gtk::Menu const* get_popup() const { return &popup_; }

      void add_filemenu(Gtk::Menu* filemenu);
      void remove_filemenu(Gtk::Menu* filemenu);

      void update(Glib::ustring const& uri, Glib::ustring const& mime_type);
      void clear();

    protected:
      void on_copy_activate(Glib::ustring const& uri);
    };

  }
}

#endif

