/** @file
 */
#if defined(HAVE_CONFIG_H)
#  include "../config.h"
#endif

#include "glade-helper.hpp"

namespace gdestraier {
  namespace gui {
    ::GladeXML* load_glade_xml(char const* root) {
      return ::glade_xml_new(PKGDATADIR "/" PACKAGE_NAME ".glade", root, GETTEXT_PACKAGE);
    }


    Gtk::Widget* get_toplevel_widget(char const* name)
    {
      ::GladeXML* glade = load_glade_xml(name);
      ::GtkWidget* cw = ::glade_xml_get_widget(glade, name);
      return Glib::wrap(cw);
    }

    void connect_clicked(::GladeXML* glade, char const* name, sigc::slot<void> const& slot) {
      Gtk::Widget* w = 0;
      get_widget(glade, name, &w);

      Gtk::Button* pbtn = dynamic_cast<Gtk::Button*>(w);
      if (pbtn) pbtn->signal_clicked().connect(slot);

      Gtk::MenuItem* pmi = dynamic_cast<Gtk::MenuItem*>(w);
      if (pmi) pmi->signal_activate().connect(slot);
    }


  }
}


