/** @file
 */
#if !defined(__GDESTRAIER__BUILD_INDEX_DIALOG__HPP__)
#define __GDESTRAIER__BUILD_INDEX_DIALOG__HPP__

#include <string>
#include <vector>

#include <gtkmm/dialog.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include <gtkmm/button.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/textview.h>

#include <glade/glade-xml.h>

#include "builder/builder.hpp"



namespace gdestraier {
  namespace gui {

    class index_build_dialog : public Gtk::Dialog
    {
    protected:
      index_build_dialog(); // DON'T IMPLEMENT

    public:
      index_build_dialog(Gtk::Dialog::BaseObjectType* cobject,
                         ::GladeXML* glade);
      virtual ~index_build_dialog();

      static char const* get_glade_node_name() { return "index_build_dialog"; }

    protected:
      Gtk::TreeView*     indexes_view_;
      Glib::RefPtr<Gtk::ListStore> indexes_model_;
      Gtk::SpinButton*   lock_timeout_;
      Gtk::CheckButton*  collect_overwrite_spaces_;
      Gtk::CheckButton*  purge_nonexist_documents_;
      Gtk::CheckButton*  collect_deleted_spaces_;
      Gtk::CheckButton*  run_optimize_;
      Gtk::CheckButton*  no_gather_;
      Gtk::CheckButton*  generate_keywords_;
      Gtk::TextView*     log_view_;
      Gtk::Button*       check_all_indexes_button_;
      Gtk::Button*       uncheck_all_indexes_button_;
      Gtk::Button*       close_button_;
      Gtk::Button*       build_execute_button_;
      Gtk::Button*       build_stop_button_;
      Gtk::SpinButton*   cache_size_button_;

      gdestraier::builder::builder builder_;


    protected:
      void on_dialog_response(int response_id);

      void on_check_all_activate();
      void on_uncheck_all_activate();

      void on_build_execute_activate();
      void on_build_stop_activate();

      void on_log_received(Glib::ustring const& line);
    };
  }
}

#endif
