/** @file
 */
#if !defined(__GDESTRAIER__INDEX_EDIT_DIALOG__HPP__)
#define __GDESTRAIER__INDEX_EDIT_DIALOG__HPP__

#include <gtkmm/treeview.h>
#include <gtkmm/dialog.h>
#include <gtkmm/entry.h>
#include <gtkmm/button.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/combobox.h>
#include <gtkmm/spinbutton.h>
#include <glade/glade-xml.h>

#include "model/filetype.hpp"
#include "model/encodings.hpp"

namespace gdestraier {
  namespace gui {

    class index_edit_dialog : public Gtk::Dialog {
    protected:
      index_edit_dialog();  // DO'NT IMPLEMENT

    protected:
      /** @name Basics pane */
      /* @{ */
      Gtk::Entry*             description_entry_;

      Gtk::ComboBox*          index_location_combo_;
      Gtk::Entry*             index_path_entry_;
      Gtk::Entry*             index_user_entry_;
      Gtk::Entry*             index_password_entry_;


      void on_description_changed();
      void on_location_changed();
      /* @} */

      /* @name Gatherer pane */
      /* @{ */
      Gtk::Label*             description_label_1_;
      Gtk::Entry*             document_path_entry_;
      Gtk::Button*            choose_document_path_button_;
      Gtk::CheckButton*       active_checkbutton_;
      Gtk::ComboBox*          filetype_combo_;
      Gtk::ComboBox*          document_encoding_combo_;
      Gtk::ComboBox*          language_combo_;
      Gtk::ComboBox*          filesystem_encoding_combo_;
      Gtk::CheckButton*       use_Ngram_for_all_languages_;
      Gtk::CheckButton*       include_document_title_to_body_;
      Gtk::CheckButton*       include_document_uri_to_body_;
      Gtk::CheckButton*       enable_quick_build_checkbutton_;

      void on_choose_document_folder();
      /* @} */


      /** @name Replace pane */
      /* @{ */
      Gtk::Label*             description_label_2_;
      Gtk::Entry*             uri_replace_rule_regex_entry_;
      Gtk::Entry*             uri_replace_rule_to_entry_;
      Gtk::Entry*             title_replace_rule_regex_entry_;
      Gtk::Entry*             title_replace_rule_to_entry_;
      /* @} */


      /** @name Limits pane */
      /* @{ */
      Gtk::Label*             description_label_3_;
      Gtk::SpinButton*        depth_spinbutton_;
      Gtk::SpinButton*        max_documents_spinbutton_;
      Gtk::CheckButton*       use_snippet_;
      /* @} */

      /** @name ダイアログ全体 */
      /* @{ */
      Gtk::Button*            ok_button_;

      virtual void on_response(int response_id);
      /* @} */

      bool                    has_error_;   //!< 入力値にエラーがあったか

    public:
      index_edit_dialog(Gtk::Dialog::BaseObjectType* cobject,
                        ::GladeXML* glade);
      virtual ~index_edit_dialog();

      static char const* get_glade_node_name() { return "index_edit_dialog"; }

      bool          has_error() const { return has_error_; }


      Glib::ustring get_description() const { return description_entry_->get_text(); }
      void          set_description(Glib::ustring const& desc) { description_entry_->set_text(desc); }

      int           get_index_location() const { return index_location_combo_->get_active_row_number(); }
      void          set_index_location(int n) const { index_location_combo_->set_active(n); }

      Glib::ustring get_index_path() const { return index_path_entry_->get_text(); }
      void          set_index_path(Glib::ustring const& path) { index_path_entry_->set_text(path); }

      Glib::ustring get_index_user() const { return index_user_entry_->get_text(); }
      void          set_index_user(Glib::ustring const& user) { index_user_entry_->set_text(user); }

      Glib::ustring get_index_password() const { return index_password_entry_->get_text(); }
      void          set_index_password(Glib::ustring const& password) { index_password_entry_->set_text(password); }

      Glib::ustring get_document_path() const { return document_path_entry_->get_text(); }
      void          set_document_path(Glib::ustring const& path) { document_path_entry_->set_text(path); }

      bool          get_active() const { return active_checkbutton_->get_active(); }
      void          set_active(bool active) { active_checkbutton_->set_active(active); }

      gdestraier::model::filetype const* get_filetype() const;
      void                               set_filetype(gdestraier::model::filetype const* type);

      gdestraier::model::encoding const* get_document_encoding() const;
      void                               set_document_encoding(gdestraier::model::encoding const* enc);

      Glib::ustring get_language() const;
      void          set_language(Glib::ustring const& lang);

      gdestraier::model::encoding const* get_filesystem_encoding() const;
      void                               set_filesystem_encoding(gdestraier::model::encoding const* enc);

      bool          get_use_Ngram_for_all_languages() const { return use_Ngram_for_all_languages_->get_active(); }
      void          set_use_Ngram_for_all_languages(bool b) { use_Ngram_for_all_languages_->set_active(b); }

      bool          get_include_document_title_to_body() const { return include_document_title_to_body_->get_active(); }
      void          set_include_document_title_to_body(bool b) { include_document_title_to_body_->set_active(b); }

      bool          get_include_document_uri_to_body() const { return include_document_uri_to_body_->get_active(); }
      void          set_include_document_uri_to_body(bool b) { include_document_uri_to_body_->set_active(b); }

      Glib::ustring get_uri_replace_rule_regex() const { return uri_replace_rule_regex_entry_->get_text(); }
      void          set_uri_replace_rule_regex(Glib::ustring const& regex) {
        uri_replace_rule_regex_entry_->set_text(regex);
      }

      Glib::ustring get_uri_replace_rule_to() const { return uri_replace_rule_to_entry_->get_text(); }
      void          set_uri_replace_rule_to(Glib::ustring const& to) {
        uri_replace_rule_to_entry_->set_text(to);
      }

      Glib::ustring get_title_replace_rule_regex() const { return title_replace_rule_regex_entry_->get_text(); }
      void          set_title_replace_rule_regex(Glib::ustring const& to) {
        title_replace_rule_regex_entry_->set_text(to);
      }

      Glib::ustring get_title_replace_rule_to() const { return title_replace_rule_to_entry_->get_text(); }
      void          set_title_replace_rule_to(Glib::ustring const& to) {
        title_replace_rule_to_entry_->set_text(to);
      }

      bool          is_enable_quick_build() const { return enable_quick_build_checkbutton_->get_active(); }
      void          set_enable_quick_build(bool b) { enable_quick_build_checkbutton_->set_active(b); }

      int           get_depth() const { return depth_spinbutton_->get_value_as_int(); }
      void          set_depth(int depth) { depth_spinbutton_->set_value(depth); }

      int           get_max_documents() const { return max_documents_spinbutton_->get_value_as_int(); }
      void          set_max_documents(int n) const { return max_documents_spinbutton_->set_value(n); }

      bool          get_use_snippet() const { return use_snippet_->get_active(); }
      void          set_use_snippet(bool use) { use_snippet_->set_active(use); }
    };

  }
}

#endif

