/** @file
 */
#if defined(HAVE_CONFIG_H)
#  include "../../config.h"
#endif
#include <cstring>
#include <algorithm>

#include "../../gettext.h"
#include <glibmm/i18n.h>

#include "filetype.hpp"

namespace gdestraier {
  namespace model {

    char const* filetype::get_translated() const { return ::gettext(get_name()); }

    filetype const filetype::auto_(N_("Auto"));
    filetype const filetype::document_draft_(N_("Document draft"));
    filetype const filetype::plain_text_(N_("Plain text"));
    filetype const filetype::html_(N_("HTML"));
    //filetype const filetype::mime_(N_("MIME"), "message/rfc822");
#if defined(HAVE_LIBID3)
    filetype const filetype::mp3_(N_("ID3"));
#endif
    filetype const filetype::pdf_(N_("Portable Document Format"));
    filetype const filetype::excel_(N_("Microsoft Excel"));
    filetype const filetype::powerpoint_(N_("Microsoft PowerPoint"));


    filetypes_manager::filetypes_manager() {
      filetypes_.push_back(&filetype::auto_);
      filetypes_.push_back(&filetype::document_draft_);
      filetypes_.push_back(&filetype::plain_text_);
      filetypes_.push_back(&filetype::html_);
      //filetypes_.push_back(&filetype::mime_);
#if defined(HAVE_LIBID3)
      filetypes_.push_back(&filetype::mp3_);
#endif
      filetypes_.push_back(&filetype::pdf_);
      filetypes_.push_back(&filetype::excel_);
      filetypes_.push_back(&filetype::powerpoint_);
    }


    filetypes_manager::~filetypes_manager() {
    }


    filetypes_manager& filetypes_manager::instance() {
      static filetypes_manager inst;
      return inst;
    }


    filetype const*
    filetypes_manager::find(char const* name) const
    {
      for (filetypes_type::const_iterator i =filetypes_.begin();
           i != filetypes_.end(); i++)
        if (::strcasecmp((*i)->get_name(), name) == 0) return *i;
      return 0;
    }

  }
}

