/** @file
 */
#if !defined(__GDESTRAIER__MODEL__FONT_AND_COLORS__HPP__)
#define __GDESTRAIER__MODEL__FONT_AND_COLORS__HPP__

#include <string>
#include <glibmm/ustring.h>
#include <ostream>

#include <cstdlib>
#include <cabin.h>


namespace gdestraier {
  namespace model {

    struct font_and_color {
      Glib::ustring font_name_;
      Glib::ustring normal_color_;
      Glib::ustring highlight_color_;


      /** @brief マークアップされた文字列をストリームへ書き出します。
       *  @param ost 出力先ストリーム
       *  @param str 出力する文字列(UTF-8)
       *  @param hilight ハイライトするか
       */
      void write_pango_markup(std::ostream& ost, std::string const& str, bool hilight) const {
        char* escaped = ::cbxmlescape(str.c_str());

        ost << "<span "
            << "foreground=\"" << (hilight? highlight_color_.raw() : normal_color_.raw()) << "\" "
            << "font_desc=\"" << font_name_.raw() << "\""
            << ">"
            << escaped
            << "</span>"
          ;
        std::free(static_cast<void*>(escaped));
      }
    };

  }
}

#endif
