/** @file
 */
#if !defined(__GDESTRAIER__MODEL__INDEX__HPP__)
#define __GDESTRAIER__MODEL__INDEX__HPP__

#include <string>
#include <boost/regex.hpp>

#include "encodings.hpp"
#include "filetype.hpp"

namespace gdestraier {
  namespace model {

    class index_type
    {
    public:
        index_type();


        std::string description_;                  //!< 名前

        enum { LOCAL_FILESYSTEM = 0, REMOTE_NODE = 1 };
        int         database_location_;            //!< ノードの場所
        std::string database_path_;                //!< インデックスのパスまたはURL
        std::string user_;                         //!< ユーザー名
        std::string password_;                     //!< パスワード

        /* @name ギャザラ */
        /* @{ */
        std::string document_path_;                //!< 文書のパス
        bool        active_;                       //!< 検索対象としてアクティブか
        filetype const* filetype_;                 //!< 文書のファイルタイプ
        encoding const* document_encoding_;        //!< 文書のエンコーディング。自動の場合は NULL
        std::string language_;                     //!< 文書の言語
        encoding const* filesystem_encoding_;      //!< ファイルシステムのエンコーディング
        bool        use_Ngram_for_all_languages_;  //!< 全ての言語でN-gramを使うか
      bool        include_title_to_body_;        //!< タイトルを本文に含めるか
      bool        include_uri_to_body_;          //!< デコード済みURIを本文に含めるか
      bool        is_enable_quick_build_;        //!< クイックビルド対象か
        /* @} */

    protected:
      struct replace_rule_type {
        std::string   regex_;
        boost::regex  compiled_;
        bool          is_valid_regex_;
        std::string   to_;
      };

      /* @name Replace */
      /* @{ */
      replace_rule_type uri_replace_rule_;
      replace_rule_type title_replace_rule_;
      /* @} */

    public:
      std::string const&  get_uri_replace_regex() const { return uri_replace_rule_.regex_; }
      std::string const&  get_uri_replace_to() const { return uri_replace_rule_.to_; }
      boost::regex const& get_uri_replace_regex_compiled() const { return uri_replace_rule_.compiled_; }
      void                set_uri_replace(char const* regex, char const* to);
      bool                is_valid_uri_replace_regex() const { return uri_replace_rule_.is_valid_regex_; }

      std::string const&  get_title_replace_regex() const { return title_replace_rule_.regex_; }
      std::string const&  get_title_replace_to() const { return title_replace_rule_.to_; }
      boost::regex const& get_title_replace_regex_compiled() const { return title_replace_rule_.compiled_; }
      void                set_title_replace(char const* regex, char const* to);
      bool                is_valid_title_replace_regex() const { return title_replace_rule_.is_valid_regex_; }

    protected:
      int         depth_;                        //!< 探索深度
      int         max_documents_;                //!< 検索する最大文書数
      bool        use_snippet_;


    public:
      inline int         get_depth() const { return depth_; }
      inline void        set_depth(int depth) { depth_ = depth; }
      inline int         get_max_documents() const { return max_documents_; }
      inline void        set_max_documents(int n) { max_documents_ = n; }
      inline bool        get_use_snippet() const { return use_snippet_; }
      inline void        set_use_snippet(bool b) { use_snippet_ = b; }

    public:
      /** @name エンコーデング関連のヘルパ */
      /* @{ */
      std::string str2utf8(std::string const& str) const;
      std::string str2utf8(char const* str) const;
      std::string str2utf8(char const* first, char const* last) const;

      encoding const* fathom_encoding(char const* first, char const* last) const;
      /* @} */
      };
  }
}

#endif

