/** @file
 */
#if !defined(__GDESTRAIER__MODEL__LANGUAGES__HPP__)
#define __GDESTRAIER__MODEL__LANGUAGES__HPP__

#include <list>
#include <string>
#include <boost/noncopyable.hpp>

namespace gdestraier {
  namespace model {

    struct language
    {
      language(char const* id, char const* name);

      std::string id_;
      std::string name_;
    };



    /** @class サポート言語の一覧
     *
     *  estcmdが扱う事のできる言語のリストです。
     *
     * 実際のリストはメッセージカタログから取得されます。
     */
    class languages :
      public boost::noncopyable,
      public std::list<language>
    {
    protected:
      languages();
      //languages(languages const& r) : std::list<language>(r) { }
    public:
      virtual ~languages();

      static languages const& instance();
    };


  }
}


#endif
