/** @file
 */
#if defined(HAVE_CONFIG_H)
#  include "../../config.h"
#endif
#include <boost/format.hpp>
#include "../../gettext.h"
#include <glibmm/i18n.h>

#include "timestamp.hpp"

namespace gdestraier {
  namespace timestamp {

    std::string to_age(std::time_t now, std::time_t r) {

      struct fmts {
        boost::format minutes_;
        boost::format minhours_;
        boost::format hours_;
        boost::format days_;
        boost::format years_;
        boost::format more_than_years_;
      };
      static fmts fmt_ago = {
        boost::format(_("%1$d minuts ago.")),
        boost::format(_("%1$d hours %2$d minutes ago.")),
        boost::format(_("%1$d hours ago.")),
        boost::format(_("%1$d days ago.")),
        boost::format(_("%1$d years ago.")),
        boost::format(_("More than %1$d yars ago."))
      };
      static fmts fmt_after = {
        boost::format(_("%1$d minuts after.")),
        boost::format(_("%1$d hours %2$d minutes after.")),
        boost::format(_("%1$d hours after.")),
        boost::format(_("%1$d days after.")),
        boost::format(_("%1$d years after.")),
        boost::format(_("More than %1$d yars after."))
      };


      fmts& fmt = *((r < now)? &fmt_ago : &fmt_after);

      int minutes = abs((now - r) / 60);
      if (minutes <= 45) {
        //  15 mins step in 0 to 45 minutes
        if (minutes <= 5)       minutes = 5;
        else if (minutes <= 15) minutes = 15;
        else if (minutes <= 30) minutes = 30;
        else                    minutes = 45;

        return (fmt.minutes_ % minutes).str();
      }

      if (minutes <= 240) {
        // 30mins step in 45 minutes to 4 hours
        if (minutes % 60 < 30)
          return (fmt.minhours_ % (minutes / 60) % 30).str();
        else
          return (fmt.hours_ % (minutes / 60 + 1)).str();
      }

      if (minutes <= 8 * 60)       // 1 hour step in 4 hours to 8 hours
        return (fmt.hours_ % (minutes / 60 + 1)).str();
      if (minutes <= 24 * 60)      // 4 hours step in 8 hours to 24 hours
        return (fmt.hours_ % ((minutes / 240) * 4 + 1)).str();
      if (minutes <= 4 * 24 * 60)  // 1 day step in 24 hours to 4 days
        return (fmt.days_ % (minutes / (24 * 60) + 1)).str();
      if (minutes <= 30 * 24 * 60) // 10 days step in 4 days to 30 days
        return (fmt.days_ % ((minutes / (10 * 24 * 60) + 1) * 10) ).str();
      if (minutes <= 180 * 24 * 60) // 30 days step in 30 days to 180 days
        return (fmt.days_ % ((minutes / (30 * 24 * 60) + 1) * 30)).str();
      if (minutes <= 360 * 24 * 60) // 180 days step in 180 days to 360 days
        return (fmt.days_ % ((minutes / (180 * 24 * 60) + 1) * 180)).str();
      if (minutes < 20 * 365 * 24 * 60)  // 1 years step in 360 days to 20 years
        return (fmt.years_ % (minutes / (365 * 24 * 60) + 1)).str();

      return (fmt.more_than_years_ % 20).str();
    }

  }
}

