/** @file
 *
 */
#if !defined(__GDESTRAIER__PREFERENCES_DIRALOG__HPP__)
#define __GDESTRAIER__PREFERENCES_DIRALOG__HPP__

#include <boost/noncopyable.hpp>

#include <gtkmm/dialog.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treeview.h>
#include <gtkmm/treemodelfilter.h>
#include <gtkmm/fontbutton.h>
#include <gtkmm/colorbutton.h>
#include <gtkmm/textview.h>
#include <gtkmm/combobox.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/checkbutton.h>

#include <glade/glade-xml.h>


namespace gdestraier {
  namespace gui {

    class preferences_dialog :
      public Gtk::Dialog,
      public boost::noncopyable
    {
    protected:
      preferences_dialog(); // DON'T IMPLEMENT

    public:
      preferences_dialog(Gtk::Dialog::BaseObjectType* cobject,
                         ::GladeXML* refGlade);
      virtual ~preferences_dialog();

      static char const* get_glade_node_name() { return "preferences_dialog"; }

    protected:
      /** @name インデックスタブ */
      /* @{ */
      Gtk::TreeView* indexes_view_;
      Glib::RefPtr<Gtk::ListStore> indexes_model_;
      Glib::RefPtr<Gtk::TreeModelFilter> indexes_model_filter_;
      Gtk::Button* edit_index_button_;
      Gtk::Button* delete_index_button_;
      Gtk::Button* moveup_index_button_;
      Gtk::Button* movedown_index_button_;

      void on_add_index_clicked();
      void on_edit_index_clicked();
      void on_delete_index_clicked();
      void on_moveup_index_clicked();
      void on_movedown_index_clicked();

      void on_index_row_activated();
      /* @} */

      /** @name 外部コマンド */
      /* @{ */
      Gtk::Entry* estcmd_path_entry_;
      /* @} */


      /** @name Font and colors */
      /* @{ */
      Gtk::TreeView*     color_target_list_;
      Gtk::FontButton*   font_chooser_;
      Gtk::ColorButton*  normal_color_chooser_;
      Gtk::ColorButton*  highlight_color_chooser_;
      Gtk::TextView*     font_sample_view_;

      void on_color_target_row_activate();
      void on_font_set();
      void on_normal_color_set();
      void on_highlight_color_set();
      /* @} */


      /** @name Defaults */
      /* @{ */
      Gtk::ComboBox*      default_group_key_combo_;
      Gtk::ComboBox*      default_sort_key_combo_;
      Gtk::SpinButton*    thumbnail_size_button_;
      /* @} */

      /** @name Network */
      /* @{ */
      Gtk::SpinButton* network_timeout_spinbutton_;
      Gtk::Entry*      proxy_server_entry_;
      Gtk::SpinButton* proxy_port_spinbutton_;
      Gtk::CheckButton* use_gnome_proxy_checkbox_;

      void on_use_gnome_proxy_toggled();
      /* @} */

      virtual void on_response(int response_id);

    };

  }
}

#endif

