<?php

###############################################################################
# slovak_utf-8.php
# This is the Slovak language file for Geeklog
# Special thanks to Mischa Polivanov for his work on this project
#
# Copyright (C) 2010 Miroslav Fikar
# miroslav.fikar+geeklog@gmail.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'UTF-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Autor:',
    2 => 'zvyšok článku',
    3 => 'komentáre(ov)',
    4 => 'Upraviť',
    5 => '',
    6 => '',
    7 => '',
    8 => '',
    9 => 'Správcovské funkcie:',
    10 => 'Príspevky',
    11 => 'Príbehy',
    12 => 'Bloky',
    13 => 'Témy',
    14 => '',
    15 => '',
    16 => '',
    17 => 'Užívatelia',
    18 => 'SQL Query',
    19 => 'Odhlásiť',
    20 => 'Užívateľské informácie:',
    21 => 'Užívateľské meno',
    22 => 'Užívateľské ID',
    23 => 'Úroveň bezpečnosti',
    24 => 'Anonymný užívateľ',
    25 => 'Odpovedať',
    26 => 'Nasledujúce komentáre sú vlastníctvom tých, ktorí ich napísali. Tento portál nie je zodpovedný za to, čo hovoria.',
    27 => 'Posledný príspevok',
    28 => 'Zmazať',
    29 => 'Žiadne komentáre.',
    30 => 'Staršie príspevky',
    31 => 'Povolené HTML Tagy:',
    32 => 'Chyba, zlé meno',
    33 => 'Chyba, nepovolený zápis do log súboru',
    34 => 'Chyba',
    35 => 'Odhlásenie',
    36 => ' - ',
    37 => 'Žiadne články',
    38 => 'Content Syndication',
    39 => 'Obnoviť',
    40 => '',
    41 => 'Neprihlásený užívateľ',
    42 => 'Autor:',
    43 => 'Reagovať',
    44 => 'Nadradený',
    45 => 'MySQL číslo chyby',
    46 => 'MySQL chybová správa',
    47 => 'Prihlásenie',
    48 => 'Moje konto',
    49 => 'Preferencie',
    50 => 'Problém s databázou',
    51 => 'pomoc',
    52 => 'Novinka(y)',
    53 => 'Admin Home',
    54 => 'Nemôžem otvoriť súbor',
    55 => 'Chyba na',
    56 => 'Hlasovať',
    57 => 'Heslo',
    58 => 'Login',
    59 => "Ešte nemáte konto?  Prihláste sa ako <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">nový užívateľ</a>.",
    60 => 'Odoslať komentár',
    61 => 'Vytvoriť nové konto',
    62 => 'slov',
    63 => 'Nastavenie komentárov',
    64 => 'Poslať článok mailom',
    65 => 'Zobraziť verziu pre tlač',
    66 => '',
    67 => 'Vitajte na',
    68 => 'Domov',
    69 => 'Kontakt',
    70 => 'Hľadať',
    71 => 'Nový príspevok',
    72 => 'Odkazy',
    73 => '',
    74 => '',
    75 => 'Podrobnejšie vyhľadávanie',
    76 => 'Štatistiky stránok',
    77 => 'Zásuvné moduly',
    78 => '',
    79 => 'Novinky',
    80 => 'články v posledných',
    81 => 'článok v poslednom',
    82 => 'hodinách',
    83 => 'Komentáre',
    84 => '',
    85 => 'do 48 hod',
    86 => 'Žiadne nové komentáre',
    87 => 'do 2 týždňov',
    88 => '',
    89 => '',
    90 => 'Hlavná stránka',
    91 => 'Vygenerované za',
    92 => 'sekúnd',
    93 => 'Copyright',
    94 => 'Všetky ochranné známky a autorské práva na tejto stránke patria dotyčným autorom a vlastníkom.',
    95 => 'Systém',
    96 => 'Skupiny',
    97 => 'Zoznam slov',
    98 => 'Zásuvné moduly',
    99 => 'Články',
    100 => 'Žiadne nové články',
    101 => '',
    102 => '',
    103 => 'DB zálohy',
    104 => 'autor:',
    105 => 'Mailoví používatelia',
    106 => 'Videné',
    107 => 'GL test verzie',
    108 => 'Vyčistiť cache',
    109 => 'Report abuse',
    110 => 'Report this post to the site admin',
    111 => '',
    112 => 'Registrovaní užívatelia',
    113 => 'Dokumentácia',
    114 => 'Trackbacks',
    115 => 'No new trackback comments',
    116 => 'Trackback',
    117 => 'Archív článkov',
    118 => 'Pokračujte čítaním na ďalšej strane:',
    119 => "Zabudli ste <a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">heslo</a>?",
    120 => 'Trvalý odkaz na tento komentár',
    121 => 'Odkazy (%d)',
    122 => 'Trackbacks (%d)',
    123 => 'Povolený je ľubovoľný HTML kód',
    124 => 'Kliknite pre vymazanie všetkých vyznačených položiek',
    125 => 'Naozaj chcete vymazať všetky vyznačené položky?',
    126 => 'Označiť alebo odznačiť',
    127 => 'Trvalý odkaz',
    128 => 'Prihlásiť sa s OpenID:',
    129 => 'Konfigurácia',
    130 => 'Web služby'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Poslať komentár',
    2 => 'Post Mode',
    3 => 'Odhlásiť',
    4 => 'Vytvoriť konto',
    5 => 'Užívateľ',
    6 => 'Tento portál vyžaduje prihlásenie pre vloženie komentára. Ak nemáte konto, použite formulár nižšie na jeho vytvorenie.',
    7 => 'Váš posledný komentár bol pred ',
    8 => " sekundami.  Tento portál vyžaduje aspoň {$_CONF['commentspeedlimit']} sekúnd medzi komentármi",
    9 => 'Komentár',
    10 => 'Odoslať správu',
    11 => 'Odoslať komentár',
    12 => 'Prosím vyplňte nadpis a/alebo samotný komentár. Je to nutné, ak chcete komentár odoslať.',
    13 => 'Vaše údaje',
    14 => 'Náhľad',
    15 => 'Nahlásiť tento príspevok',
    16 => 'Nadpis',
    17 => 'Chyba',
    18 => 'Dôležité',
    19 => 'Treba sa držať témy.',
    20 => 'Je lepšie odpovedať na konkrétny komentár, ako začínať dalšie vlákno.',
    21 => 'Prečítať si príspevky ostatných, aby sa komentáre neopakovali.',
    22 => 'Použiť jasný nadpis, ktorý hovorí o komentári.',
    23 => 'Váš e-mail NEBUDE zobrazený',
    24 => 'Anonymný užívateľ',
    25 => 'Naozaj chcete poslať oznámenie o tomto komentári administrátorovi portálu?',
    26 => '%s oznámil nasledovný nevhodný komentár:',
    27 => 'Správa o nevhodných komentároch',
    28 => 'Náhľad zmien',
    29 => 'Odoslať zmeny',
    30 => 'Upravované',
    31 => 'autor:',
    32 => 'Úprava komentára',
    33 => 'Editing a Comment Submission',
    34 => 'Preview Submission Changes',
    35 => 'Uložiť zmeny do fronty',
    36 => 'Oznámiť mi nové komentáre',
    37 => 'Nová odpoveď na komentár',
    38 => 'Na váš komentár prišla odpoveď \'%s\'.',
    39 => 'Môžete si prezrieť celé vlákno komentárov na nasledovnej adrese:',
    40 => 'Ak si neželáte prijímať ďalšie oznámenia o odpovediach, navšívte nasledovný odkaz:',
    41 => 'Vitajte %s,',
    42 => 'Prestať odoberať príspevky',
    43 => 'Prestať odoberať upozornenia na odpovede',
    44 => 'Your Name'
);

###############################################################################
# users.php

$LANG04 = array(
    1 => 'Profil užívateľa',
    2 => 'Meno užívateľa',
    3 => 'Celé meno',
    4 => 'Heslo',
    5 => 'E-mail',
    6 => 'Webová stránka',
    7 => 'O mne',
    8 => 'PGP Klúč',
    9 => 'Uložiť',
    10 => 'Posledných 10 komentárov užívateľa',
    11 => 'Žiadne komentáre',
    12 => 'Užívateľské preferencie pre',
    13 => 'Email Nightly Digest',
    14 => 'This password is generated by a randomizer. It is recommended that you change this password immediately. To change your password, log in and then click Account Information from the User Functions menu.',
    15 => "Your {$_CONF['site_name']} account has been created successfully. To be able to use it, you must login using the information below. Please save this mail for further reference.",
    16 => 'Your Account Information',
    17 => 'Account does not exist',
    18 => 'The email address provided does not appear to be a valid email address',
    19 => 'The username or email address provided already exists',
    20 => 'The email address provided does not appear to be a valid email address',
    21 => 'Error',
    22 => "Vytvorenie prístupu pre {$_CONF['site_name']}",
    23 => 'Vytvorením konta máte možnosť písať komentáre a prispievať článkami pod svojím menom. Pokiaľ si prístup nevytvoríte, budete mať obmedzený anonymný prístup. Váš e-mail nebude <b><i>nikdy</i></b> zobrazovaný.',
    24 => 'Heslo Vám bude zaslané na e-mailovú adresu, ktorú zadáte.',
    25 => 'Zabudli ste svoje heslo?',
    26 => 'Zadajte Vaše prihlasovacie meno a kliknite na odoslať heslo. Bude Vám na Vašu nastavenú e-mailovú adresu zaslané heslo.',
    27 => 'Vytvoriť konto',
    28 => 'Odoslať heslo',
    29 => 'odhlásenie z',
    30 => 'prihlásenie z',
    31 => 'Táto akcia vyžaduje prihlásenie',
    32 => 'Podpis',
    33 => 'Verejne sa nezobrazuje',
    34 => 'Vaše skutočné meno',
    35 => 'Pri zmene hesla tu zadať nové heslo',
    36 => 'Musí začínať s http://',
    37 => 'Použije sa pre komentáre',
    38 => 'Ďalšie verejné informácie o Vás',
    39 => 'Váš verejný PGP kľúč',
    40 => 'Žiadne ikony tém',
    41 => 'Willing to Moderate',
    42 => 'Formát dátumu',
    43 => 'Maximum príspevkov',
    44 => 'Bez stĺpcov',
    45 => 'Nastavenie zobrazovania pre',
    46 => 'Vynechané položky pre',
    47 => 'Konfigurácia boxov na pravej strane pre',
    48 => 'Témy',
    49 => 'V článkoch sa nebudú zobrazovať ikony tém',
    50 => 'Uncheck this if you aren\'t interested',
    51 => 'Just the news stories',
    52 => 'The default is',
    53 => 'Receive the days stories every night',
    54 => 'Označiť témy a autorov, ktorých nechcete vidieť.',
    55 => 'Ak necháš všetko neoznačené, znamená to, že chceš štandardné nastavenie. Ak už začneš označovať, označ naozaj všetko, co chceš. Štandardné nastavenie bude ignorovať. Štandardné položky sú <strong>tučné</strong>.',
    56 => 'Autori',
    57 => 'Mód zobrazenia',
    58 => 'Poradie triedenia',
    59 => 'Limit na počet komentárov',
    60 => 'Ako zobrazovať komentáre?',
    61 => 'Od najnovších alebo od najstarších?',
    62 => 'Štandard je 100',
    63 => "Bolo Vám zaslané heslo e-mailom a malo by k Vám v krátkom čase prísť. Prosíme následujte inštrukcie v e-maili. Ďakujeme Vám za prihlásenie do {$_CONF['site_name']}.",
    64 => 'Nastavenie komentárov pre',
    65 => 'Skúste sa prihlásiť znovu',
    66 => "Nesprávne prihlasovacie údaje. Prosím skúste opätovné prihlásenie nižšie. Alebo ste <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">nový užívateľ</a>?",
    67 => 'Člen od',
    68 => 'Pamätať prihlásenie',
    69 => 'Ako dlho si má stránka pamätať prihlásenie?',
    70 => "Customize the layout and content of {$_CONF['site_name']}",
    71 => "One of the great features of {$_CONF['site_name']} is you can customize the content you get and you can change the overall layout of this site.  In order to take advantage of these great features you must first <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">register</a> with {$_CONF['site_name']}.  Are you already a member?  Then use the login form to the left to log in!",
    72 => 'Téma zobrazenia',
    73 => 'Jazyk',
    74 => 'Zmeniť vzhľad portálu',
    75 => 'Emailed Topics for',
    76 => 'If you select a topic from the list below you will receive any new stories posted to that topic at the end of each day.  Choose only the topics that interest you!',
    77 => 'Fotografia',
    78 => 'Pridať fotografiu alebo obrázok.',
    79 => 'Zaškrtnúť pre vymazanie tohto obrázku.',
    80 => 'Prihlásenie',
    81 => 'Poslať mail',
    82 => 'Last 10 stories for user',
    83 => 'Posting statistics for user',
    84 => 'Total number of articles:',
    85 => 'Total number of comments:',
    86 => 'Find all postings by',
    87 => 'Your login name',
    88 => "Someone (possibly you) has requested a new password for your account \"%s\" on {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nIf you really want this action to be taken, please click on the following link:\n\n",
    89 => "If you do not want this action to be taken, simply ignore this message and the request will be disregarded (your password will remain unchanged).\n\n",
    90 => 'You can enter a new password for your account below. Please note that your old password is still valid until you submit this form.',
    91 => 'Set New Password',
    92 => 'Enter New Password',
    93 => 'Your last request for a new password was %d seconds ago. This site requires at least %d seconds between password requests.',
    94 => 'Delete Account "%s"',
    95 => 'Click the "delete account" button below to remove your account from our database. Please note that any stories and comments you posted under this account will <strong>not</strong> be deleted but show up as being posted by "Anonymous".',
    96 => 'delete account',
    97 => 'Confirm Account Deletion',
    98 => 'Are you sure you want to delete your account? By doing so, you will not be able to log into this site again (unless you create a new account). If you are sure, click "delete account" again on the form below.',
    99 => 'Privacy Options for',
    100 => 'Maily od administrátora',
    101 => 'Allow email from Site Admins',
    102 => 'Maily od užívateľov',
    103 => 'Allow email from other users',
    104 => 'Zobrazovať online status',
    105 => 'Show up in Who\'s Online block',
    106 => 'Miesto',
    107 => 'Zobrazené vo verejnom profile',
    108 => 'Potvrdiť nové heslo',
    109 => 'Tu ešte raz potvrdiť nové heslo',
    110 => 'Doterajšie heslo',
    111 => 'Tu zadať doterajšie heslo do systému',
    112 => 'You have exceeded the number of allowed login attempts.  Please try again later.',
    113 => 'Login Attempt Failed',
    114 => 'Account Disabled',
    115 => 'Your account has been disabled, you may not login. Please contact an Administrator.',
    116 => 'Account Awaiting Activation',
    117 => 'Your account is currently awaiting activation by an administrator. You will not be able to login until your account has been approved.',
    118 => "Your {$_CONF['site_name']} account has now been activated by an administrator. You may now login to the site at the url below using your username (<username>) and password as previously emailed to you.",
    119 => 'If you have forgotten your password, you may request a new one at this url:',
    120 => 'Account Activated',
    121 => 'Service',
    122 => 'Sorry, new user registration is disabled',
    123 => "Are you a <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">new user</a>?",
    124 => 'Zopakovať e-mail',
    125 => 'Musíte zadať rovnakú e-mailovú adresu v oboch políčkach!',
    126 => 'Zopakujte pre potvrdenie',
    127 => 'Pre ľubovoľnú zmenu týchto nastavení budete potrebovať zadať svoje heslo.',
    128 => 'Meno',
    129 => 'Heslo a mail',
    130 => 'O mne',
    131 => 'Daily Digest Options',
    132 => 'Daily Digest Feature',
    133 => 'Zobrazenie komentárov',
    134 => 'Možnosti komentárov',
    135 => '<li>Default mode for how comments will be displayed</li><li>Default order to display comments</li><li>Set maximum number of comments to show - default is 100</li>',
    136 => 'Skrývať témy a autorov',
    137 => 'Filter Story Content',
    138 => 'Rozličné nastavenia',
    139 => 'Layout and Language',
    140 => '<li>No Topic Icons if checked will not display the story topic icons</li><li>No boxes if checked will only show the Admin Menu, User Menu and Topics<li>Set the maximum number of stories to show per page</li><li>Set your theme and perferred date format</li>',
    141 => 'Nastavenie súkromia',
    142 => 'The default setting is to allow users & admins to email fellow site members and show your status as online. Un-check these options to protect your privacy.',
    143 => 'Filter Block Content',
    144 => 'Zobraziť/skryť bloky',
    145 => 'Your Public Profile',
    146 => 'Password and email',
    147 => 'Edit your account password, email and autologin feature. You will need to enter the same password or email address twice as a confirmation.',
    148 => 'User Information',
    149 => 'Modify your user information that will be shown to other users.<li>The signature will be added to any comments or forum posts you made</li><li>The BIO is a brief summary of yourself to share</li><li>Share your PGP Key</li>',
    150 => 'Warning: Javascript recommended for enhanced functionality',
    156 => 'Delete Account',
    157 => 'Delete Option',
    158 => 'Časové pásmo',
    159 => 'This email was generated automatically. Please do not reply to this email.',
    160 => '(max. %d x %d pixels, %d bytes; %s)',
    161 => 'will be scaled down',
    162 => 'will not be scaled',
    163 => 'Re-Authentication Failed',
    164 => 'You have exceeded the number of allowed attempts for re-authentication. The operation has been aborted and your recent changes were lost, sorry.',
    165 => 'Use Advanced Editor'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Prehľad',
    'pe_namepass' => 'Meno a heslo',
    'pe_userinfo' => 'O mne',
    'pe_layout' => 'Zobrazenie a jazyk',
    'pe_content' => 'Obsah',
    'pe_privacy' => 'Súkromie'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'No News to Display',
    2 => 'There are no news stories to display.  There may be no news for this topic or your user preferences may be too restrictive',
    3 => ' for topic %s',
    4 => 'Dnešný hlavný članok',
    5 => 'Ďalší',
    6 => 'Predošlý',
    7 => 'Prvý',
    8 => 'Posledný'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'There was an error sending your message. Please try again.',
    2 => 'Message sent successfully.',
    3 => 'Please make sure you use a valid email address in the Reply To field.',
    4 => 'Please fill in the Your Name, Reply To, Subject and Message fields',
    5 => 'Error: No such user.',
    6 => 'There was an error.',
    7 => 'User Profile for',
    8 => 'User Name',
    9 => 'User URL',
    10 => 'Send mail to',
    11 => 'Your Name:',
    12 => 'Reply To:',
    13 => 'Subject:',
    14 => 'Message:',
    15 => 'HTML will not be translated.',
    16 => 'Send Message',
    17 => 'Mail Story to a Friend',
    18 => 'To Name',
    19 => 'To Email Address',
    20 => 'From Name',
    21 => 'From Email Address',
    22 => 'All fields are required',
    23 => "This email was sent to you by %s at %s because they thought you might be interested it this article from {$_CONF['site_url']}.  This is not SPAM and the email addresses involved in this transaction were not saved to a list or stored for later use.",
    24 => 'Comment on this story at',
    25 => 'You must be logged in to user this feature.  By having you log in, it helps us prevent misuse of the system',
    26 => 'This form will allow you to send an email to the selected user.  All fields are required.',
    27 => 'Short message',
    28 => '%s wrote: ',
    29 => "This is the daily digest from {$_CONF['site_name']} for ",
    30 => ' Daily Newsletter for ',
    31 => 'Nadpis',
    32 => 'Dátum',
    33 => 'Read the full article at',
    34 => 'End of Message',
    35 => 'Sorry, this user prefers not to receive any emails.',
    36 => 'Copy:',
    37 => 'Send me a copy of this email',
    38 => "This is a copy of the email that you sent to %s from <{$_CONF['site_url']}>:"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Pokročilé vyhľadávanie',
    2 => 'Kľúčové slová',
    3 => 'Téma',
    4 => 'Všetko',
    5 => 'Typ',
    6 => 'Články',
    7 => 'Komentáre',
    8 => 'Autor',
    9 => 'Všetko',
    10 => 'Hľadať',
    11 => 'Výsledky hľadania',
    12 => 'zhôd',
    13 => 'Výsledok hľadania: žiadna zhoda',
    14 => 'Nenašla sa žiadna zhoda pri hľadaní',
    15 => 'Skúste znova.',
    16 => 'Nadpis',
    17 => 'Dátum',
    18 => 'Autor',
    19 => "Prehľadávanie celej databázy {$_CONF['site_name']} v aktuálnych a starších článkoch",
    20 => 'Dátum',
    21 => 'do',
    22 => '(Formát dátumu YYYY-MM-DD)',
    23 => 'Prístupy',
    24 => 'Nášiel',
    25 => 'Vyhľadávanie',
    26 => 'položiek za',
    27 => 'sekúnd',
    28 => 'Žiadny článok alebo komentár nepasuje na tvoje hľadanie',
    29 => 'Výsledok pre články a komentáre',
    30 => '',
    31 => 'Tento modul nenašiel žiadnu zhodu',
    32 => '',
    33 => 'URL',
    34 => 'Miesto',
    35 => 'Celý deň',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Your query string should have at least 3 characters.',
    42 => 'Please use a date formatted as YYYY-MM-DD (year-month-day).',
    43 => 'presný text',
    44 => 'všetky tieto slová',
    45 => 'ľubovoľné z týchto slov',
    46 => 'Ďalší',
    47 => 'Predošlý',
    48 => 'Autor',
    49 => 'Dátum',
    50 => 'Hits',
    51 => '',
    52 => 'Location',
    53 => 'Story Results',
    54 => 'Comment Results',
    55 => 'frázy',
    56 => 'AND',
    57 => 'OR',
    58 => 'More results &gt;&gt;',
    59 => 'Výsledky',
    60 => 'na stranu',
    61 => 'Spresniť vyhľadávanie',
    62 => '#',
    63 => 'Description',
    64 => 'Zobrazujú sa výsledky %1$d - %2$d z %3$d',
    65 => 'Story',
    66 => 'Comment',
    67 => 'Show %d Results',
    68 => 'Sort By',
    69 => 'Titles Only',
    70 => 'Not available ...',
    71 => 'asc',
    72 => 'desc'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Štatistiky stránok',
    2 => 'Celkový počet prístupov',
    3 => 'Články(Komentáre)',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Najčítanejšie články',
    8 => 'Nadpis',
    9 => 'Zobrazenia',
    10 => 'Zdá sa, že na portáli nie sú žiadne články alebo ich nikto nečíta.',
    11 => 'Najkomentovanejšie články',
    12 => 'Komentárov',
    13 => 'Zdá sa, že na portáli nie sú žiadne články alebo ich nikto nekomentuje.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'Články najviac posielané e-mailom',
    23 => 'E-maily',
    24 => 'Zdá sa, že nikto neposielal článok e-mailom.',
    25 => 'Top Ten Trackback Commented Stories',
    26 => 'No trackback comments found.',
    27 => 'Number of active users',
    28 => '',
    29 => '',
    30 => 'Hits',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Podobné',
    2 => 'Pošli e-mailom',
    3 => 'Verzia pre tlač',
    4 => 'Voľby článku',
    5 => '',
    6 => 'Subscribe to \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'To submit a %s you are required to be logged in as a user.',
    2 => 'Login',
    3 => 'New User',
    4 => '',
    5 => '',
    6 => 'Submit a Story',
    7 => 'Login is Required',
    8 => 'Submit',
    9 => 'When submitting information for use on this site we ask that you follow the following suggestions...<ul><li>Fill in all the fields, they\'re required<li>Provide complete and accurate information<li>Double check those URLs</ul>',
    10 => 'Nadpis',
    11 => '',
    12 => 'Start Date',
    13 => 'End Date',
    14 => 'Location',
    15 => 'Description',
    16 => '',
    17 => '',
    18 => '',
    19 => 'Read First',
    20 => '',
    21 => '',
    22 => 'Error: Missing Fields',
    23 => 'Please fill in all the fields on the form.  All fields are required.',
    24 => 'Submission Saved',
    25 => 'Your %s submission has been saved successfully.',
    26 => 'Speed Limit',
    27 => 'Username',
    28 => 'Topic',
    29 => 'Story',
    30 => 'Your last submission was ',
    31 => " seconds ago.  This site requires at least {$_CONF['speedlimit']} seconds between submissions",
    32 => 'Preview',
    33 => 'Story Preview',
    34 => 'Log Out',
    35 => 'HTML tags are not allowed',
    36 => 'Post Mode',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Address Line 1',
    45 => 'Address Line 2',
    46 => 'City/Town',
    47 => 'State',
    48 => 'Zip Code',
    49 => '',
    50 => '',
    51 => 'Miesto',
    52 => 'Zmazať',
    53 => 'Create Account',
    54 => 'Story Introduction',
    55 => 'Story Body'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Authentication Required',
    2 => 'Denied! Incorrect Login Information',
    3 => 'Invalid password for user',
    4 => 'Username:',
    5 => 'Password:',
    6 => 'All access to administrative portions of this web site are logged and reviewed.<br' . XHTML . '>This page is for the use of authorized personnel only.',
    7 => 'login'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Insufficient Admin Rights',
    2 => 'You do not have the necessary rights to edit this block.',
    3 => 'Block Editor',
    4 => 'There was a problem reading this feed (see error.log for details).',
    5 => '',
    6 => '',
    7 => 'All',
    8 => 'Block Security Level',
    9 => 'Block Order',
    10 => '',
    11 => 'Portal Block',
    12 => 'Normal Block',
    13 => 'Portal Block Options',
    14 => 'RDF URL',
    15 => 'Last RDF Update',
    16 => 'Normal Block Options',
    17 => 'Block Content',
    18 => 'Please fill in the Block Title, Security Level and Content fields',
    19 => 'Block Manager',
    20 => '',
    21 => 'Block SecLev',
    22 => '',
    23 => 'Block Order',
    24 => '',
    25 => 'To modify or delete a block, click on that block below.  To create a new block click on new block above.',
    26 => 'Layout Block',
    27 => 'PHP Block',
    28 => 'PHP Block Options',
    29 => 'Block Function',
    30 => 'If you would like to have one of your blocks use PHP code, enter the name of the function above.  Your function name must start with the prefix "phpblock_" (e.g. phpblock_getweather).  If it does not have this prefix, your function will NOT be called.  We do this to keep people who may have hacked your Geeklog installation from putting arbitrary function calls that may be harmful to your system.  Be sure not to put empty parenthisis "()" after your function name.  Finally, it is recommended that you put all your PHP Block code in /path/to/geeklog/system/lib-custom.php.  That will allow the code to stay with you even when you upgrade to a newer version of Geeklog.',
    31 => 'Error in PHP Block.  Function, %s, does not exist.',
    32 => 'Error Missing Field(s)',
    33 => 'You must enter the URL to the .rdf file for portal blocks',
    34 => 'You must enter the title and the function for PHP blocks',
    35 => 'You must enter the title and the content for normal blocks',
    36 => 'You must enter the content for layout blocks',
    37 => 'Bad PHP block function name',
    38 => 'Functions for PHP Blocks must have the prefix \'phpblock_\' (e.g. phpblock_getweather).  The \'phpblock_\' prefix is required for security reasons to prevent the execution of arbitrary code.',
    39 => 'Side',
    40 => 'Left',
    41 => 'Right',
    42 => 'You must enter the blockorder and security level for Geeklog default blocks',
    43 => 'Homepage Only',
    44 => '',
    45 => "You are trying to access a block that you don't have rights to.  This attempt has been logged. Please <a href=\"{$_CONF['site_admin_url']}/block.php\">go back to the block administration screen</a>.",
    46 => 'New Block',
    47 => '',
    48 => 'Block Name',
    49 => ' (no spaces and must be unique)',
    50 => 'Help File URL',
    51 => 'include http://',
    52 => 'If you leave this blank the help icon for this block will not be displayed',
    53 => 'Zapnuté',
    54 => 'save',
    55 => 'cancel',
    56 => 'delete',
    57 => 'Move Block Down',
    58 => 'Move Block Up',
    59 => 'Move block to the right side',
    60 => 'Move block to the left side',
    61 => 'No Title',
    62 => 'Article Limit',
    63 => 'Bad Block Title',
    64 => 'Your Title must not be empty and cannot contain HTML!',
    65 => 'Order',
    66 => 'Autotags',
    67 => 'Check to allow autotags',
    68 => 'The feed for this portal block is too long to display. Please set a maximum number of articles to import for the block in the block setup screen, or a global maximum in Geeklog Configuration.'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => 'Previous Stories',
    2 => 'Next Stories',
    3 => 'Mode',
    4 => 'Post Mode',
    5 => 'Editor článku',
    6 => 'There are no stories in the system',
    7 => 'Autor',
    8 => 'uložiť',
    9 => 'náhľad',
    10 => 'zrušiť',
    11 => 'zmazať',
    12 => 'ID',
    13 => '',
    14 => '',
    15 => 'Dátum',
    16 => 'Text v úvodníku',
    17 => 'Text v tele',
    18 => 'Zobrazenia',
    19 => 'Komentáre',
    20 => 'Ping',
    21 => 'Send Ping',
    22 => 'Story List',
    23 => 'To modify or delete a story, click on that story\'s number below. To view a story, click on the title of the story you wish to view. To create a new story click on new story above.',
    24 => 'The ID you chose for this story is already in use. Please use another ID.',
    25 => 'Error when saving story',
    26 => 'Story Preview',
    27 => 'If you use [unscaledX] instead of [imageX], the image will be inserted at its original dimensions.',
    28 => '<p><b>PREVIEWING</b>: Previewing a story with images attached is best done by saving the article as a draft INSTEAD OF hitting the preview button.  Use the preview button only when images are not attached.',
    29 => 'Trackbacks',
    30 => 'File Upload Errors',
    31 => 'Please fill in the Author, Title and Intro Text fields',
    32 => 'Featured',
    33 => 'There can only be one featured story',
    34 => 'Nečistopis',
    35 => 'Áno',
    36 => 'Nie',
    37 => 'Viac od',
    38 => 'Viac z',
    39 => 'Emails',
    40 => '',
    41 => "You are trying to access a story that you don't have rights to.  This attempt has been logged.  You may view the article in read-only below. Please <a href=\"{$_CONF['site_admin_url']}/story.php\">go back to the story administration screen</a> when you are done.",
    42 => "You are trying to access a story that you don't have rights to.  This attempt has been logged.  Please <a href=\"{$_CONF['site_admin_url']}/story.php\">go back to the story administration screen</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>NOTE:</b> if you modify this date to be in the future, this article will not be published until that date.  That also means the story will not be included in your RDF headline feed and it will be ignored by the search and statistics pages.',
    47 => 'Obrázky',
    48 => 'image',
    49 => 'right',
    50 => 'left',
    51 => 'To add one of the images you are attaching to this article you need to insert specially formatted text.  The specially formatted text is [imageX], [imageX_right] or [imageX_left] where X is the number of the image you have attached.  NOTE: You must use the images you attach.  If you do not you will be unable to save your story.<BR><P><B>PREVIEWING</B>: Previewing a story with images attached is best done by saving the article as a draft INSTEAD OF hitting the preview button.  Use the preview button only when images are not attached.',
    52 => '',
    53 => 'was not used.  You must include this image in the intro or body before you can save your changes',
    54 => 'Attached Images Not Used',
    55 => 'The following errors occured while trying to save your story.  Please correct these errors before saving',
    56 => 'Show Topic Icon',
    57 => 'View unscaled image',
    58 => 'Správa článku',
    59 => 'Nastavenie',
    60 => '',
    61 => 'Auto Archive',
    62 => 'Auto Delete',
    63 => 'Disable Comments',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Expand the Content Edit Area size',
    68 => 'Reduce the Content Edit Area size',
    69 => 'Publish Story Date',
    70 => 'Toolbar Selection',
    71 => 'Basic Toolbar',
    72 => 'Common Toolbar',
    73 => 'Advanced Toolbar',
    74 => 'Advanced II Toolbar',
    75 => 'Full Featured',
    76 => 'Publish Options',
    77 => 'Javascript needs to be enabled for Advanced Editor. Option can be disabled in the main site config.php',
    78 => 'Click <a href="%s/story.php?mode=edit&amp;sid=%s&amp;editopt=default">here</a> to use default editor',
    79 => 'Náhľad',
    80 => 'Redaktor',
    81 => 'Publish Options',
    82 => 'Images',
    83 => 'Archive Options',
    84 => 'Prístupové práva',
    85 => 'Zobraziť všetky',
    86 => 'Advanced Editor',
    87 => 'Story Stats',
    88 => 'Wiki-style format',
    89 => 'Meta Description',
    90 => 'Meta Keywords',
    91 => 'You can always hit "Preview" to extend the expiry time.'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Topic Editor',
    2 => 'Topic ID',
    3 => 'Topic Name',
    4 => 'Topic Image',
    5 => '(do not use spaces)',
    6 => 'Deleting a topic deletes all stories and blocks associated with it',
    7 => 'Please fill in the Topic ID and Topic Name fields',
    8 => 'Topic Manager',
    9 => 'To modify or delete a topic, click on that topic.  To create a new topic click the new topic button to the left. You will find your access level for each topic in parenthesis',
    10 => 'Sort Order',
    11 => 'Stories/Page',
    12 => 'Access Denied',
    13 => "You are trying to access a topic that you don't have rights to.  This attempt has been logged. Please <a href=\"{$_CONF['site_admin_url']}/topic.php\">go back to the topic administration screen</a>.",
    14 => 'Sort Method',
    15 => 'alphabetical',
    16 => 'default is',
    17 => 'New Topic',
    18 => 'Admin Home',
    19 => 'uložiť',
    20 => 'zrušiť',
    21 => 'zmazať',
    22 => 'Default',
    23 => 'make this the default topic for new story submissions',
    24 => '(*)',
    25 => 'Archive Topic',
    26 => 'make this the default topic for archived stories. Only one topic allowed.',
    27 => 'Or Upload Topic Icon',
    28 => 'Maximum',
    29 => 'File Upload Errors',
    30 => 'Stories in Topic'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'Editor užívateľa',
    2 => 'Číslo užívateľa',
    3 => 'Meno užívateľa',
    4 => 'Celé meno',
    5 => 'Heslo',
    6 => 'Security Level',
    7 => 'Emailová adresa',
    8 => 'Domovská stránka',
    9 => '(nepoužívať medzery)',
    10 => 'Please fill in the Username and Email Address fields',
    11 => 'User Manager',
    12 => 'To modify or delete a user, click on that user below.  To create a new user click the new user button to the left. You can do simple searches by entering parts of a username,email address or fullname (e.g.*son* or *.edu) in the form below.',
    13 => 'SecLev',
    14 => 'Reg. Date',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'uložiť',
    21 => 'The username you tried saving already exists.',
    22 => 'Error',
    23 => 'Batch Add',
    24 => 'Batch Import of Users',
    25 => 'You can import a batch of users into Geeklog.  The import file must a tab-delimited text file and must have the fields in the following order: full name, username, email address.  Each user you import will be emailed with a random password.  You must have one user entered per line.  Failure to follow these instructions will cause problems that may require manual work so double check your entries!',
    26 => '',
    27 => '',
    28 => 'Check here to delete this picture',
    29 => 'Path',
    30 => 'Import',
    31 => 'New Users',
    32 => 'Done processing. Imported %d and encountered %d failures',
    33 => 'submit',
    34 => 'Error: You must specify a file to upload.',
    35 => 'Last Login',
    36 => '(never)',
    37 => 'UID',
    38 => 'Group Listing',
    39 => 'Password (again)',
    40 => 'Registration Date',
    41 => 'Last login Date',
    42 => 'Banned',
    43 => 'Awaiting Activation',
    44 => 'Awaiting Authorization',
    45 => 'Active',
    46 => 'User Status',
    47 => 'Edit',
    48 => 'Show Admin Groups',
    49 => 'Admin Group',
    50 => 'Check to allow filtering this group as an Admin Use Group',
    51 => 'Online Days',
    52 => '<br' . XHTML . '>Note: "Online Days" is the number of days between the first registration and the last login.',
    53 => 'registered',
    54 => 'Batch Delete',
    55 => 'This only works if you have <code>$_CONF[\'lastlogin\'] = true;</code> in your config.php',
    56 => 'Please choose the type of user you want to delete and press "Update List". Then, uncheck those from the list you do not want to delete and press "Delete". Please note that you will only delete those that are currently visible in case the list spans over several pages.',
    57 => 'Phantom users',
    58 => 'Short-Time Users',
    59 => 'Old Users',
    60 => 'Users that registered more than ',
    61 => ' months ago, but never logged in.',
    62 => 'Users that registered more than ',
    63 => ' months ago, then logged in within 24 hours, but since then never came back to your site.',
    64 => 'Normal users, who simply did not visit your site since ',
    65 => ' months.',
    66 => 'Update List',
    67 => 'Months since registration',
    68 => 'Online Hours',
    69 => 'Offline Months',
    70 => 'could not be deleted',
    71 => 'sucessfully deleted',
    72 => 'No User selected for deletion',
    73 => 'Are You sure you want to permanently delete ALL selected users?',
    74 => 'Recent Users',
    75 => 'Users that registered in the last ',
    76 => ' months',
    77 => 'Email site login reminder to selected users',
    78 => 'Send Reminder',
    79 => 'No User selected for reminders',
    80 => 'Successfully sent Reminders',
    81 => 'Reminder to verify account for %s',
    82 => "Your account on {$_CONF['site_name']} has not been accesssed since %s and will be disabled if not accessed in the 30 days.",
    83 => "Your account on {$_CONF['site_name']} has not been used since it was created and will deleted soon if not accessed.",
    84 => "Your login name is: %s  for our site: {$_CONF['site_url']}",
    85 => 'If you have forgotten the password use the following link: %s',
    86 => 'Include',
    87 => 'Reminders',
    88 => 'Default Group',
    89 => 'Check to make this a default group for new users',
    90 => 'Apply "Default Group" change to existing user accounts'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => 'Approve',
    2 => 'Delete',
    3 => 'Edit',
    4 => 'Profile',
    10 => 'Nadpis',
    11 => 'Start Date',
    12 => 'URL',
    13 => 'Category',
    14 => 'Date',
    15 => 'Topic',
    16 => 'User name',
    17 => 'Full name',
    18 => 'Email',
    34 => 'Command and Control',
    35 => 'Story Submissions',
    36 => 'Link Submissions',
    37 => '',
    38 => 'Submit',
    39 => 'There are no submissions to moderate at this time',
    40 => 'User Submissions',
    41 => 'Comment Submissions',
    42 => 'User Name',
    43 => 'Auto-publish Comments?'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "{$_CONF['site_name']} Mail Utility",
    2 => 'From',
    3 => 'Reply-to',
    4 => 'Subject',
    5 => 'Body',
    6 => 'Send to:',
    7 => 'All users',
    8 => 'Admin',
    9 => 'Options',
    10 => 'HTML',
    11 => 'Urgent message!',
    12 => 'Send',
    13 => 'Reset',
    14 => 'Ignore user settings',
    15 => 'Error when sending to: ',
    16 => 'Successfully sent messages to: ',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>Send another message</a>",
    18 => 'To',
    19 => 'NOTE: if you wish to send a message to all site members, select the Logged-in Users group from the drop down.',
    20 => "Successfully sent <successcount> messages and unsuccessfully sent <failcount> messages.  If you need them, the details of each message attempts is below.  Otherwise you can <a href=\"{$_CONF['site_admin_url']}/mail.php\">Send another message</a> or you can <a href=\"{$_CONF['site_admin_url']}/moderation.php\">go back to the administration page</a>.",
    21 => 'Failures',
    22 => 'Successes',
    23 => 'No failures',
    24 => 'No successes',
    25 => '-- Select Group --',
    26 => 'Please fill in all the fields on the form and select a group of users from the drop down.'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'Installing plugins could possibly cause damage to your Geeklog installation and, possibly, to your system.  It is important that you only install plugins downloaded from the <a href="http://www.geeklog.net" target="_blank">Geeklog Homepage</a> as we thoroughly test all plugins submitted to our site on a variety of operating systems.  It is important that you understand that the plugin installation process will require the execution of a few filesystem commands which could lead to security problems particularly if you use plugins from third party sites.  Even with this warning you are getting, we do not gaurantee the success of any installation nor are we liable for damage caused by installing a Geeklog plugin.  In other words, install at your own risk.  For the wary, directions on how to manually install a plugin is included with each plugin package.',
    2 => 'Plug-in Installation Disclaimer',
    3 => 'Plug-in Installation Form',
    4 => 'Plug-in File',
    5 => 'Plug-in List',
    6 => 'Warning: Plug-in Already Installed!',
    7 => 'The plug-in you are trying to install already exists.  Please delete the plugin before re-installing it',
    8 => 'Plugin Compatibility Check Failed',
    9 => 'This plugin requires a newer version of Geeklog. Either upgrade your copy of <a href="http://www.geeklog.net">Geeklog</a> or get a newer version of the plug-in.',
    10 => '<br' . XHTML . '><b>There are no plugins currently installed.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'To modify or delete a plug-in, click on that plug-in\'s number below. To learn more about a plug-in, click the plug-in name and you will be directed to that plug-in\'s website. To install or upgrade a plug-in please consult it\'s documentation.',
    12 => 'no plugin name provided to plugineditor()',
    13 => 'Editor pluginov',
    14 => 'Nový plugin',
    15 => 'Admin Home',
    16 => 'Názov pluginu',
    17 => 'Verzia pluginu',
    18 => 'Verzia GeegLog',
    19 => 'Zapnuté',
    20 => 'Áno',
    21 => 'Nie',
    22 => 'Nainštalovať',
    23 => 'Uložiť',
    24 => 'Zrušiť',
    25 => 'Zmazať',
    26 => 'Plug-in Name',
    27 => 'Plug-in Homepage',
    28 => 'Plug-in Version',
    29 => 'Geeklog Version',
    30 => 'Delete Plug-in?',
    31 => 'Are you sure you want to delete this plug-in?  By doing so you will remove all the files, data and data structures that this plug-in uses.  If you are sure, click delete again on the form below.',
    32 => '<p><b>Error AutoLink tag not correct format</b></p>',
    33 => 'Code Version',
    34 => 'Update',
    35 => 'Edit',
    36 => 'Code',
    37 => 'Data',
    38 => 'Update!',
    39 => 'Upload a plugin',
    40 => 'You can upload a plugin archive (.tar.gz, .tgz, .zip) directly here:',
    41 => 'Upload',
    42 => 'Click to update',
    99 => 'An unknown error occured',
    100 => 'Ok.',
    101 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini.',
    102 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.',
    103 => 'The uploaded file was only partially uploaded.',
    104 => 'No file was uploaded.',
    105 => '(undefined error)',
    106 => 'Missing a temporary folder.',
    107 => 'Failed to write file to disk.',
    108 => 'File upload stopped by extension.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'create feed',
    2 => 'uložiť',
    3 => 'zmazať',
    4 => 'zrušiť',
    10 => 'Content Syndication',
    11 => 'New Feed',
    12 => 'Admin Home',
    13 => 'To modify or delete a feed, click on the feed\'s title below. To create a new feed, click on New Feed above.',
    14 => 'Nadpis',
    15 => 'Type',
    16 => 'Filename',
    17 => 'Format',
    18 => 'last updated',
    19 => 'Zapnuté',
    20 => 'Áno',
    21 => 'Nie',
    22 => '<i>(no feeds)</i>',
    23 => 'all Stories',
    24 => 'Feed Editor',
    25 => 'Feed Title',
    26 => 'Limit',
    27 => 'Length of entries',
    28 => '(0 = no text, 1 = full text, other = limit to that number of chars.)',
    29 => 'Description',
    30 => 'Last Update',
    31 => 'Character Set',
    32 => 'Language',
    33 => 'Contents',
    34 => 'Entries',
    35 => 'Hours',
    36 => 'Select type of feed',
    37 => '',
    38 => 'Error: Missing Fields',
    39 => 'Please fill in the Feed Title, Description, and Filename.',
    40 => 'Please enter a  number of entries or number of hours.',
    41 => 'Links',
    42 => '',
    43 => 'All',
    44 => 'None',
    45 => 'Header-link in topic',
    46 => 'Limit Results',
    47 => 'Search',
    48 => 'Edit',
    49 => 'Feed Logo',
    50 => "Relative to site url ({$_CONF['site_url']})",
    51 => 'The filename you have chosen is already used by another feed. Please choose a different one.',
    52 => 'Error: existing Filename',
    53 => 'All Frontpage Stories',
    54 => 'Please select the type of feed to create.',
    55 => 'Articles'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Vaše prihlasovacie heslo Vám bolo zaslané na zadanú adresu. Prosím riaďte sa inštrukciami v maili. Ďakujeme Vám za na portáli {$_CONF['site_name']}",
    2 => "Thank-you for submitting your story to {$_CONF['site_name']}.  It has been submitted to our staff for approval. If approved, your story will be available for others to read on our site.",
    3 => '',
    4 => '',
    5 => 'Your account information has been successfully saved.',
    6 => 'Your display preferences have been successfully saved.',
    7 => 'Your comment preferences have been successfully saved.',
    8 => 'Boli ste úspešne odhlásení.',
    9 => 'Článok bol úspešne uložený.',
    10 => 'Článok bol úspešne zmazaný.',
    11 => 'Your block has been successfully saved.',
    12 => 'The block has been successfully deleted.',
    13 => 'Your topic has been successfully saved.',
    14 => 'The topic and all it\'s stories an blocks have been successfully deleted.',
    15 => 'Webový odkaz bol úspešne ulozený.',
    16 => 'Webový odkaz bol úspešne zmazaný.',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => 'The new user has been successfully saved.',
    22 => 'The user has been successfully deleted',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => 'Message successfully sent.',
    28 => 'The plug-in has been successfully saved',
    29 => 'Sorry, you do not have access to this administration page.  Please note that all attempts to access unauthorized features are logged',
    30 => 'Access Denied',
    31 => '',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'Správa systému',
    41 => '',
    42 => '',
    43 => '',
    44 => 'The plug-in was successfully installed!',
    45 => 'The plug-in was successfully deleted.',
    46 => '',
    47 => '',
    48 => "Thank you for applying for a membership with {$_CONF['site_name']}. Our team will review your application. If approved, your password will be emailed to you at the email address you just entered.",
    49 => 'Your group has been successfully saved.',
    50 => 'The group has been successfully deleted.',
    51 => 'This username is already in use. Please choose another one.',
    52 => 'The email address provided does not appear to be a valid email address.',
    53 => 'Your new password has been accepted. Please use your new password below to log in now.',
    54 => 'Your request for a new password has expired. Please try again below.',
    55 => 'An email has been sent to you and should arrive momentarily. Please follow the directions in the message to set a new password for your account.',
    56 => 'The email address provided is already in use for another account.',
    57 => 'Your account has been successfully deleted.',
    58 => 'Your feed has been successfully saved.',
    59 => 'The feed has been successfully deleted.',
    60 => 'The plugin was successfully updated',
    61 => 'Plugin %s: Unknown message placeholder',
    62 => 'The trackback comment has been deleted.',
    63 => 'An error occurred when deleting the trackback comment.',
    64 => 'Your trackback comment has been successfully sent.',
    65 => 'Weblog directory service successfully saved.',
    66 => 'The weblog directory service has been deleted.',
    67 => 'The new password does not match the confirmation password!',
    68 => 'You have to enter the correct current password.',
    69 => 'Your account has been blocked!',
    70 => 'Your account is awaiting administrator approval.',
    71 => 'Your account has now been confirmed and is awaiting administrator approval.',
    72 => 'An error occured while attempting to install the plugin. See error.log for details.',
    73 => 'An error occured while attempting to uninstall the plugin. See error.log for details.',
    74 => 'The pingback has been successfully sent.',
    75 => 'Trackbacks must be sent using a POST request.',
    76 => 'Do you really want to delete this item?',
    77 => 'WARNING:<br' . XHTML . '>You have set your default encoding to UTF-8. However, your server does not support multibyte encodings. Please install mbstring functions for PHP or choose a different character set/language.',
    78 => 'Please make sure that the email address and the confirmation email address are the same.',
    79 => 'The page you have been trying to open refers to a function that no longer exists on this site.',
    80 => 'The plugin that created this feed is currently disabled. You will not be able to edit this feed until you re-enable the parent plugin.',
    81 => 'You may have mistyped your login credentials.  Please try logging in again below.',
    82 => 'You have exceeded the number of allowed login attempts.  Please try again later.',
    83 => 'To change your password, email address, or for how long to remember you, please enter your current password.',
    84 => 'To delete your account, please enter your current password.',
    85 => 'There was a problem sending the email.',
    86 => 'The OpenID server invalidated your login attempt.',
    87 => 'OpenID login operation cancelled by user.',
    88 => 'The OpenID server returned an error.',
    89 => 'Unable to find an OpenID server for the given identity URL.',
    90 => 'OpenID identification cancelled.',
    91 => 'You specified an invalid identity URL.',
    92 => "Please <a href=\"{$_CONF['site_admin_url']}/sectest.php\">check the security of your site</a> before using it!",
    93 => 'Database back up was successful.',
    94 => 'Backup Failed: Filesize less than 1kb',
    95 => 'There was an error.',
    96 => '',
    97 => '',
    98 => 'The plugin was successfully uploaded.',
    99 => 'The plugin already exists.',
    100 => 'The plugin file you uploaded was not a GZip or Zip compressed archive.',
    101 => 'There are no topics (that you have access to). You need at least one topic to be able to submit stories.',
    400 => 'Not all required fields have been passed validation',
    401 => 'Please enter Fullname'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Prístup',
    'ownerroot' => 'Owner/Root',
    'group' => 'Skupina',
    'readonly' => 'Read-Only',
    'accessrights' => 'Prístupové práva',
    'owner' => 'Majiteľ',
    'grantgrouplabel' => 'Grant Above Group Edit Rights',
    'permmsg' => 'NOTE: members is all logged in members of the site and anonymous is all users browsing the site that aren\'t logged in.',
    'securitygroups' => 'Security Groups',
    'editrootmsg' => "Even though you are a User Administrator, you can't edit a root user without first being a root user yourself.  You can edit all other users except root users. Please note that all attempts to illegally edit root users are logged.  Please go back to the <a href=\"{$_CONF['site_admin_url']}/user.php\">User Administration page</a>.",
    'securitygroupsmsg' => 'Select the checkboxes for the groups you want the user to belong to.',
    'groupeditor' => 'Group Editor',
    'description' => 'Description',
    'name' => 'Name',
    'rights' => 'Rights',
    'missingfields' => 'Missing Fields',
    'missingfieldsmsg' => 'You must supply the name and a description for a group',
    'groupmanager' => 'Group Manager',
    'newgroupmsg' => 'To modify or delete a group, click on that group below. To create a new group click new group above. Please note that core groups cannot be deleted because they are used in the system.',
    'groupname' => 'Group Name',
    'coregroup' => 'Core Group',
    'yes' => 'Yes',
    'no' => 'No',
    'corerightsdescr' => "This group is a core {$_CONF['site_name']} Group.  Therefore the rights for this group cannot be edited.  Below is a read-only list of the rights this group has access to.",
    'groupmsg' => 'Security Groups on this site are hierarchical.  By adding this group to any of the groups below you will giving this group the same rights that those groups have.  Where possible it is encouraged you use the groups below to give rights to a group.  If you need this group to have custom rights then you can select the rights to various site features in the section below called \'Rights\'.  To add this group to any of the ones below simply check the box next to the group(s) that you want.',
    'coregroupmsg' => "This group is a core {$_CONF['site_name']} Group.  Therefore the groups that this group belongs to cannot be edited.  Below is a read-only list of the groups this group belongs to.",
    'rightsdescr' => 'A groups access to a certain right below can be given directly to the group OR to a different group that this group is a part of.  The ones you see below without a checkbox are the rights that have been given to this group because it belongs to another group with that right.  The rights with checkboxes below are rights that can be given directly to this group.',
    'lock' => 'Lock',
    'members' => 'Členovia',
    'anonymous' => 'Anonymní',
    'permissions' => 'Prístupové práva',
    'permissionskey' => 'R = čítať, E = upraviť, právo na úpravu zahŕňa právo čítať',
    'edit' => 'Edit',
    'none' => 'None',
    'accessdenied' => 'Access Denied',
    'storydenialmsg' => "You do not have access to view this story.  This could be because you aren't a member of {$_CONF['site_name']}.  Please <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\"> become a member</a> of {$_CONF['site_name']} to receive full membership access!",
    'nogroupsforcoregroup' => 'This group doesn\'t belong to any of the other groups',
    'grouphasnorights' => 'This group doesn\'t have access to any of the administrative features of this site',
    'newgroup' => 'New Group',
    'adminhome' => 'Admin Home',
    'save' => 'uložiť',
    'cancel' => 'zrušiť',
    'delete' => 'zmazať',
    'canteditroot' => 'You have tried to edit the Root group but you are not in the Root group yourself therefore your access to this group is denied.  Please contact the system administrator if you feel this is an error',
    'listusers' => 'List Users',
    'listthem' => 'list',
    'usersingroup' => 'Users in group "%s"',
    'usergroupadmin' => 'User Group Administration',
    'add' => 'Add',
    'remove' => 'Remove',
    'availmembers' => 'Available Members',
    'groupmembers' => 'Group Members',
    'canteditgroup' => 'To edit this group, you have to be a member of the group. Please contact the system administrator if you feel this is an error.',
    'cantlistgroup' => 'To see the members of this group, you have to be a member yourself. Please contact the system administrator if you feel this is an error.',
    'editgroupmsg' => 'To modify the group membership, click on the member names(s) and use the add or remove buttons. If the member is a member of the group, their name will appear on the right side only. Once you are complete - press <b>Save</b> to update the group and return to the main group admin page.',
    'listgroupmsg' => 'Listing of all current members in the group: <b>%s</b>',
    'search' => 'Search',
    'submit' => 'Submit',
    'limitresults' => 'Limit Results',
    'group_id' => 'Group ID',
    'plugin_access_denied_msg' => 'You are illegally trying access a plugin administration page.  Please note that all attempts to illegally access this page are logged.',
    'groupexists' => 'Group name already exists',
    'groupexistsmsg' => 'There is already a group with this name. Group names must be unique.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => 'Last 10 Back-ups',
    'do_backup' => 'Do Backup',
    'backup_successful' => 'Database back up was successful.',
    'db_explanation' => 'To create a new backup of your Geeklog system, hit the button below',
    'not_found' => "Incorrect path or mysqldump utility not executable.<br" . XHTML . ">Check <strong>\$_DB_mysqldump_path</strong> definition in config.php.<br" . XHTML . ">Variable currently defined as: <var>{$_DB_mysqldump_path}</var>",
    'zero_size' => 'Backup Failed: Filesize was 0 bytes',
    'path_not_found' => "{$_CONF['backup_path']} does not exist or is not a directory",
    'no_access' => "ERROR: Directory {$_CONF['backup_path']} is not accessible.",
    'backup_file' => 'Backup file',
    'size' => 'Size',
    'bytes' => 'Bytes',
    'total_number' => 'Total number of backups: %d',
    'download' => 'Click to download this file',
    'new_backup' => 'New Backup',
    'delete_failure' => 'One or more backup files could not be deleted.',
    'delete_success' => 'Backup file(s) successfully deleted.',
    'convert_menu' => 'Convert to InnoDB',
    'convert_title' => 'Convert to InnoDB tables',
    'convert_button' => 'Convert',
    'sorry_no_innodb' => 'Sorry, your version of MySQL does not support InnoDB tables.',
    'innodb_explain' => 'InnoDB tables provide better performance on <em>really</em> large databases but make the backup process more complicated. Please <a href="http://dev.mysql.com/doc/mysql/en/innodb.html">read up</a> on the pros and cons of InnoDB tables before you perform this operation.',
    'already_converted' => 'Note: It appears that all of the tables have already been converted to InnoDB.',
    'conversion_patience' => 'Note: Conversion may take some time - please be patient.',
    'innodb_success' => 'Successfully converted tables to InnoDB.',
    'table_issues' => 'There may have been problems with some tables, though. Please check error.log for details.',
    'optimize_menu' => 'Optimize Tables',
    'optimize_title' => 'Optimize Tables',
    'optimize_button' => 'Optimize',
    'optimize_explain' => 'Optimizing tables may help to improve the performance of your site. The actual impact depends on the table usage and some tables may benefit from it more than others. Do no expect to see a huge difference in performance. The <a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQL manual</a> states: <q>it is not likely that you need to do this more than once a week or month</q>.',
    'last_optimization' => 'Last optimization',
    'optimization_patience' => 'Note: Optimization may take some time - please be patient.',
    'optimize_success' => 'Successfully optimized database tables.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'Hlavná stránka',
    2 => 'Kontakt',
    3 => 'Napísať článok',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Štatistiky portálu',
    8 => 'Prispôsobenie',
    9 => 'Hľadať',
    10 => 'Podrobnejšie vyhľadávanie',
    11 => 'Archív článkov'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => 'Chyba 404 (stránka neexistuje)',
    2 => 'Gee, I\'ve looked everywhere but I can not find <b>%s</b>.',
    3 => "<p>We're sorry, but the file you have requested does not exist. Please feel free to check the <a href=\"{$_CONF['site_url']}\">main page</a> or the <a href=\"{$_CONF['site_url']}/search.php\">search page</a> to see if you can find what you lost."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Login required',
    2 => 'Sorry, to access this area you need to be logged in as a user.',
    3 => 'Login',
    4 => 'New User'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Trackback',
    'from' => 'from',
    'tracked_on' => 'Tracked on',
    'read_more' => '[read more]',
    'intro_text' => 'Here\'s what others have to say about \'%s\':',
    'no_comments' => 'No trackback comments for this entry.',
    'this_trackback_url' => 'Trackback URL for this entry:',
    'num_comments' => '%d trackback comments',
    'send_trackback' => 'Send Pings',
    'preview' => 'Preview',
    'editor_title' => 'Send trackback comment',
    'trackback_url' => 'Trackback URL',
    'entry_url' => 'Entry URL',
    'entry_title' => 'Entry Title',
    'blog_name' => 'Site Name',
    'excerpt' => 'Excerpt',
    'truncate_warning' => 'Note: The receiving site may truncate your excerpt',
    'button_send' => 'Send',
    'button_preview' => 'Preview',
    'send_error' => 'Error',
    'send_error_details' => 'Error when sending trackback comment:',
    'url_missing' => 'No Entry URL',
    'url_required' => 'Please enter at least a URL for the entry.',
    'target_missing' => 'No Trackback URL',
    'target_required' => 'Please enter a trackback URL',
    'error_socket' => 'Could not open socket.',
    'error_response' => 'Response not understood.',
    'error_unspecified' => 'Unspecified error.',
    'select_url' => 'Select Trackback URL',
    'not_found' => 'Trackback URL not found',
    'autodetect_failed' => 'Geeklog could not detect the Trackback URL for the post you want to send your comment to. Please enter it manually below.',
    'trackback_explain' => 'From the links below, please select the URL you want to send your Trackback comment to. Geeklog will then try to determine the correct Trackback URL for that post. Or you can <a href="%s">enter it manually</a> if you know it already.',
    'no_links_trackback' => 'No links found. You can not send a Trackback comment for this entry.',
    'pingback' => 'Pingback',
    'pingback_results' => 'Pingback results',
    'send_pings' => 'Send Pings',
    'send_pings_for' => 'Send Pings for "%s"',
    'no_links_pingback' => 'No links found. No Pingbacks were sent for this entry.',
    'pingback_success' => 'Pingback sent.',
    'no_pingback_url' => 'No pingback URL found.',
    'resend' => 'Resend',
    'ping_all_explain' => 'You can now notify the sites you linked to (<a href="http://en.wikipedia.org/wiki/Pingback">Pingback</a>), advertise that your site has been updated by pinging weblog directory services, or send a <a href="http://en.wikipedia.org/wiki/Trackback">Trackback</a> comment in case you wrote about a post on someone else\'s site.',
    'pingback_button' => 'Send Pingback',
    'pingback_short' => 'Send Pingbacks to all sites linked from this entry.',
    'pingback_disabled' => '(Pingback disabled)',
    'ping_button' => 'Send Ping',
    'ping_short' => 'Ping weblog directory services.',
    'ping_disabled' => '(Ping disabled)',
    'trackback_button' => 'Send Trackback',
    'trackback_short' => 'Send a Trackback comment.',
    'trackback_disabled' => '(Trackback disabled)',
    'may_take_a_while' => 'Please note that sending Pingbacks and Pings may take a while.',
    'ping_results' => 'Ping results',
    'unknown_method' => 'Unknown ping method',
    'ping_success' => 'Ping sent.',
    'error_site_name' => 'Please enter the site\'s name.',
    'error_site_url' => 'Please enter the site\'s URL.',
    'error_ping_url' => 'Please enter a valid Ping URL.',
    'no_services' => 'No weblog directory services configured.',
    'services_headline' => 'Weblog Directory Services',
    'service_explain' => 'To modify or delete a weblog directory service, click on the edit icon of that service below. To add a new weblog directory service, click on "Create New" above.',
    'service' => 'Service',
    'ping_method' => 'Ping method',
    'service_website' => 'Website',
    'service_ping_url' => 'URL to ping',
    'ping_standard' => 'Standard Ping',
    'ping_extended' => 'Extended Ping',
    'ping_unknown' => '(unknown method)',
    'edit_service' => 'Edit Weblog Directory Service',
    'trackbacks' => 'Trackbacks',
    'editor_intro' => 'Prepare your trackback comment for <a href="%s">%s</a>.',
    'editor_intro_none' => 'Prepare your trackback comment.',
    'trackback_note' => 'To send a trackback comment for a story, go to the list of stories and click on "Send Ping" for the story. To send a trackback that is not related to a story, <a href="%s">click here</a>.',
    'pingback_explain' => 'Enter a URL to send the Pingback to. The pingback will point to your site\'s homepage.',
    'pingback_url' => 'Pingback URL',
    'site_url' => 'This site\'s URL',
    'pingback_note' => 'To send a pingback for a story, go to the list of stories and click on "Send Ping" for the story. To send a pingback that is not related to a story, <a href="%s">click here</a>.',
    'pbtarget_missing' => 'No Pingback URL',
    'pbtarget_required' => 'Please enter a pingback URL',
    'pb_error_details' => 'Error when sending the pingback:',
    'delete_trackback' => 'To delete this Trackback click: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Archív článkov',
    'title_year' => 'Archív článkov pre %d',
    'title_month_year' => 'Archív článkov pre %s %d',
    'nav_top' => 'Naspäť na archív článkov',
    'no_articles' => 'Žiadne články.'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog Security Check',
    'results' => 'Results of the Security Check',
    'okay' => 'Everything seems to be in order.',
    'please_fix' => 'Please fix the above issues before using your site!',
    'please_note' => 'Please note that no site is ever 100% secure. This script can only test for obvious security issues.',
    'stay_informed' => 'To stay informed about new Geeklog releases and possible security issues, we suggest that you subscribe to the (low-traffic) %s mailing list and/or use the %s option in your Admin menu from time to time to check for available updates.',
    'public_html' => '"public_html" should never be part of your site\'s URL.  Please read the part about public_html in the %s again and change your setup accordingly before you proceed.',
    'installation' => 'installation instructions',
    'directory' => 'directory',
    'failed_tmp' => 'Failed to create a temporary file in your %s directory. Check your directory permissions!',
    'fix_it' => 'This is a security risk and should be fixed!',
    'reachable' => 'Your %s is reachable from the web.',
    'not_reachable' => 'Good! Your %s is not reachable from the web.',
    'not_sure' => 'Got an HTTP result code %s when trying to test your %s. Not sure what to make of it ...',
    'remove_inst' => 'You should really remove the install directory %s once you have your site up and running without any errors.',
    'remove_inst2' => 'Keeping it around would allow malicious users the ability to destroy your current install, take over your site, or retrieve sensitive information.',
    'inst_removed' => 'Good! You seem to have removed the install directory already.',
    'fix_password' => 'You still have not changed the <strong>default password</strong> from "password" on %s Root user account(s).',
    'password_okay' => 'Good! You seem to have changed the default account password already.'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n nových %i za posledných %t %s',
    'new_last' => 'za %t posledných %s',
    'minutes' => 'minút',
    'hours' => 'hodín',
    'days' => 'dní',
    'weeks' => 'týždňov',
    'months' => 'mesiacov',
    'minute' => 'minúta',
    'hour' => 'hodina',
    'day' => 'deň',
    'week' => 'týždeň',
    'month' => 'mesiac'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Január',
    2 => 'Február',
    3 => 'Marec',
    4 => 'Apríl',
    5 => 'Máj',
    6 => 'Jún',
    7 => 'Júl',
    8 => 'August',
    9 => 'September',
    10 => 'Október',
    11 => 'November',
    12 => 'December'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Nedeľa',
    2 => 'Pondelok',
    3 => 'Utorok',
    4 => 'Streda',
    5 => 'Štvrtok',
    6 => 'Piatok',
    7 => 'Sobota'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Hľadať',
    'limit_results' => 'Limit Results',
    'submit' => 'Submit',
    'edit' => 'Upraviť',
    'edit_adv' => 'Adv. Edit',
    'admin_home' => 'Admin Home',
    'create_new' => 'Create New',
    'create_new_adv' => 'Create New (Adv.)',
    'enabled' => 'Zapnuté',
    'title' => 'Nadpis',
    'page_title' => 'Page Title',
    'type' => 'Typ',
    'topic' => 'Téma',
    'help_url' => 'Help File URL',
    'save' => 'Uložiť',
    'cancel' => 'Zrušiť',
    'delete' => 'Zmazať',
    'delete_sel' => 'Delete selected',
    'copy' => 'Copy',
    'no_results' => '- No entries found -',
    'data_error' => 'There was an error processing the subscription data. Please check the data source.',
    'preview' => 'Náhľad',
    'records_found' => 'Records found',
    'addchild' => 'Add child',
    'list' => 'list',
    'list_all' => 'List all',
    'meta_description' => 'Meta Description',
    'meta_keywords' => 'Meta Keywords',
    'na' => 'N/A',
    'token_expiry' => 'You have until %s to make changes. After that time, the security token embedded into this page will expire and you will lose your changes.',
    'token_expired' => 'The security token for this operation has expired. Please authenticate again to continue.',
    'reauth_msg' => 'The security token for this operation has expired. If you want to continue with this operation, then please authenticate again below. This will ensure that the changes you just made will not be lost.',
    'authenticate' => 'Authenticate'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'Komentáre povolené',
    -1 => 'Komentáre zakázané',
    1 => 'Comments Closed'
);

$LANG_commentmodes = array(
    'flat' => 'Bez odsadenia',
    'nested' => 'S odsadením',
    'threaded' => 'Podľa témy',
    'nocomment' => 'Bez komentárov'
);

$LANG_cookiecodes = array(
    0 => '(don\'t)',
    3600 => '1 Hour',
    7200 => '2 Hours',
    10800 => '3 Hours',
    28800 => '8 Hours',
    86400 => '1 Day',
    604800 => '1 Week',
    2678400 => '1 Month'
);

$LANG_dateformats = array(
    0 => 'System Default'
);

$LANG_featurecodes = array(
    0 => 'Not Featured',
    1 => 'Featured'
);

$LANG_frontpagecodes = array(
    0 => 'Zobraziť iba v téme',
    1 => 'Zobraziť na titulnej stránke'
);

$LANG_postmodes = array(
    'plaintext' => 'Plain Old Text',
    'html' => 'HTML Formatted'
);

$LANG_sortcodes = array(
    'ASC' => 'Najstarší prvý',
    'DESC' => 'Najnovší prvý'
);

$LANG_trackbackcodes = array(
    0 => 'Trackback Enabled',
    -1 => 'Trackback Disabled'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Home',
    'admin_home' => 'Site Administration',
    'sections' => 'Configuration Sections',
    'restore' => 'Restore',
    'add_element' => 'Add Element',
    'save_changes' => 'Save Changes',
    'reset_form' => 'Reset Form',
    'changes_made' => 'Changes were successfully made to',
    'title' => 'Configuration Manager',
    'disable' => 'Click to disable this option',
    'enable' => 'Enable'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklog Configuration'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTML Path',
    'site_url' => 'Site URL',
    'site_admin_url' => 'Admin URL',
    'site_mail' => 'Site E-Mail',
    'noreply_mail' => 'No-Reply E-Mail',
    'site_name' => 'Site Name',
    'site_slogan' => 'Slogan',
    'microsummary_short' => 'Microsummary',
    'path_log' => 'Log',
    'path_language' => 'Language',
    'backup_path' => 'Backup',
    'path_data' => 'Data',
    'path_images' => 'Images',
    'path_pear' => 'Path Pear',
    'have_pear' => 'Have Pear?',
    'mail_settings' => 'Mail Settings',
    'allow_mysqldump' => 'Allow MySQL Dump',
    'mysqldump_path' => 'Path of Executable',
    'mysqldump_options' => 'MySQL Dump Options',
    'mysqldump_filename_mask' => 'Backup File Name Mask',
    'theme' => 'Theme',
    'doctype' => 'DOCTYPE Declaration',
    'menu_elements' => 'Menu Elements',
    'path_themes' => 'Themes Path',
    'disable_new_user_registration' => 'Disable New Registrations',
    'allow_user_themes' => 'Allow User Themes',
    'allow_user_language' => 'Allow User Language',
    'allow_user_photo' => 'Allow User Photo',
    'allow_username_change' => 'Allow Username Changes',
    'allow_account_delete' => 'Allow Account Deletion',
    'hide_author_exclusion' => 'Allow Hide Author',
    'show_fullname' => 'Show Fullname',
    'show_servicename' => 'Show Service Name',
    'custom_registration' => 'Enable Custom Registration',
    'user_login_method' => 'User Login Method',
    'spamx' => 'Spam-X Actions',
    'sort_admin' => 'Sort Links',
    'language' => 'Language',
    'locale' => 'Locale',
    'date' => 'Date Format',
    'daytime' => 'Daytime Format',
    'shortdate' => 'Short Date Format',
    'dateonly' => 'Date Only Format',
    'timeonly' => 'Time Only Format',
    'week_start' => 'Week Start',
    'hour_mode' => 'Hour Mode',
    'thousand_separator' => 'Thousands Separator',
    'decimal_separator' => 'Decimal Separator',
    'decimal_count' => 'Decimal Count',
    'language_files' => 'Language Files',
    'languages' => 'Languages',
    'timezone' => 'Timezone',
    'site_disabled_msg' => 'Site Disabled Message or URL',
    'rootdebug' => 'Root Debugging',
    'cookie_session' => 'Session Cookie Name',
    'cookie_name' => 'Permanent Cookie Name',
    'cookie_password' => 'Password Cookie Name',
    'cookie_theme' => 'Theme Cookie Name',
    'cookie_language' => 'Language Cookie Name',
    'cookie_tzid' => 'Timezone Cookie Name',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'Cookies embed IP?',
    'default_perm_cookie_timeout' => 'Permanent Timeout',
    'session_cookie_timeout' => 'Session Timeout',
    'cookie_path' => 'Cookie Path',
    'cookiedomain' => 'Cookie Domain',
    'cookiesecure' => 'Cookie Secure',
    'lastlogin' => 'Record Last Login?',
    'num_search_results' => 'Number of Search Results',
    'loginrequired' => 'Login Required?',
    'submitloginrequired' => 'Submit Login Required?',
    'commentsloginrequired' => 'Comment Login Required?',
    'statsloginrequired' => 'Stats Login Required?',
    'searchloginrequired' => 'Search Login Required?',
    'profileloginrequired' => 'Profile Login Required?',
    'emailuserloginrequired' => 'E-Mail User Login Required?',
    'emailstoryloginrequired' => 'E-Mail Story Login Required?',
    'directoryloginrequired' => 'Directory Login Required?',
    'storysubmission' => 'Story Submission Queue?',
    'usersubmission' => 'User Submission Queue?',
    'listdraftstories' => 'List Draft Stories?',
    'notification' => 'Notifications',
    'postmode' => 'Default Post Mode',
    'speedlimit' => 'Post Speed Limit',
    'skip_preview' => 'Skip Preview in Posts',
    'advanced_editor' => 'Advanced Editor?',
    'wikitext_editor' => 'Wikitext Editor?',
    'cron_schedule_interval' => 'Cron Schedule Interval',
    'sortmethod' => 'Sort Topics',
    'showstorycount' => 'Show Story Count?',
    'showsubmissioncount' => 'Show Submission Count?',
    'hide_home_link' => 'Hide Home Link?',
    'whosonline_threshold' => 'Session Threshold',
    'whosonline_anonymous' => 'Hide Names from Guests?',
    'emailstories' => 'Daily Digest Enabled?',
    'emailstorieslength' => 'Length of Stories',
    'emailstoriesperdefault' => 'Enable for New Users?',
    'allow_domains' => 'Automatic Allow Domains',
    'disallow_domains' => 'Automatic Disallow Domains',
    'newstoriesinterval' => 'New Stories Interval',
    'newcommentsinterval' => 'New Comments Interval',
    'newtrackbackinterval' => 'New Trackbacks Interval',
    'hidenewstories' => 'Hide New Stories',
    'hidenewcomments' => 'Hide New Comments',
    'hidenewtrackbacks' => 'Hide New Trackbacks',
    'hidenewplugins' => 'Hide New Plugin Entries',
    'title_trim_length' => 'Title Trim Length',
    'trackback_enabled' => 'Trackback Enabled?',
    'pingback_enabled' => 'Pingback Enabled?',
    'ping_enabled' => 'Ping Enabled?',
    'trackback_code' => 'Trackback Default',
    'multiple_trackbacks' => 'Multiple Trackbacks',
    'trackbackspeedlimit' => 'Trackback Speed Limit',
    'check_trackback_link' => 'Check Trackbacks',
    'pingback_self' => 'Pingback Self?',
    'pingback_excerpt' => 'Create Pingback Excerpt?',
    'link_documentation' => 'Link to Documentation?',
    'link_versionchecker' => 'Link to Version Checker?',
    'maximagesperarticle' => 'Max Images per Article',
    'limitnews' => 'Stories per Page',
    'minnews' => 'Min. Stories per Page',
    'contributedbyline' => 'Show "Contributed By"?"',
    'hideviewscount' => 'Hide Views Count?',
    'hideemailicon' => 'Hide E-Mail Icon?',
    'hideprintericon' => 'Hide Print Icon?',
    'allow_page_breaks' => 'Allow Page Breaks?',
    'page_break_comments' => 'Comments on Multi-Page Articles',
    'article_image_align' => 'Topic Icon Alignment',
    'show_topic_icon' => 'Show Topic Icon?',
    'draft_flag' => 'Draft Flag Default',
    'frontpage' => 'Frontpage Default',
    'hide_no_news_msg' => 'Hide "No News" Message?',
    'hide_main_page_navigation' => 'Hide Main Page Navigation?',
    'onlyrootfeatures' => 'Only Root can Feature?',
    'aftersave_story' => 'After Saving Story',
    'aftersave_user' => 'After Saving User',
    'show_right_blocks' => 'Always Show Right Blocks?',
    'showfirstasfeatured' => 'Show First Story as Featured?',
    'backend' => 'Enable Feeds?',
    'rdf_file' => 'Syndication Output Folder',
    'rdf_limit' => 'Feed Limit',
    'rdf_storytext' => 'Length of Stories in Feed',
    'rdf_language' => 'Feed Language',
    'syndication_max_headlines' => 'Max. Number of Headlines (portal blocks)',
    'copyrightyear' => 'Copyright Year',
    'image_lib' => 'Image Library',
    'path_to_mogrify' => 'Path to Mogrify',
    'path_to_netpbm' => 'Path to Netpbm',
    'debug_image_upload' => 'Debug Image Uploading?',
    'keep_unscaled_image' => 'Keep Unscaled Image?',
    'allow_user_scaling' => 'Allow User Scaling?',
    'jpeg_quality' => 'JPEG Quality?',
    'max_image_width' => 'Max Image Width?',
    'max_image_height' => 'Max Image Height?',
    'max_image_size' => 'Max Image Size?',
    'max_topicicon_width' => 'Max Topic Icon Width?',
    'max_topicicon_height' => 'Max Topic Icon Height?',
    'max_topicicon_size' => 'Max Topic Icon Size?',
    'max_photo_width' => 'Max Photo Width?',
    'max_photo_height' => 'Max Photo Height?',
    'max_photo_size' => 'Max Photo Size?',
    'use_gravatar' => 'Use Gravatar?',
    'gravatar_rating' => 'Gravatar Rating Allowed',
    'force_photo_width' => 'Force Photo Width',
    'default_photo' => 'Default Photo',
    'commentspeedlimit' => 'Comment Speed Limit',
    'comment_limit' => 'Comment Limit',
    'comment_mode' => 'Comment Mode',
    'comment_code' => 'Comment Default',
    'comment_edit' => 'Allow Comment Edit?',
    'comment_edittime' => 'Comment Edit Time (seconds)',
    'commentsubmission' => 'Queue Comment Submissions',
    'passwordspeedlimit' => 'Password Speed Limit',
    'login_attempts' => 'Max. Login Attempts',
    'login_speedlimit' => 'Login Speed Limit',
    'user_html' => 'User HTML',
    'admin_html' => 'Admin HTML',
    'advanced_html' => 'Additional HTML for Adv. Editor',
    'skip_html_filter_for_root' => 'Skip HTML Filter for Root?',
    'allowed_protocols' => 'Allowed Protocols',
    'disable_autolinks' => 'Disable Autolinks?',
    'clickable_links' => 'Make URLs clickable?',
    'compressed_output' => 'Send compressed output?',
    'frame_options' => 'Protection against "clickjacking"',
    'censormode' => 'Censor Mode?',
    'censorreplace' => 'Censor Replace Text',
    'censorlist' => 'Censor List',
    'ip_lookup' => 'IP Lookup',
    'url_rewrite' => 'Enable URL Rewrite',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'Default Meta Description',
    'meta_keywords' => 'Default Meta Keywords',
    'default_permissions_block' => 'Block Default Permissions',
    'default_permissions_story' => 'Story Default Permissions',
    'default_permissions_topic' => 'Topic Default Permissions',
    'atom_max_stories' => 'Max. Stories in Webservices Feed',
    'disable_webservices' => 'Disable Webservices?',
    'restrict_webservices' => 'Restrict Webservices?',
    'article_comment_close_enabled' => 'Automatically close comments (default)',
    'article_comment_close_days' => 'Days to close comments (default)',
    'comment_close_rec_stories' => 'Number of most recent stories enabled for comments',
    'allow_reply_notifications' => 'Allow comment reply notifications?',
    'search_style' => 'Results List Style',
    'search_limits' => 'Page Limits',
    'search_show_num' => 'Show Result Number?',
    'search_show_type' => 'Show Result Type?',
    'search_show_sort' => 'Allow User to Sort Results?',
    'search_show_limit' => 'Show Page Limits?',
    'search_separator' => 'Group Separator',
    'search_def_keytype' => 'Default Search Method',
    'search_def_sort' => 'Default Sort Order'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Site',
    'sg_stories' => 'Stories and Trackback',
    'sg_theme' => 'Theme',
    'sg_blocks' => 'Blocks',
    'sg_users' => 'Users and Submissions',
    'sg_images' => 'Images',
    'sg_locale' => 'Languages and Locale',
    'sg_misc' => 'Miscellaneous'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Site',
    'fs_paths' => 'Paths',
    'fs_theme' => 'Theme',
    'fs_mail' => 'Mail',
    'fs_pear' => 'Pear',
    'fs_mysql' => 'MySQL',
    'fs_users' => 'Users',
    'fs_misc' => 'Miscellaneous',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin Block',
    'fs_locale' => 'Locale',
    'fs_language' => 'Language',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Cookies',
    'fs_login' => 'Login Settings',
    'fs_search' => 'Search',
    'fs_user_submission' => 'User Submission',
    'fs_submission' => 'Submission Settings',
    'fs_topics_block' => 'Topics Block',
    'fs_whosonline_block' => 'Who\'s Online Block',
    'fs_daily_digest' => 'Daily Digest',
    'fs_whatsnew_block' => 'What\'s New Block',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Story',
    'fs_theme_advanced' => 'Advanced Settings',
    'fs_syndication' => 'Syndication',
    'fs_imagelib' => 'Image Library',
    'fs_upload' => 'Upload',
    'fs_articleimg' => 'Images in Articles',
    'fs_topicicon' => 'Topic Icons',
    'fs_userphoto' => 'Photos',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'Comments',
    'fs_htmlfilter' => 'HTML Filtering',
    'fs_censoring' => 'Censoring',
    'fs_iplookup' => 'IP Lookup',
    'fs_perm_story' => 'Story Default Permission',
    'fs_perm_topic' => 'Topic Default Permission',
    'fs_perm_block' => 'Block Default Permission',
    'fs_webservices' => 'Webservices'
);

$LANG_configselects['Core'] = array(
    0 => array('True' => 1, 'False' => 0),
    1 => array('True' => true, 'False' => false),
    2 => array('Reject' => 0, 'Only Keep Latest' => 1, 'Allow Multiple Posts' => 2),
    3 => array('Trackback Enabled' => 0, 'Trackback Disabled' => -1),
    4 => array('Don\'t Check Anything' => 0, 'Check against Site URL' => 1, 'Check full URL' => 2, 'Check against Site URL and full URL' => 3, 'Check IP against Site IP' => 4, 'Check IP and Site URL' => 5, 'Check IP and Full URL' => 6, 'Check IP, Full URL, and Site URL' => 7),
    5 => array('Plain Old Text' => 'plaintext', 'HTML Formatted' => 'html'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Last Page' => 'last', 'First Page' => 'first', 'Every Page' => 'all'),
    8 => array('Right' => 'right', 'Left' => 'left'),
    9 => array('Forward to page' => 'item', 'Display List' => 'list', 'Display Home' => 'home', 'Display Admin' => 'admin'),
    10 => array('None' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Flat' => 'flat', 'Nested' => 'nested', 'Threaded' => 'threaded', 'No Comments' => 'nocomment'),
    12 => array('No access' => 0, 'Read-Only' => 2, 'Read-Write' => 3),
    13 => array('Skip' => 0, 'Allow, with speedlimit' => 1, 'Allow, no speedlimit' => 2),
    14 => array('Sunday' => 'Sun', 'Monday' => 'Mon'),
    15 => array('By Number' => 'sortnum', 'Alphabetically' => 'alpha'),
    16 => array('No Login required' => 0, 'Advanced Search only' => 1, 'Simple + Advanced Search' => 2),
    17 => array('Comments Enabled' => 0, 'Comments Disabled' => -1),
    18 => array('Disabled' => 0, 'Enabled (Exact Match)' => 1, 'Enabled (Word Beginning)' => 2, 'Enabled (Word Fragment)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('Exact Phrase' => 'phrase', 'All of The Words' => 'all', 'Any of The Words' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (Default for Homepage only)' => 2),
    24 => array('Contribute' => 'contribute', 'Home' => 'home', 'Advanced Search' => 'search', 'Directory' => 'directory', 'My Account' => 'prefs', 'Plugin Entries' => 'plugins', 'Custom Entries' => 'custom', 'Site Statistics' => 'stats'),
    25 => array('New Stories' => 'story', 'New Comments' => 'comment', 'New Trackbacks' => 'trackback', 'New Pingbacks' => 'pingback', 'New Users' => 'user'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (asc)' => 'hits|asc', 'Hits (desc)' => 'hits|desc', 'Date (asc)' => 'date|asc', 'Date (desc)' => 'date|desc', 'Title (asc)' => 'title|asc', 'Title (desc)' => 'title|desc', 'Author (asc)' => 'uid|asc', 'Author (desc)' => 'uid|desc')
);

?>
