<?php

###############################################################################
# finnish.php
# This is the Finnish language page for GeekLog!
#
# Copyright (C) 2004 Jussi Josefsson
# 20031012 - Version 1.0 - Geeklog 1.3.8
# 20040217 - Version 1.1 - Geeklog 1.3.9rc1
# ihra@iki.fi
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'iso-8859-1';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Kirjoittaja:',
    2 => 'lue lis',
    3 => 'kommentti(a)',
    4 => 'Muokkaa',
    5 => '',
    6 => '',
    7 => '',
    8 => '',
    9 => 'Yllpidon toiminnot:',
    10 => 'Lhetyksi',
    11 => 'Artikkeleja',
    12 => 'Blokkeja',
    13 => 'Aiheita',
    14 => '',
    15 => '',
    16 => '',
    17 => 'Kyttji',
    18 => 'SQL kysely',
    19 => 'Kirjaudu ulos',
    20 => 'Kyttjn tiedot:',
    21 => 'Kyttjn nimi',
    22 => 'Tunnus',
    23 => 'Turvallisuustaso',
    24 => 'Tuntematon',
    25 => 'Vastaa',
    26 => 'Oheiset kommentit ovat kirjoittajiensa omaisuutta. Sivusto ei ole vastuussa kirjoittajien sanomisista.',
    27 => 'Uusin kirjoitus',
    28 => 'Poista',
    29 => 'Ei kyttjn lhettmi kommentteja',
    30 => 'Vanhemmat artikkelit',
    31 => 'Sallitut HTML tagit:',
    32 => 'Virhe, virheellinen kyttjnimi',
    33 => 'Virhe, logiin ei voi kirjoittaa',
    34 => 'Virhe',
    35 => 'Kirjaudu ulos',
    36 => 'on',
    37 => 'Ei kyttjn kirjoituksia',
    38 => 'Content Syndication',
    39 => 'Virkist',
    40 => '',
    41 => 'Vieraita sivustolla',
    42 => 'Tekij:',
    43 => 'Vastaa thn',
    44 => 'Edellinen',
    45 => 'MySQL virhe numeroltaan',
    46 => 'MySQL virhe viesti',
    47 => 'Kyttjn toiminnot',
    48 => 'Omat tiedot',
    49 => 'Asetukset',
    50 => 'Virhe SQL lauseessa',
    51 => 'apua',
    52 => 'Uusi',
    53 => 'Yllpito',
    54 => 'Tiedostoa ei voinut avata.',
    55 => 'Virhe',
    56 => 'nest',
    57 => 'Salasana',
    58 => 'Kirjaudu',
    59 => "Ei tunnusta viel? Kirjaudu <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">uutena kyttjn</a>",
    60 => 'Lhet kommentti',
    61 => 'Luo uusi kyttjtili',
    62 => 'sanaa',
    63 => 'Kommenttien asetukset',
    64 => 'Lhet artikkeli shkpostitse ystvlle',
    65 => 'Nyt tulostettava versio',
    66 => '',
    67 => 'Tervetuloa sivustolle',
    68 => 'etusivu',
    69 => 'yhteystiedot',
    70 => 'etsi',
    71 => 'lhet artikkeli',
    72 => 'verkkoresurssit',
    73 => '',
    74 => '',
    75 => 'laajennettu etsint',
    76 => 'sivuston tilastot',
    77 => 'Laajennukset',
    78 => '',
    79 => 'Uutta sivustolla',
    80 => 'artikkelia viimeiseen',
    81 => 'artikkeli viimeiseen',
    82 => 'tuntiin',
    83 => 'KOMMENTIT',
    84 => '',
    85 => 'viimeisen 48 tuntina',
    86 => 'Ei uusia kommentteja',
    87 => 'viimeiseen 2 viikkoon',
    88 => '',
    89 => '',
    90 => 'Etusivu',
    91 => 'Sivu luotu ',
    92 => 'sekunnissa',
    93 => 'Copyright',
    94 => 'All trademarks and copyrights on this page are owned by their respective owners.',
    95 => 'Moottorina toimii',
    96 => 'Ryhmi',
    97 => 'Sana lista',
    98 => 'Laajennuksia',
    99 => 'ARTIKKELIT',
    100 => 'Ei uusia artikkeleita',
    101 => '',
    102 => '',
    103 => 'DB varmuuskopiointi',
    104 => 'by',
    105 => 'Shkpostia kyttjille',
    106 => 'Katselukertoja',
    107 => 'GL versiotesti',
    108 => 'Tyhjenn vlimuisti',
    109 => 'Report abuse',
    110 => 'Report this post to the site admin',
    111 => '',
    112 => 'Registered Users',
    113 => 'Documentation',
    114 => 'TRACKBACKS',
    115 => 'No new trackback comments',
    116 => 'Trackback',
    117 => 'Directory',
    118 => 'Please continue reading on the next page:',
    119 => "Lost your <a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">password</a>?",
    120 => 'Permanent link to this comment',
    121 => 'Comments (%d)',
    122 => 'Trackbacks (%d)',
    123 => 'All HTML is allowed',
    124 => 'Click to delete all checked items',
    125 => 'Are you sure you want to Delete all checked items?',
    126 => 'Select or de-select all items',
    127 => 'Permalink',
    128 => 'Login with OpenID:',
    129 => 'Configuration',
    130 => 'Webservices'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Lhet kommentti',
    2 => 'Lhetyksen muoto',
    3 => 'Kirjaudu ulos',
    4 => 'Luo kyttjtili',
    5 => 'Kyttjnimi',
    6 => 'Sivustolle voi lhett kommentteja vain rekisterityneet kyttjt. Jos sinulla ei ole kyttjtili sivustolla, voit tehd tilin kyttmll alla olevaa lomaketta.',
    7 => 'Viimeisin kommenttisi kirjoitettiin ',
    8 => " sekuntia sitten. Sivusto vaatii vhintn {$_CONF['commentspeedlimit']} sekuntia kommenttien vlill",
    9 => 'Kommentti',
    10 => 'Send Report',
    11 => 'Lhet kommentti',
    12 => 'Tyt otsikko ja kommentti -kentt, ne ovat pakollisia kommenttia lhetettess.',
    13 => 'Omat tietosi',
    14 => 'Esikatselu',
    15 => 'Report this post',
    16 => 'Otsikko',
    17 => 'Virhe',
    18 => 'Trkeit huomioita',
    19 => 'Yrit pysy aiheessa.',
    20 => 'Pyri vastaamaan muiden lhettmiin kommentteihin uuden kommenttisikeen aloittamisen sijaan.',
    21 => 'Lue muiden lhettmt viestit ennen oman kommentin postittamista toiston estmiseksi.',
    22 => 'Nime viesti selkesti ja kuvaavasti.',
    23 => 'Shkpostiosoitteesi EI tule julkisesti nkyville.',
    24 => 'Tuntematon kyttj',
    25 => 'Are you sure you want to report this post to the site admin?',
    26 => '%s reported the following abusive comment post:',
    27 => 'Abuse report',
    28 => 'Preview Changes',
    29 => 'Submit Changes',
    30 => 'Edited on',
    31 => 'by',
    32 => 'Editing a Comment',
    33 => 'Editing a Comment Submission',
    34 => 'Preview Submission Changes',
    35 => 'Save Changes to Queue',
    36 => 'Notify me of new replies',
    37 => 'New Comment Reply',
    38 => 'A reply has been made to your comment \'%s\'.',
    39 => 'You may view the comment thread at the following address:',
    40 => 'If you wish to receive no further notifications of replies, visit the following link:',
    41 => 'Hello %s,',
    42 => 'Unsubscribe',
    43 => 'Unsubscribe from reply notifications',
    44 => 'Your Name'
);

###############################################################################
# users.php

$LANG04 = array(
    1 => 'Tiedot kyttjst',
    2 => 'Kyttjn nimi',
    3 => 'Koko nimi',
    4 => 'Salasana',
    5 => 'Shkposti',
    6 => 'Kotisivu',
    7 => 'Tiedot',
    8 => 'PGP avain',
    9 => 'Tallenna tiedot',
    10 => 'Viimeiset 10 kommentti kyttjlt',
    11 => 'Ei kyttjn lhettmi kommentteja',
    12 => 'Asetukset kyttjlle',
    13 => 'Lhet pivittinen yhteenveto shkpostitse',
    14 => 'Tm salasana on satunnaisgeneraattorin tuottama. On suositeltavaa vaihtaa salasana toiseen vlittmsti. Vaihtaaksesi salasanan, kirjaudu sivustolle ja valitse Omat tiedot kyttjn toiminnoista.',
    15 => "{$_CONF['site_name']} kyttjtili on luotu. Kyttksesi tili, kirjaudu sisn allaolevin tiedoin. Sst tm shkposti tulevaa kytt varten.",
    16 => 'Omat tiedot',
    17 => 'Tili ei ole olemassa',
    18 => 'Shkposti-osoite ei ole tunnu olevan oikeanmuotoinen osoite',
    19 => 'Sytetty kyttjnimi tai shkposti ovat jo kytss',
    20 => 'Shkposti-osoite ei ole oikea shkposti-osoite',
    21 => 'Virhe',
    22 => "Rekisteridy sivustolle {$_CONF['site_name']}!",
    23 => "Luomalla sivustolle {$_CONF['site_name']} kyttjtilin voit itse lhett artikkeleita tai kommentteja. Ilman tili voit lhett viestej vain tuntemattomana. Huomaa ett shkpostiosoitettasi ei <b><i>koskaan</i></b> nytet julkisesti sivustolla.",
    24 => 'Salasanasi lhetetn syttmsi shkpostiosoitteeseen.',
    25 => 'Unohditko salasanasi?',
    26 => 'Syt <em>joko</em> kyttjnimesi <em>tai</em> shkposti-osoitteesi jotka sytit rekisterityesssi ja valitse Lhet salasana. Ohjeet uuden salasanan asettamiseksi lhetetn shkpostitse tilin osoitteeseen.',
    27 => 'Rekisteridy!',
    28 => 'Lhet salasana',
    29 => 'kirjauduit ulos sivustolta',
    30 => 'kirjauduit sisn sivustolle',
    31 => 'Toiminto vaatii rekisteritymist',
    32 => 'Allekirjoitus',
    33 => 'Ei julkisesti nkyv',
    34 => 'Oikea nimesi',
    35 => 'Kirjoita uusi salasana jos haluat vaihtaa vanhan',
    36 => 'Alkaa http://',
    37 => 'Listty kommentteihisi',
    38 => 'Kaikki elmstsi! Kaikki voivat lukea tmn',
    39 => 'Julkinen PGP avain jaettavaksi',
    40 => 'Ei aiheiden kuvakkeita',
    41 => 'Halukas moderoijaksi',
    42 => 'Pivyksen muoto',
    43 => 'Artikkelien maksimimr',
    44 => 'Ei laatikkoja',
    45 => 'Nyt asetukset tilille',
    46 => 'Poisjtettvt kohteet tilille',
    47 => 'Uutislaatikon asetukset tilille',
    48 => 'Aiheet',
    49 => 'Ei kuvakkeita artikkeleissa',
    50 => 'Poista rasti jos et ole kiinnostunut',
    51 => 'Vain uutiset',
    52 => 'Oletus on',
    53 => 'Vastaanota pivn tarina joka y',
    54 => 'Valitse aiheet ja kirjoittajat joita et halua nhd.',
    55 => 'Jttmll kaikki laatikot valitsematta, kytetn oletusarvoja. Jos alat rastittamaan valintoja, muista valita kaikki haluamasi, koska oletusarvot ohitetaan. Oletusarvot nytetn lihavoituina.',
    56 => 'Kirjoittajat',
    57 => 'Nytttila',
    58 => 'Lajittelujrjestys',
    59 => 'Kommenttien rajoitus',
    60 => 'Miten haluat kommenttisi nytettvn?',
    61 => 'Uusimmat vai vanhimmat ensin?',
    62 => 'Oletus on 100',
    63 => "Salasanasi on lhetetty shkpostitse. Seuraa viestiss olevia ohjeita ja kiitos kun kytt sivustoa {$_CONF['site_name']}",
    64 => 'Kommenttien astukset kyttjlle',
    65 => 'Yrit kirjautua uudestaan',
    66 => "Kirjoitit sisnkirjautuessa jotain vrin. Yrit kirjautua uudelleen. Oletko <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">uusi kyttj</a>?",
    67 => 'Liittynyt',
    68 => 'Silyt tiedot',
    69 => 'Kuinka kauan sivuston tulee muistaa tietosi kirjautumisen jlkeen?',
    70 => "Muokkaa ulkoasua ja asetuksia sivustolle {$_CONF['site_name']}",
    71 => "Yksi tmn sivuston ({$_CONF['site_name']}) parhaista ominaisuuksista on muokattavuus - voit muokata haluamasi ulkoasun ja sislln sivustolle. Hydyntksesi ominaisuuksia sinun tulee ensiksi <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">rekisterity</a> sivustolle {$_CONF['site_name']}.  Oletko jo rekisteritynyt? Kirjaudu sisn kytten vasemmalla olevaa lomaketta!",
    72 => 'Teema',
    73 => 'Kieli',
    74 => 'Vaihda sivuston ulkoasua!',
    75 => 'Shkpostitse lhetettvt uutiset',
    76 => 'Valitsemalla aiheet alla olevasta listasta, saat uudet aiheisiin liittyvt uutiset shkpostitse itsellesi kerran pivss. Valitse vain aiheet joista olet kiinnostunut!',
    77 => 'Kuva',
    78 => 'Lis kuva itsestsi!',
    79 => 'Rastita tm poistaaksesi kuvan',
    80 => 'Kirjaudu',
    81 => 'Lhet shkpostitse',
    82 => 'Viimeiset 10 tarinaa kyttjlt',
    83 => 'Tilastot kirjoituksista kyttjlt',
    84 => 'Artikkeleita yhteens:',
    85 => 'Kommentteja yhteens:',
    86 => 'Etsi kaikki postitukset kyttjlt',
    87 => 'Nimesi jolla olet kirjautunut',
    88 => "Joku (mahdollisesti sin itse) on pyytnyt uutta salasanaa tilillesi \"%s\" sivustolla {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nJos haluat vaihtaa salasanan, valitse seuraava linkki:\n\n",
    89 => "Jos et halua tehd nin, ohita tm viesti ja pyynt evtn (salasanasi pysyy muuttumattomana).\n\n",
    90 => 'Voit kirjoittaa tilisi uuden salasanan alle, Huomaa ett vanha salasanasi on yh voimassa kunnes lhett tmn lomakkeen.',
    91 => 'Aseta uusi salasana',
    92 => 'Kirjoita uusi salasana',
    93 => 'Edellinen pyyntsi salasanan vaihtamiseksi tapahtui %d sekuntia sitten. Sivusto vaatii ainakin %d sekunnin viiveen vaihtojen vlill.',
    94 => 'Poista tili "%s"',
    95 => 'Valitse "poista tili" nappi alta poistaaksesi tietosi tietokannasta. Huomaa ett kaikki postittamasi artikkelit ja kommentit <strong>eivt</strong> poistu, mutta niiden kirjoittajaksi merkitn "tuntematon".',
    96 => 'poista tili',
    97 => 'Vahvista tilin poistaminen',
    98 => 'Oletko varma ett haluat poistaa tilisi? Poistamalla kyttjtilin et voi kirjautua sivustolle uudestaan (paitsi tekemll uuden tilin). Jos olet varma, valitse "poista tili" alta.',
    99 => 'Yksityisyyden vaihtoehdot tilille',
    100 => 'Yllpidon viestit',
    101 => 'Salli yllpidon lhettmt shkpostit',
    102 => 'Kyttjien viestit',
    103 => 'Salli muiden kyttjien lhettmt shkpostit',
    104 => 'Nyt linjalla -tila',
    105 => 'Ny Ket on linjalla -lohkossa',
    106 => 'Location',
    107 => 'Shown in your public profile',
    108 => 'Confirm new password',
    109 => 'Enter the New password again here',
    110 => 'Current Password',
    111 => 'Please enter your Current password',
    112 => 'You have exceeded the number of allowed login attempts.  Please try again later.',
    113 => 'Login Attempt Failed',
    114 => 'Account Disabled',
    115 => 'Your account has been disabled, you may not login. Please contact an Administrator.',
    116 => 'Account Awaiting Activation',
    117 => 'Your account is currently awaiting activation by an administrator. You will not be able to login until your account has been approved.',
    118 => "Your {$_CONF['site_name']} account has now been activated by an administrator. You may now login to the site at the url below using your username (<username>) and password as previously emailed to you.",
    119 => 'If you have forgotten your password, you may request a new one at this url:',
    120 => 'Account Activated',
    121 => 'Service',
    122 => 'Sorry, new user registration is disabled',
    123 => "Are you a <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">new user</a>?",
    124 => 'Confirm Email',
    125 => 'You have to enter the same email address in both fields!',
    126 => 'Please repeat for confirmation',
    127 => 'To change any of these settings, you will have to enter your current password.',
    128 => 'Your Name',
    129 => 'Password &amp; Email',
    130 => 'About You',
    131 => 'Daily Digest Options',
    132 => 'Daily Digest Feature',
    133 => 'Comment Display',
    134 => 'Comment Options',
    135 => '<li>Default mode for how comments will be displayed</li><li>Default order to display comments</li><li>Set maximum number of comments to show - default is 100</li>',
    136 => 'Exclude Topics and Authors',
    137 => 'Filter Story Content',
    138 => 'Misc Settings',
    139 => 'Layout and Language',
    140 => '<li>No Topic Icons if checked will not display the story topic icons</li><li>No boxes if checked will only show the Admin Menu, User Menu and Topics</li><li>Set the maximum number of stories to show per page</li><li>Set your theme, timezone and preferred date format</li>',
    141 => 'Privacy Settings',
    142 => 'The default setting is to allow users & admins to email fellow site members and show your status as online. Un-check these options to protect your privacy.',
    143 => 'Filter Block Content',
    144 => 'Show & hide boxes',
    145 => 'Your Public Profile',
    146 => 'Password and email',
    147 => 'Edit your account password, email and autologin feature. You will need to enter the same password or email address twice as a confirmation.',
    148 => 'User Information',
    149 => 'Modify your user information that will be shown to other users.<li>The signature will be added to any comments or forum posts you made</li><li>The BIO is a brief summary of yourself to share</li><li>Share your PGP Key</li>',
    150 => 'Warning: Javascript recommended for enhanced functionality',
    156 => 'Delete Account',
    157 => 'Delete Option',
    158 => 'Time Zone',
    159 => 'This email was generated automatically. Please do not reply to this email.',
    160 => '(max. %d x %d pixels, %d bytes; %s)',
    161 => 'will be scaled down',
    162 => 'will not be scaled',
    163 => 'Re-Authentication Failed',
    164 => 'You have exceeded the number of allowed attempts for re-authentication. The operation has been aborted and your recent changes were lost, sorry.',
    165 => 'Use Advanced Editor'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Preview',
    'pe_namepass' => 'Username &amp; Password',
    'pe_userinfo' => 'About You',
    'pe_layout' => 'Layout &amp; Language',
    'pe_content' => 'Content',
    'pe_privacy' => 'Privacy'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'Ei nytettvi uutisia',
    2 => 'Ei nytettvi uutisi. Joko aiheesta ei ole uutisia tai asetuksesi voivat olla liian rajoittavia',
    3 => ' aiheesta %s',
    4 => 'Pivn artikkeli',
    5 => 'Seuraava',
    6 => 'Edellinen',
    7 => 'First',
    8 => 'Last'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'Virhe viesti lhetettess. Yrit uudelleen.',
    2 => 'Viesti lhetetty onnistuneesti.',
    3 => 'Varmista ett vastausosoite-kentss on oikea shkpostiosoite.',
    4 => 'Tyt nimesi, vastausosoite, aihe sek viesti-kentt',
    5 => 'Virhe: valittua kyttj ei lydy.',
    6 => 'Tapahtui virhe ksittelyss.',
    7 => 'Profiili kyttjlle',
    8 => 'Kyttjnimi',
    9 => 'Kyttjn URL',
    10 => 'Lhet viesti kyttjlle',
    11 => 'Nimesi:',
    12 => 'Vastausosoite:',
    13 => 'Aihe:',
    14 => 'Viesti:',
    15 => 'HTML koodeja ei knnet.',
    16 => 'Lhet viesti',
    17 => 'Lhet artikkeli ystvlle',
    18 => 'Kyttjlle',
    19 => 'Shkpostiosoitteeseen',
    20 => 'Lhettjn nimi',
    21 => 'Lhettjn shkpostiosoite',
    22 => 'Kaikki kentt on tytettv',
    23 => "Tmn shkpostin lhetti sinulle %s at %s koska hn ajatteli artikkelin osoitteesta {$_CONF['site_url']} kiinnostavan sinua.  Tm ei ole roskapostia ja lhetyksess kytettyj shkpostiosoitteita ei tallenneta myhemp kytt varten.",
    24 => 'Kommentoi artikkelia osoitteessa',
    25 => 'Sinun taytyy olla kirjautuneena sivustolle kyttksesi ominaisuutta. Vaatimalla kirjautumista estetn jrjestelmn vrinkytkset',
    26 => 'Tll lomakkeella voit lhett shkpostia valitulle kyttjlle. Kaikki kentt ovat pakollisia tytt.',
    27 => 'Lyhyt viesti',
    28 => '%s kirjoitti: ',
    29 => "Tm on pivittinen kooste sivustolta {$_CONF['site_name']} kyttjlle ",
    30 => ' Pivittinen uutislehti ',
    31 => 'Otsikko',
    32 => 'Pivys',
    33 => 'Lue artikkeli kokonaan osoitteessa',
    34 => 'Viestin loppu',
    35 => 'Pahoittelemme, kyttj ei halua saada shkposteja.',
    36 => 'Copy:',
    37 => 'Send me a copy of this email',
    38 => "This is a copy of the email that you sent to %s from <{$_CONF['site_url']}>:"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Laajennettu haku',
    2 => 'Avainsanat',
    3 => 'Aihe',
    4 => 'Kaikki',
    5 => 'Tyyppi',
    6 => 'Artikkelit',
    7 => 'Kommentit',
    8 => 'Kirjoittajat',
    9 => 'Kaikki',
    10 => 'Etsi',
    11 => 'Etsinnn tulokset',
    12 => 'osumaa',
    13 => 'Etsinnn tulokset: ei osumia',
    14 => 'Ei lytynyt hakutuloksia haulle',
    15 => 'Yrit uudelleen.',
    16 => 'Otsikko',
    17 => 'Pivys',
    18 => 'Kirjoittaja',
    19 => "Etsi nykyisi ja vanhoja artikkeleita sivuston {$_CONF['site_name']} koko tietokannasta",
    20 => 'Pivys',
    21 => 'viiva',
    22 => '(Pivyksen muoto VVVV-KK-PP)',
    23 => 'Katselukertaa',
    24 => 'Lydetty %d aihetta',
    25 => 'Etsitty ',
    26 => 'aihetta ',
    27 => 'sekuntia',
    28 => 'Yksikn artikkeli tai kommentti ei vastannut hakuasi',
    29 => 'Artikkeleiden ja kommenttien tulokset',
    30 => '',
    31 => 'Laajennus ei lytnyt osumia',
    32 => '',
    33 => 'URL',
    34 => 'Sijainti',
    35 => 'Koko pivn',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Hakulauseessa tulee olla ainakin 3 merkki.',
    42 => 'Kyt pivyst muodossa VVVV-KK-PP (vuosi-kuukausi-piv).',
    43 => 'tsmlleen sama lause',
    44 => 'kaikki sanat',
    45 => 'mik tahansa sanoista',
    46 => 'Seuraava',
    47 => 'Edellinen',
    48 => 'Kirjoittaja',
    49 => 'Pivys',
    50 => 'Osumia',
    51 => '',
    52 => 'Sijainti',
    53 => 'Tulokset artikkeleista',
    54 => 'Tulokset kommenteista',
    55 => 'lause',
    56 => 'JA',
    57 => 'TAI',
    58 => 'More results &gt;&gt;',
    59 => 'Results',
    60 => 'per page',
    61 => 'Refine search',
    62 => '#',
    63 => 'Description',
    64 => 'Showing %1$d - %2$d of %3$d results',
    65 => 'Story',
    66 => 'Comment',
    67 => 'Show %d Results',
    68 => 'Sort By',
    69 => 'Titles Only',
    70 => 'Not available ...',
    71 => 'asc',
    72 => 'desc'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Sivuston tilastot',
    2 => 'Yhteens latauksia jrjestelmst',
    3 => 'Artikkeleja(kommentteja) jrjestelmss',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Kymmenen luetuinta artikkelia',
    8 => 'Artikkelin otsikko',
    9 => 'Lukukertoja',
    10 => 'Nytt silt ettei sivustolla ole artikkeleita tai kukaan ei ole koskaan niit lukenut.',
    11 => 'Kymmenen kommentoiduinta artikkelia',
    12 => 'Kommentteja',
    13 => 'Nytt silt ettei sivustolla ole artikkeleita tai kukaan ei ole kommentoinut niit.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'Kymmenen postitetuinta artikkelia',
    23 => 'Lhetyksi',
    24 => 'Nytt silt ettei kukaan ole lhettnyt shkpostitse artikkeleita sivustolta.',
    25 => 'Top Ten Trackback Commented Stories',
    26 => 'No trackback comments found.',
    27 => 'Number of active users',
    28 => '',
    29 => '',
    30 => 'Hits',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Aiheeseen liittyen',
    2 => 'Lhet artikkeli ystvlle',
    3 => 'Tulostettava versio artikkelista',
    4 => 'Artikkelien asetukset',
    5 => '',
    6 => 'Subscribe to \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'Lhettksesi %s sinun tytyy olla kirjautuneena sivustolle.',
    2 => 'Kirjaudu',
    3 => 'Uusi kyttj',
    4 => '',
    5 => '',
    6 => 'Lhet artikkeli',
    7 => 'Kirjautuminen vaaditaan',
    8 => 'Lhet',
    9 => 'Lhettesssi tietoa sivuston kyttn, seuraa oheisia suosituksia...<ul><li>Tyt kaikki kentt<li>Lhet tydellist ja paikkaansapitv tietoa<li>Tuplatarkista URL-osoitteet</ul>',
    10 => 'Otsikko',
    11 => '',
    12 => 'Aloituspiv',
    13 => 'Lopetuspiv',
    14 => 'Sijainti',
    15 => 'Kuvaus',
    16 => '',
    17 => '',
    18 => '',
    19 => 'Lue ensin',
    20 => '',
    21 => '',
    22 => 'Virhe: puuttuvia kentti',
    23 => 'Tyt kaikki kentt lomakkeessa. Kaikki kentt ovat pakollisia.',
    24 => 'Lhetys tallennettu',
    25 => '%s -lhetys on tallennettu onnistuneesti.',
    26 => 'Nopeusrajoitus',
    27 => 'Kyttjnimi',
    28 => 'Aihe',
    29 => 'Juttu',
    30 => 'Viimeisin lhetyksesi oli ',
    31 => " sekuntia sitten. Sivusto vaatii vhintn {$_CONF['speedlimit']} sekunnin tauon lhetysten vlill",
    32 => 'Esikatselu',
    33 => 'Artikkelin esikatselu',
    34 => 'Kirjaudu ulos',
    35 => 'HTML koodit eivt ole sallittu',
    36 => 'Lhetystila',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Osoiterivi 1',
    45 => 'Osoiterivi 2',
    46 => 'Kaupunki',
    47 => 'Osavaltio',
    48 => 'Postinumero',
    49 => '',
    50 => '',
    51 => 'Sijainti',
    52 => 'Poista',
    53 => 'Luo tili',
    54 => 'Story Introduction',
    55 => 'Story Body'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Tunnistus vaaditaan',
    2 => 'Evtty! Virheelliset kirjautumistiedot',
    3 => 'Vr salasana kyttjlle',
    4 => 'Kyttjtunnus:',
    5 => 'Salasana:',
    6 => 'Kaikki yllpidon osioiden liikenne sivustolla kirjataan ja tarkistetaan. <br' . XHTML . '>Sivu on tarkoitettu vain sallitulle henkilkunnalle.',
    7 => 'kirjaudu'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Riittmttmt yllpidolliset valtuudet',
    2 => 'Sinulla ei ole oikeuksia muokata tt lohkoa.',
    3 => 'Lohkojen muokkaus',
    4 => 'There was a problem reading this feed (see error.log for details).',
    5 => '',
    6 => '',
    7 => 'Kaikki',
    8 => 'Lohkon turvallisuustaso',
    9 => 'Lohkon lajittelu',
    10 => '',
    11 => 'Sivuston lohko',
    12 => 'Normaali lohko',
    13 => 'Sivuston lohkojen asetukset',
    14 => 'RDF URL',
    15 => 'Viimeisin RDF pivitys',
    16 => 'Normaalin lohkon asetukset',
    17 => 'Lohkon sislt',
    18 => 'Tyt lohkon otsikko, turvallisuus taso sek sislt -kentt',
    19 => 'Lohkojen hallinta',
    20 => '',
    21 => 'Lohkon turvataso',
    22 => '',
    23 => 'Lajittelujrjestys',
    24 => '',
    25 => 'Muokataksesi tai poistaaksesi lohkoa, klikkaa haluamaasi lohkoa alta. Luodaksesi uuden lohkon, klikkaa uusi lohko ylpuolelta.',
    26 => 'Ulkoasu lohko',
    27 => 'PHP lohko',
    28 => 'PHP lohkon asetukset',
    29 => 'Lohkon toiminnot',
    30 => 'Jos haluat lohkon kyttvn PHP koodia, syt funktion nimi ylhlle. Funktion tai toiminteen tulee alkaa "phpblock_" (esimerkiksi phpblock_getweather). Jos aliohjelmassa ei ole tt alkulausetta, funktiota ei kutsuta.  Tm tehdn epmristen aliohjelmakutsujen estmiseksi jos henkilt ovat hakkeroineet Geeklogin asennuksen. Varmista ettet laita tyhji sulkuja "()" funktion nimen pern. Lopuksi on suositeltavaa laittaa kaikki PHP koodisi tiedostoon /path/to/geeklog/system/lib-custom.php.  Tll varmistut ett koodisi silyy vaikka pivittisit Geeklogin uudempaan versioon.',
    31 => 'Virhe PHP lohkossa.  Funktio, %s, ei ole olemassa.',
    32 => 'Virhe puuttuva kentt',
    33 => 'Sinun tulee sytt URL .rdf tiedostoon sivuston lohkoa varten',
    34 => 'Sinun tulee sytt otsikko ja funktio PHP lohkoa varten',
    35 => 'Sinun tulee sytt otsikko ja sislt normaali lohkoihin',
    36 => 'Sinun tulee sytt sislt ulkoasu lohkoa varten',
    37 => 'Virheellinen PHP lohkon funktion nimi',
    38 => 'PHP lohkojen funktioissa tulee olla alussa \'phpblock_\' (esim. phpblock_getweather).  \'phpblock_\' etuliite vaaditaan turvallisuuden vuoksi, hmrn koodin ajamisen estmiseksi.',
    39 => 'Sivu',
    40 => 'Vasen',
    41 => 'Oikea',
    42 => 'Lajittelujrjestys ja turvallisuustaso tulee sytt Geeklogin oletuslohkoja varten',
    43 => 'Vain kotisivu',
    44 => '',
    45 => "Olet yrittmss kytt lohkoa johon sinulla ei ole oikeuksia. Yritys on kirjattu lokitiedostoon.  <a href=\"{$_CONF['site_admin_url']}/block.php\">Siirry takaisin yllpidon valikkoon</a>.",
    46 => 'Uusi lohko',
    47 => '',
    48 => 'Lohkon nimi',
    49 => ' (ei vlilyntej ja nimen tulee olla yksilllinen)',
    50 => 'The Block Name can not be empty',
    51 => 'sisllyt http://',
    52 => 'Jos jtt tmn tyhjksi, avuste-ikonia ei nytet tlle lohkolle',
    53 => 'Pll',
    54 => 'tallenna',
    55 => 'peruuta',
    56 => 'poista',
    57 => 'Siirr lohkoa alaspin',
    58 => 'Siirr lohkoa ylspin',
    59 => 'Siirr lohko oikealle puolelle',
    60 => 'Siirr lohko vasemmalle puolelle',
    61 => 'No Title',
    62 => 'Article Limit',
    63 => 'Bad Block Title',
    64 => 'Your Title must not be empty and cannot contain HTML!',
    65 => 'Order',
    66 => 'Autotags',
    67 => 'Check to allow autotags',
    68 => 'The feed for this portal block is too long to display. Please set a maximum number of articles to import for the block in the block setup screen, or a global maximum in Geeklog Configuration.'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => 'Aikaisemmat artikkelit',
    2 => 'Seuraavat artikkelit',
    3 => 'Tila',
    4 => 'Lhetystila',
    5 => 'Artikkelin muokkaus',
    6 => 'Ei artikkeleja jrjestelmss',
    7 => 'Kirjoittaja',
    8 => 'tallenna',
    9 => 'esikatselu',
    10 => 'peruuta',
    11 => 'poista',
    12 => 'ID',
    13 => '',
    14 => '',
    15 => 'Pivys',
    16 => 'Alkuteksti',
    17 => 'Leipteksti',
    18 => 'Osumia',
    19 => 'Kommentteja',
    20 => 'Ping',
    21 => 'Send Ping',
    22 => 'Lista artikkeleista',
    23 => 'Muokataksesi tai poistaaksesi artikkelin, klikkaa artikkelin numeroa. Nhdksesi artikkelin, klikkaa haluamaasi otsikkoa. Luodaksesi uuden artikkelin, valitse uusi artikkeli.',
    24 => 'The ID you chose for this story is already in use. Please use another ID.',
    25 => 'Error when saving story',
    26 => 'Artikkelin esikatselu',
    27 => 'If you use [unscaledX] instead of [imageX], the image will be inserted at its original dimensions.',
    28 => '<p><b>PREVIEWING</b>: Previewing a story with images attached is best done by saving the article as a draft INSTEAD OF hitting the preview button.  Use the preview button only when images are not attached.',
    29 => 'Trackbacks',
    30 => 'Tiedoston lhetys-virhe',
    31 => 'Tyt otsikko ja alkuteksti kentt',
    32 => 'Erikoisartikkeli',
    33 => 'Vain yksi artikkeli voi olla erikoisena',
    34 => 'Vedos',
    35 => 'Kyll',
    36 => 'Ei',
    37 => 'Lis',
    38 => 'Lis',
    39 => 'Lhetyksi',
    40 => '',
    41 => "Yritt ladata artikkelia johon sinulla ei ole oikeuksia. Yritys on kirjattu lokitiedostoon. Voit nhd artikkelin vain luku-muodossa. <a href=\"{$_CONF['site_admin_url']}/story.php\">Siirry takaisin artikkelien yllpitoon</a> kun olet valmis.",
    42 => "Yritt ladata artikkelia johon sinulla ei ole oikeuksia. Yritys on kirjattu lokitiedostoon. <a href=\"{$_CONF['site_admin_url']}/story.php\">Siirry takaisin artikkelien yllpitoon</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>HUOMAA:</b> jos muokkaat pivyst osoittamaan tulevaisuuteen, artikkelia ei julkaista ennen kyseist piv. Artikkelia ei myskn sisllytet RDF otsikoihin, hakuihin tai tilastoihin.',
    47 => 'Kuvat',
    48 => 'kuva',
    49 => 'oikea',
    50 => 'vasen',
    51 => 'Listksesi kuvan artikkeliin, tekstin joukkoon tulee list erikoisteksti. Erikoistekstej ovat [imageX], [imageX_right] tai [imageX_left] jossa X on kuvan numero jonka olet liittnyt. HUOMAA: Sinun tulee kytt kuvia jotka itse liitt artikkeliin, muuten et voi tallentaa artikkelia.<BR><P><B>ESIKATSELU</B>: Esikatselu kuvien kanssa onnistuu parhaiten tallentamalla artikkeli aluksi vedoksena EIK painamalla esikatselu-nappia. Kyt esikatselua vain kun kuvia ei ole liitettyn.',
    52 => '',
    53 => 'ei kytetty. Sinun tulee sisllytt tm kuva alkutekstiin tai leiptekstiin ennen kuin voit tallentaa muutokset',
    54 => 'Liitetyt kuvat joita ei kytetty',
    55 => 'Seuraavat virheet tapahtuivat tallennettaessa. Korjaa virheet ennen tallentamista',
    56 => 'Nyt aihe kuvake',
    57 => 'Nyt skaalaamaton kuva',
    58 => 'Story Management',
    59 => 'Option',
    60 => '',
    61 => 'Auto Archive',
    62 => 'Auto Delete',
    63 => 'Disable Comments',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Expand the Content Edit Area size',
    68 => 'Reduce the Content Edit Area size',
    69 => 'Publish Story Date',
    70 => 'Toolbar Selection',
    71 => 'Basic Toolbar',
    72 => 'Common Toolbar',
    73 => 'Advanced Toolbar',
    74 => 'Advanced II Toolbar',
    75 => 'Full Featured',
    76 => 'Publish Options',
    77 => 'Javascript needs to be enabled for Advanced Editor. Option can be disabled in the main site config.php',
    78 => 'Click <a href="%s/story.php?mode=edit&amp;sid=%s&amp;editopt=default">here</a> to use default editor',
    79 => 'Preview',
    80 => 'Editor',
    81 => 'Publish Options',
    82 => 'Images',
    83 => 'Archive Options',
    84 => 'Permissions',
    85 => 'Show All',
    86 => 'Advanced Editor',
    87 => 'Story Stats',
    88 => 'Wiki-style format',
    89 => 'Meta Description',
    90 => 'Meta Keywords',
    91 => 'You can always hit "Preview" to extend the expiry time.'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Aihepiirien muokkaus',
    2 => 'Aiheen ID',
    3 => 'Aihepiirin nimi',
    4 => 'Aiheen kuva',
    5 => '(l kyt vlilyntej)',
    6 => 'Aihepiirin poistaminen poistaa kaikki aihepiirin artikkelit ja lohkot jotka siihen liittyvt',
    7 => 'Tyt Aiheen ID ja Aihepiirin nimi -kentt',
    8 => 'Aihepiirien hallinta',
    9 => 'Klikkaa aihepiiri muokataksesi tai poistaaksesi aiheen. Luodaksesi uuden valitse uusi aihepiiri -nappi vasemmalta. Net kyttoikeutesi aihepiiriin suluissa. Thti (*) merkitsee oletusaihetta.',
    10 => 'Lajittelujrjestys',
    11 => 'Artikkeleja/sivu',
    12 => 'Psy kielletty',
    13 => "Olet pyrkimss aiheeseen johon sinulla ei ole oikeuksia. Yritys on kirjattu lokitiedostoon. <a href=\"{$_CONF['site_admin_url']}/topic.php\">Siirry takaisin aihepiirien yllpitoon</a>.",
    14 => 'Lajittelu tapa',
    15 => 'aakkosellinen',
    16 => 'oletus on',
    17 => 'Uusi aihepiiri',
    18 => 'Yllpidon sivu',
    19 => 'tallenna',
    20 => 'peruuta',
    21 => 'poista',
    22 => 'Oletus',
    23 => 'tee tst oletus aihe uusille artikkeleille',
    24 => '(*)',
    25 => 'Archive Topic',
    26 => 'make this the default topic for archived stories. Only one topic allowed.',
    27 => 'Or Upload Topic Icon',
    28 => 'Maximum',
    29 => 'File Upload Errors',
    30 => 'Stories in Topic'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'Kyttjn muokkaus',
    2 => 'Kyttjn ID',
    3 => 'Kyttjtunnus',
    4 => 'Koko nimi',
    5 => 'Salasana',
    6 => 'Turvallisuustaso',
    7 => 'Shkposti-osoite',
    8 => 'Kotisivu',
    9 => '(l kyt vlilyntej)',
    10 => 'Tyt kyttjtunnus ja shkposti-osoite kentt',
    11 => 'Kyttjien hallinta',
    12 => 'Klikkaa alta jos haluat muokata tai poistaa kyttjn. Luodaksesi uuden kyttjn, valitse uusi kyttj vasemmalta. Voit tehd yksinkertaisia hakuja syttmll osan kyttjtunnuksesta, shkpostista tai kokonimest allaolevaan lomakkeeseen (esimerkiksi *son* tai *.edu).',
    13 => 'Turvataso',
    14 => 'Rek.piv',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'tallenna',
    21 => 'Kyttjtunnus on jo olemassa.',
    22 => 'Virhe',
    23 => 'Kimppalisys',
    24 => 'Tuo lauma kyttji',
    25 => 'Voit tuoda Geeklogiin suuremman mrn kyttji. Tuontitiedoston tulee olla sarkain-eroteltu teksti-tiedosto jossa kenttien tulee olla seuraavassa jrjestyksess: koko nimi, kyttjtunnus, shkposti-osoite. Tuomillesi henkilille postitetaan satunnaisesti generoitu salasana shkpostitse. Tiedostossa tulee olla yksi kyttj per rivi. Virheet tuonnissa voivat aiheuttaa ongelmia joiden selvittminen vaatii ksityt joten tarkista sytteesi tarkasti!',
    26 => '',
    27 => '',
    28 => 'Klikkaa thn tuhotaksesi tmn kuvan',
    29 => 'Polku',
    30 => 'Tuo',
    31 => 'Uudet kyttjt',
    32 => 'Ksittely valmis. Tuotiin %d ja kohdattiin %d virhett',
    33 => 'lhet',
    34 => 'Virhe: valitse lhetettv tiedosto.',
    35 => 'Viimeksi kirjautunut',
    36 => '(ei koskaan)',
    37 => 'UID',
    38 => 'Group Listing',
    39 => 'Password (again)',
    40 => 'Registration Date',
    41 => 'Last login Date',
    42 => 'Banned',
    43 => 'Awaiting Activation',
    44 => 'Awaiting Authorization',
    45 => 'Active',
    46 => 'User Status',
    47 => 'Edit',
    48 => 'Show Admin Groups',
    49 => 'Admin Group',
    50 => 'Check to allow filtering this group as an Admin Use Group',
    51 => 'Online Days',
    52 => '<br' . XHTML . '>Note: "Online Days" is the number of days between the first registration and the last login.',
    53 => 'registered',
    54 => 'Batch Delete',
    55 => 'This only works if you have <code>$_CONF[\'lastlogin\'] = true;</code> in your config.php',
    56 => 'Please choose the type of user you want to delete and press "Update List". Then, uncheck those from the list you do not want to delete and press "Delete". Please note that you will only delete those that are currently visible in case the list spans over several pages.',
    57 => 'Phantom users',
    58 => 'Short-Time Users',
    59 => 'Old Users',
    60 => 'Users that registered more than ',
    61 => ' months ago, but never logged in.',
    62 => 'Users that registered more than ',
    63 => ' months ago, then logged in within 24 hours, but since then never came back to your site.',
    64 => 'Normal users, who simply did not visit your site since ',
    65 => ' months.',
    66 => 'Update List',
    67 => 'Months since registration',
    68 => 'Online Hours',
    69 => 'Offline Months',
    70 => 'could not be deleted',
    71 => 'sucessfully deleted',
    72 => 'No User selected for deletion',
    73 => 'Are You sure you want to permanently delete ALL selected users?',
    74 => 'Recent Users',
    75 => 'Users that registered in the last ',
    76 => ' months',
    77 => 'Email site login reminder to selected users',
    78 => 'Send Reminder',
    79 => 'No User selected for reminders',
    80 => 'Successfully sent Reminders',
    81 => 'Reminder to verify account for %s',
    82 => "Your account on {$_CONF['site_name']} has not been accesssed since %s and will be disabled if not accessed in the 30 days.",
    83 => "Your account on {$_CONF['site_name']} has not been used since it was created and will deleted soon if not accessed.",
    84 => "Your login name is: %s  for our site: {$_CONF['site_url']}",
    85 => 'If you have forgotten the password use the following link: %s',
    86 => 'Include',
    87 => 'Reminders',
    88 => 'Default Group',
    89 => 'Check to make this a default group for new users',
    90 => 'Apply "Default Group" change to existing user accounts'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => 'Hyvksy',
    2 => 'Poista',
    3 => 'Muokkaa',
    4 => 'Profiili',
    10 => 'Otsikko',
    11 => 'Aloitus piv',
    12 => 'URL',
    13 => 'Aihepiiri',
    14 => 'Piv',
    15 => 'Aihe',
    16 => 'Kyttjnimi',
    17 => 'Koko nimi',
    18 => 'Shkposti',
    34 => 'Komennot ja hallinta',
    35 => 'Lhetettyj artikkeleja',
    36 => 'Parent or Comment',
    37 => '',
    38 => 'Lhet',
    39 => 'Ei hallinnoitavia lhetyksi tll hetkell',
    40 => 'Kyttjien lhetyksi',
    41 => 'Comment Submissions',
    42 => 'Username',
    43 => 'Auto-publish Comments?'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "{$_CONF['site_name']} Posti Apuri",
    2 => 'Lhettj',
    3 => 'Vastausosoite',
    4 => 'Aihe',
    5 => 'Leipteksti',
    6 => 'Kenelle lhetetn:',
    7 => 'Kaikille kyttjille',
    8 => 'Yllpito',
    9 => 'Vaihtoehdot',
    10 => 'HTML',
    11 => 'Trke viesti!',
    12 => 'Lhet',
    13 => 'Tyhjenn',
    14 => 'Ohita kyttjien asetukset',
    15 => 'Virhe lhetettess: ',
    16 => 'Lhetykset tehty onnistuneesti: ',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>Lhet toinen viesti</a>",
    18 => 'Vastaanottaja',
    19 => 'HUOMAA: jos haluat lhett viestin sivuston kaikille jsenille, valitse kirjautuneet kyttjt -ryhm pudotusvalikosta.',
    20 => "Onnistuneesti lhetetty <successcount> viesti ja eponnistuttu <failcount> viestin lhetyksess. Tarvittaessa kaikkien viestilhetyksien tiedot lytyvt alta. Muuten voit lhett <a href=\"{$_CONF['site_admin_url']}/mail.php\">seuraavan viestin</a> tai <a href=\"{$_CONF['site_admin_url']}/moderation.php\">siirty takaisin hallinnon sivulle</a>.",
    21 => 'eponnistumisia',
    22 => 'onnistumisia',
    23 => 'Ei eponnistumisia',
    24 => 'Ei onnistumisia',
    25 => '-- Valitse ryhm --',
    26 => 'Tyt kaikki kentt lomakkeesta ja valitse kohdekyttjien ryhm pudotusvalikosta.'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'Laajennusten asentaminen voi vahingoittaa Geeklogia ja mahdollisesti jrjestelmsi. Kyt vain <a href="http://www.geeklog.net" target="_blank">Geeklogin kotisivulta</a> ladattuja laajennuksia, koska testaamme sivustollemme lhetetyt laajennukset usealla kyttjrjestelmll. On trke ymmrt laajennuksien asentamisen vaativan joidenkin kyttjrjestelmikskyjen ajamisen, jotka voivat johtaa turvallisuusongelmiin, varsinkin kolmansien osapuolien laajennusten tapauksessa. Vaikka varoitammekin kyttji laajennuksista, emme takaa asennuksen onnistumista emmek ota vastuuta Geeklogin laajennusten aiheuttamista vahingoista. Toisinsanoen, asenna nit omalla vastuullasi. Varovaisille; ksin tapahtuvaan asennukseen tulee ohjeet jokaisessa laajennuspaketissa.',
    2 => 'Huomioi laajennuksia asentaessasi',
    3 => 'Laajennuksien asentamislomake',
    4 => 'Laajennustiedosto',
    5 => 'Lista laajennuksista',
    6 => 'Varoitus: laajennus on jo asennettu!',
    7 => 'Laajennus jonka asentamista yritt, on jo asennettu. Poista laajennus ennen sen uudelleenasentamista',
    8 => 'Laajennuksen yhteensopivuustesti eponnistui',
    9 => 'Laajennus vaatii uudemman version Geeklogista. Pivit <a href="http://www.geeklog.net">Geeklog-jrjestelmsi</a> tai hanki uudempi versio laajennuksesta.',
    10 => '<br' . XHTML . '><b>Laajennuksia ei ole tll hetkell asennettuna.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'Muokataksesi tai poistaaksesi laajennuksen, valitse laajennuksen numero. Halutessasi listietoja laajennuksesta, valitse laajennuksen nimi alta ja sinut ohjataa laajennuksen kotisivulle. Asentaaksesi tai pivittksesi laajennuksen, lue laajennuksen dokumentaatio.',
    12 => 'laajennuksen nime ei ole lhetetty plugineditor()',
    13 => 'Laajennusten muokkain',
    14 => 'Uusi laajennus',
    15 => 'Hallinnon sivu',
    16 => 'Laajennuksen nimi',
    17 => 'Laajennuksen versio',
    18 => 'Geeklogin versio',
    19 => 'Pll',
    20 => 'Kyll',
    21 => 'Ei',
    22 => 'Asenna',
    23 => 'Tallenna',
    24 => 'Peruuta',
    25 => 'Poista',
    26 => 'Laajennuksen nimi',
    27 => 'Laajennuksen kotisivu',
    28 => 'Laajennuksen versio',
    29 => 'Geeklogin versio',
    30 => 'Poista laajennus?',
    31 => 'Oletko varma ett haluat poistaa laajennuksen? Poistamalla poistat mys kaiken tiedot ja tietorakenteen jotka liittyvt thn laajennukseen. Jos olet varma, valitse poista uudelleen alta lytyvst lomakkeesta.',
    32 => '<p><b>Error AutoLink tag not correct format</b></p>',
    33 => 'Code Version',
    34 => 'Update',
    35 => 'Edit',
    36 => 'Code',
    37 => 'Data',
    38 => 'Update!',
    39 => 'Upload a plugin',
    40 => 'You can upload a plugin archive (.tar.gz, .tgz, .zip) directly here:',
    41 => 'Upload',
    42 => 'Click to update',
    99 => 'An unknown error occured',
    100 => 'Ok.',
    101 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini.',
    102 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.',
    103 => 'The uploaded file was only partially uploaded.',
    104 => 'No file was uploaded.',
    105 => '(undefined error)',
    106 => 'Missing a temporary folder.',
    107 => 'Failed to write file to disk.',
    108 => 'File upload stopped by extension.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'luo syte',
    2 => 'tallenna',
    3 => 'poista',
    4 => 'peruuta',
    10 => 'Sislln syndikointi',
    11 => 'Uusi syte',
    12 => 'Yllpidon sivu',
    13 => 'Poistaaksesi tai muokataksesi sytett, valitse sytteen otsikko. Luodaksesi uuden sytteen, valitse Uusi syte ylt.',
    14 => 'Otsikko',
    15 => 'Tyyppi',
    16 => 'Tiedosto',
    17 => 'Muoto',
    18 => 'viimeksi pivitetty',
    19 => 'Sallittu',
    20 => 'Kyll',
    21 => 'Ei',
    22 => '<i>(ei sytteit)</i>',
    23 => 'kaikki artikkelit',
    24 => 'Sytteiden muokkain',
    25 => 'Sytteen otsikko',
    26 => 'Rajoitus',
    27 => 'Sislln pituus',
    28 => '(0 = ei teksti, 1 = koko teksti, muu = rajoita syttmsi mrn merkkej.)',
    29 => 'Kuvaus',
    30 => 'Viimeisin pivitys',
    31 => 'Merkkilaji',
    32 => 'Kieli',
    33 => 'Sislt',
    34 => 'Kirjauksia',
    35 => 'Tuntia',
    36 => 'Valitse sytteen tyyppi',
    37 => '',
    38 => 'Virhe: puuttuvia kentti',
    39 => 'Tyt sytteen otsikko, kuvaus ja tiedoston nimi.',
    40 => 'Syt kirjauksien mr tai tuntien lukumr.',
    41 => 'Linkit',
    42 => '',
    43 => 'All',
    44 => 'None',
    45 => 'Header-link in topic',
    46 => 'Limit Results',
    47 => 'Search',
    48 => 'Edit',
    49 => 'Feed Logo',
    50 => "Relative to site url ({$_CONF['site_url']})",
    51 => 'The filename you have chosen is already used by another feed. Please choose a different one.',
    52 => 'Error: existing Filename',
    53 => 'All Frontpage Stories',
    54 => 'Please select the type of feed to create.',
    55 => 'Articles'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Salasanasi on lhetetty shkpostitse ja pitisi saapua sinulle hetken kuluttua. Seuraa viestiss olevia ohjeita. Kiitmme sivuston {$_CONF['site_name']} kytst.",
    2 => "Kiitokset artikkelin lhettmisest sivustolle {$_CONF['site_name']}.  Yllpito tarkistaa ja lpiky sen ja se tulee hyvksymisen jlkeen lukijoiden nkyville sivustolle.",
    3 => '',
    4 => '',
    5 => 'Tilisi tiedot ovat tallennettu.',
    6 => 'Nyttasetuksesi ovat tallennettu.',
    7 => 'Kommennttisi asetukset ovat tallennettu.',
    8 => 'Olet kirjautunut ulos.',
    9 => 'Artikkelisi on tallennettu.',
    10 => 'Artikkelisi on poistettu.',
    11 => 'Lohko on tallennettu.',
    12 => 'Lohko on poistettu.',
    13 => 'Aiheesi on tallennettu.',
    14 => 'Aihe ja kaikki sen artikkelit ja lohkot ovat poistettu.',
    15 => 'Your comment has been submitted for review and will be published when approved by a moderator.',
    16 => 'You have been unsubscribed. You will no longer be notified of new replies.',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => 'Uusi kyttj on tallennettu.',
    22 => 'Kyttj on poistettu.',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => 'Viesti lhetetty onnistuneesti.',
    28 => 'Laajennus on tallennettu',
    29 => 'Sorry, you do not have access to this administration page.  Please note that all attempts to access unauthorized features are logged',
    30 => 'Psy kielletty',
    31 => '',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'Jrjestelmn viesti',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Laajennus on onnistuneesti asennettu!',
    45 => 'Laajennus on poistettu.',
    46 => '',
    47 => '',
    48 => "Kiitos jsenhakemuksestasi sivustolle {$_CONF['site_name']}. Yllpito ky lpi hakemuksesi. Hyvksymisen jlkeen salasanasi lhetetn antamaasi shkpostiosoitteeseen.",
    49 => 'Ryhm on tallennettu.',
    50 => 'Ryhm on poistettu.',
    51 => 'Kyttjnimi on jo kytss. Valitse toinen kyttjnimi.',
    52 => 'Syttmsi shkpostiosoite ei ole oikea.',
    53 => 'Uusi salasanasi on hyvksytty. Kyt uutta salasanaasi kirjautuessasi nyt sisn.',
    54 => 'Pyyntsi uuden salasanan saamiseksi on ikntynyt. Yrit uudestaan alta.',
    55 => 'Shkpostiviesti on lhetetty sinulle ja sen pitisi saapua hetken pst. Seuraa viestin ohjeita asettaaksesi uuden salasanan tilillesi.',
    56 => 'Syttmsi shkpostiosoite on jo kytss toisella tilill.',
    57 => 'Tilisi on poistettu.',
    58 => 'Sytteesi on tallennettu.',
    59 => 'Syte on poistettu.',
    60 => 'The plugin was successfully updated',
    61 => 'Plugin %s: Unknown message placeholder',
    62 => 'The trackback comment has been deleted.',
    63 => 'An error occurred when deleting the trackback comment.',
    64 => 'Your trackback comment has been successfully sent.',
    65 => 'Weblog directory service successfully saved.',
    66 => 'The weblog directory service has been deleted.',
    67 => 'The new password does not match the confirmation password!',
    68 => 'You have to enter the correct current password.',
    69 => 'Your account has been blocked!',
    70 => 'Your account is awaiting administrator approval.',
    71 => 'Your account has now been confirmed and is awaiting administrator approval.',
    72 => 'An error occured while attempting to install the plugin. See error.log for details.',
    73 => 'An error occured while attempting to uninstall the plugin. See error.log for details.',
    74 => 'The pingback has been successfully sent.',
    75 => 'Trackbacks must be sent using a POST request.',
    76 => 'Do you really want to delete this item?',
    77 => 'WARNING:<br' . XHTML . '>You have set your default encoding to UTF-8. However, your server does not support multibyte encodings. Please install mbstring functions for PHP or choose a different character set/language.',
    78 => 'Please make sure that the email address and the confirmation email address are the same.',
    79 => 'The page you have been trying to open refers to a function that no longer exists on this site.',
    80 => 'The plugin that created this feed is currently disabled. You will not be able to edit this feed until you re-enable the parent plugin.',
    81 => 'You may have mistyped your login credentials.  Please try logging in again below.',
    82 => 'You have exceeded the number of allowed login attempts.  Please try again later.',
    83 => 'To change your password, email address, or for how long to remember you, please enter your current password.',
    84 => 'To delete your account, please enter your current password.',
    85 => 'There was a problem sending the email.',
    86 => 'The OpenID server invalidated your login attempt.',
    87 => 'OpenID login operation cancelled by user.',
    88 => 'The OpenID server returned an error.',
    89 => 'Unable to find an OpenID server for the given identity URL.',
    90 => 'OpenID identification cancelled.',
    91 => 'You specified an invalid identity URL.',
    92 => "Please <a href=\"{$_CONF['site_admin_url']}/sectest.php\">check the security of your site</a> before using it!",
    93 => 'Database back up was successful.',
    94 => 'Backup Failed: Filesize less than 1kb',
    95 => 'There was an error.',
    96 => '',
    97 => '',
    98 => 'The plugin was successfully uploaded.',
    99 => 'The plugin already exists.',
    100 => 'The plugin file you uploaded was not a GZip or Zip compressed archive.',
    101 => 'There are no topics (that you have access to). You need at least one topic to be able to submit stories.',
    400 => 'Not all required fields have been passed validation',
    401 => 'Please enter Fullname'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Psy',
    'ownerroot' => 'Omistaja/Root',
    'group' => 'Ryhm',
    'readonly' => 'Vain luku',
    'accessrights' => 'Kyttoikeudet',
    'owner' => 'Omistaja',
    'grantgrouplabel' => 'Salli ryhmlle muokkaus oikeudet',
    'permmsg' => 'HUOMAA: jsenet tarkoittavat kaikkia sivustolle kirjautuneita henkilit ja tuntematon tarkoittaa kaikkia sivustolla selailevia kyttji jotka eivt ole kirjautuneet sisn.',
    'securitygroups' => 'Turvallisuus ryhmt',
    'editrootmsg' => "Vaikka olet kyttjien yllpitj, et voi muokata pkyttj olematta itse pkyttj. Voit muokata muita kyttji paitsi pyllpitj. Huomaa ett kaikki yritykset laittomasti muokata pkyttji kirjoitetaan lokitiedostoon. Siirry takaisin <a href=\"{$_CONF['site_admin_url']}/user.php\">kyttjien yllpitoon</a>.",
    'securitygroupsmsg' => 'Rastita ruudut niist ryhmist joihin haluat kyttjn kuuluvan.',
    'groupeditor' => 'Ryhmien muokkaus',
    'description' => 'Kuvaus',
    'name' => 'Nimi',
    'rights' => 'Oikeudet',
    'missingfields' => 'Puuttuvat kentt',
    'missingfieldsmsg' => 'Syt ryhmn nimi ja kuvaus',
    'groupmanager' => 'Ryhmien hallinta',
    'newgroupmsg' => 'Muokataksesi tai poistaaksesi ryhmn, valitse ryhm alta. Luodaksesi uuden ryhmn, valitse uusi ryhm ylt. Huomaa ett ydinryhmi ei voi poistaa koska ne ovat jrjestelmn kytss.',
    'groupname' => 'Ryhmn nimi',
    'coregroup' => 'Ydin ryhm',
    'yes' => 'Kyll',
    'no' => 'Ei',
    'corerightsdescr' => "Ryhm kuuluu sivuston {$_CONF['site_name']} ydin ryhmn. Ryhmn oikeuksia ei voi siit syyst muokata. Alla on lista ryhmn oikeuksista vain lukemista varten.",
    'groupmsg' => 'Turvallisuus ryhmt sivustolla ovat hierarkiset. Muokkaamalla tt ryhm tai jotain alla olevista ryhmist antaa tlle ryhmlle samat oikeudet kuin muille alla oleville ryhmille. Milloin se on mahdollista, suosittelemme kyttmn allaolevia ryhmi oikeuksie jakamiseen tlle ryhmlle. Jos tarvitset muokattuja oikeuksia, voit valita oikeudet sivuston eri toimintoihin alta lytyvst \'Oikeudet\'-kohdasta. Listksesi tmn ryhmn johonkin allaolevista ryhmist, merkitse rasti ryhmn tai ryhmien viereen.',
    'coregroupmsg' => "Tm ryhm on ydinryhm sivustolla {$_CONF['site_name']}.  Tst johtuen ryhm ei voi muokata. Alla on lista vain luku-muodossa ryhmist joihin tm ryhm kuuluu.",
    'rightsdescr' => 'Ryhm saa oikeutensa joko olemalla osana toista ryhm TAI ryhmlle voi antaa suoraan haluamasi oikeudet. Alla olevat oikeudet joissa ei ole rastiruutua, ovat oikeuksia jotka ryhm on saanut olemalla osa jotain toista ryhm jolla nuo oikeudet ovat. Ne joissa on laatikko vieress ovat oikeuksia joita ryhmlle voidaan suoraan mynt.',
    'lock' => 'Lukittu',
    'members' => 'Jsenet',
    'anonymous' => 'Tuntematon',
    'permissions' => 'Oikeudet',
    'permissionskey' => 'L = luku, M = muokkaa, muokkaus-oikeudet olettavat mys luku oikeuksien lytyvn',
    'edit' => 'Muokkaa',
    'none' => 'Ei yhtn',
    'accessdenied' => 'Psy kielletty',
    'storydenialmsg' => "Sinulla ei ole oikeuksia katsoa artikkelia. Oletko varmasti jsenen sivustolla {$_CONF['site_name']}? <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">Rekisteridy jseneksi</a> sivustolle {$_CONF['site_name']} saadaksesi tydet jsenyyden suomat oikeudet!",
    'nogroupsforcoregroup' => 'Ryhm ei kuulu mihinkn muuhun ryhmn',
    'grouphasnorights' => 'Ryhmll ei ole hallinnointi oikeuksia sivustolla.',
    'newgroup' => 'Uusi ryhm',
    'adminhome' => 'Yllpidon sivu',
    'save' => 'tallenna',
    'cancel' => 'peruuta',
    'delete' => 'poista',
    'canteditroot' => 'Olet yrittnyt muokata Omistajien ryhm, mutta et kuulu itse ryhmn, niinp sinulta on psy ryhmn kielletty. Ota yhteytt jrjestelmn yllpitoon jos uskot tmn olevan virhe',
    'listusers' => 'Listaa kyttjt',
    'listthem' => 'lista',
    'usersingroup' => 'Kyttjt ryhmss %s',
    'usergroupadmin' => 'Kyttjryhmien yllpito',
    'add' => 'Lis',
    'remove' => 'Poista',
    'availmembers' => 'Saatavilla olevat jsenet',
    'groupmembers' => 'Ryhmn jsenet',
    'canteditgroup' => 'Sinun tulee olla ryhmn jsen muokataksesi tt ryhm. Jos tm tuntuu virheelt, ota yhteytt jrjestelmn yllpitoon.',
    'cantlistgroup' => 'To see the members of this group, you have to be a member yourself. Please contact the system administrator if you feel this is an error.',
    'editgroupmsg' => 'To modify the group membership, click on the member names(s) and use the add or remove buttons. If the member is a member of the group, their name will appear on the right side only. Once you are complete - press <b>Save</b> to update the group and return to the main group admin page.',
    'listgroupmsg' => 'Listing of all current members in the group: <b>%s</b>',
    'search' => 'Search',
    'submit' => 'Submit',
    'limitresults' => 'Limit Results',
    'group_id' => 'Group ID',
    'plugin_access_denied_msg' => 'You are illegally trying access a plugin administration page.  Please note that all attempts to illegally access this page are logged.',
    'groupexists' => 'Group name already exists',
    'groupexistsmsg' => 'There is already a group with this name. Group names must be unique.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => 'Viimeiset 10 varmuuskopiota',
    'do_backup' => 'Tee varmuuskopio',
    'backup_successful' => 'Tietokannan varmistus onnistui.',
    'db_explanation' => 'Luodaksesi uuden varmuuskopion Geeklogista, klikkaa alta lytyv nappia',
    'not_found' => "Viallinen polku tai mysqldump apuohjelma ei ole suoritettavissa.<br" . XHTML . ">Tarkista <strong>\$_DB_mysqldump_path</strong> mritys config.php -tiedostossa.<br" . XHTML . ">Muuttujan nykyinen mrittely: <var>{$_DB_mysqldump_path}</var>",
    'zero_size' => 'Varmuuskopiointi eponnistui: tiedoston koko 0 tavua',
    'path_not_found' => "{$_CONF['backup_path']} ei ole olemassa tai ei ole hakemisto",
    'no_access' => "VIRHE: Hakemisto {$_CONF['backup_path']} ei ole saatavilla.",
    'backup_file' => 'Tee varmuuskopio',
    'size' => 'Koko',
    'bytes' => 'tavua',
    'total_number' => 'Varmistuksia yhteens: %d',
    'download' => 'Click to download this file',
    'new_backup' => 'New Backup',
    'delete_failure' => 'One or more backup files could not be deleted.',
    'delete_success' => 'Backup file(s) successfully deleted.',
    'convert_menu' => 'Convert to InnoDB',
    'convert_title' => 'Convert to InnoDB tables',
    'convert_button' => 'Convert',
    'sorry_no_innodb' => 'Sorry, your version of MySQL does not support InnoDB tables.',
    'innodb_explain' => 'InnoDB tables provide better performance on <em>really</em> large databases but make the backup process more complicated. Please <a href="http://dev.mysql.com/doc/mysql/en/innodb.html">read up</a> on the pros and cons of InnoDB tables before you perform this operation.',
    'already_converted' => 'Note: It appears that all of the tables have already been converted to InnoDB.',
    'conversion_patience' => 'Note: Conversion may take some time - please be patient.',
    'innodb_success' => 'Successfully converted tables to InnoDB.',
    'table_issues' => 'There may have been problems with some tables, though. Please check error.log for details.',
    'optimize_menu' => 'Optimize Tables',
    'optimize_title' => 'Optimize Tables',
    'optimize_button' => 'Optimize',
    'optimize_explain' => 'Optimizing tables may help to improve the performance of your site. The actual impact depends on the table usage and some tables may benefit from it more than others. Do no expect to see a huge difference in performance. The <a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQL manual</a> states: <q>it is not likely that you need to do this more than once a week or month</q>.',
    'last_optimization' => 'Last optimization',
    'optimization_patience' => 'Note: Optimization may take some time - please be patient.',
    'optimize_success' => 'Successfully optimized database tables.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'Etusivu',
    2 => 'Yhteystiedot',
    3 => 'Julkaise',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Sivuston tilastot',
    8 => 'Mukauta',
    9 => 'Etsi',
    10 => 'laajennettu haku',
    11 => 'Directory'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => '404 Virhe',
    2 => 'Oho, etsin kaikkialta, mutten lytnyt <b>%s</b>.',
    3 => "<p>Pahoittelumme mutta emme lyd haluamaasi tiedostoa. Katso sivuston <a href=\"{$_CONF['site_url']}\">psivu</a> tai sivuston <a href=\"{$_CONF['site_url']}/search.php\">hakusivu</a> lytksesi mit olet hukannut."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Kirjautuminen vaaditaan',
    2 => 'Tm alue vaatii sisnkirjautumisen kyttjn.',
    3 => 'Kirjaudu',
    4 => 'Uusi kyttj'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Trackback',
    'from' => 'from',
    'tracked_on' => 'Tracked on',
    'read_more' => '[read more]',
    'intro_text' => 'Here\'s what others have to say about \'%s\':',
    'no_comments' => 'No trackback comments for this entry.',
    'this_trackback_url' => 'Trackback URL for this entry:',
    'num_comments' => '%d trackback comments',
    'send_trackback' => 'Send Pings',
    'preview' => 'Preview',
    'editor_title' => 'Send trackback comment',
    'trackback_url' => 'Trackback URL',
    'entry_url' => 'Entry URL',
    'entry_title' => 'Entry Title',
    'blog_name' => 'Site Name',
    'excerpt' => 'Excerpt',
    'truncate_warning' => 'Note: The receiving site may truncate your excerpt',
    'button_send' => 'Send',
    'button_preview' => 'Preview',
    'send_error' => 'Error',
    'send_error_details' => 'Error when sending trackback comment:',
    'url_missing' => 'No Entry URL',
    'url_required' => 'Please enter at least a URL for the entry.',
    'target_missing' => 'No Trackback URL',
    'target_required' => 'Please enter a trackback URL',
    'error_socket' => 'Could not open socket.',
    'error_response' => 'Response not understood.',
    'error_unspecified' => 'Unspecified error.',
    'select_url' => 'Select Trackback URL',
    'not_found' => 'Trackback URL not found',
    'autodetect_failed' => 'Geeklog could not detect the Trackback URL for the post you want to send your comment to. Please enter it manually below.',
    'trackback_explain' => 'From the links below, please select the URL you want to send your Trackback comment to. Geeklog will then try to determine the correct Trackback URL for that post. Or you can <a href="%s">enter it manually</a> if you know it already.',
    'no_links_trackback' => 'No links found. You can not send a Trackback comment for this entry.',
    'pingback' => 'Pingback',
    'pingback_results' => 'Pingback results',
    'send_pings' => 'Send Pings',
    'send_pings_for' => 'Send Pings for "%s"',
    'no_links_pingback' => 'No links found. No Pingbacks were sent for this entry.',
    'pingback_success' => 'Pingback sent.',
    'no_pingback_url' => 'No pingback URL found.',
    'resend' => 'Resend',
    'ping_all_explain' => 'You can now notify the sites you linked to (<a href="http://en.wikipedia.org/wiki/Pingback">Pingback</a>), advertise that your site has been updated by pinging weblog directory services, or send a <a href="http://en.wikipedia.org/wiki/Trackback">Trackback</a> comment in case you wrote about a post on someone else\'s site.',
    'pingback_button' => 'Send Pingback',
    'pingback_short' => 'Send Pingbacks to all sites linked from this entry.',
    'pingback_disabled' => '(Pingback disabled)',
    'ping_button' => 'Send Ping',
    'ping_short' => 'Ping weblog directory services.',
    'ping_disabled' => '(Ping disabled)',
    'trackback_button' => 'Send Trackback',
    'trackback_short' => 'Send a Trackback comment.',
    'trackback_disabled' => '(Trackback disabled)',
    'may_take_a_while' => 'Please note that sending Pingbacks and Pings may take a while.',
    'ping_results' => 'Ping results',
    'unknown_method' => 'Unknown ping method',
    'ping_success' => 'Ping sent.',
    'error_site_name' => 'Please enter the site\'s name.',
    'error_site_url' => 'Please enter the site\'s URL.',
    'error_ping_url' => 'Please enter a valid Ping URL.',
    'no_services' => 'No weblog directory services configured.',
    'services_headline' => 'Weblog Directory Services',
    'service_explain' => 'To modify or delete a weblog directory service, click on the edit icon of that service below. To add a new weblog directory service, click on "Create New" above.',
    'service' => 'Service',
    'ping_method' => 'Ping method',
    'service_website' => 'Website',
    'service_ping_url' => 'URL to ping',
    'ping_standard' => 'Standard Ping',
    'ping_extended' => 'Extended Ping',
    'ping_unknown' => '(unknown method)',
    'edit_service' => 'Edit Weblog Directory Service',
    'trackbacks' => 'Trackbacks',
    'editor_intro' => 'Prepare your trackback comment for <a href="%s">%s</a>.',
    'editor_intro_none' => 'Prepare your trackback comment.',
    'trackback_note' => 'To send a trackback comment for a story, go to the list of stories and click on "Send Ping" for the story. To send a trackback that is not related to a story, <a href="%s">click here</a>.',
    'pingback_explain' => 'Enter a URL to send the Pingback to. The pingback will point to your site\'s homepage.',
    'pingback_url' => 'Pingback URL',
    'site_url' => 'This site\'s URL',
    'pingback_note' => 'To send a pingback for a story, go to the list of stories and click on "Send Ping" for the story. To send a pingback that is not related to a story, <a href="%s">click here</a>.',
    'pbtarget_missing' => 'No Pingback URL',
    'pbtarget_required' => 'Please enter a pingback URL',
    'pb_error_details' => 'Error when sending the pingback:',
    'delete_trackback' => 'To delete this Trackback click: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Article Directory',
    'title_year' => 'Article Directory for %d',
    'title_month_year' => 'Article Directory for %s %d',
    'nav_top' => 'Back to Article Directory',
    'no_articles' => 'No articles.'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog Security Check',
    'results' => 'Results of the Security Check',
    'okay' => 'Everything seems to be in order.',
    'please_fix' => 'Please fix the above issues before using your site!',
    'please_note' => 'Please note that no site is ever 100% secure. This script can only test for obvious security issues.',
    'stay_informed' => 'To stay informed about new Geeklog releases and possible security issues, we suggest that you subscribe to the (low-traffic) %s mailing list and/or use the %s option in your Admin menu from time to time to check for available updates.',
    'public_html' => '"public_html" should never be part of your site\'s URL.  Please read the part about public_html in the %s again and change your setup accordingly before you proceed.',
    'installation' => 'installation instructions',
    'directory' => 'directory',
    'failed_tmp' => 'Failed to create a temporary file in your %s directory. Check your directory permissions!',
    'fix_it' => 'This is a security risk and should be fixed!',
    'reachable' => 'Your %s is reachable from the web.',
    'not_reachable' => 'Good! Your %s is not reachable from the web.',
    'not_sure' => 'Got an HTTP result code %s when trying to test your %s. Not sure what to make of it ...',
    'remove_inst' => 'You should really remove the install directory %s once you have your site up and running without any errors.',
    'remove_inst2' => 'Keeping it around would allow malicious users the ability to destroy your current install, take over your site, or retrieve sensitive information.',
    'inst_removed' => 'Good! You seem to have removed the install directory already.',
    'fix_password' => 'You still have not changed the <strong>default password</strong> from "password" on %s Root user account(s).',
    'password_okay' => 'Good! You seem to have changed the default account password already.'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n new %i in the last %t %s',
    'new_last' => 'last %t %s',
    'minutes' => 'minutes',
    'hours' => 'hours',
    'days' => 'days',
    'weeks' => 'weeks',
    'months' => 'months',
    'minute' => 'minute',
    'hour' => 'hour',
    'day' => 'day',
    'week' => 'week',
    'month' => 'month'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Tammikuu',
    2 => 'Helmikuu',
    3 => 'Maaliskuu',
    4 => 'Huhtikuu',
    5 => 'Toukokuu',
    6 => 'Keskuu',
    7 => 'Heinkuu',
    8 => 'Elokuu',
    9 => 'Syyskuu',
    10 => 'Lokakuu',
    11 => 'Marraskuu',
    12 => 'Joulukuu'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Sunnuntai',
    2 => 'Maanantai',
    3 => 'Tiistai',
    4 => 'Keskiviikko',
    5 => 'Torstai',
    6 => 'Perjantai',
    7 => 'Lauantai'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Search',
    'limit_results' => 'Limit Results',
    'submit' => 'Submit',
    'edit' => 'Edit',
    'edit_adv' => 'Adv. Edit',
    'admin_home' => 'Admin Home',
    'create_new' => 'Create New',
    'create_new_adv' => 'Create New (Adv.)',
    'enabled' => 'Enabled',
    'title' => 'Title',
    'page_title' => 'Page Title',
    'type' => 'Type',
    'topic' => 'Topic',
    'help_url' => 'Help File URL',
    'save' => 'Save',
    'cancel' => 'Cancel',
    'delete' => 'Delete',
    'delete_sel' => 'Delete selected',
    'copy' => 'Copy',
    'no_results' => '- No entries found -',
    'data_error' => 'There was an error processing the subscription data. Please check the data source.',
    'preview' => 'Preview',
    'records_found' => 'Records found',
    'addchild' => 'Add child',
    'list' => 'list',
    'list_all' => 'List all',
    'meta_description' => 'Meta Description',
    'meta_keywords' => 'Meta Keywords',
    'na' => 'N/A',
    'token_expiry' => 'You have until %s to make changes. After that time, the security token embedded into this page will expire and you will lose your changes.',
    'token_expired' => 'The security token for this operation has expired. Please authenticate again to continue.',
    'reauth_msg' => 'The security token for this operation has expired. If you want to continue with this operation, then please authenticate again below. This will ensure that the changes you just made will not be lost.',
    'authenticate' => 'Authenticate'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'Comments Enabled',
    -1 => 'Comments Disabled',
    1 => 'Comments Closed'
);

$LANG_commentmodes = array(
    'flat' => 'Flat',
    'nested' => 'Nested',
    'threaded' => 'Threaded',
    'nocomment' => 'No Comments'
);

$LANG_cookiecodes = array(
    0 => '(don\'t)',
    3600 => '1 Hour',
    7200 => '2 Hours',
    10800 => '3 Hours',
    28800 => '8 Hours',
    86400 => '1 Day',
    604800 => '1 Week',
    2678400 => '1 Month'
);

$LANG_dateformats = array(
    0 => 'System Default'
);

$LANG_featurecodes = array(
    0 => 'Not Featured',
    1 => 'Featured'
);

$LANG_frontpagecodes = array(
    0 => 'Show Only in Topic',
    1 => 'Show on Front Page'
);

$LANG_postmodes = array(
    'plaintext' => 'Plain Old Text',
    'html' => 'HTML Formatted'
);

$LANG_sortcodes = array(
    'ASC' => 'Oldest First',
    'DESC' => 'Newest First'
);

$LANG_trackbackcodes = array(
    0 => 'Trackback Enabled',
    -1 => 'Trackback Disabled'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Home',
    'admin_home' => 'Site Administration',
    'sections' => 'Configuration Sections',
    'restore' => 'Restore',
    'add_element' => 'Add Element',
    'save_changes' => 'Save Changes',
    'reset_form' => 'Reset Form',
    'changes_made' => 'Changes were successfully made to',
    'title' => 'Configuration Manager',
    'disable' => 'Click to disable this option',
    'enable' => 'Enable'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklog Configuration'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTML Path',
    'site_url' => 'Site URL',
    'site_admin_url' => 'Admin URL',
    'site_mail' => 'Site E-Mail',
    'noreply_mail' => 'No-Reply E-Mail',
    'site_name' => 'Site Name',
    'site_slogan' => 'Slogan',
    'microsummary_short' => 'Microsummary',
    'path_log' => 'Log',
    'path_language' => 'Language',
    'backup_path' => 'Backup',
    'path_data' => 'Data',
    'path_images' => 'Images',
    'path_pear' => 'Path Pear',
    'have_pear' => 'Have Pear?',
    'mail_settings' => 'Mail Settings',
    'allow_mysqldump' => 'Allow MySQL Dump',
    'mysqldump_path' => 'Path of Executable',
    'mysqldump_options' => 'MySQL Dump Options',
    'mysqldump_filename_mask' => 'Backup File Name Mask',
    'theme' => 'Theme',
    'doctype' => 'DOCTYPE Declaration',
    'menu_elements' => 'Menu Elements',
    'path_themes' => 'Themes Path',
    'disable_new_user_registration' => 'Disable New Registrations',
    'allow_user_themes' => 'Allow User Themes',
    'allow_user_language' => 'Allow User Language',
    'allow_user_photo' => 'Allow User Photo',
    'allow_username_change' => 'Allow Username Changes',
    'allow_account_delete' => 'Allow Account Deletion',
    'hide_author_exclusion' => 'Allow Hide Author',
    'show_fullname' => 'Show Fullname',
    'show_servicename' => 'Show Service Name',
    'custom_registration' => 'Enable Custom Registration',
    'user_login_method' => 'User Login Method',
    'spamx' => 'Spam-X Actions',
    'sort_admin' => 'Sort Links',
    'language' => 'Language',
    'locale' => 'Locale',
    'date' => 'Date Format',
    'daytime' => 'Daytime Format',
    'shortdate' => 'Short Date Format',
    'dateonly' => 'Date Only Format',
    'timeonly' => 'Time Only Format',
    'week_start' => 'Week Start',
    'hour_mode' => 'Hour Mode',
    'thousand_separator' => 'Thousands Separator',
    'decimal_separator' => 'Decimal Separator',
    'decimal_count' => 'Decimal Count',
    'language_files' => 'Language Files',
    'languages' => 'Languages',
    'timezone' => 'Timezone',
    'site_disabled_msg' => 'Site Disabled Message or URL',
    'rootdebug' => 'Root Debugging',
    'cookie_session' => 'Session Cookie Name',
    'cookie_name' => 'Permanent Cookie Name',
    'cookie_password' => 'Password Cookie Name',
    'cookie_theme' => 'Theme Cookie Name',
    'cookie_language' => 'Language Cookie Name',
    'cookie_tzid' => 'Timezone Cookie Name',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'Cookies embed IP?',
    'default_perm_cookie_timeout' => 'Permanent Timeout',
    'session_cookie_timeout' => 'Session Timeout',
    'cookie_path' => 'Cookie Path',
    'cookiedomain' => 'Cookie Domain',
    'cookiesecure' => 'Cookie Secure',
    'lastlogin' => 'Record Last Login?',
    'num_search_results' => 'Number of Search Results',
    'loginrequired' => 'Login Required?',
    'submitloginrequired' => 'Submit Login Required?',
    'commentsloginrequired' => 'Comment Login Required?',
    'statsloginrequired' => 'Stats Login Required?',
    'searchloginrequired' => 'Search Login Required?',
    'profileloginrequired' => 'Profile Login Required?',
    'emailuserloginrequired' => 'E-Mail User Login Required?',
    'emailstoryloginrequired' => 'E-Mail Story Login Required?',
    'directoryloginrequired' => 'Directory Login Required?',
    'storysubmission' => 'Story Submission Queue?',
    'usersubmission' => 'User Submission Queue?',
    'listdraftstories' => 'List Draft Stories?',
    'notification' => 'Notifications',
    'postmode' => 'Default Post Mode',
    'speedlimit' => 'Post Speed Limit',
    'skip_preview' => 'Skip Preview in Posts',
    'advanced_editor' => 'Advanced Editor?',
    'wikitext_editor' => 'Wikitext Editor?',
    'cron_schedule_interval' => 'Cron Schedule Interval',
    'sortmethod' => 'Sort Topics',
    'showstorycount' => 'Show Story Count?',
    'showsubmissioncount' => 'Show Submission Count?',
    'hide_home_link' => 'Hide Home Link?',
    'whosonline_threshold' => 'Session Threshold',
    'whosonline_anonymous' => 'Hide Names from Guests?',
    'emailstories' => 'Daily Digest Enabled?',
    'emailstorieslength' => 'Length of Stories',
    'emailstoriesperdefault' => 'Enable for New Users?',
    'allow_domains' => 'Automatic Allow Domains',
    'disallow_domains' => 'Automatic Disallow Domains',
    'newstoriesinterval' => 'New Stories Interval',
    'newcommentsinterval' => 'New Comments Interval',
    'newtrackbackinterval' => 'New Trackbacks Interval',
    'hidenewstories' => 'Hide New Stories',
    'hidenewcomments' => 'Hide New Comments',
    'hidenewtrackbacks' => 'Hide New Trackbacks',
    'hidenewplugins' => 'Hide New Plugin Entries',
    'title_trim_length' => 'Title Trim Length',
    'trackback_enabled' => 'Trackback Enabled?',
    'pingback_enabled' => 'Pingback Enabled?',
    'ping_enabled' => 'Ping Enabled?',
    'trackback_code' => 'Trackback Default',
    'multiple_trackbacks' => 'Multiple Trackbacks',
    'trackbackspeedlimit' => 'Trackback Speed Limit',
    'check_trackback_link' => 'Check Trackbacks',
    'pingback_self' => 'Pingback Self?',
    'pingback_excerpt' => 'Create Pingback Excerpt?',
    'link_documentation' => 'Link to Documentation?',
    'link_versionchecker' => 'Link to Version Checker?',
    'maximagesperarticle' => 'Max Images per Article',
    'limitnews' => 'Stories per Page',
    'minnews' => 'Min. Stories per Page',
    'contributedbyline' => 'Show "Contributed By"?"',
    'hideviewscount' => 'Hide Views Count?',
    'hideemailicon' => 'Hide E-Mail Icon?',
    'hideprintericon' => 'Hide Print Icon?',
    'allow_page_breaks' => 'Allow Page Breaks?',
    'page_break_comments' => 'Comments on Multi-Page Articles',
    'article_image_align' => 'Topic Icon Alignment',
    'show_topic_icon' => 'Show Topic Icon?',
    'draft_flag' => 'Draft Flag Default',
    'frontpage' => 'Frontpage Default',
    'hide_no_news_msg' => 'Hide "No News" Message?',
    'hide_main_page_navigation' => 'Hide Main Page Navigation?',
    'onlyrootfeatures' => 'Only Root can Feature?',
    'aftersave_story' => 'After Saving Story',
    'aftersave_user' => 'After Saving User',
    'show_right_blocks' => 'Always Show Right Blocks?',
    'showfirstasfeatured' => 'Show First Story as Featured?',
    'backend' => 'Enable Feeds?',
    'rdf_file' => 'Syndication Output Folder',
    'rdf_limit' => 'Feed Limit',
    'rdf_storytext' => 'Length of Stories in Feed',
    'rdf_language' => 'Feed Language',
    'syndication_max_headlines' => 'Max. Number of Headlines (portal blocks)',
    'copyrightyear' => 'Copyright Year',
    'image_lib' => 'Image Library',
    'path_to_mogrify' => 'Path to Mogrify',
    'path_to_netpbm' => 'Path to Netpbm',
    'debug_image_upload' => 'Debug Image Uploading?',
    'keep_unscaled_image' => 'Keep Unscaled Image?',
    'allow_user_scaling' => 'Allow User Scaling?',
    'jpeg_quality' => 'JPEG Quality?',
    'max_image_width' => 'Max Image Width?',
    'max_image_height' => 'Max Image Height?',
    'max_image_size' => 'Max Image Size?',
    'max_topicicon_width' => 'Max Topic Icon Width?',
    'max_topicicon_height' => 'Max Topic Icon Height?',
    'max_topicicon_size' => 'Max Topic Icon Size?',
    'max_photo_width' => 'Max Photo Width?',
    'max_photo_height' => 'Max Photo Height?',
    'max_photo_size' => 'Max Photo Size?',
    'use_gravatar' => 'Use Gravatar?',
    'gravatar_rating' => 'Gravatar Rating',
    'force_photo_width' => 'Force Photo Width',
    'default_photo' => 'Default Photo',
    'commentspeedlimit' => 'Comment Speed Limit',
    'comment_limit' => 'Comment Limit',
    'comment_mode' => 'Comment Mode',
    'comment_code' => 'Comment Default',
    'comment_edit' => 'Allow Comment Edit?',
    'comment_edittime' => 'Comment Edit Time (seconds)',
    'commentsubmission' => 'Queue Comment Submissions',
    'passwordspeedlimit' => 'Password Speed Limit',
    'login_attempts' => 'Max. Login Attempts',
    'login_speedlimit' => 'Login Speed Limit',
    'user_html' => 'User HTML',
    'admin_html' => 'Admin HTML',
    'advanced_html' => 'Additional HTML for Adv. Editor',
    'skip_html_filter_for_root' => 'Skip HTML Filter for Root?',
    'allowed_protocols' => 'Allowed Protocols',
    'disable_autolinks' => 'Disable Autotags?',
    'clickable_links' => 'Make URLs clickable?',
    'compressed_output' => 'Send compressed output?',
    'frame_options' => 'Protection against "clickjacking"',
    'censormode' => 'Censor Mode?',
    'censorreplace' => 'Censor Replace Text',
    'censorlist' => 'Censor List',
    'ip_lookup' => 'IP Lookup',
    'url_rewrite' => 'Enable URL Rewrite',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'Default Meta Description',
    'meta_keywords' => 'Default Meta Keywords',
    'default_permissions_block' => 'Block Default Permissions',
    'default_permissions_story' => 'Story Default Permissions',
    'default_permissions_topic' => 'Topic Default Permissions',
    'atom_max_stories' => 'Max. Stories in Webservices Feed',
    'disable_webservices' => 'Disable Webservices?',
    'restrict_webservices' => 'Restrict Webservices?',
    'article_comment_close_enabled' => 'Automatically close comments (default)',
    'article_comment_close_days' => 'Days to close comments (default)',
    'comment_close_rec_stories' => 'Number of most recent stories enabled for comments',
    'allow_reply_notifications' => 'Allow comment reply notifications?',
    'search_style' => 'Results List Style',
    'search_limits' => 'Page Limits',
    'search_show_num' => 'Show Result Number?',
    'search_show_type' => 'Show Result Type?',
    'search_show_sort' => 'Allow User to Sort Results?',
    'search_show_limit' => 'Show Page Limits?',
    'search_separator' => 'Group Separator',
    'search_def_keytype' => 'Default Search Method',
    'search_def_sort' => 'Default Sort Order'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Site',
    'sg_stories' => 'Stories and Trackback',
    'sg_theme' => 'Theme',
    'sg_blocks' => 'Blocks',
    'sg_users' => 'Users and Submissions',
    'sg_images' => 'Images',
    'sg_locale' => 'Languages and Locale',
    'sg_misc' => 'Miscellaneous'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Site',
    'fs_paths' => 'Paths',
    'fs_theme' => 'Theme',
    'fs_mail' => 'Mail',
    'fs_pear' => 'Pear',
    'fs_mysql' => 'MySQL',
    'fs_users' => 'Users',
    'fs_misc' => 'Miscellaneous',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin Block',
    'fs_locale' => 'Locale',
    'fs_language' => 'Language',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Cookies',
    'fs_login' => 'Login Settings',
    'fs_search' => 'Search',
    'fs_user_submission' => 'User Submission',
    'fs_submission' => 'Submission Settings',
    'fs_topics_block' => 'Topics Block',
    'fs_whosonline_block' => 'Who\'s Online Block',
    'fs_daily_digest' => 'Daily Digest',
    'fs_whatsnew_block' => 'What\'s New Block',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Story',
    'fs_theme_advanced' => 'Advanced Settings',
    'fs_syndication' => 'Syndication',
    'fs_imagelib' => 'Image Library',
    'fs_upload' => 'Upload',
    'fs_articleimg' => 'Images in Articles',
    'fs_topicicon' => 'Topic Icons',
    'fs_userphoto' => 'Photos',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'Comments',
    'fs_htmlfilter' => 'HTML Filtering',
    'fs_censoring' => 'Censoring',
    'fs_iplookup' => 'IP Lookup',
    'fs_perm_story' => 'Story Default Permission',
    'fs_perm_topic' => 'Topic Default Permission',
    'fs_perm_block' => 'Block Default Permission',
    'fs_webservices' => 'Webservices'
);

$LANG_configselects['Core'] = array(
    0 => array('True' => 1, 'False' => 0),
    1 => array('True' => true, 'False' => false),
    2 => array('Reject' => 0, 'Only Keep Latest' => 1, 'Allow Multiple Posts' => 2),
    3 => array('Trackback Enabled' => 0, 'Trackback Disabled' => -1),
    4 => array('Don\'t Check Anything' => 0, 'Check against Site URL' => 1, 'Check full URL' => 2, 'Check against Site URL and full URL' => 3, 'Check IP against Site IP' => 4, 'Check IP and Site URL' => 5, 'Check IP and Full URL' => 6, 'Check IP, Full URL, and Site URL' => 7),
    5 => array('Plain Old Text' => 'plaintext', 'HTML Formatted' => 'html'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Last Page' => 'last', 'First Page' => 'first', 'Every Page' => 'all'),
    8 => array('Right' => 'right', 'Left' => 'left'),
    9 => array('Forward to page' => 'item', 'Display List' => 'list', 'Display Home' => 'home', 'Display Admin' => 'admin'),
    10 => array('None' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Flat' => 'flat', 'Nested' => 'nested', 'Threaded' => 'threaded', 'No Comments' => 'nocomment'),
    12 => array('No access' => 0, 'Read-Only' => 2, 'Read-Write' => 3),
    13 => array('Skip' => 0, 'Allow, with speedlimit' => 1, 'Allow, no speedlimit' => 2),
    14 => array('Sunday' => 'Sun', 'Monday' => 'Mon'),
    15 => array('By Number' => 'sortnum', 'Alphabetically' => 'alpha'),
    16 => array('No Login required' => 0, 'Advanced Search only' => 1, 'Simple + Advanced Search' => 2),
    17 => array('Comments Enabled' => 0, 'Comments Disabled' => -1),
    18 => array('Disabled' => 0, 'Enabled (Exact Match)' => 1, 'Enabled (Word Beginning)' => 2, 'Enabled (Word Fragment)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('Exact Phrase' => 'phrase', 'All of The Words' => 'all', 'Any of The Words' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (Default for Homepage only)' => 2),
    24 => array('Contribute' => 'contribute', 'Home' => 'home', 'Advanced Search' => 'search', 'Directory' => 'directory', 'My Account' => 'prefs', 'Plugin Entries' => 'plugins', 'Custom Entries' => 'custom', 'Site Statistics' => 'stats'),
    25 => array('New Stories' => 'story', 'New Comments' => 'comment', 'New Trackbacks' => 'trackback', 'New Pingbacks' => 'pingback', 'New Users' => 'user'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (asc)' => 'hits|asc', 'Hits (desc)' => 'hits|desc', 'Date (asc)' => 'date|asc', 'Date (desc)' => 'date|desc', 'Title (asc)' => 'title|asc', 'Title (desc)' => 'title|desc', 'Author (asc)' => 'uid|asc', 'Author (desc)' => 'uid|desc')
);

?>
